/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.person.PasswordUtils;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.PasswordForgottenTicket;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.sec.TapestryPasswordChanger;
import at.cdes.bo.sec.symetric.PasswordEncryption;
import at.cdes.controller.actionhandler.login.URLMapper;
import at.cdes.db.dao.PersonDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.SupportDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.service.CertificateOperations;
import at.cdes.service.LoginLessOperations;
import at.cdes.service.MailOperations;
import at.cdes.service.PersonOperations;
import at.cdes.service.exception.WrongPasswordException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class LoginLessOperationsImpl
implements LoginLessOperations {
    private CertificateOperations certificateOperations;
    private MailOperations mailOperations;
    private PersonOperations personOperations;
    private PersonDAO personDAO;
    private ProjectDAO projectDAO;
    private SupportDAO supportDAO;
    private URLMapper urlMapper;
    private PasswordUtils passwordUtils;
    private TapestryPasswordChanger tapestryPasswordChanger;
    private static final Logger log = LoggerFactory.getLogger(LoginLessOperations.class);

    public void setCertificateOperations(CertificateOperations certificateOperations) {
        this.certificateOperations = certificateOperations;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    public void setPersonOperations(PersonOperations personOperations) {
        this.personOperations = personOperations;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setSupportDAO(SupportDAO supportDAO) {
        this.supportDAO = supportDAO;
    }

    public void setUrlMapper(URLMapper urlMapper) {
        this.urlMapper = urlMapper;
    }

    public void setPasswordUtils(PasswordUtils passwordUtils) {
        this.passwordUtils = passwordUtils;
    }

    public void setTapestryPasswordChanger(TapestryPasswordChanger tapestryPasswordChanger) {
        this.tapestryPasswordChanger = tapestryPasswordChanger;
    }

    @Override
    public List getAllSupportContacts() {
        return this.supportDAO.getAll();
    }

    @Override
    public String requestNewPassword(String login) {
        Person person = this.personDAO.get(login);
        if (person == null) {
            return "NoPersonFound";
        }
        if (person.getSecurityQuestion() == null || person.getSecurityQuestion().length() == 0) {
            return "NoSecurityQuestionDefined";
        }
        PasswordStatus passwordStatus = this.personOperations.checkPasswordStatus(person.getId());
        if (passwordStatus == PasswordStatus.EXPIRED) {
            return "PasswordExpired";
        }
        PasswordForgottenTicket ticket = this.createPasswordForgottenTicket(person);
        String email = this.generatePasswordForgottenEMailText(person, ticket);
        if (person.getOrganisationPersons() == null) {
            return "SecurityQuestionLogin_" + ticket.getUuid();
        }
        Collection<OrganisationPerson> ops = person.getOrganisationPersons().values();
        OrganisationPerson receiver = null;
        for (OrganisationPerson op : ops) {
            if (op.isInActive() || op.getEmailAddress() == null || op.getEmailAddress().length() <= 0) continue;
            receiver = op;
            break;
        }
        if (receiver == null) {
            return "SecurityQuestionLogin_" + ticket.getUuid();
        }
        this.mailOperations.createSimpleMailReply(receiver, "Neuanforderung des c.des Benutzerzugangs", email, null);
        return null;
    }

    @Override
    public int countProjects() {
        return this.projectDAO.countProjects();
    }

    private PasswordForgottenTicket createPasswordForgottenTicket(Person person) {
        PasswordForgottenTicket ticket = new PasswordForgottenTicket();
        ticket.setPerson(person);
        ticket.setDone(false);
        ticket.setDate(new Date(System.currentTimeMillis()));
        ticket.setUuid(UUID.randomUUID().toString());
        return this.personDAO.save(ticket);
    }

    private String generatePasswordForgottenEMailText(Person person, PasswordForgottenTicket ticket) {
        Locale locale = new Locale(person.getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        StringBuffer sb = new StringBuffer();
        sb.append(String.format(i18n.tr("S.g. %s!"), person.getCommonName()));
        sb.append("\n\n");
        sb.append(i18n.tr("Sie haben die Neuausstellung ihres CDES Benutzerzugangs beantragt.") + "\n");
        sb.append(i18n.tr("Klicken sie hier um ihren Zugang zu erneuern.") + " " + this.urlMapper.getURL(person) + "/cdes/app?service=external/RequestNewPassword&sp=S" + ticket.getUuid() + "\n");
        sb.append("\n");
        sb.append(i18n.tr("mfg\n\nIhr CDES-Betreiber\n"));
        return sb.toString();
    }

    @Override
    public PasswordForgottenTicket getPasswordForgottenTicket(String id) {
        log.info("Called getPasswordForgottenTicket");
        return this.personDAO.getPasswordForgottenTicketByUuid(id);
    }

    @Override
    public boolean checkPersonSecurityAnswer(Person person, String answer) throws WrongPasswordException {
        PasswordEncryption enc = new PasswordEncryption();
        try {
            String oldPassword = this.passwordUtils.decryptSecurityAnswer(person.getQuestionEncryptedPassword(), answer);
            return oldPassword != null;
        }
        catch (Exception e) {
            log.error("Exception while decrypting securityAnswer of user [" + person.getLogin() + "] (" + person.getGivenName() + " " + person.getSurName() + "); Exception will follow in CleanLoggingInterceptor.");
            throw e;
        }
    }

    @Override
    public boolean isPasswordExpired(Integer personId) {
        PasswordStatus passwordStatus = this.personOperations.checkPasswordStatus(personId);
        return passwordStatus == PasswordStatus.EXPIRED;
    }

    @Override
    public void changePasswordWithAnswer(Person person, String answer, String newPassword) throws WrongPasswordException {
        String oldPassword = this.passwordUtils.decryptSecurityAnswer(person.getQuestionEncryptedPassword(), answer);
        String question = person.getSecurityQuestion();
        this.setPersonSecurityQuestion(person, question, answer, newPassword);
        this.changePersonPasswordAndSecurityQuestion(person.getId(), newPassword, oldPassword, null, null);
    }

    private Person setPersonSecurityQuestion(Person person, String question, String answer, String password) {
        String hashed = this.passwordUtils.encryptSecurityAnswer(password, answer);
        person.setQuestionEncryptedPassword(hashed);
        person.setSecurityQuestion(question);
        return person;
    }

    public Person changePersonPasswordAndSecurityQuestion(Integer personId, String newPassword, String oldPassword, String question, String answer) throws WrongPasswordException {
        Person person = this.personDAO.get(personId);
        if (newPassword != null && newPassword.length() > 0 && person.getOrganisationPersons() != null) {
            for (OrganisationPerson op : person.getOrganisationPersons().values()) {
                if (op.getCertificates() == null) continue;
                for (CDESCertificate cert : op.getCertificates().values()) {
                    if (cert.getPrivateKey() == null || cert.getPrivateKey().isEmpty()) continue;
                    try {
                        cert = this.certificateOperations.changePassword(newPassword, oldPassword, cert);
                        this.certificateOperations.updateCert(cert);
                    }
                    catch (WrongPasswordException e) {
                        if (cert.isMaySign() && cert.getValidTo() != null && cert.getValidTo().after(new Date(System.currentTimeMillis()))) {
                            log.error("Error changing password of active certificate[id=" + cert.getId() + "].", (Throwable)e);
                            throw e;
                        }
                        log.warn("Error changing password of inactive certificate[id=" + cert.getId() + "].", (Throwable)e);
                    }
                }
            }
            person = this.setPersonPassword(person, newPassword);
        }
        if (question != null && question.length() > 0 && answer != null && answer.length() > 0) {
            String passwordToBeEncrypted = oldPassword;
            if (newPassword != null && newPassword.length() > 0) {
                passwordToBeEncrypted = newPassword;
            }
            person.setSecurityQuestion(question);
            String hashed = this.passwordUtils.encryptSecurityAnswer(passwordToBeEncrypted, answer);
            person.setQuestionEncryptedPassword(hashed);
            return this.personDAO.update(person);
        }
        return this.updatePerson(person);
    }

    private Person setPersonPassword(Person person, String password) {
        this.tapestryPasswordChanger.setPassword(person.getId(), password);
        return this.personDAO.get(person.getId());
    }

    private Person updatePerson(Person person) {
        Person per = this.personDAO.get(person.getId());
        per.setGender(person.getGender());
        per.setGivenName(person.getGivenName());
        per.setSurName(person.getSurName());
        per.setTitle(person.getTitle());
        per.setRole(person.getRole());
        per.setZtPermission(person.isZtPermission());
        per.setPassword(person.getPassword());
        per.setGender(person.getGender());
        return this.personDAO.update(per);
    }

    @Override
    public PasswordForgottenTicket finishPasswordForgottenTicket(PasswordForgottenTicket ticket) {
        ticket.setDone(true);
        return this.personDAO.update(ticket);
    }
}

