/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.ActionRuleDefault;
import at.cdes.bo.data.role.CDESAction;
import at.cdes.db.dao.ActionDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Restrictions;

public class ActionDAOHibernate
extends HibernateDaoSupport
implements ActionDAO {
    @Override
    public CDESAction get(Integer id) {
        return (CDESAction)this.getSession().get(CDESAction.class, (Serializable)id);
    }

    @Override
    public CDESAction get(String name) {
        List actions = this.findHibernate(" from CDESAction where name = ?", name);
        if (actions == null || actions.isEmpty()) {
            return null;
        }
        return (CDESAction)actions.get(0);
    }

    @Override
    public List<CDESAction> getAll() {
        return this.loadAllHibernate(CDESAction.class);
    }

    @Override
    public List<ActionRule> getActionRules(Integer actionId, Integer networkId) {
        if (actionId == null) {
            return new ArrayList<ActionRule>();
        }
        if (networkId == null) {
            return this.findHibernate("from ActionRule where network is null and action.id = ?", actionId);
        }
        return this.findHibernate("from ActionRule where network.id = ? and action.id = ?", new Object[]{networkId, actionId});
    }

    @Override
    public List<ActionRule> getActionRules(Network network, boolean allWithNetworkReference) {
        if (network != null) {
            return this.findHibernate("from ActionRule where network.id = ?", network.getId());
        }
        if (allWithNetworkReference) {
            List found = this.findHibernate("from ActionRule where destinationContext.id != ? and destinationContext.id != ?", new Object[]{1, 20});
            HashMap<Integer, ActionRule> distinct = new HashMap<Integer, ActionRule>();
            for (ActionRule rule : found) {
                distinct.put(rule.getAction().getId(), rule);
            }
            return new ArrayList<ActionRule>(distinct.values());
        }
        return this.findHibernate("from ActionRule where network is null");
    }

    @Override
    public CDESAction save(CDESAction action) {
        return this.get((Integer)this.getSession().save((Object)action));
    }

    @Override
    public CDESAction merge(CDESAction action) {
        action = (CDESAction)this.getSession().merge((Object)action);
        return action;
    }

    @Override
    public void delete(CDESAction action) {
        this.getSession().delete((Object)action);
    }

    @Override
    public ActionRule getRule(Integer id) {
        return (ActionRule)this.getSession().get(ActionRule.class, (Serializable)id);
    }

    @Override
    public ActionRule merge(ActionRule action) {
        return (ActionRule)this.getSession().merge((Object)action);
    }

    @Override
    public ActionRule save(ActionRule action) {
        return this.getRule((Integer)this.getSession().save((Object)action));
    }

    @Override
    public void delete(ActionRule rule) {
        this.getSession().delete((Object)rule);
    }

    @Override
    public ActionRuleDefault getActionRuleDefault(Integer id) {
        return (ActionRuleDefault)this.getSession().get(ActionRuleDefault.class, (Serializable)id);
    }

    @Override
    public ActionRuleDefault save(ActionRuleDefault rule) {
        return this.getActionRuleDefault((Integer)this.getSession().save((Object)rule));
    }

    @Override
    public ActionRuleDefault merge(ActionRuleDefault rule) {
        return (ActionRuleDefault)this.getSession().merge((Object)rule);
    }

    @Override
    public void delete(ActionRuleDefault rule) {
        this.getSession().delete((Object)rule);
    }

    @Override
    public List getAllActionRuleDefaults() {
        return this.loadAllHibernate(ActionRuleDefault.class);
    }

    @Override
    public ActionRuleDefault getActionRuleDefaultByAction(Integer actionId) {
        List rules = this.getSession().createCriteria(ActionRuleDefault.class).createCriteria("action").add(Restrictions.idEq((Object)actionId)).list();
        if (rules != null && rules.size() > 0) {
            return (ActionRuleDefault)rules.get(0);
        }
        return null;
    }

    @Override
    public ActionRule update(ActionRule rule) {
        this.getSession().update((Object)rule);
        return rule;
    }
}

