/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class OrganisationPersonDAOHibernate
extends HibernateDaoSupport
implements OrganisationPersonDAO {
    @Override
    public OrganisationPerson get(Integer id) {
        return (OrganisationPerson)this.getSession().load(OrganisationPerson.class, (Serializable)id);
    }

    @Override
    public OrganisationPerson get(Integer personId, Integer organisationId) {
        return (OrganisationPerson)this.findHibernate(" from OrganisationPerson where person.id = ? and organisation.id = ?", new Object[]{personId, organisationId}).get(0);
    }

    @Override
    public OrganisationPerson getByPersonOrgPersonId(Integer personId, Integer organisationPersonId) {
        Criteria crit = this.getSession().createCriteria(OrganisationPerson.class);
        crit.add(Restrictions.idEq((Object)organisationPersonId));
        crit.createCriteria("person").add(Restrictions.idEq((Object)personId));
        List res = crit.list();
        if (!res.isEmpty()) {
            return (OrganisationPerson)res.get(0);
        }
        return null;
    }

    @Override
    public List getAll(Integer networkId) {
        if (networkId == null) {
            return this.loadAllHibernate(OrganisationPerson.class);
        }
        Criteria crit = this.getSession().createCriteria(OrganisationPerson.class);
        crit.createCriteria("organisation").createCriteria("networks").add(Restrictions.idEq((Object)networkId));
        return crit.list();
    }

    @Override
    public List getAllPersons(Integer networkId, Integer networkMemberId, String criterion, Integer personStatus) {
        Criteria crit = this.getSession().createCriteria(Person.class);
        if (personStatus != null && personStatus >= 0) {
            crit.add((Criterion)Restrictions.like((String)"status", (Object)personStatus));
        }
        if (personStatus != null && personStatus < 0) {
            crit.add((Criterion)Restrictions.ne((String)"status", (Object)2));
        }
        if (criterion != null) {
            crit.add((Criterion)Restrictions.like((String)"surName", (Object)(criterion + "%")));
        }
        if (networkId != null) {
            crit.createCriteria("organisationPersons").createCriteria("organisation").createCriteria("networks").add(Restrictions.idEq((Object)networkId));
        } else if (networkMemberId != null) {
            crit.createCriteria("organisationPersons").createCriteria("organisation").createCriteria("networks").createCriteria("organisations").add(Restrictions.idEq((Object)networkMemberId));
        }
        List pers = crit.list();
        ArrayList<Person> result = new ArrayList<Person>();
        for (Person per : pers) {
            if (result.contains(per)) continue;
            result.add(per);
        }
        return result;
    }

    @Override
    public OrganisationPerson save(OrganisationPerson organisation) {
        Integer id = (Integer)this.getSession().save((Object)organisation);
        return this.get(id);
    }

    @Override
    public void delete(OrganisationPerson organisation) {
        this.getSession().delete((Object)organisation);
    }

    @Override
    public OrganisationPerson update(OrganisationPerson organisation) {
        this.getSession().merge((Object)organisation);
        return organisation;
    }

    @Override
    public List getAllFromOtherNetworks(Integer ownNetworkId, String filter, Integer personStatus) {
        Criteria crit = this.getSession().createCriteria(Person.class);
        if (personStatus != null && personStatus >= 0) {
            crit.add((Criterion)Restrictions.like((String)"status", (Object)personStatus));
        } else if (personStatus != null && personStatus < 0) {
            crit.add((Criterion)Restrictions.ne((String)"status", (Object)2));
        }
        if (filter != null) {
            crit.add((Criterion)Restrictions.like((String)"surName", (Object)(filter + "%")));
        }
        crit.createCriteria("organisationPersons").createCriteria("organisation").createCriteria("networks").add((Criterion)Restrictions.ne((String)"id", (Object)ownNetworkId));
        return crit.list();
    }
}

