/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.person;

import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.ObjectPlannerPositionDefinition;
import java.io.Serializable;

public class PersonObjectPlannerPositionAssignmentDTO
implements Serializable {
    private static final long serialVersionUID = 818002457970788547L;
    private String objectCode;
    private String objectName;
    private String objectPlannerCode;
    private String objectPlannerName;
    private String positionName;
    private String subProjectName;
    private final boolean notifyReleasedPositive;
    private final boolean notifyReleasedNegative;
    private final boolean notifyInvalidateVersion;
    private final boolean notifyInvalidateAll;
    private final boolean notifyDeleted;
    private final boolean notifyReplacedByRevision;

    public PersonObjectPlannerPositionAssignmentDTO(ObjectPlannerPosition pos) {
        this.objectCode = pos.getObjectPlanner().getObject().getCode();
        this.objectName = pos.getObjectPlanner().getObject().getName();
        this.objectPlannerCode = pos.getObjectPlanner().getCode();
        this.objectPlannerName = pos.getObjectPlanner().getArea();
        this.positionName = pos.getObjectPlannerPositionDefinition().getName();
        this.subProjectName = pos.getObjectPlanner().getObject().getObjectList().getSubProject().getCode();
        ObjectPlannerPositionDefinition posDef = pos.getObjectPlannerPositionDefinition();
        this.notifyReleasedPositive = posDef != null && (posDef.getStatusNotification() & 1) != 0;
        this.notifyReleasedNegative = posDef != null && (posDef.getStatusNotification() & 2) != 0;
        this.notifyInvalidateVersion = posDef != null && (posDef.getStatusNotification() & 4) != 0;
        this.notifyInvalidateAll = posDef != null && (posDef.getStatusNotification() & 8) != 0;
        this.notifyDeleted = posDef != null && (posDef.getStatusNotification() & 0x10) != 0;
        this.notifyReplacedByRevision = posDef != null && (posDef.getStatusNotification() & 0x20) != 0;
    }

    public PersonObjectPlannerPositionAssignmentDTO(ObjectPlanner objectPlanner, String plannerString) {
        this.objectCode = objectPlanner.getObject().getCode();
        this.objectName = objectPlanner.getObject().getName();
        this.objectPlannerCode = objectPlanner.getCode();
        this.objectPlannerName = objectPlanner.getArea();
        this.positionName = plannerString;
        this.subProjectName = objectPlanner.getObject().getObjectList().getSubProject().getCode();
        this.notifyReleasedPositive = false;
        this.notifyReleasedNegative = false;
        this.notifyInvalidateVersion = false;
        this.notifyInvalidateAll = false;
        this.notifyDeleted = false;
        this.notifyReplacedByRevision = false;
    }

    public String getObjectPlannerCode() {
        return this.objectPlannerCode;
    }

    public String getObjectPlannerName() {
        return this.objectPlannerName;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public String getObjectCode() {
        return this.objectCode;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isNotifyReleasedPositive() {
        return this.notifyReleasedPositive;
    }

    public boolean isNotifyReleasedNegative() {
        return this.notifyReleasedNegative;
    }

    public boolean isNotifyInvalidateVersion() {
        return this.notifyInvalidateVersion;
    }

    public boolean isNotifyInvalidateAll() {
        return this.notifyInvalidateAll;
    }

    public boolean isNotifyDeleted() {
        return this.notifyDeleted;
    }

    public boolean isNotifyReplacedByRevision() {
        return this.notifyReplacedByRevision;
    }

    public String getSubProjectName() {
        return this.subProjectName;
    }
}

