/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.project;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderAddressVisitor;
import at.cdes.bo.data.order.OrderAddressVisitorAcceptor;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.role.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ProjectParticipation
implements CdesDataObject,
OrderAddressVisitorAcceptor {
    static final long serialVersionUID = 1L;
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_MARKED_FOR_DELETION = 1;
    public static final int STATUS_INVALID = 2;
    private Integer id;
    private String comment;
    private Role role;
    private Project project;
    private Map projectParticipants;
    private Map invalidProjectParticipants;
    private boolean mailReciever;
    private Organisation organisation;
    private String customerId;
    private String attachmentEmailAddress;
    private int status;
    private Map excludedSubProjects;
    private ProjectParticipation asBuiltPlannerParticipation;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Map getProjectParticipants() {
        return this.projectParticipants;
    }

    public void setProjectParticipants(Map projectParticipants) {
        this.projectParticipants = projectParticipants;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public ProjectParticipant getMainParticipant() {
        if (this.projectParticipants.values() == null || this.projectParticipants.values().isEmpty()) {
            return null;
        }
        for (ProjectParticipant projectParticipant : this.projectParticipants.values()) {
            if (!projectParticipant.isMainParticipant()) continue;
            return projectParticipant;
        }
        return null;
    }

    public boolean hasMultipleOrganisations() {
        if (this.projectParticipants.values() == null || this.projectParticipants.values().isEmpty()) {
            return false;
        }
        Iterator it = this.projectParticipants.values().iterator();
        ArrayList<Organisation> counted = new ArrayList<Organisation>();
        if (this.getOrganisation() == null) {
            return false;
        }
        while (it.hasNext()) {
            ProjectParticipant projectParticipant = (ProjectParticipant)it.next();
            if (!this.getOrganisation().isConsortiumHead() && !counted.contains(projectParticipant.getOrganisationPerson().getOrganisation())) {
                counted.add(projectParticipant.getOrganisationPerson().getOrganisation());
            }
            if (this.getOrganisation().isConsortiumHead() && !this.getOrganisation().getConsortiumMembers().containsKey(projectParticipant.getOrganisationPerson().getOrganisation().getId())) {
                counted.add(projectParticipant.getOrganisationPerson().getOrganisation());
            }
            if ((this.getOrganisation().isConsortiumHead() || counted.size() <= 1) && (!this.getOrganisation().isConsortiumHead() || counted.size() <= 0)) continue;
            return true;
        }
        return false;
    }

    public boolean isMailReciever() {
        return this.mailReciever;
    }

    public void setMailReciever(boolean mailReciever) {
        this.mailReciever = mailReciever;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public Map getInvalidProjectParticipants() {
        return this.invalidProjectParticipants;
    }

    public void setInvalidProjectParticipants(Map invalidProjectParticipants) {
        this.invalidProjectParticipants = invalidProjectParticipants;
    }

    public Collection<ProjectParticipant> getAllParticipants() {
        ArrayList<ProjectParticipant> col = new ArrayList<ProjectParticipant>();
        if (this.getProjectParticipants() != null) {
            col.addAll(this.getProjectParticipants().values());
        }
        if (this.getInvalidProjectParticipants() != null) {
            col.addAll(this.getInvalidProjectParticipants().values());
        }
        return col;
    }

    @Override
    public OrderAddress accept(OrderAddressVisitor visitor) {
        return visitor.getOrderAddress(this);
    }

    public String getAttachmentEmailAddress() {
        return this.attachmentEmailAddress;
    }

    public void setAttachmentEmailAddress(String attachmentEmailAddress) {
        this.attachmentEmailAddress = attachmentEmailAddress;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ProjectParticipation.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ProjectParticipation other = (ProjectParticipation)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public boolean isInvalidated() {
        return this.status == 2;
    }

    public boolean isActive() {
        return this.status == 0;
    }

    public Map getExcludedSubProjects() {
        return this.excludedSubProjects;
    }

    public void setExcludedSubProjects(Map excludedSubProjects) {
        this.excludedSubProjects = excludedSubProjects;
    }

    public void setAsBuiltPlannerParticipation(ProjectParticipation asBuiltPlannerParticipation) {
        this.asBuiltPlannerParticipation = asBuiltPlannerParticipation;
    }

    public ProjectParticipation getAsBuiltPlannerParticipation() {
        return this.asBuiltPlannerParticipation;
    }
}

