/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.label;

import at.cdes.bo.data.label.CDataRichTextItem;
import at.cdes.bo.data.label.DocumentVersionTextField;
import at.cdes.bo.data.label.FreeTextLabelTextField;
import at.cdes.bo.data.label.ParagraphRichTextItem;
import at.cdes.bo.data.label.SignatureTextField;
import at.cdes.bo.label.AbstractTextFieldRenderer;
import at.cdes.util.TapestryI18nHelper;
import java.io.IOException;
import java.util.Date;

public class SampleTextFieldRenderer
extends AbstractTextFieldRenderer {
    Date creationDate;

    public SampleTextFieldRenderer(double _dx, double _dy, Date _creationDate) {
        super(_dx, _dy, 1.0);
        this.creationDate = _creationDate;
    }

    @Override
    public void visit(SignatureTextField field) throws IOException {
        super.renderSignatureTextFieldInternal(field, this.creationDate, field.getReviewCycleNode() != null ? TapestryI18nHelper.getLocalizedString(field.getReviewCycleNode().getName()) + (field.getComment() != null && field.getComment().length() > 0 ? " [" + field.getComment() + "]" : "") : "dummy Node", "Titel Vorname Nachname, Firmenbezeichnung", "xxxxxxxxxxxxxxxxxxxx", null, null, 0, 1, false, false);
    }

    @Override
    public void visit(DocumentVersionTextField field) throws IOException {
        String cdata = field.getContent();
        int idx = cdata.indexOf("${upload_sig}");
        if (idx < 0) {
            CDataRichTextItem cdata_item = new CDataRichTextItem(cdata + "\r");
            super.renderFDFObject(field, "DocumentVersion", "c.des", this.creationDate, new ParagraphRichTextItem(cdata_item), 0, 1);
        } else {
            String header = null;
            header = idx > 0 ? cdata.substring(0, idx) : "Planung";
            String trailer = null;
            if (idx + 13 < cdata.length()) {
                trailer = cdata.substring(idx + 13, cdata.length());
            }
            this.renderSignatureTextFieldInternal(field, this.creationDate, "upload", "Titel Vorname Nachname, Firmenbezeichnung", "xxxxxxxxxxxxxxxxxxxx", header, trailer, 0, 1, false, false);
        }
    }

    @Override
    public void visit(FreeTextLabelTextField textField) throws IOException {
        CDataRichTextItem cdata_item = new CDataRichTextItem(textField.getContent() + "\r");
        super.renderFDFObject(textField, "Freitext", "c.des", this.creationDate, new ParagraphRichTextItem(cdata_item), 0, 1);
    }
}

