/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.action.impl;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.role.RoleMapEntry;
import at.cdes.db.dao.RoleDAO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkValidator {
    private RoleDAO roleDAO;
    static Logger log = LoggerFactory.getLogger((String)NetworkValidator.class.getName());

    public boolean validateAction(List networkRoles, ActionRule action) {
        for (RoleMapEntry roleMapEntry : networkRoles) {
            if (log.isDebugEnabled()) {
                log.debug("............ Checking RoleMapEntry: R [" + roleMapEntry.getId() + "]; N [" + roleMapEntry.getNetworkId() + "]; P [" + roleMapEntry.getProjectId() + "]; PP [" + roleMapEntry.getProjectParticipantId() + "]; C [" + roleMapEntry.getContextId() + "]; OP [" + roleMapEntry.getOrganisationPersonId() + "]");
                log.debug("............ Desired action is: [" + action.getAction().getName() + "]");
            }
            if (!this.validateAction(roleMapEntry, action)) continue;
            return true;
        }
        return false;
    }

    public boolean validateAction(RoleMapEntry networkRole, ActionRule action) {
        Role role = this.roleDAO.get(networkRole.getId());
        if (role.hasAction(action.getAction().getName())) {
            if (log.isDebugEnabled()) {
                log.debug("........ NetworkValidator.validateAction returns YES for role " + networkRole.getId() + ", action " + action.getAction().getName());
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("............ NetworkValidator.validateAction returns NO since no check passed.");
        }
        return false;
    }

    public boolean validateMember(Network network, OrganisationPerson organisationPerson) {
        if (network == null) {
            return false;
        }
        return network.getOrganisations().containsKey(organisationPerson.getOrganisation().getId());
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }
}

