/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.person.PasswordUtils;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.api.sec.PersonVariablesDTO;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.mail.MailModes;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.network.NetworkPerson;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.PasswordForgottenTicket;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.person.PersonTraining;
import at.cdes.bo.data.person.PersonVariables;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.data.search.Search;
import at.cdes.bo.data.sec.TabSession;
import at.cdes.bo.data.task.ReviewableTask;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.role.RoleMap;
import at.cdes.bo.sec.TapestryPasswordChanger;
import at.cdes.bo.sec.certificate.KeyHelper;
import at.cdes.bo.sec.symetric.PasswordEncryption;
import at.cdes.controller.actionhandler.login.URLMapper;
import at.cdes.controller.helper.CdesDTOHelper;
import at.cdes.db.dao.OrganisationDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.PersonDAO;
import at.cdes.db.dao.PersonVariablesDAO;
import at.cdes.db.dao.SearchDAO;
import at.cdes.db.dao.TaskDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.oldGwtDto.ProjectParticipantDTO;
import at.cdes.oldGwtDto.RoleMapGWT;
import at.cdes.service.CertificateOperations;
import at.cdes.service.MailOperations;
import at.cdes.service.NetworkOperations;
import at.cdes.service.PersonOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.NoPasswordException;
import at.cdes.service.exception.UnkownLoginException;
import at.cdes.service.exception.WrongPasswordException;
import at.cdes.util.DLStringMatcher;
import at.cdes.util.ImplContextHelper;
import java.security.KeyPair;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.HasherFactory;
import org.clazzes.util.sec.PasswordHasherFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.xnap.commons.i18n.I18n;

public class PersonOperationsImpl
implements PersonOperations {
    private PersonDAO personDAO;
    private SearchDAO searchDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private TaskDAO taskDAO;
    private PersonVariablesDAO personVariablesDAO;
    private CertificateOperations certificateOperations;
    private NetworkOperations networkOperations;
    private Boolean debugEnabled;
    private Bundle blueprintBundle;
    private PasswordUtils passwordUtils;
    private ProjectOperations projectOperations;
    private TapestryPasswordChanger tapestryPasswordChanger;
    private URLMapper urlMapper;
    private MailOperations mailOperations;
    private OrganisationDAO organisationDAO;
    private Long passwordMaxAge;
    private String sessionThreadLocalKey;
    static Logger log = Logger.getLogger(PersonOperationsImpl.class);

    public void setNetworkOperations(NetworkOperations networkOperations) {
        this.networkOperations = networkOperations;
    }

    public void setDebugEnabled(Boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void setBlueprintBundle(Bundle blueprintBundle) {
        this.blueprintBundle = blueprintBundle;
    }

    public void setPasswordUtils(PasswordUtils passwordUtils) {
        this.passwordUtils = passwordUtils;
    }

    public void setTapestryPasswordChanger(TapestryPasswordChanger tapestryPasswordChanger) {
        this.tapestryPasswordChanger = tapestryPasswordChanger;
    }

    public void setPasswordMaxAge(Long passwordMaxAge) {
        this.passwordMaxAge = passwordMaxAge;
    }

    public void setSessionThreadLocalKey(String sessionThreadLocalKey) {
        this.sessionThreadLocalKey = sessionThreadLocalKey;
    }

    @Override
    public Person getPerson(Integer id) {
        return this.personDAO.get(id);
    }

    @Override
    public PersonVariables getPersonVariables(Integer personId) {
        return this.personVariablesDAO.getByPerson(personId);
    }

    @Override
    public List getNetworks(Person person) {
        Map<Integer, OrganisationPerson> orgPersons = person.getOrganisationPersons();
        ArrayList networks = new ArrayList();
        for (OrganisationPerson o : orgPersons.values()) {
            o.getId();
            if (o.getOrganisation().getNetworks() == null) continue;
            networks.addAll(o.getOrganisation().getNetworks().values());
        }
        return networks;
    }

    @Override
    public void savePersonVariables(PersonVariables personVariables) {
        this.personVariablesDAO.save(personVariables);
    }

    @Override
    public PersonVariables updatePersonVariables(PersonVariables personVariables) {
        return this.personVariablesDAO.update(personVariables);
    }

    @Override
    public List getPersons(Integer networkId, Integer organisationPersonId, String filter, Integer personStatus) {
        if (networkId == null && organisationPersonId == null) {
            return this.personDAO.getAll(filter, personStatus);
        }
        return this.organisationPersonDAO.getAllPersons(networkId, organisationPersonId != null ? this.organisationPersonDAO.get(organisationPersonId).getOrganisation().getId() : null, filter, personStatus);
    }

    @Override
    public List getPersonsFromOtherNetworks(Integer ownNetworkId, String filter, Integer personStatus) {
        return this.organisationPersonDAO.getAllFromOtherNetworks(ownNetworkId, filter, personStatus);
    }

    @Override
    public Person insertPerson(Person person) {
        if ((person = this.personDAO.save(person)).getOrganisationPersons() != null) {
            Iterator<OrganisationPerson> it = person.getOrganisationPersons().values().iterator();
            while (it.hasNext()) {
                this.organisationPersonDAO.save(it.next());
            }
        }
        return person;
    }

    @Override
    public void deletePerson(Person person) {
        List<Search> searches;
        if (person.getOrganisationPersons() != null) {
            Iterator<OrganisationPerson> it = person.getOrganisationPersons().values().iterator();
            while (it.hasNext()) {
                this.deleteOrganisationPerson(it.next().getId());
            }
        }
        if ((searches = this.searchDAO.getAll(person.getId())) != null) {
            for (Search search : searches) {
                this.searchDAO.delete(search);
            }
        }
        try {
            this.personVariablesDAO.delete(person.getPersonVariables(false));
            this.personDAO.delete(person);
        }
        catch (DAOException e) {
            log.warn((Object)("Error deleting person[id=" + person.getId() + "] caused by DataAccessException."));
        }
    }

    @Override
    public Person updatePerson(Person person) {
        Person per = this.personDAO.get(person.getId());
        per.setGender(person.getGender());
        per.setGivenName(person.getGivenName());
        per.setSurName(person.getSurName());
        per.setTitle(person.getTitle());
        per.setRole(person.getRole());
        per.setZtPermission(person.isZtPermission());
        per.setPassword(person.getPassword());
        per.setGender(person.getGender());
        return this.personDAO.update(per);
    }

    @Override
    public OrganisationPerson getOrganisationPerson(Integer id) {
        return this.organisationPersonDAO.get(id);
    }

    @Override
    public OrganisationPerson getOrganisationPerson2(Integer personId, Integer organisationId) {
        return this.organisationPersonDAO.get(personId, organisationId);
    }

    @Override
    public OrganisationPerson insertOrganisationPerson(OrganisationPerson orgPerson, boolean withPerson, String userLocale) {
        Person person = null;
        if (withPerson && orgPerson.getPerson().getId() == null) {
            person = this.personDAO.save(orgPerson.getPerson());
            PersonVariables vars = new PersonVariables();
            vars.setPerson(person);
            if (userLocale != null) {
                vars.setUserLocale(userLocale);
            } else {
                vars.setUserLocale("de");
            }
            this.savePersonVariables(vars);
            person.setVariables(vars);
        } else {
            person = this.getPerson(orgPerson.getPerson().getId());
        }
        if (orgPerson.getEmailSendMode() == null || orgPerson.getEmailSendMode() == 0) {
            orgPerson.setEmailSendMode(MailModes.BRIEF);
            orgPerson.setEmailSendTime(780);
        }
        orgPerson.setPerson(person);
        orgPerson = this.organisationPersonDAO.save(orgPerson);
        if (person.getOrganisationPersons() == null) {
            person.setOrganisationPersons(new HashMap<Integer, OrganisationPerson>());
        }
        person.getOrganisationPersons().put(orgPerson.getId(), orgPerson);
        this.updatePerson(person);
        return orgPerson;
    }

    @Override
    public OrganisationPerson updateOrganisationPerson(OrganisationPerson orgPerson, boolean withPerson) {
        if (withPerson) {
            orgPerson.setPerson(this.updatePerson(orgPerson.getPerson()));
        }
        return this.organisationPersonDAO.update(orgPerson);
    }

    @Override
    public void deleteOrganisationPerson(Integer opId) {
        OrganisationPerson op = this.organisationPersonDAO.get(opId);
        if (op.getCertificates() != null) {
            Iterator it = op.getCertificates().values().iterator();
            while (it.hasNext()) {
                this.certificateOperations.deleteCert(((CDESCertificate)it.next()).getId());
            }
        }
        this.mailOperations.deleteOrganisationPersonReferences(op.getId());
        this.organisationPersonDAO.delete(op);
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    @Override
    public Task getTask(Integer id) {
        return this.taskDAO.get(id);
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    @Override
    public String getOrganisationPersonURL(Integer organisationPersonId) {
        OrganisationPerson op = this.organisationPersonDAO.get(organisationPersonId);
        return this.urlMapper.getURL(op);
    }

    @Override
    public String getPersonURL(Integer personId) {
        Person p = this.personDAO.get(personId);
        return this.urlMapper.getURL(p);
    }

    @Override
    public Person getPersonLogin(String login, String password) throws UnkownLoginException, WrongPasswordException, NoPasswordException {
        Person person = this.personDAO.get(login);
        if (person == null) {
            throw new UnkownLoginException("No Person found with that Login.");
        }
        if (person.getPassword() == null || person.getPassword().length() == 0) {
            throw new NoPasswordException("Person has no password defined");
        }
        if (!this.checkPersonPassword(person, password)) {
            throw new WrongPasswordException();
        }
        return person;
    }

    @Override
    public Person getPersonByLogin(String login) {
        Person person = this.personDAO.get(login);
        return person;
    }

    @Override
    public boolean checkPersonPassword(Person person, String password) {
        String pwd = person.getPassword();
        HasherFactory factory = new HasherFactory();
        boolean ok = HashTools.checkPassword((PasswordHasherFactory)factory, (String)password, (String)pwd);
        return ok;
    }

    @Override
    public boolean checkPersonCertificatePassword(Integer personId, String password) throws WrongPasswordException {
        Collection<OrganisationPerson> ops = this.personDAO.get(personId).getOrganisationPersons().values();
        for (OrganisationPerson op : ops) {
            Collection certs = op.getCertificates().values();
            for (CDESCertificate certificate : certs) {
                if (!certificate.isMayLogin()) continue;
                try {
                    KeyPair kp = KeyHelper.openKeyPair(certificate.getPrivateKey(), password);
                    if (kp == null) continue;
                    return true;
                }
                catch (WrongPasswordException e) {
                    throw new WrongPasswordException("Password wrong when encrypting private key");
                }
            }
        }
        throw new WrongPasswordException("Password wrong when encrypting private key");
    }

    @Override
    public Person changePersonPasswordAndSecurityQuestion(Integer personId, String newPassword, String oldPassword, String question, String answer) throws WrongPasswordException {
        Person person = this.personDAO.get(personId);
        if (newPassword != null && newPassword.length() > 0 && person.getOrganisationPersons() != null) {
            for (OrganisationPerson op : person.getOrganisationPersons().values()) {
                if (op.getCertificates() == null) continue;
                for (CDESCertificate cert : op.getCertificates().values()) {
                    if (cert.getPrivateKey() == null || cert.getPrivateKey().isEmpty()) continue;
                    try {
                        cert = this.certificateOperations.changePassword(newPassword, oldPassword, cert);
                        this.certificateOperations.updateCert(cert);
                    }
                    catch (WrongPasswordException e) {
                        if (cert.isMaySign() && cert.getValidTo() != null && cert.getValidTo().after(new Date(System.currentTimeMillis()))) {
                            log.error((Object)("Error changing password of active certificate[id=" + cert.getId() + "]."), (Throwable)e);
                            throw e;
                        }
                        log.warn((Object)("Error changing password of inactive certificate[id=" + cert.getId() + "]."), (Throwable)e);
                    }
                }
            }
            person = this.setPersonPassword(person, newPassword);
        }
        if (question != null && question.length() > 0 && answer != null && answer.length() > 0) {
            String passwordToBeEncrypted = oldPassword;
            if (newPassword != null && newPassword.length() > 0) {
                passwordToBeEncrypted = newPassword;
            }
            person.setSecurityQuestion(question);
            String hashed = this.passwordUtils.encryptSecurityAnswer(passwordToBeEncrypted, answer);
            person.setQuestionEncryptedPassword(hashed);
            return this.personDAO.update(person);
        }
        return this.updatePerson(person);
    }

    @Override
    public Person setPersonPassword(Person person, String password) {
        this.tapestryPasswordChanger.setPassword(person.getId(), password);
        return this.personDAO.get(person.getId());
    }

    @Override
    public Person setPersonSecurityQuestion(Person person, String question, String answer, String password) {
        PasswordEncryption enc = new PasswordEncryption();
        String hashed = this.passwordUtils.encryptSecurityAnswer(password, answer);
        person.setQuestionEncryptedPassword(hashed);
        person.setSecurityQuestion(question);
        return person;
    }

    @Override
    public void changePasswordWithAnswer(Person person, String answer, String newPassword) throws WrongPasswordException {
        String oldPassword = this.passwordUtils.decryptSecurityAnswer(person.getQuestionEncryptedPassword(), answer);
        String question = person.getSecurityQuestion();
        this.setPersonSecurityQuestion(person, question, answer, newPassword);
        this.changePersonPasswordAndSecurityQuestion(person.getId(), newPassword, oldPassword, null, null);
    }

    public void setCertificateOperations(CertificateOperations certificateOperations) {
        this.certificateOperations = certificateOperations;
    }

    @Override
    public PasswordForgottenTicket createPasswordForgottenTicket(Person person) {
        PasswordForgottenTicket ticket = new PasswordForgottenTicket();
        ticket.setPerson(person);
        ticket.setDone(false);
        ticket.setDate(new Date(System.currentTimeMillis()));
        ticket.setUuid(UUID.randomUUID().toString());
        return this.personDAO.save(ticket);
    }

    @Override
    public PasswordForgottenTicket finishPasswordForgottenTicket(PasswordForgottenTicket ticket) {
        ticket.setDone(true);
        return this.personDAO.update(ticket);
    }

    @Override
    public PasswordForgottenTicket getPasswordForgottenTicket(Integer id) {
        return this.personDAO.getPasswordForgottenTicket(id);
    }

    @Override
    public boolean checkPersonSecurityAnswer(Person person, String answer) throws WrongPasswordException {
        PasswordEncryption enc = new PasswordEncryption();
        try {
            String oldPassword = this.passwordUtils.decryptSecurityAnswer(person.getQuestionEncryptedPassword(), answer);
            return oldPassword != null;
        }
        catch (Exception e) {
            log.error((Object)("Exception while decrypting securityAnswer of user [" + person.getLogin() + "] (" + person.getGivenName() + " " + person.getSurName() + "); Exception will follow in CleanLoggingInterceptor."));
            throw e;
        }
    }

    @Override
    public String generatePasswordForgottenEMailText(Person person, PasswordForgottenTicket ticket) {
        Locale locale = new Locale(person.getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        StringBuffer sb = new StringBuffer();
        sb.append(String.format(i18n.tr("S.g. %s!"), person.getCommonName()));
        sb.append("\n\n");
        sb.append(i18n.tr("Sie haben die Neuausstellung ihres CDES Benutzerzugangs beantragt.") + "\n");
        sb.append(i18n.tr("Klicken sie hier um ihren Zugang zu erneuern.") + " " + this.urlMapper.getURL(person) + "/cdes/app?service=external/RequestNewPassword&sp=" + ticket.getId() + "\n");
        sb.append("\n");
        sb.append(i18n.tr("mfg\n\nIhr CDES-Betreiber\n"));
        return sb.toString();
    }

    @Override
    public void invalidateUserLoginAndCertificates(Person person) {
        person.setLogin(null);
        person.setPassword(null);
        this.personDAO.update(person);
        if (person.getOrganisationPersons() == null) {
            return;
        }
        Collection<OrganisationPerson> ops = person.getOrganisationPersons().values();
        for (OrganisationPerson op : ops) {
            if (op.getCertificates() == null) continue;
            Collection certs = op.getCertificates().values();
            for (CDESCertificate certificate : certs) {
                this.certificateOperations.invalidateCert(certificate);
            }
        }
    }

    @Override
    public List<PersonTraining> getPersonalTrainings(Integer personId) {
        return this.personDAO.getAllTrainings(personId);
    }

    @Override
    public void saveOrUpdatePersonalTrainings(Collection<PersonTraining> trainings) {
        if (trainings == null) {
            return;
        }
        for (PersonTraining training : trainings) {
            if (training.getComment() == null || training.getComment().length() == 0) continue;
            if (training.getId() == null || training.getId() < 1) {
                training = this.personDAO.save(training);
                continue;
            }
            PersonTraining personTraining = this.personDAO.update(training);
        }
    }

    @Override
    public Collection<OrganisationPerson> getOrganisationPersons(Integer networkId) {
        return this.organisationPersonDAO.getAll(networkId);
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    public void setUrlMapper(URLMapper urlMapper) {
        this.urlMapper = urlMapper;
    }

    @Override
    public Pair<Person, Boolean> getPersonWithNetworkContext(Integer personId, Integer networkId) {
        Pair pair = new Pair();
        Person person = this.personDAO.get(personId);
        Collection<OrganisationPerson> orgPersons = person.getOrganisationPersons().values();
        boolean hasNetworkContext = false;
        for (OrganisationPerson orgPerson : orgPersons) {
            if (this.organisationPersonDAO.getAllPersons(networkId, orgPerson.getOrganisation().getId(), null, -1).size() <= 0) continue;
            hasNetworkContext = true;
            break;
        }
        pair.setFirst((Object)person);
        pair.setSecond((Object)new Boolean(hasNetworkContext));
        return pair;
    }

    @Override
    public String getAllPersonsMatchingStrings(Integer networkId, Integer organisationPersonId) {
        String resultString = "";
        String personSeparator = "$";
        String subElementSeparator = "|";
        ArrayList<Integer> donePersonIDs = new ArrayList<Integer>();
        List ownPersons = this.getPersons(networkId, organisationPersonId, null, -1);
        for (Person person : ownPersons) {
            Collection<OrganisationPerson> orgPersons = person.getOrganisationPersons().values();
            Iterator<OrganisationPerson> it = orgPersons.iterator();
            String organisationIds = "";
            while (it.hasNext()) {
                organisationIds = organisationIds + it.next().getOrganisation().getId();
                if (!it.hasNext()) continue;
                organisationIds = organisationIds + ";";
            }
            resultString = resultString + person.getId() + subElementSeparator + person.getGivenName() + subElementSeparator + person.getSurName() + subElementSeparator + "true" + subElementSeparator + organisationIds + personSeparator;
            donePersonIDs.add(person.getId());
        }
        List otherPersons = this.getPersonsFromOtherNetworks(networkId, null, -1);
        for (Person person : otherPersons) {
            if (donePersonIDs.contains(person.getId())) continue;
            Collection<OrganisationPerson> orgPersons = person.getOrganisationPersons().values();
            Iterator<OrganisationPerson> it = orgPersons.iterator();
            String organisationIds = "";
            while (it.hasNext()) {
                organisationIds = organisationIds + it.next().getOrganisation().getId();
                if (!it.hasNext()) continue;
                organisationIds = organisationIds + ";";
            }
            resultString = resultString + person.getId() + subElementSeparator + person.getGivenName() + subElementSeparator + person.getSurName() + subElementSeparator + "false" + subElementSeparator + organisationIds + personSeparator;
            donePersonIDs.add(person.getId());
        }
        return resultString;
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    @Override
    public Person invalidatePerson(Integer personId, Integer organisationPersonId) throws ActionException {
        Person p = this.getPerson(personId);
        List pps = this.projectOperations.getPersonsProjectParticipants(personId);
        for (ProjectParticipant pp : pps) {
            if (!pp.isMainParticipant() || this.projectOperations.isProjectParticipationInvalidatable(pp.getParticipation())) continue;
            throw new ActionException("could not invalidate ProjectParticipation");
        }
        for (ProjectParticipant part : pps) {
            ProjectParticipation participation = part.getParticipation();
            if (part.isMainParticipant() && participation.getProjectParticipants().size() <= 1) {
                this.projectOperations.invalidateProjectParticipation(part.getParticipation().getId());
                continue;
            }
            ArrayList<ProjectParticipant> deletePart = new ArrayList<ProjectParticipant>();
            deletePart.add(part);
            ProjectParticipant newMainParticipant = null;
            if (part.isMainParticipant()) {
                ArrayList participants = new ArrayList(participation.getProjectParticipants().values());
                for (ProjectParticipant pp : participants) {
                    if (part.getId().equals(pp.getId())) continue;
                    newMainParticipant = pp;
                }
            }
            this.projectOperations.updateProjectParticipation(participation, newMainParticipant, null, deletePart, new ArrayList<SubProject>(), new ArrayList<SubProject>(), null, null, organisationPersonId);
        }
        List certificates = this.certificateOperations.getCertificatesByPerson(personId);
        for (CDESCertificate cert2del : certificates) {
            this.certificateOperations.invalidateCert(cert2del);
        }
        p.setStatus(2);
        return this.personDAO.update(p);
    }

    @Override
    public Person updatePersonCompletely(Person p) {
        return this.personDAO.update(p);
    }

    @Override
    public Person changePersonStatusMarkedForDeletionAndRemoveOccurences(Integer personId) {
        Person person = this.getPerson(personId);
        List participants = this.projectOperations.getProjectParticipants(person);
        for (ProjectParticipant part : participants) {
            if (!part.isMainParticipant() || part.getParticipation().getStatus() != 0) continue;
            this.projectOperations.deleteAssignmentsOfParticipationAndInvalidateOrMarkForDeletion(part.getParticipation().getId());
        }
        person.setStatus(1);
        return this.personDAO.update(person);
    }

    public void changePersonStatusToInvalidIfMarkedAndPossible(Integer personId) {
        Person person = this.getPerson(personId);
        List participants = this.projectOperations.getProjectParticipants(person);
        boolean invalidatable = true;
        ArrayList<Project> personsProjects = new ArrayList<Project>();
        for (ProjectParticipant part : participants) {
            if (!part.isMainParticipant() || part.getParticipation().getStatus() != 0) continue;
            if (this.projectOperations.isProjectParticipationInvalidatable(part.getParticipation())) {
                personsProjects.add(part.getParticipation().getProject());
                continue;
            }
            invalidatable = false;
        }
        if (invalidatable) {
            for (Project p : personsProjects) {
                this.projectOperations.invalidateAllMarkedProjectParticipations(p);
            }
            person.setStatus(1);
            this.personDAO.update(person);
        }
    }

    @Override
    public Person changePersonStatus(Integer personId, int personStatus) {
        Person p = this.getPerson(personId);
        p.setStatus(personStatus);
        return this.personDAO.update(p);
    }

    @Override
    public void invalidateAllMarkedPersons(Integer networkId) {
        List markedPersons = this.getPersons(networkId, null, null, 1);
        for (Person markedPerson : markedPersons) {
            List participants = this.projectOperations.getPersonsProjectParticipants(markedPerson.getId());
            for (ProjectParticipant participant : participants) {
                if (participant.getParticipation().getStatus() == 2) continue;
                return;
            }
            this.changePersonStatus(markedPerson.getId(), 2);
        }
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    @Override
    public List getPotentialPersonsWithMatchingNames(String givenName, String surName, int maxDistance, Integer networkId, Integer activePersonId) {
        ArrayList<Person> matches = new ArrayList<Person>();
        List allPersons = this.getPersons(activePersonId == null ? null : networkId, null, null, -1);
        String sourceName = givenName.trim() + surName.trim();
        for (Person person : allPersons) {
            String destName = person.getGivenName().trim() + person.getSurName().trim();
            if (person.getId().equals(activePersonId) || !DLStringMatcher.valdiateDistance(sourceName, destName, maxDistance)) continue;
            matches.add(person);
        }
        return matches;
    }

    @Override
    public void createDirectCertificationRequest(Integer certifiedOrgPersonId, Integer issuingOrgPersonId) {
        OrganisationPerson certificateOwner = this.getOrganisationPerson(certifiedOrgPersonId);
        OrganisationPerson certificateIssuer = this.getOrganisationPerson(issuingOrgPersonId);
        certificateOwner.setDirectCertificationRequestIssuer(certificateIssuer);
        this.organisationPersonDAO.update(certificateOwner);
    }

    @Override
    public int getActivePersonCount() {
        return this.personDAO.getActivePersonCount();
    }

    @Override
    public Integer checkUserLogin(String userName, String password) {
        Person person = this.getPersonByLogin(userName);
        if (person != null) {
            return person.getId();
        }
        return null;
    }

    @Override
    public PersonVariablesDTO getPersonVariablesDTO(Integer personId) {
        PersonVariables pv;
        block2: {
            Person person;
            block3: {
                person = this.personDAO.get(personId);
                pv = person.getPersonVariables(false);
                if (pv.getActiveOrganisationPersonId() != null) break block3;
                Collection<OrganisationPerson> possibleOrgPersons = person.getOrganisationPersons().values();
                for (OrganisationPerson possibleOrgPerson : possibleOrgPersons) {
                    CDESCertificate validCert = this.certificateOperations.getSignerCertificate(possibleOrgPerson.getId(), false);
                    if (possibleOrgPerson.isInActive() || !possibleOrgPerson.getPerson().getId().equals(person.getId()) || validCert == null) continue;
                    pv.setActiveOrganisationPersonId(possibleOrgPerson.getId());
                    break block2;
                }
                break block2;
            }
            OrganisationPerson orgPerson = this.organisationPersonDAO.get(pv.getActiveOrganisationPersonId());
            CDESCertificate validCert = this.certificateOperations.getSignerCertificate(orgPerson.getId(), false);
            if (!orgPerson.isInActive() && validCert != null) break block2;
            Collection<OrganisationPerson> possibleOrgPersons = person.getOrganisationPersons().values();
            for (OrganisationPerson possibleOrgPerson : possibleOrgPersons) {
                validCert = this.certificateOperations.getSignerCertificate(possibleOrgPerson.getId(), false);
                if (possibleOrgPerson.isInActive() || !possibleOrgPerson.getPerson().getId().equals(person.getId()) || validCert == null) continue;
                pv.setActiveOrganisationPersonId(possibleOrgPerson.getId());
                break;
            }
        }
        return CdesDTOHelper.getPersonVariablesDTO(pv, this.certificateOperations.hasMultipleCertifiedOrganisationPersons(personId));
    }

    @Override
    public RoleMapGWT createRoleMapGWT(Integer orgPersonId) {
        OrganisationPerson organisationPerson = this.getOrganisationPerson(orgPersonId);
        Person user = organisationPerson.getPerson();
        RoleMapGWT roleMap = new RoleMapGWT();
        roleMap.add(user.getRole().getId(), null, null, null, null);
        List networks = this.getNetworks(user);
        for (int i = 0; i < networks.size(); ++i) {
            Network network = (Network)networks.get(i);
            Iterator roleIt = network.getNetworkRoles().values().iterator();
            for (NetworkPerson networkPerson : network.getNetworkPersons().values()) {
                OrganisationPerson uop = user.getOrganisationPersons().get(networkPerson.getOrganisationPerson().getId());
                if (uop == null) continue;
                roleMap.add(networkPerson.getRole().getId(), network.getId(), null, null, networkPerson.getOrganisationPerson().getId());
            }
            while (roleIt.hasNext()) {
                Role role = (Role)roleIt.next();
                if (!role.isContextDefaultRole()) continue;
                for (OrganisationPerson orgPerson : user.getOrganisationPersons().values()) {
                    if (network.getOrganisations().get(orgPerson.getOrganisation().getId()) == null) continue;
                    roleMap.add(role.getId(), network.getId(), null, null, orgPerson.getId());
                }
            }
        }
        List participants = this.projectOperations.getProjectParticipants(user);
        for (int i = 0; i < participants.size(); ++i) {
            ProjectParticipant participant = (ProjectParticipant)participants.get(i);
            int projectFlag = participant.getParticipation().getRole().getProjectFlag();
            roleMap.add(participant.getParticipation().getRole().getId(), participant.getParticipation().getProject().getNetwork().getId(), participant.getParticipation().getProject().getId(), participant.getId(), participant.getOrganisationPerson().getId());
        }
        return roleMap;
    }

    @Override
    public ProjectParticipantDTO getOverridingProjectParticipantDTO(Integer organisationPersonId, Integer taskId) {
        ReviewableTask task = (ReviewableTask)this.taskDAO.get(taskId);
        SubProject sp = task.getDocumentVersion().getDocument().getDocumentList().getSubProject();
        List<ProjectParticipation> participationsForAction = this.projectOperations.getAllProjectParticipationsForAction("overrideLateReviews", organisationPersonId, 2);
        if (participationsForAction != null && !participationsForAction.isEmpty()) {
            for (ProjectParticipation part : participationsForAction) {
                if (!part.getProject().getId().equals(sp.getProject().getId())) continue;
                ArrayList participants = new ArrayList(part.getProjectParticipants().values());
                for (ProjectParticipant participant : participants) {
                    if (!participant.getOrganisationPerson().getId().equals(organisationPersonId)) continue;
                    return CdesDTOHelper.getProjectParticipantDTO(participant, false);
                }
            }
        }
        log.error((Object)("Could not find suitable participant for override action orgPersonId=[" + organisationPersonId + "] taskId=[" + taskId + "]"));
        return null;
    }

    @Override
    public TabSession openTabSession(String userName) {
        Person person = this.getPersonByLogin(userName);
        Integer personId = person.getId();
        PersonVariables personVariables = this.getAndUpdatePersonVariablesForSecurity(personId);
        String userLocaleFromPersonVariables = this.getUserLocaleFromPersonVariables(personId, personVariables);
        Version version = this.blueprintBundle.getVersion();
        TabSession tabSession = this.debugEnabled != false && version.toString().endsWith("SNAPSHOT") ? new TabSession(personId, userName, userName) : new TabSession(personId, userName);
        tabSession.setLocale(userLocaleFromPersonVariables != null ? new Locale(userLocaleFromPersonVariables) : Locale.GERMAN);
        tabSession.setContextOrganisationPersonId(this.getInitialContextOrganisationPerson(person, personVariables));
        tabSession.setRoleMap(this.createRoleMap(person));
        this.updateContextInTabSession(tabSession, personId, personVariables);
        return tabSession;
    }

    @Override
    public void updatePersonVariablesWithCurrentTabSession() {
        TabSession tabSession = ImplContextHelper.getTabSession();
        this.updatePersonVariablesWithTabSession(tabSession);
    }

    @Override
    public void updatePersonVariablesWithTabSession(TabSession tabSession) {
        Integer loginPersonId = tabSession.getPersonId();
        PersonVariables personVariables = this.getPersonVariables(loginPersonId);
        personVariables.setActiveNetworkId(tabSession.getContextNetworkId());
        personVariables.setActiveProjectId(tabSession.getContextProjectId());
        personVariables.setActiveSubProjectId(tabSession.getContextSubProjectId());
        personVariables.setActivePNNetworkId(tabSession.getPnContextNetworkId());
        personVariables.setActivePNProjectId(tabSession.getPnContextProjectId());
        personVariables.setActiveOrganisationPersonId(tabSession.getContextOrganisationPersonId());
        personVariables.setPreselectedTab(tabSession.isPnViewActive() ? 7 : 6);
        this.updatePersonVariables(personVariables);
    }

    @Override
    public void updateTabSessionOnOrganisationPersonChange(Integer desiredOrganisationPersonId) {
        TabSession tabSession = ImplContextHelper.getTabSession();
        Integer personId = tabSession.getPersonId();
        Person person = this.getPerson(personId);
        PersonVariables personVariables = this.getAndUpdatePersonVariablesForSecurity(personId);
        String userLocaleFromPersonVariables = this.getUserLocaleFromPersonVariables(personId, personVariables);
        tabSession.setLocale(userLocaleFromPersonVariables != null ? new Locale(userLocaleFromPersonVariables) : Locale.GERMAN);
        tabSession.setContextOrganisationPersonId(desiredOrganisationPersonId);
        tabSession.setRoleMap(this.createRoleMap(person));
        this.updateContextInTabSession(tabSession, personId, personVariables);
    }

    private PersonVariables getAndUpdatePersonVariablesForSecurity(Integer personId) {
        PersonVariables personVariables = this.getPersonVariables(personId);
        if (personVariables == null) {
            throw new RuntimeException("No PersonVariables exists for personId [" + personId + "]");
        }
        this.updatePersonVariablesForSecurityIfNecessary(personId, personVariables);
        return personVariables;
    }

    private String getUserLocaleFromPersonVariables(Integer personId, PersonVariables personVariables) {
        String userLocaleFromPersonVariables = personVariables.getUserLocale();
        if (userLocaleFromPersonVariables == null) {
            log.warn((Object)("Loaded PersonVariables for person [" + personId + "]; its locale is null.  Using default locale [de]"));
            userLocaleFromPersonVariables = null;
        } else {
            log.info((Object)("Loaded PersonVariables for person [" + personId + "]; its locale is [" + userLocaleFromPersonVariables + "]"));
        }
        return userLocaleFromPersonVariables;
    }

    private void updatePersonVariablesForSecurityIfNecessary(Integer personId, PersonVariables personVariables) {
        OrganisationPerson organisationPerson;
        if (personVariables.getActiveOrganisationPersonId() != null && (organisationPerson = this.organisationPersonDAO.getByPersonOrgPersonId(personId, personVariables.getActiveOrganisationPersonId())) == null) {
            personVariables.setActiveOrganisationPersonId(null);
            this.updatePersonVariables(personVariables);
        }
        if (personVariables.getActiveSubProjectId() != null) {
            boolean activeSubProjectInvalid = true;
            if (personVariables.getActiveOrganisationPersonId() != null) {
                Integer projectId = personVariables.getActiveProjectId() != null ? personVariables.getActiveProjectId() : this.projectOperations.getSubProject(personVariables.getActiveSubProjectId()).getProject().getId();
                Integer organisationPersonId = personVariables.getActiveOrganisationPersonId();
                List subProjects = this.projectOperations.getVisibleSubProjectForOrganisationPerson(projectId, organisationPersonId);
                for (SubProject subProject : subProjects) {
                    if (!subProject.getId().equals(personVariables.getActiveSubProjectId())) continue;
                    activeSubProjectInvalid = false;
                }
            }
            if (activeSubProjectInvalid) {
                personVariables.setActiveSubProjectId(null);
                this.updatePersonVariables(personVariables);
            }
        }
    }

    private Integer getInitialContextOrganisationPerson(Person person, PersonVariables personVariables) {
        OrganisationPerson orgPerson = null;
        if (personVariables.getActiveOrganisationPersonId() != null) {
            orgPerson = this.getOrganisationPerson(personVariables.getActiveOrganisationPersonId());
        }
        if (orgPerson != null && orgPerson.getPerson() != null && !orgPerson.isInActive() && orgPerson.getPerson().getId().equals(person.getId()) && this.certificateOperations.getSignerCertificate(orgPerson.getId(), false) != null) {
            return orgPerson.getId();
        }
        Collection<OrganisationPerson> possibleOrgPersons = person.getOrganisationPersons().values();
        for (OrganisationPerson pop : possibleOrgPersons) {
            if (pop.isInActive() || !pop.getPerson().getId().equals(person.getId()) || this.certificateOperations.getSignerCertificate(pop.getId(), false) == null) continue;
            return pop.getId();
        }
        return null;
    }

    @Override
    public RoleMap createRoleMap(Person user) {
        RoleMap roleMap = new RoleMap();
        if (log.isDebugEnabled()) {
            log.debug((Object)("RoleMap: Adding global role [" + user.getRole().getId() + "]"));
        }
        roleMap.add(user.getRole().getId(), null, null, null, null);
        List networks = this.networkOperations.getNetworksByPersonId(user.getId());
        for (int i = 0; i < networks.size(); ++i) {
            Network network = (Network)networks.get(i);
            for (NetworkPerson networkPerson : network.getNetworkPersons().values()) {
                OrganisationPerson uop = user.getOrganisationPersons().get(networkPerson.getOrganisationPerson().getId());
                if (uop == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RoleMap: Adding administrator role [" + networkPerson.getRole().getId() + "] for: N [" + network.getId() + "]; NP [" + networkPerson.getId() + "]; OP [" + networkPerson.getOrganisationPerson().getId() + "]; P,PP null"));
                }
                roleMap.add(networkPerson.getRole().getId(), network.getId(), null, null, networkPerson.getOrganisationPerson().getId());
            }
            if (network.getNetworkRoles() == null) continue;
            for (Role role : network.getNetworkRoles().values()) {
                if (!role.isContextDefaultRole()) continue;
                for (OrganisationPerson orgPerson : user.getOrganisationPersons().values()) {
                    if (network.getOrganisations().get(orgPerson.getOrganisation().getId()) == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RoleMap: Adding default role [" + role.getId() + "]; N [" + network.getId() + "]; OP [" + orgPerson.getId() + "]; P,PP null"));
                    }
                    roleMap.add(role.getId(), network.getId(), null, null, orgPerson.getId());
                }
            }
        }
        List participants = this.projectOperations.getProjectParticipants(user);
        for (int i = 0; i < participants.size(); ++i) {
            ProjectParticipant participant = (ProjectParticipant)participants.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RoleMap: Adding Participant role [" + participant.getParticipation().getRole().getId() + "]; N [" + participant.getParticipation().getProject().getNetwork().getId() + "]; P [" + participant.getParticipation().getProject().getId() + "]; PP [ " + participant.getId() + "]; OP [" + participant.getOrganisationPerson().getId() + "]"));
            }
            roleMap.add(participant.getParticipation().getRole().getId(), participant.getParticipation().getProject().getNetwork().getId(), participant.getParticipation().getProject().getId(), participant.getId(), participant.getOrganisationPerson().getId());
        }
        return roleMap;
    }

    private void updateContextInTabSession(TabSession tabSession, Integer personId, PersonVariables personVariables) {
        this.updateStandardContextInTabSession(tabSession, personId, personVariables);
        this.updatePlanningNotificationContextInTabSession(tabSession, personId, personVariables);
    }

    private void updateStandardContextInTabSession(TabSession tabSession, Integer personId, PersonVariables personVariables) {
        List possibleNetworks;
        Integer desiredNetworkId = personVariables.getActiveNetworkId();
        Network desiredNetwork = desiredNetworkId != null ? this.networkOperations.getNetwork(desiredNetworkId) : null;
        tabSession.setContextNetworkId(desiredNetwork != null ? desiredNetworkId : null);
        Project chosenProject = null;
        if (desiredNetwork != null) {
            Integer desiredProjectId = personVariables.getActiveProjectId();
            Project desiredProject = desiredProjectId != null ? this.projectOperations.getProject(desiredProjectId) : null;
            try {
                desiredProject.getNetwork().getId();
            }
            catch (Exception e) {
                desiredProject = null;
            }
            if (desiredProject != null) {
                tabSession.setContextProjectId(desiredProject.getId());
                chosenProject = desiredProject;
                if (desiredProject.getNetwork() != null) {
                    tabSession.setContextNetworkId(desiredProject.getNetwork().getId());
                } else {
                    tabSession.setContextProjectId(null);
                    chosenProject = null;
                }
            } else {
                tabSession.setContextProjectId(null);
                chosenProject = null;
            }
            if (desiredProject != null) {
                Integer desiredSubProjectId = personVariables.getActiveSubProjectId();
                SubProject desiredSubProject = desiredSubProjectId != null ? this.projectOperations.getSubProject(desiredSubProjectId) : null;
                try {
                    desiredSubProject.getProject().getNetwork().getId();
                }
                catch (Exception e) {
                    desiredSubProject = null;
                }
                if (desiredSubProject != null) {
                    tabSession.setContextSubProjectId(desiredSubProject.getId());
                    tabSession.setContextProjectId(desiredSubProject.getProject().getId());
                    chosenProject = desiredSubProject.getProject();
                    tabSession.setContextNetworkId(desiredSubProject.getProject().getNetwork().getId());
                } else {
                    tabSession.setContextSubProjectId(null);
                }
            } else {
                tabSession.setContextSubProjectId(null);
            }
        } else {
            tabSession.setContextProjectId(null);
            chosenProject = null;
            tabSession.setContextSubProjectId(null);
        }
        if (tabSession.getContextNetworkId() == null && (possibleNetworks = this.networkOperations.getNetworksByPersonId(personId)).size() > 0) {
            tabSession.setContextNetworkId(((Network)possibleNetworks.get(0)).getId());
            for (Network possibleNetwork : possibleNetworks) {
                List possibleProjects = this.projectOperations.getAllPersonalProjects(possibleNetwork.getId(), tabSession.getContextOrganisationPersonId(), null);
                if (possibleProjects.size() <= 0) continue;
                tabSession.setContextNetworkId(possibleNetwork.getId());
                Integer chosenProjectId = ((Project)possibleProjects.get(0)).getId();
                tabSession.setContextProjectId(chosenProjectId);
                chosenProject = (Project)possibleProjects.get(0);
                List possibleSubProjects = this.projectOperations.getAllSubProjects(chosenProjectId, null, true);
                if (possibleSubProjects.size() <= 0) break;
                tabSession.setContextSubProjectId(((SubProject)possibleSubProjects.get(0)).getId());
                break;
            }
        }
        if (chosenProject != null && chosenProject.getAccess() == 0) {
            tabSession.setContextProjectId(null);
            tabSession.setContextSubProjectId(null);
        }
    }

    private void updatePlanningNotificationContextInTabSession(TabSession tabSession, Integer personId, PersonVariables personVariables) {
        Integer desiredNetworkId = personVariables.getActivePNNetworkId();
        Network desiredNetwork = desiredNetworkId != null ? this.networkOperations.getNetwork(desiredNetworkId) : null;
        tabSession.setPnContextNetworkId(desiredNetwork != null ? desiredNetworkId : null);
        tabSession.setPnViewActive(personVariables.getPreselectedTab() == 7);
        Project chosenProject = null;
        if (desiredNetwork != null) {
            Project desiredProject;
            Integer desiredProjectId = personVariables.getActivePNProjectId();
            Project project = desiredProject = desiredProjectId != null ? this.projectOperations.getProject(desiredProjectId) : null;
            if (desiredProject != null && desiredProject.getStatus() == 10) {
                tabSession.setPnContextProjectId(desiredProject.getId());
                chosenProject = desiredProject;
                tabSession.setPnContextNetworkId(desiredProject.getNetwork().getId());
            } else {
                tabSession.setPnContextProjectId(null);
                chosenProject = null;
            }
        } else {
            tabSession.setPnContextProjectId(null);
            chosenProject = null;
        }
        if (chosenProject != null && chosenProject.getAccess() == 0) {
            tabSession.setContextProjectId(null);
            tabSession.setContextSubProjectId(null);
        }
    }

    @Override
    public PasswordStatus checkPasswordStatus(Integer personId) {
        Person person = this.personDAO.get(personId);
        if (this.passwordMaxAge == 0L) {
            return PasswordStatus.VALID;
        }
        if (person.getLastPasswordChangeTs() == null) {
            return PasswordStatus.WARN;
        }
        Long days = ChronoUnit.DAYS.between(Instant.ofEpochMilli(person.getLastPasswordChangeTs()), Instant.now());
        if (days <= this.passwordMaxAge) {
            return PasswordStatus.WARN;
        }
        return PasswordStatus.EXPIRED;
    }
}

