/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.sec.UserPolicyStatus;
import at.cdes.bo.data.certificate.CertificateRequest;
import at.cdes.bo.sec.TapestryUserPolicyStatusChecker;
import at.cdes.db.dao.CertificateDAO;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class TapestryUserPolicyStatusCheckerImpl
implements TapestryUserPolicyStatusChecker {
    private CertificateDAO certificateDAO;
    private Instant userPolicyDeadline;
    private Long userPolicyDeadlineInterval;
    private Integer userPolicyVersion;

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setUserPolicyDeadline(String userPolicyDeadline) {
        if (userPolicyDeadline != null && userPolicyDeadline.length() > 0) {
            this.userPolicyDeadline = LocalDate.parse(userPolicyDeadline, DateTimeFormatter.ofPattern("dd.MM.yyyy")).plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
    }

    public void setUserPolicyDeadlineInterval(Long userPolicyDeadlineInterval) {
        this.userPolicyDeadlineInterval = userPolicyDeadlineInterval;
    }

    public void setUserPolicyVersion(Integer userPolicyVersion) {
        this.userPolicyVersion = userPolicyVersion;
    }

    @Override
    public UserPolicyStatus checkStatus(Integer personId) {
        if (this.userPolicyDeadline == null) {
            return UserPolicyStatus.UP_TO_DATE;
        }
        boolean outdated = false;
        List<CertificateRequest> signedUserPolicyVersions = this.certificateDAO.getSignedUserPolicyVersionsForPerson(personId);
        for (CertificateRequest signedUserPolicyVersion : signedUserPolicyVersions) {
            Integer mostRecentSignedVersion = signedUserPolicyVersion.getRequestPdfUploadVersion();
            outdated |= mostRecentSignedVersion == null || mostRecentSignedVersion < this.userPolicyVersion;
        }
        Instant shownDeadline = ChronoUnit.DAYS.addTo(this.userPolicyDeadline, -this.userPolicyDeadlineInterval.longValue());
        if (outdated && Instant.now().compareTo(shownDeadline) <= 0) {
            return UserPolicyStatus.WARN;
        }
        return outdated && Instant.now().compareTo(this.userPolicyDeadline) > 0 ? UserPolicyStatus.EXPIRED : UserPolicyStatus.UP_TO_DATE;
    }
}

