/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.cycle.OEBBComment;
import at.cdes.bo.data.cycle.Realm;
import at.cdes.bo.data.cycle.ReviewCyclePositionRelease;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCyclePositionResultImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.db.dao.ReviewCyclePositionResultDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewCyclePositionResultDAOHibernate
extends HibernateDaoSupport
implements ReviewCyclePositionResultDAO {
    private static final Logger log = LoggerFactory.getLogger(ReviewCyclePositionResultDAOHibernate.class);

    @Override
    public ReviewCyclePositionResult get(Integer id) {
        return (ReviewCyclePositionResult)this.getSession().load(ReviewCyclePositionResultImpl.class, (Serializable)id);
    }

    @Override
    public List getAll() {
        return this.loadAllHibernate(ReviewCyclePositionResultImpl.class);
    }

    @Override
    public ReviewCyclePositionResult save(ReviewCyclePositionResult cons) {
        if (log.isDebugEnabled()) {
            log.debug("Saving ReviewCyclePositionResult with Id[" + cons.getId() + "] for ReviewCycleNode with Id [" + cons.getReviewCycleNode().getId() + "].");
        }
        Integer id = (Integer)this.getSession().save((Object)cons);
        if (log.isDebugEnabled()) {
            log.debug("ReviewCyclePositionResult saved, id is [" + id + "].");
        }
        return this.get(id);
    }

    @Override
    public ReviewCyclePositionResult update(ReviewCyclePositionResult cons) {
        if (log.isDebugEnabled()) {
            log.debug("Updating ReviewCyclePositionResult with Id[" + cons.getId() + "] for ReviewCycleNode with Id [" + cons.getReviewCycleNode().getId() + "].");
        }
        this.getSession().merge((Object)cons);
        if (log.isDebugEnabled()) {
            log.debug("ReviewCyclePositionResult saved, id is [" + cons.getId() + "].");
        }
        return cons;
    }

    @Override
    public void delete(ReviewCyclePositionResult cons) {
        if (log.isDebugEnabled()) {
            log.debug("Deleting ReviewCyclePositionResult with Id [" + cons.getId() + "].");
        }
        this.getSession().delete((Object)cons);
        this.getSession().flush();
    }

    @Override
    public List getAll(ReviewCycleNode node, DocumentVersion version) {
        return this.findHibernate("from ReviewCyclePositionResultImpl where documentVersion.id = ? and reviewCycleNode.id = ?", new Object[]{version.getId(), node.getId()});
    }

    @Override
    public ReviewCyclePositionResult get(ReviewCyclePositionResult reference, ProjectParticipation participation, ReviewCycleNode node) {
        if (log.isDebugEnabled()) {
            log.debug("c = " + reference.getId() + " p =" + participation.getId() + " r=" + node.getId());
        }
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("commentReference").add(Restrictions.idEq((Object)reference.getId()));
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participation.getId()));
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        return (ReviewCyclePositionResult)crit.uniqueResult();
    }

    @Override
    public List getAllUnsigned(ReviewCyclePositionResult reference, ProjectParticipation participation, ReviewCycleNode node) {
        if (log.isDebugEnabled()) {
            log.debug("c = " + reference.getId() + " p =" + participation.getId() + " r=" + node.getId());
        }
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("commentReference").add(Restrictions.idEq((Object)reference.getId()));
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participation.getId()));
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        crit.add(Restrictions.isNull((String)"digest"));
        return crit.list();
    }

    @Override
    public List getAll(ReviewCycleNodeResult destNodeResult, ReviewCycleNodeResult nodeResult) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("commentReference").createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)destNodeResult.getId()));
        crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)nodeResult.getId()));
        return crit.list();
    }

    @Override
    public ReviewCyclePositionResult get(Realm realm, ReviewCycleNodeResult reviewCycleNodeResult, ProjectParticipation participation) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)reviewCycleNodeResult.getId()));
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realm.getId()));
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participation.getId()));
        crit.add(Restrictions.isNull((String)"commentReference"));
        return (ReviewCyclePositionResult)crit.uniqueResult();
    }

    @Override
    public ReviewCyclePositionResult get(Realm realm, ReviewCycleNode node, DocumentVersion version, ProjectParticipation participation, Integer reviewCycleNodeResultId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realm.getId()));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)version.getId()));
        if (reviewCycleNodeResultId != null) {
            crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)reviewCycleNodeResultId));
        }
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participation.getId()));
        crit.add(Restrictions.isNull((String)"commentReference"));
        return (ReviewCyclePositionResult)crit.uniqueResult();
    }

    @Override
    public List getAllUnsigned(Realm realm, ReviewCycleNode node, DocumentVersion version, ProjectParticipation participation) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realm.getId()));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)version.getId()));
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participation.getId()));
        crit.add(Restrictions.isNull((String)"commentReference"));
        crit.add(Restrictions.isNull((String)"signature"));
        return crit.list();
    }

    @Override
    public List getUnsigned(Realm realm, ReviewCycleNode node, DocumentVersion version, ProjectParticipation participation, Integer reviewCycleNodeResultId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        if (reviewCycleNodeResultId != null) {
            crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)reviewCycleNodeResultId));
        }
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realm.getId()));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)version.getId()));
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participation.getId()));
        crit.add(Restrictions.isNull((String)"commentReference"));
        crit.add(Restrictions.isNull((String)"signature"));
        return crit.list();
    }

    @Override
    public ReviewCyclePositionResult getSigned(Integer realmId, Integer nodeId, Integer versionId, Integer participationId, Integer reviewCycleNodeResultId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)versionId));
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)nodeId));
        if (reviewCycleNodeResultId != null) {
            crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)reviewCycleNodeResultId));
        }
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participationId));
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realmId));
        crit.add(Restrictions.isNotNull((String)"digest"));
        crit.add(Restrictions.isNull((String)"commentReference"));
        return (ReviewCyclePositionResult)crit.uniqueResult();
    }

    @Override
    public List getAllSigned(Integer realmId, Integer nodeId, Integer versionId, Integer participationId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)versionId));
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)nodeId));
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)participationId));
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realmId));
        crit.add(Restrictions.isNotNull((String)"digest"));
        crit.add(Restrictions.isNull((String)"commentReference"));
        return crit.list();
    }

    @Override
    public OEBBComment save(OEBBComment comm) {
        Integer id = (Integer)this.getSession().save((Object)comm);
        return (OEBBComment)this.getSession().get(OEBBComment.class, (Serializable)id);
    }

    @Override
    public List getAllOEBBComments(ReviewCycleNodeResult destNodeResult, ReviewCycleNodeResult nodeResult) {
        Criteria crit = this.getSession().createCriteria(OEBBComment.class);
        if (destNodeResult != null) {
            crit.createCriteria("commentedResult").add(Restrictions.idEq((Object)destNodeResult.getId()));
        }
        crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)nodeResult.getId()));
        return crit.list();
    }

    @Override
    public List getAllUnsigned() {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.add(Restrictions.isNull((String)"signature"));
        return crit.list();
    }

    @Override
    public List getAllCommentingUnsignedEmpty(Integer documentVersionId, Integer reviewCycleNodeId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId));
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)reviewCycleNodeId));
        crit.add(Restrictions.isNull((String)"digest"));
        crit.add(Restrictions.isNull((String)"comment"));
        crit.add(Restrictions.isNull((String)"reviewCycleCommentOption"));
        crit.add(Restrictions.isNotNull((String)"commentReference"));
        return crit.list();
    }

    @Override
    public List getAllCommentingForResult(Integer reviewCyclePositionResultId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("commentReference").add(Restrictions.idEq((Object)reviewCyclePositionResultId));
        return crit.list();
    }

    @Override
    public List getAllSignedWithinTime(Date startDate, Date endDate) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("signature").add((Criterion)Restrictions.ge((String)"time", (Object)startDate)).add((Criterion)Restrictions.le((String)"time", (Object)endDate));
        return crit.list();
    }

    @Override
    public List getAllCommentResultsOfNodeResult(Integer nodeResultId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)nodeResultId));
        crit.add(Restrictions.isNotNull((String)"commentReference"));
        return crit.list();
    }

    @Override
    public List getAllPositionResultsOfSubProject(Integer subProjectId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("activeObjectList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        return crit.list();
    }

    @Override
    public ReviewCyclePositionResult getLastByOptionValue(Integer docVersionId, int statusValue) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("reviewCycleResultOption").add((Criterion)Restrictions.eq((String)"value", (Object)statusValue));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)docVersionId));
        List results = crit.list();
        return results != null && results.size() > 0 ? (ReviewCyclePositionResult)results.get(0) : null;
    }

    @Override
    public ReviewCyclePositionResult getLatestPositionResultOfDocumentVersion(Integer documentVersionId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId));
        crit.add(Restrictions.isNull((String)"commentReference"));
        crit.addOrder(Order.desc((String)"resultDate"));
        List results = crit.list();
        return results != null && results.size() > 0 ? (ReviewCyclePositionResult)results.get(0) : null;
    }

    @Override
    public ReviewCyclePositionResult getUnsignedOverridingReviewCyclePositionResult(ReviewCyclePositionRelease positionRelease, DocumentVersion version, Integer nodeResultId, Integer overridingProjectParticipantId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionResultImpl.class);
        crit.createCriteria("overridingProjectParticipant").add(Restrictions.idEq((Object)overridingProjectParticipantId));
        if (nodeResultId != null) {
            crit.createCriteria("reviewCycleNodeResult").add(Restrictions.idEq((Object)nodeResultId));
        }
        crit.createCriteria("realm").add(Restrictions.idEq((Object)positionRelease.getRealm().getId()));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)version.getId()));
        crit.createCriteria("projectParticipant").createCriteria("participation").add(Restrictions.idEq((Object)positionRelease.getProjectParticipation().getId()));
        crit.add(Restrictions.isNull((String)"signature"));
        return (ReviewCyclePositionResult)crit.uniqueResult();
    }

    @Override
    public List<OEBBComment> getAllOebbCommentsForSubProject(Integer subProjectId) {
        Criteria crit = this.getSession().createCriteria(OEBBComment.class);
        crit.createCriteria("reviewCycleNodeResult").createCriteria("activeObjectListOfDocumentArrival").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        return crit.list();
    }
}

