/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.msp.auth;

import java.io.IOException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JcifsNtlmScheme
implements AuthScheme {
    private static final Log LOG = LogFactory.getLog(NTLMScheme.class);
    private String ntlmchallenge = null;
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private int state;

    public JcifsNtlmScheme() {
        this.state = 0;
    }

    public JcifsNtlmScheme(String challenge) throws MalformedChallengeException {
        this.processChallenge(challenge);
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String s = AuthChallengeParser.extractScheme((String)challenge);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid NTLM challenge: " + challenge);
        }
        int i = challenge.indexOf(32);
        if (i != -1) {
            s = challenge.substring(i, challenge.length());
            this.ntlmchallenge = s.trim();
            this.state = 3;
        } else {
            this.ntlmchallenge = "";
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public String getRealm() {
        return null;
    }

    public String getID() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public static String authenticate(NTCredentials credentials, String challenge) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    public static String authenticate(NTCredentials credentials, String challenge, String charset) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        LOG.trace((Object)"enter NTLMScheme.authenticate(Credentials, HttpMethod)");
        if (this.state == 0) {
            throw new IllegalStateException("NTLM authentication process has not been initiated");
        }
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        byte[] msgBytes = null;
        String response = null;
        if (this.state == 1) {
            Type1Message msg = new Type1Message();
            msg.setFlags(20998);
            msg.setSuppliedWorkstation(ntcredentials.getHost());
            msg.setSuppliedDomain(ntcredentials.getDomain());
            msgBytes = msg.toByteArray();
            this.state = 2;
        } else if (this.state == 3) {
            byte[] msg2Bytes = Base64.decodeBase64((byte[])EncodingUtil.getBytes((String)this.ntlmchallenge, (String)method.getParams().getCredentialCharset()));
            try {
                Type2Message msg2 = new Type2Message(msg2Bytes);
                Type3Message msg3 = new Type3Message(msg2, ntcredentials.getPassword(), ntcredentials.getDomain(), ntcredentials.getUserName(), ntcredentials.getHost(), 0);
                msgBytes = msg3.toByteArray();
            }
            catch (IOException ex) {
                throw new AuthenticationException("unable to parse Type2Message", (Throwable)ex);
            }
            this.state = 4;
        } else {
            throw new RuntimeException("Authetication failed.");
        }
        response = EncodingUtil.getAsciiString((byte[])Base64.encodeBase64((byte[])msgBytes));
        return "NTLM " + response;
    }
}

