/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.cycle.cell;

import at.cdes.bo.data.cycle.ReviewCycleNodeResultPositionComparator;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.project.SubProject;
import at.cdes.util.TapestryI18nHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReviewCycleCellResultImpl
implements ReviewCycleCellResult {
    static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(ReviewCycleCellResultImpl.class);
    private boolean finished;
    private Integer id;
    private ReviewCycleResultOption reviewCycleResultOption;
    private Date documentArrivalDate;
    private Date documentDepartureDate;
    private Map reviewCycleNodeResults;
    private ReviewCycleCell reviewCycleCell;
    private ReviewCycleCell nextReviewCycleCell;
    private ReviewCycleCell previousReviewCycleCell;
    private DocumentVersion documentVersion;

    @Override
    public ReviewCycleNodeResult getNodeResult(Integer nodeId) {
        Map m = this.getReviewCycleNodeResults();
        if (m == null || m.isEmpty()) {
            return null;
        }
        if (nodeId == null) {
            return null;
        }
        for (ReviewCycleNodeResult res : m.values()) {
            if (res.getReviewCycleNode().getId() == null || !res.getReviewCycleNode().getId().equals(nodeId)) continue;
            return res;
        }
        return null;
    }

    @Override
    public ReviewCycleNodeResult getNodeResultByPosition(int position) {
        Map m = this.getReviewCycleNodeResults();
        if (m == null || m.isEmpty()) {
            return null;
        }
        if (position <= 0) {
            return null;
        }
        for (ReviewCycleNodeResult res : m.values()) {
            if (res.getReviewCycleNode().getPosition() != position) continue;
            return res;
        }
        return null;
    }

    @Override
    public Date getDocumentArrivalDate() {
        return this.documentArrivalDate;
    }

    @Override
    public void setDocumentArrivalDate(Date documentArrivalDate) {
        this.documentArrivalDate = documentArrivalDate;
    }

    @Override
    public Date getDocumentDepartureDate() {
        return this.documentDepartureDate;
    }

    @Override
    public void setDocumentDepartureDate(Date documentDepartureDate) {
        this.documentDepartureDate = documentDepartureDate;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public ReviewCycleCell getReviewCycleCell() {
        return this.reviewCycleCell;
    }

    @Override
    public void setReviewCycleCell(ReviewCycleCell reviewCycleCell) {
        this.reviewCycleCell = reviewCycleCell;
    }

    @Override
    public ReviewCycleResultOption getReviewCycleResultOption() {
        return this.reviewCycleResultOption;
    }

    @Override
    public void setReviewCycleResultOption(ReviewCycleResultOption reviewCycleResultOption) {
        this.reviewCycleResultOption = reviewCycleResultOption;
    }

    @Override
    public Map getReviewCycleNodeResults() {
        return this.reviewCycleNodeResults;
    }

    @Override
    public void setReviewCycleNodeResults(Map reviewCycleNodeResults) {
        this.reviewCycleNodeResults = reviewCycleNodeResults;
    }

    @Override
    public DocumentVersion getDocumentVersion() {
        return this.documentVersion;
    }

    @Override
    public void setDocumentVersion(DocumentVersion documentVersion) {
        this.documentVersion = documentVersion;
    }

    @Override
    public void setNextReviewCycleCell(ReviewCycleCell destinationCell) {
        this.nextReviewCycleCell = destinationCell;
    }

    @Override
    public ReviewCycleCell getPreviousReviewCycleCell() {
        return this.previousReviewCycleCell;
    }

    @Override
    public void setPreviousReviewCycleCell(ReviewCycleCell previousReviewCycleCell) {
        this.previousReviewCycleCell = previousReviewCycleCell;
    }

    @Override
    public ReviewCycleCell getNextReviewCycleCell() {
        return this.nextReviewCycleCell;
    }

    @Override
    public Collection<ReviewCycleNodeResult> getReviewCycleNodeResultsSortedByPosition(boolean resultUnique) {
        ArrayList<ReviewCycleNodeResult> results = new ArrayList<ReviewCycleNodeResult>();
        results.addAll(this.getReviewCycleNodeResults().values());
        Collections.sort(results, new ReviewCycleNodeResultPositionComparator());
        if (!resultUnique) {
            return results;
        }
        HashMap<Integer, ReviewCycleNodeResult> resultsToRemove = new HashMap<Integer, ReviewCycleNodeResult>();
        for (ReviewCycleNodeResult res : results) {
            for (ReviewCycleNodeResult res1 : results) {
                if (res.getId().equals(res1.getId()) || !res.getReviewCycleNode().getId().equals(res1.getReviewCycleNode().getId())) continue;
                if (res.getDocumentArrivalDate().after(res1.getDocumentArrivalDate())) {
                    resultsToRemove.put(res1.getId(), res1);
                    continue;
                }
                resultsToRemove.put(res.getId(), res);
            }
        }
        if (resultsToRemove.size() > 0) {
            Collection deleteResults = resultsToRemove.values();
            for (ReviewCycleNodeResult deleteResult : deleteResults) {
                DocumentVersion docVersion = deleteResult.getDocumentVersion();
                SubProject sp = docVersion.getDocument().getObjectPlanner().getObject().getObjectList().getSubProject();
                logger.warn((Object)("Duplicated ReviewCycleNodeResult found: id=[" + deleteResult.getId() + "] nodeId=[" + deleteResult.getReviewCycleNode().getId() + "] nodeName=[" + TapestryI18nHelper.getLocalizedString(deleteResult.getReviewCycleNode().getName()) + "] documentVersionId=[" + deleteResult.getDocumentVersion() + "] documentName=[" + deleteResult.getDocumentVersion().getDocument().getName() + "] subProject=[" + sp.getCode() + " " + sp.getName() + " (" + sp.getId() + ")] project=[" + sp.getProject().getCode() + " " + sp.getProject().getName() + " (" + sp.getProject().getId() + ")] network=[" + sp.getProject().getNetwork().getName() + " (" + sp.getProject().getNetwork().getId() + ")]"));
                results.remove(deleteResult);
            }
        }
        return results;
    }

    @Override
    public ReviewCycleNodeResult getLastReviewCycleNodeResult() {
        if (this.getReviewCycleNodeResults() == null || this.getReviewCycleNodeResults().isEmpty()) {
            return null;
        }
        ArrayList ret = new ArrayList(this.getReviewCycleNodeResults().size());
        ret.addAll(this.getReviewCycleNodeResults().values());
        Collections.sort(ret, new ReviewCycleNodeResultPositionComparator());
        return (ReviewCycleNodeResult)ret.get(ret.size() - 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ReviewCycleCellResultImpl.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReviewCycleCellResultImpl other = (ReviewCycleCellResultImpl)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

