/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.oldGwtDto;

import at.cdes.oldGwtDto.DocumentVersionDTO;
import at.cdes.oldGwtDto.ObjectPlannerDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class DocumentDTO
implements Serializable {
    private static final long serialVersionUID = 4906921402150588697L;
    private Integer id;
    private Integer number;
    private String name;
    private String content;
    private String scale;
    private String comment;
    private Date startDate;
    private Date endDate;
    private Integer duration;
    private int modified;
    private boolean invalidated;
    private Integer asBuiltReferenceId;
    private ObjectPlannerDTO objectPlanner;
    private List<DocumentVersionDTO> documentVersions = new ArrayList<DocumentVersionDTO>();

    public DocumentDTO() {
    }

    public DocumentDTO(Integer id, Integer number, String name, String content, String scale, String comment, Date startDate, Date endDate, Integer duration, int modified, boolean invalidated, Integer asBuiltReferenceId, ObjectPlannerDTO objectPlanner, List<DocumentVersionDTO> documentVersions) {
        this();
        this.id = id;
        this.number = number;
        this.name = name;
        this.content = content;
        this.scale = scale;
        this.comment = comment;
        this.startDate = startDate;
        this.endDate = endDate;
        this.duration = duration;
        this.modified = modified;
        this.invalidated = invalidated;
        this.asBuiltReferenceId = asBuiltReferenceId;
        this.objectPlanner = objectPlanner;
        if (documentVersions != null) {
            this.documentVersions.addAll(documentVersions);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public String getScale() {
        return this.scale;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public int getModified() {
        return this.modified;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public Integer getAsBuiltReferenceId() {
        return this.asBuiltReferenceId;
    }

    public ObjectPlannerDTO getObjectPlanner() {
        return this.objectPlanner;
    }

    public List<DocumentVersionDTO> getDocumentVersions() {
        return this.documentVersions;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setModified(int modified) {
        this.modified = modified;
    }

    public void setInvalidated(boolean invalidated) {
        this.invalidated = invalidated;
    }

    public void setAsBuiltReferenceId(Integer asBuiltReferenceId) {
        this.asBuiltReferenceId = asBuiltReferenceId;
    }

    public void setObjectPlanner(ObjectPlannerDTO objectPlanner) {
        this.objectPlanner = objectPlanner;
    }

    public void setDocumentVersions(List<DocumentVersionDTO> documentVersions) {
        this.documentVersions = documentVersions;
    }

    public Integer getLastDocumentVersionId() {
        DocumentVersionDTO dv;
        ArrayList<DocumentVersionDTO> ret = new ArrayList<DocumentVersionDTO>();
        ret.addAll(this.documentVersions);
        Collections.sort(ret, new DocumentVersionComparator());
        DocumentVersionDTO documentVersionDTO = dv = ret.isEmpty() ? null : (DocumentVersionDTO)ret.get(ret.size() - 1);
        if (dv != null && dv.getReactivatedDocumentVersionId() != null) {
            return dv.getReactivatedDocumentVersionId();
        }
        return dv.getId();
    }

    public Integer getFirstDocumentVersionId() {
        ArrayList<DocumentVersionDTO> ret = new ArrayList<DocumentVersionDTO>();
        ret.addAll(this.documentVersions);
        Collections.sort(ret, new DocumentVersionComparator());
        return ret == null || ret.isEmpty() ? null : ((DocumentVersionDTO)ret.get(0)).getId();
    }

    private class DocumentVersionComparator
    implements Comparator<DocumentVersionDTO> {
        private DocumentVersionComparator() {
        }

        @Override
        public int compare(DocumentVersionDTO arg0, DocumentVersionDTO arg1) {
            if (arg0 == null) {
                if (arg1 == null) {
                    return 0;
                }
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            long res = arg0.getUploaded().getTime() - arg1.getUploaded().getTime();
            if (res == 0L) {
                return arg0.getId().compareTo(arg1.getId());
            }
            if (res < 0L) {
                return -1;
            }
            return 1;
        }
    }
}

