/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.helper;

import at.cdes.bo.data.document.ArchiveBulkDownloadEntry;
import at.cdes.bo.data.project.SubProject;
import at.cdes.controller.apiHelper.ArchiveHelper;
import at.cdes.util.ArchiveJobStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Logger;
import org.xnap.commons.i18n.I18n;

public class ArchiveTableOfContentsWriter {
    private static Logger log = Logger.getLogger(ArchiveTableOfContentsWriter.class);
    private XMLStreamWriter writer;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private I18n i18n;

    public ArchiveTableOfContentsWriter(I18n i18n) throws XMLStreamException, FactoryConfigurationError {
        this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(this.out, "utf-8");
        this.i18n = i18n;
    }

    public void renderDocument(Collection<ArchiveBulkDownloadEntry> entries, SubProject context, ArchiveJobStatus status, boolean enableCustomerLogo) throws XMLStreamException {
        this.writer.writeStartDocument("utf-8", "1.0");
        this.br();
        this.writer.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        this.br();
        this.br();
        this.writer.writeStartElement("html");
        this.writer.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
        this.br();
        this.writer.writeStartElement("head");
        this.br();
        this.writer.writeStartElement("meta");
        this.writer.writeAttribute("http-equiv", "Content-Type");
        this.writer.writeAttribute("content", "text/html;charset=UTF-8");
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("title");
        this.writer.writeCharacters(this.i18n.tr("Inhaltsverzeichnis"));
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEmptyElement("link");
        this.writer.writeAttribute("rel", "stylesheet");
        this.writer.writeAttribute("type", "text/css");
        this.writer.writeAttribute("href", ArchiveHelper.getHTMLRessourcePath(this.i18n, "archive.css"));
        this.br();
        this.writer.writeEmptyElement("script");
        this.writer.writeAttribute("language", "JavaScript");
        this.writer.writeAttribute("type", "text/javascript");
        this.writer.writeAttribute("src", ArchiveHelper.getHTMLRessourcePath(this.i18n, "table.js"));
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("body");
        this.br();
        this.writer.writeStartElement("script");
        this.writer.writeAttribute("language", "JavaScript");
        this.writer.writeAttribute("type", "text/javascript");
        this.writer.writeCharacters("window.onload = function () { initTable(); };\n");
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("div");
        this.writer.writeAttribute("id", "cHeaderBgLeft");
        this.br();
        if (enableCustomerLogo) {
            this.writer.writeStartElement("div");
            this.writer.writeAttribute("id", "cHeaderImage");
            this.writer.writeEndElement();
            this.br();
        }
        this.writer.writeStartElement("div");
        this.writer.writeAttribute("id", "cHeaderLogo");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("div");
        this.writer.writeAttribute("id", "context");
        if (context != null) {
            this.writer.writeStartElement("strong");
            this.writer.writeCharacters(this.i18n.tr("Netzwerk") + ": ");
            this.writer.writeEndElement();
            this.writer.writeCharacters(context.getProject().getNetwork().getName());
            this.writer.writeStartElement("strong");
            this.writer.writeCharacters(" " + this.i18n.tr("Projekt") + ": ");
            this.writer.writeEndElement();
            this.writer.writeCharacters(context.getProject().getCode() + " " + context.getProject().getName());
            this.writer.writeStartElement("strong");
            this.writer.writeCharacters(" " + this.i18n.tr("Subprojekt") + ": ");
            this.writer.writeEndElement();
            this.writer.writeCharacters(context.getCode() + " " + context.getName());
            this.br();
        }
        this.writer.writeEndElement();
        this.writer.writeEmptyElement("div");
        this.writer.writeAttribute("id", "cLinie");
        this.br();
        this.writer.writeStartElement("div");
        this.writer.writeAttribute("id", "cScroller");
        this.br();
        this.writer.writeStartElement("div");
        this.writer.writeAttribute("id", "cContainer");
        this.br();
        this.writer.writeStartElement("div");
        this.writer.writeAttribute("id", "cContent");
        this.br();
        this.writer.writeStartElement("div");
        this.writer.writeAttribute("id", "headline");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.writer.writeCharacters(String.format(this.i18n.tr("Inhaltsverzeichnis Planarchiv vom %s"), df.format(Calendar.getInstance().getTime())));
        this.writer.writeEndElement();
        this.br();
        if (status != null && status.getErrorMessages() != null && !status.getErrorMessages().isEmpty()) {
            this.writer.writeStartElement("div");
            this.writer.writeStartElement("fieldset");
            this.writer.writeStartElement("legend");
            this.writer.writeStartElement("table");
            this.writer.writeAttribute("cellspacing", "0");
            this.writer.writeAttribute("cellpadding", "3");
            this.writer.writeStartElement("colgroup");
            this.writer.writeEmptyElement("col");
            this.writer.writeAttribute("width", "20px");
            this.writer.writeEmptyElement("col");
            this.writer.writeAttribute("width", "620px");
            this.writer.writeEndElement();
            this.writer.writeStartElement("tr");
            this.writer.writeStartElement("td");
            this.writer.writeEmptyElement("img");
            this.writer.writeAttribute("src", ArchiveHelper.getHTMLRessourcePath(this.i18n, "error_small.png"));
            this.writer.writeAttribute("title", this.i18n.tr("Fehler"));
            this.writer.writeEndElement();
            this.writer.writeStartElement("td");
            this.writer.writeStartElement("b");
            this.writer.writeCharacters(this.i18n.tr("Beim Erstellen des Planarchivs sind Fehler aufgetreten, die betroffenen Dateien wurden dem Archiv m\u00f6glicherweise nicht hinzugef\u00fcgt."));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeStartElement("ul");
            for (String msg : status.getErrorMessages()) {
                this.writer.writeStartElement("li");
                this.writer.writeCharacters(msg);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.br();
        }
        this.writer.writeStartElement("table");
        this.writer.writeAttribute("id", "tabl");
        this.writer.writeAttribute("class", "base table-autosort table-autofilter table-stripeclass:alternate table-autopage:10 table-page-number:t1page table-page-count:t1pages table-filtered-rowcount:t1filtercount table-rowcount:t1allcount");
        this.writer.writeAttribute("cellspacing", "0");
        this.writer.writeAttribute("cellpadding", "3");
        this.br();
        this.writer.writeStartElement("colgroup");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width: 6px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width:180px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width:150px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width:120px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width:120px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width:100px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width:80px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width:60px;");
        this.br();
        this.writer.writeEmptyElement("col");
        this.writer.writeAttribute("style", "width: 6px;");
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("thead");
        this.br();
        this.writeNavRow("t1page", "t1pages", "", true);
        this.writer.writeStartElement("tr");
        this.br();
        this.writer.writeEmptyElement("th");
        this.writer.writeAttribute("class", "cornerTopLeft");
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("class", "table-sortable:default");
        this.writer.writeAttribute("id", "dvnamecol");
        this.writer.writeCharacters(this.i18n.tr("Plannummer"));
        this.writer.writeEmptyElement("br");
        this.writer.writeStartElement("input");
        this.writer.writeAttribute("placeholder", "Filter");
        this.writer.writeAttribute("onkeyup", "Table.filter(document.getElementById('dvnamecol'),this)");
        this.writer.writeAttribute("onclick", "stopOnclickPropatation(event)");
        this.writer.writeAttribute("name", "filter");
        this.writer.writeAttribute("id", "dvnamefilter");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("class", "table-sortable:default");
        this.writer.writeAttribute("id", "titlecol");
        this.writer.writeCharacters(this.i18n.tr("Titel / Inhalt"));
        this.writer.writeEmptyElement("br");
        this.writer.writeStartElement("input");
        this.writer.writeAttribute("placeholder", "Filter");
        this.writer.writeAttribute("onkeyup", "Table.filter(document.getElementById('titlecol'),this)");
        this.writer.writeAttribute("onclick", "stopOnclickPropatation(event)");
        this.writer.writeAttribute("name", "filter");
        this.writer.writeAttribute("id", "titlefilter");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("class", "table-filterable table-sortable:default");
        this.writer.writeAttribute("id", "plannercol");
        this.writer.writeCharacters(this.i18n.tr("Planer"));
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("class", "table-filterable table-sortable:default");
        this.writer.writeAttribute("id", "objectcol");
        this.writer.writeCharacters(this.i18n.tr("Objekt"));
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("class", "table-filterable table-sortable:default");
        this.writer.writeAttribute("id", "objectplannercol");
        this.writer.writeCharacters(this.i18n.tr("Objektblatt"));
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("class", "table-filterable table-sortable:default");
        this.writer.writeAttribute("id", "objectkmcol");
        this.writer.writeCharacters(this.i18n.tr("km von - bis"));
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("class", "table-sortable:default");
        this.writer.writeAttribute("id", "statuscol");
        this.writer.writeCharacters(this.i18n.tr("Status"));
        this.writer.writeEmptyElement("br");
        this.writer.writeStartElement("input");
        this.writer.writeAttribute("placeholder", "Filter");
        this.writer.writeAttribute("onkeyup", "Table.filter(document.getElementById('statuscol'),this)");
        this.writer.writeAttribute("onclick", "stopOnclickPropatation(event)");
        this.writer.writeAttribute("name", "filter");
        this.writer.writeAttribute("id", "statusfilter");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("id", "filecol");
        this.writer.writeCharacters(this.i18n.tr("Datei"));
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEmptyElement("th");
        this.writer.writeAttribute("class", "cornerTopRight");
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("tfoot");
        this.br();
        this.writer.writeStartElement("tr");
        this.writer.writeAttribute("class", "footer");
        this.br();
        this.writer.writeEmptyElement("th");
        this.writer.writeAttribute("class", "cornerBottomLeft");
        this.br();
        this.writer.writeStartElement("th");
        this.writer.writeAttribute("style", "text-align:right");
        this.writer.writeAttribute("colspan", "8");
        this.br();
        this.writer.writeStartElement("span");
        this.writer.writeAttribute("id", "t1filtercount");
        this.writer.writeCharacters("1");
        this.writer.writeEndElement();
        this.writer.writeCharacters(" " + this.i18n.tr("von") + " ");
        this.writer.writeStartElement("span");
        this.writer.writeAttribute("id", "t1allcount");
        this.writer.writeCharacters("1");
        this.writer.writeEndElement();
        this.writer.writeCharacters(" " + this.i18n.tr("Eintr\u00e4gen gefiltert"));
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEmptyElement("th");
        this.writer.writeAttribute("class", "cornerBottomRight");
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writeNavRow("activePageCount", "totalPageCount", "1", false);
        this.writer.writeEndElement();
        this.br();
        this.writer.writeStartElement("tbody");
        this.br();
        for (ArchiveBulkDownloadEntry entry : entries) {
            this.writer.writeStartElement("tr");
            this.writer.writeAttribute("class", "even");
            this.br();
            this.writer.writeEmptyElement("td");
            this.writer.writeAttribute("class", "cornerSpacerLeft");
            this.writer.writeStartElement("td");
            this.writer.writeCharacters(entry.getName());
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("td");
            this.writer.writeCharacters(entry.getTitle());
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("td");
            this.writer.writeCharacters(entry.getPlanner());
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("td");
            this.writer.writeCharacters(entry.getObject());
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("td");
            this.writer.writeCharacters(entry.getObjectplanner());
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("td");
            this.writer.writeCharacters(entry.getObjectkm());
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("td");
            this.writer.writeCharacters(entry.getStatus());
            if (entry.getStatusSuffix() != null && !entry.getStatusSuffix().isEmpty()) {
                this.writer.writeEmptyElement("br");
                this.writer.writeCharacters(entry.getStatusSuffix());
            }
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("td");
            if (entry.getReviewProtocolPath() != null) {
                this.writer.writeStartElement("a");
                this.writer.writeAttribute("href", entry.getReviewProtocolPath());
                this.writer.writeAttribute("target", "_blank");
                this.writer.writeEmptyElement("img");
                this.writer.writeAttribute("src", ArchiveHelper.getHTMLRessourcePath(this.i18n, "pruefprotokoll.gif"));
                this.writer.writeAttribute("title", this.i18n.tr("Pr\u00fcfprotokoll"));
                this.writer.writeEndElement();
                this.br();
            }
            if (entry.getPdfPreviewPath() != null) {
                this.writer.writeStartElement("a");
                this.writer.writeAttribute("href", entry.getPdfPreviewPath());
                this.writer.writeAttribute("target", "_blank");
                this.writer.writeEmptyElement("img");
                this.writer.writeAttribute("src", ArchiveHelper.getHTMLRessourcePath(this.i18n, "planvorschau_pdf.gif"));
                this.writer.writeAttribute("title", this.i18n.tr("Planvorschau"));
                this.writer.writeEndElement();
                this.br();
            }
            if (entry.getDocumentPath() != null) {
                this.writer.writeStartElement("a");
                this.writer.writeAttribute("href", entry.getDocumentPath());
                this.writer.writeAttribute("type", "application/octet-stream");
                this.writer.writeAttribute("target", "_blank");
                this.writer.writeEmptyElement("img");
                this.writer.writeAttribute("src", ArchiveHelper.getHTMLRessourcePath(this.i18n, "speichern.gif"));
                this.writer.writeAttribute("title", this.i18n.tr("Plandownload"));
                this.writer.writeEndElement();
                this.br();
            }
            this.writer.writeEndElement();
            this.br();
            this.writer.writeEmptyElement("td");
            this.writer.writeAttribute("class", "cornerSpacerRight");
            this.br();
            this.writer.writeEndElement();
            this.br();
        }
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEmptyElement("br");
        this.writer.writeEmptyElement("br");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndDocument();
    }

    private void writeNavRow(String activePageCountId, String totalPageCountId, String idSuffix, boolean renderPageSelect) throws XMLStreamException {
        this.writer.writeStartElement("tr");
        this.writer.writeAttribute("id", "navrow" + idSuffix);
        this.br();
        if (renderPageSelect) {
            this.writer.writeStartElement("td");
            this.writer.writeAttribute("colspan", "7");
            this.br();
            this.writer.writeCharacters(this.i18n.tr("Zeilen/Seite") + ": ");
            this.br();
            this.writer.writeStartElement("select");
            this.writer.writeAttribute("class", "select");
            this.writer.writeAttribute("id", "selectPages" + idSuffix);
            this.writer.writeAttribute("onchange", "Table.setPageSize(parseInt(this.value),document.getElementById('tabl'))");
            this.writer.writeStartElement("option");
            this.writer.writeAttribute("value", "10");
            this.writer.writeCharacters("10");
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("option");
            this.writer.writeAttribute("selected", "selected");
            this.writer.writeAttribute("value", "20");
            this.writer.writeCharacters("20");
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("option");
            this.writer.writeAttribute("value", "50");
            this.writer.writeCharacters("50");
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("option");
            this.writer.writeAttribute("value", "100");
            this.writer.writeCharacters("100");
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("option");
            this.writer.writeAttribute("value", "200");
            this.writer.writeCharacters("200");
            this.writer.writeEndElement();
            this.br();
            this.writer.writeStartElement("option");
            this.writer.writeAttribute("value", "999999");
            this.writer.writeCharacters(this.i18n.tr("alle"));
            this.writer.writeEndElement();
            this.br();
            this.writer.writeEndElement();
            this.br();
            this.writer.writeEndElement();
            this.br();
        }
        this.writer.writeStartElement("td");
        this.writer.writeAttribute("colspan", renderPageSelect ? "3" : "10");
        this.writer.writeAttribute("style", "text-align:right");
        this.br();
        this.writer.writeStartElement("a");
        this.writer.writeAttribute("href", "#");
        this.writer.writeAttribute("onclick", "Table.pagePrevious(this)");
        this.writer.writeCharacters(" < ");
        this.writer.writeEndElement();
        this.writer.writeCharacters("   ");
        this.writer.writeStartElement("span");
        this.writer.writeCharacters(this.i18n.tr("Seite") + " ");
        this.writer.writeStartElement("span");
        this.writer.writeAttribute("id", activePageCountId);
        this.writer.writeCharacters("1");
        this.writer.writeEndElement();
        this.writer.writeCharacters(" " + this.i18n.tr("von") + " ");
        this.writer.writeStartElement("span");
        this.writer.writeAttribute("id", totalPageCountId);
        this.writer.writeCharacters("?");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeCharacters("   ");
        this.writer.writeStartElement("a");
        this.writer.writeAttribute("href", "#");
        this.writer.writeAttribute("onclick", "Table.pageNext(this)");
        this.writer.writeCharacters(" > ");
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndElement();
        this.br();
        this.writer.writeEndElement();
    }

    private void br() throws XMLStreamException {
        this.writer.writeCharacters("\n");
    }

    public void writeTableOfContents(ZipArchiveOutputStream zos, Collection<ArchiveBulkDownloadEntry> entries, Locale locale, SubProject context, ArchiveJobStatus status, boolean enableCustomerLogo) throws IOException {
        try {
            this.renderDocument(entries, context, status, enableCustomerLogo);
        }
        catch (Exception e) {
            log.error((Object)"Error in method renderDocument writing table of contents.", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (XMLStreamException e) {
                log.warn((Object)"Error in closing XMLStreamWriter", (Throwable)e);
            }
        }
        ZipArchiveEntry ze = new ZipArchiveEntry("index.html");
        zos.putArchiveEntry((ArchiveEntry)ze);
        byte[] ba = this.out.toByteArray();
        zos.write(ba);
        zos.closeArchiveEntry();
    }
}

