/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.number;

import at.cdes.api.document.NumberCalculatorException;
import at.cdes.api.voc.DocumentNumberComponent;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleEntryCondition;
import at.cdes.bo.data.document.BaseDocumentVersion;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.DocumentVersionStatusChange;
import at.cdes.bo.data.number.DocumentNumberPart;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.number.NumberCalculator;
import at.cdes.db.dao.DocumentVersionDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.log4j.Logger;

public class OgnlNumberCalculator
implements NumberCalculator {
    static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(OgnlNumberCalculator.class);
    private OgnlContext context = new OgnlContext();
    private ObjectPlannerDAO objectPlannerDAO;
    private DocumentVersionDAO documentVersionDAO;

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    @Override
    public String getNumber(Document document, Project project, ReviewCycleCell cell) throws NumberCalculatorException {
        return this.getNumber(document, project, cell, null);
    }

    @Override
    public String getNumber(ReviewCycleCellConnection connection, ReviewCycleCellResult oldResult, Project project) throws NumberCalculatorException {
        return this.getNumber(connection, oldResult, project, null);
    }

    @Override
    public String getNumber(ReviewCycleCellConnection connection, ReviewCycleCellResult oldResult, Project project, BaseDocumentVersion version) throws NumberCalculatorException {
        String number;
        DocumentVersion oldVersion = oldResult.getDocumentVersion();
        Document document = oldVersion.getDocument();
        DocumentVersionStatusChange lastStatusChange = this.documentVersionDAO.getLastStatusChangeByVersionId(oldVersion.getId());
        String versionPartA = null;
        String versionPartB = null;
        String seperator = null;
        if (document.getName() == "" || document.getName() == null) {
            number = this.getNumber(document, project, true);
        } else {
            number = document.getName();
            number = number + this.getLastSeperator(document, document.getDocumentList().getSubProject().getProject());
        }
        versionPartA = version != null && version.getVersionPartA() != null ? (connection.getPartAFormat() != null && connection.getPartAFormat().contains("d") ? this.format(connection.getPartAFormat(), Integer.valueOf(version.getVersionPartA())) : this.format(connection.getPartAFormat(), version.getVersionPartA())) : this.getPart(connection, oldResult, "A", lastStatusChange);
        seperator = connection.getSourceCell().getReviewCycle().getDocumentNumberVersionPart().getSeperator();
        versionPartB = version != null && version.getVersionPartB() != null ? (connection.getPartBFormat() != null && connection.getPartBFormat().contains("d") ? this.format(connection.getPartBFormat(), Integer.valueOf(version.getVersionPartB())) : this.format(connection.getPartBFormat(), version.getVersionPartB())) : this.getPart(connection, oldResult, "B", lastStatusChange);
        if (version != null) {
            version.setVersionPartA(versionPartA);
            version.setVersionPartB(versionPartB);
            version.setVersionPartSeperator(seperator);
        }
        return number + (versionPartA != null && versionPartA.length() > 0 ? versionPartA + seperator : "") + versionPartB;
    }

    public String getPart(ReviewCycleCellConnection connection, ReviewCycleCellResult oldResult, String part, DocumentVersionStatusChange lastStatusChange) throws NumberCalculatorException {
        String rule = null;
        Object expression = null;
        DocumentVersion oldVersion = oldResult.getDocumentVersion();
        this.context.clear();
        this.context.put("sourceCell", connection.getSourceCell());
        this.context.put("destinationCell", connection.getDestinationCell());
        this.context.put("oldPartA", oldResult.getDocumentVersion().getVersionPartA());
        this.context.put("oldPartB", oldResult.getDocumentVersion().getVersionPartB());
        this.context.put("lastStatusChange", lastStatusChange);
        this.context.put("calculator", this);
        try {
            if (part.equals("A")) {
                rule = connection.getPartARule();
            } else if (part.equals("B")) {
                rule = connection.getPartBRule();
            }
            if (rule != null && rule.length() > 0) {
                expression = Ognl.parseExpression(rule);
            }
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Parse Exception", (Throwable)e);
        }
        try {
            Object res = null;
            if (expression != null) {
                res = Ognl.getValue(expression, (Map)this.context, (Object)this.context);
            } else if (part.equals("A")) {
                res = oldVersion.getVersionPartA();
            } else if (part.equals("B")) {
                res = oldVersion.getVersionPartB();
            }
            if (part.equals("A")) {
                if (connection.getPartAFormat() != null && connection.getPartAFormat().contains("d")) {
                    return this.format(connection.getPartAFormat(), res instanceof String ? Integer.valueOf((String)res) : res);
                }
                return this.format(connection.getPartAFormat(), res);
            }
            if (part.equals("B")) {
                if (connection.getPartBFormat() != null && connection.getPartBFormat().contains("d")) {
                    return this.format(connection.getPartBFormat(), res instanceof String ? Integer.valueOf((String)res) : res);
                }
                return this.format(connection.getPartBFormat(), res);
            }
            return "";
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Calculation Exception", (Throwable)e);
        }
    }

    public String getPart(ReviewCycleEntryCondition condition, ReviewCycleCell cell, String part) throws NumberCalculatorException {
        String rule = null;
        Object expression = null;
        OgnlContext ctxt = new OgnlContext();
        ctxt.put("calculator", this);
        ctxt.put("reviewCycleCell", cell);
        ctxt.put("asBuiltReference", (Object)null);
        try {
            rule = part.equals("A") ? condition.getPartARule() : condition.getPartBRule();
            if (rule != null && rule.length() > 0) {
                expression = Ognl.parseExpression(rule);
            }
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Parse Exception", (Throwable)e);
        }
        try {
            Object res = null;
            if (expression == null) {
                throw new NumberCalculatorException("Calulation Exception: Not Entry Rule found");
            }
            res = Ognl.getValue(expression, (Map)ctxt, (Object)ctxt);
            if (part.equals("A")) {
                return this.format(condition.getPartAFormat(), res);
            }
            return this.format(condition.getPartBFormat(), res);
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Calulation Exception", (Throwable)e);
        }
    }

    @Override
    public String getNumber(Document document, Project project, boolean includeLastSeperator) throws NumberCalculatorException {
        Map rules = project.getDocumentNumberPartGroup().getParts();
        if (rules == null) {
            return null;
        }
        Iterator it = rules.values().iterator();
        String result = new String();
        OgnlContext ctxt = new OgnlContext();
        ReleasedObjectList releasedOList = document.getDocumentList().getSubProject().getActiveObjectList();
        ReleasedObjectPlanner relObjectPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(releasedOList.getId(), document.getObjectPlanner().getId());
        ctxt.put("document", document);
        ctxt.put("project", project);
        ctxt.put("objectPlanner", document.getObjectPlanner());
        ctxt.put("relObjectPlanner", relObjectPlanner);
        while (it.hasNext()) {
            Object expression;
            DocumentNumberPart part = (DocumentNumberPart)it.next();
            if (part.getRule() == null) continue;
            try {
                expression = Ognl.parseExpression(part.getRule());
            }
            catch (OgnlException e) {
                logger.error((Object)"parse error ", (Throwable)e);
                throw new NumberCalculatorException("Parse Exception", (Throwable)e);
            }
            try {
                DocumentNumberComponent component = OgnlNumberCalculator.getDocumentNumberComponentByOgnlPath(part.getRule());
                Object code = Ognl.getValue(expression, (Map)ctxt, (Object)ctxt);
                String format = part.getFormat();
                if (code == null) {
                    result = result + "";
                } else if (format == null || format.length() == 0) {
                    result = result + String.valueOf(code);
                } else {
                    try {
                        if (component == DocumentNumberComponent.SUBPROJECT_NUMBER && format.length() == 4 && format.charAt(0) == '%' && format.charAt(1) == '.' && format.charAt(3) == 'd') {
                            int prec = Integer.parseInt(String.valueOf(format.charAt(2)));
                            String codeStr = code.toString();
                            String part1 = codeStr.substring(0, codeStr.length() - prec);
                            String part2 = codeStr.substring(codeStr.length() - prec, codeStr.length());
                            result = result + part1 + "." + part2;
                        } else {
                            result = result + String.format(format, code);
                        }
                    }
                    catch (IllegalFormatConversionException e) {
                        throw new IllegalArgumentException("Illegal format: " + format, e);
                    }
                }
                if (!it.hasNext() && !includeLastSeperator) continue;
                result = result + part.getSeperator();
            }
            catch (OgnlException e) {
                logger.error((Object)"calc error ", (Throwable)e);
                throw new NumberCalculatorException("Calulation Exception", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getNumber(Document document, Project project, ReleasedObjectPlanner relObjectPlanner, boolean includeLastSeperator) throws NumberCalculatorException {
        Map rules = project.getDocumentNumberPartGroup().getParts();
        if (rules == null) {
            return null;
        }
        Iterator it = rules.values().iterator();
        String result = new String();
        OgnlContext ctxt = new OgnlContext();
        ctxt.put("document", document);
        ctxt.put("project", project);
        ctxt.put("objectPlanner", document.getObjectPlanner());
        ctxt.put("relObjectPlanner", relObjectPlanner);
        while (it.hasNext()) {
            Object expression;
            DocumentNumberPart part = (DocumentNumberPart)it.next();
            if (part.getRule() == null) continue;
            try {
                expression = Ognl.parseExpression(part.getRule());
            }
            catch (OgnlException e) {
                logger.error((Object)"parse error ", (Throwable)e);
                throw new NumberCalculatorException("Parse Exception", (Throwable)e);
            }
            try {
                Object res = Ognl.getValue(expression, (Map)ctxt, (Object)ctxt);
                result = result + this.format(part.getFormat(), res);
                if (!it.hasNext() && !includeLastSeperator) continue;
                result = result + part.getSeperator();
            }
            catch (OgnlException e) {
                logger.error((Object)"calc error ", (Throwable)e);
                throw new NumberCalculatorException("Calulation Exception", (Throwable)e);
            }
        }
        return result;
    }

    public String getDocumentNumberRetroactively(Document document, Project project) throws NumberCalculatorException {
        Map rules = project.getDocumentNumberPartGroup().getParts();
        if (rules == null) {
            return null;
        }
        Iterator it = rules.values().iterator();
        String result = new String();
        OgnlContext ctxt = new OgnlContext();
        ctxt.put("document", document);
        ctxt.put("project", project);
        ctxt.put("objectPlanner", document.getObjectPlanner());
        ctxt.put("relObjectPlanner", document.getObjectPlanner());
        while (it.hasNext()) {
            Object expression;
            DocumentNumberPart part = (DocumentNumberPart)it.next();
            if (part.getRule() == null) continue;
            try {
                expression = Ognl.parseExpression(part.getRule());
            }
            catch (OgnlException e) {
                logger.error((Object)"parse error ", (Throwable)e);
                throw new NumberCalculatorException("Parse Exception", (Throwable)e);
            }
            try {
                Object res = Ognl.getValue(expression, (Map)ctxt, (Object)ctxt);
                result = result + this.format(part.getFormat(), res);
                if (!it.hasNext()) continue;
                result = result + part.getSeperator();
            }
            catch (OgnlException e) {
                logger.error((Object)"calc error ", (Throwable)e);
                throw new NumberCalculatorException("Calulation Exception", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getLastSeperator(Document document, Project project) throws NumberCalculatorException {
        Map rules = project.getDocumentNumberPartGroup().getParts();
        if (rules == null) {
            return null;
        }
        Iterator it = rules.values().iterator();
        String result = new String();
        while (it.hasNext()) {
            DocumentNumberPart part = (DocumentNumberPart)it.next();
            try {
                if (it.hasNext()) continue;
                result = part.getSeperator();
            }
            catch (Exception e) {
                logger.error((Object)"getLastSeperator error ", (Throwable)e);
                throw new NumberCalculatorException("getLastSeperator Exception", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getVersionPartAEntry(ReviewCycleCell cell) throws NumberCalculatorException {
        if (cell.getReviewCycleEntryCondition() == null) {
            return null;
        }
        return this.getPart(cell.getReviewCycleEntryCondition(), cell, "A");
    }

    @Override
    public String getVersionPartBEntry(ReviewCycleCell cell) throws NumberCalculatorException {
        if (cell.getReviewCycleEntryCondition() == null) {
            return null;
        }
        return this.getPart(cell.getReviewCycleEntryCondition(), cell, "B");
    }

    @Override
    public String getVersionPartA(ReviewCycleCellConnection connection, ReviewCycleCellResult oldResult) throws NumberCalculatorException {
        return this.getPart(connection, oldResult, "A", null);
    }

    @Override
    public String getVersionPartB(ReviewCycleCellConnection connection, ReviewCycleCellResult oldResult) throws NumberCalculatorException {
        return this.getPart(connection, oldResult, "B", null);
    }

    public String format(String format, Object value) {
        if (value == null) {
            return "";
        }
        if (format == null || format.length() == 0) {
            return String.valueOf(value);
        }
        try {
            if (format.contains("d")) {
                return String.format(format, value instanceof String ? Integer.valueOf((String)value) : value);
            }
            return String.format(format, value);
        }
        catch (IllegalFormatConversionException e) {
            logger.error((Object)"IllegalFormatConversion error ", (Throwable)e);
            return String.valueOf(value);
        }
    }

    public Object add(String value, String add) {
        int res = 0;
        int incr = 0;
        if (add == null || !Character.isDigit(add.charAt(0))) {
            throw new NumberFormatException("");
        }
        incr = Integer.parseInt(add);
        try {
            if (value != null && Character.isDigit(value.charAt(0))) {
                res = Integer.parseInt(value);
                return res + incr;
            }
            if (value != null && value.length() == 1) {
                char cValue = value.charAt(0);
                cValue = (char)(cValue + incr);
                return String.valueOf(cValue);
            }
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return 0;
    }

    @Override
    public String getNumber(Document document, Project project, ReviewCycleCell cell, BaseDocumentVersion version) throws NumberCalculatorException {
        String number;
        if (document.getName() == "" || document.getName() == null) {
            number = this.getNumber(document, project, true);
        } else {
            number = document.getName();
            number = number + this.getLastSeperator(document, document.getDocumentList().getSubProject().getProject());
        }
        if (cell == null) {
            throw new NumberCalculatorException("Cell must not be null");
        }
        if (cell.getReviewCycleEntryCondition() == null) {
            throw new NumberCalculatorException("Cell.getReviewCycleEntryCondition() must not be null. The cell may not be a valid review cycle entry point");
        }
        String ruleA = null;
        String ruleB = null;
        Object expressionA = null;
        Object expressionB = null;
        this.context.clear();
        this.context.put("reviewCycleCell", cell);
        this.context.put("asBuiltReference", version != null ? version.getAsBuiltReference() : null);
        try {
            ruleA = cell.getReviewCycleEntryCondition().getPartARule();
            ruleB = cell.getReviewCycleEntryCondition().getPartBRule();
            expressionA = ruleA != null && ruleA.length() > 0 ? Ognl.parseExpression(ruleA) : null;
            expressionB = ruleB != null && ruleB.length() > 0 ? Ognl.parseExpression(ruleB) : null;
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Parse Exception", (Throwable)e);
        }
        try {
            Object resA = null;
            Object resB = null;
            String versionPartA = null;
            String versionPartB = null;
            String seperator = null;
            String formatA = cell.getReviewCycleEntryCondition().getPartAFormat();
            String formatB = cell.getReviewCycleEntryCondition().getPartBFormat();
            if (version != null && version.getVersionPartA() != null) {
                resA = formatA != null && formatA.contains("d") ? Integer.valueOf(version.getVersionPartA()) : version.getVersionPartA();
            } else {
                Object object = resA = expressionA != null ? Ognl.getValue(expressionA, (Map)this.context, (Object)this.context) : null;
            }
            if (version != null && version.getVersionPartB() != null) {
                resB = formatB != null && formatB.contains("d") ? Integer.valueOf(version.getVersionPartB()) : version.getVersionPartB();
            } else {
                Object object = resB = expressionB != null ? Ognl.getValue(expressionB, (Map)this.context, (Object)this.context) : null;
            }
            if (formatA == null || formatA.length() == 0) {
                formatA = cell.getReviewCycle().getDocumentNumberVersionPart().getPartAFormat();
            }
            if (formatB == null || formatB.length() == 0) {
                formatB = cell.getReviewCycle().getDocumentNumberVersionPart().getPartBFormat();
            }
            versionPartA = this.format(formatA, resA);
            seperator = cell.getReviewCycle().getDocumentNumberVersionPart().getSeperator();
            versionPartB = resB instanceof String && formatB != null && formatB.contains("d") ? (String)resB : this.format(formatB, resB);
            if (version != null) {
                version.setVersionPartA(versionPartA);
                version.setVersionPartB(versionPartB);
                version.setVersionPartSeperator(seperator);
            }
            return number + (versionPartA != null && versionPartA.length() > 0 ? versionPartA + seperator : "") + versionPartB;
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Calulation Exception", (Throwable)e);
        }
    }

    public DocumentVersion getNumber(Document document, Project project, ReviewCycleResultOption option, DocumentVersion version, String separator) throws NumberCalculatorException {
        String number;
        if (document.getName() == "" || document.getName() == null) {
            number = this.getNumber(document, project, true);
        } else {
            number = document.getName();
            number = number + this.getLastSeperator(document, project);
        }
        if (option == null) {
            throw new NumberCalculatorException("Cell must not be null");
        }
        this.context.clear();
        this.context.put("oldPartA", version.getVersionPartA());
        this.context.put("oldPartB", version.getVersionPartB());
        this.context.put("calculator", this);
        Object resA = null;
        Object resB = null;
        Object expressionA = null;
        Object expressionB = null;
        String versionPartA = null;
        String versionPartB = null;
        try {
            if (option.getCellChangePartA() != null && option.getCellChangePartA().length() > 0) {
                expressionA = Ognl.parseExpression(option.getCellChangePartA());
            }
            if (option.getCellChangePartB() != null && option.getCellChangePartB().length() > 0) {
                expressionB = Ognl.parseExpression(option.getCellChangePartB());
            }
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Parse Exception", (Throwable)e);
        }
        try {
            resA = expressionA != null ? Ognl.getValue(expressionA, (Map)this.context, (Object)this.context) : version.getVersionPartA();
            resB = expressionB != null ? Ognl.getValue(expressionB, (Map)this.context, (Object)this.context) : version.getVersionPartB();
        }
        catch (OgnlException e) {
            throw new NumberCalculatorException("Ognl Exception", (Throwable)e);
        }
        String formatA = option.getCellChangePartAFormat();
        String formatB = option.getCellChangePartBFormat();
        versionPartA = formatA != null && formatA.contains("d") ? this.format(formatA, resA instanceof String ? Integer.valueOf((String)resA) : resA) : this.format(formatA, resA);
        versionPartB = formatB != null && formatB.contains("d") ? this.format(formatB, resB instanceof String ? Integer.valueOf((String)resB) : resB) : this.format(formatB, resB);
        version.setVersionPartA(versionPartA);
        version.setVersionPartB(versionPartB);
        version.setVersionPartSeperator(separator);
        version.setName(number + (versionPartA != null && versionPartA.length() > 0 ? versionPartA + separator : "") + versionPartB);
        return version;
    }

    private static DocumentNumberComponent getDocumentNumberComponentByOgnlPath(String path) {
        if ("document.documentType.code".equals(path)) {
            return DocumentNumberComponent.DOCUMENT_TYPE_CODE;
        }
        if ("document.documentType.documentTypeGroup.code".equals(path)) {
            return DocumentNumberComponent.DOCUMENT_TYPE_GROUP_CODE;
        }
        if ("document.number".equals(path)) {
            return DocumentNumberComponent.DOCUMENT_NUMBER;
        }
        if ("document.objectPlanner.code".equals(path)) {
            return DocumentNumberComponent.OBJECTPLANNER_CODE;
        }
        if ("document.objectPlanner.object.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_CODE_FULL;
        }
        if ("document.objectPlanner.object.codeWithoutType".equals(path)) {
            return DocumentNumberComponent.OBJECT_CODE;
        }
        if ("document.objectPlanner.object.objectType.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_TYPE_CODE;
        }
        if ("document.objectPlanner.planner.customerId".equals(path)) {
            return DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID;
        }
        if ("document.documentList.subProject.code".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_CODE;
        }
        if ("document.documentList.subProject.codeWithoutNumber".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_CODE_WITHOUTNUMBER;
        }
        if ("document.documentList.subProject.number".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_NUMBER;
        }
        if ("document.documentList.subProject.subProjectType.code".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_TYPE_CODE;
        }
        if ("document.documentList.subProject.project.code".equals(path)) {
            return DocumentNumberComponent.PROJECT_CODE;
        }
        if ("relObjectPlanner.code".equals(path)) {
            return DocumentNumberComponent.OBJECTPLANNER_RELEASE_CODE;
        }
        if ("relObjectPlanner.object.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_RELEASE_CODE_FULL;
        }
        if ("relObjectPlanner.object.codeWithoutType".equals(path)) {
            return DocumentNumberComponent.OBJECT_RELEASE_CODE;
        }
        if ("relObjectPlanner.object.objectType.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_RELEASE_TYPE_CODE;
        }
        if ("relObjectPlanner.planner.customerId".equals(path)) {
            return DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID;
        }
        if ("relObjectPlanner.objectPlanner.planner.customerId".equals(path)) {
            return DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID;
        }
        throw new IllegalArgumentException("Unsupported ognl path: " + path);
    }
}

