/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.activation.UnsupportedDataTypeException;

public class ParameterHelper {
    private static void contructInternal(StringBuffer s, Object param) throws UnsupportedDataTypeException {
        if (param == null) {
            s.append("X");
        } else if (param instanceof Long) {
            s.append("L");
            s.append(param);
        } else if (param instanceof String) {
            s.append("S");
            try {
                s.append(URLEncoder.encode((String)param, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedDataTypeException("Cannot utf-8 encode string.");
            }
        } else if (param instanceof Integer) {
            s.append(param);
        } else {
            throw new UnsupportedDataTypeException("Only null, String, Integer and Long parameters are allowed.");
        }
    }

    public static String constructParameterString(Object param) throws UnsupportedDataTypeException {
        StringBuffer s = new StringBuffer();
        ParameterHelper.contructInternal(s, param);
        return s.toString();
    }

    public static String constructParametersString(Object[] params) throws UnsupportedDataTypeException {
        if (params == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                s.append('&');
            }
            ParameterHelper.contructInternal(s, params[i]);
        }
        return s.toString();
    }

    public static String constructURLParametersString(String var, Object[] params) throws UnsupportedDataTypeException {
        String evar;
        if (params == null) {
            return null;
        }
        try {
            evar = URLEncoder.encode(var, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedDataTypeException("Cannot utf-8 encode variable name.");
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                s.append('&');
            }
            s.append(evar);
            s.append('=');
            ParameterHelper.contructInternal(s, params[i]);
        }
        return s.toString();
    }

    public static Object parseParameterString(String str) throws UnsupportedDataTypeException {
        if (str == null) {
            return null;
        }
        if (str.length() <= 0) {
            return null;
        }
        if (str.equals("X")) {
            return null;
        }
        if (str.startsWith("L")) {
            return Long.valueOf(str.substring(1));
        }
        if (str.startsWith("S")) {
            try {
                return URLDecoder.decode(str.substring(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedDataTypeException("Cannot utf-8 decode string.");
            }
        }
        char char0 = str.charAt(0);
        if (Character.isDigit(char0)) {
            return Integer.valueOf(str);
        }
        throw new UnsupportedDataTypeException("Only null, String, Integer and Long parameters are allowed.");
    }

    public static Object[] parseParametersString(String str) throws UnsupportedDataTypeException {
        int npos;
        if (str == null) {
            return new Object[0];
        }
        int pos = 0;
        ArrayList<String> strs = new ArrayList<String>();
        while ((npos = str.indexOf(38, pos)) >= pos) {
            strs.add(str.substring(pos, npos));
            pos = npos + 1;
        }
        strs.add(str.substring(pos));
        Object[] ret = new Object[strs.size()];
        int i = 0;
        for (String s : strs) {
            ret[i] = ParameterHelper.parseParameterString(s);
            ++i;
        }
        return ret;
    }

    public static Object[] parseURLParametersString(String var, String str) throws UnsupportedDataTypeException {
        int npos;
        String evar;
        if (str == null) {
            return new Object[0];
        }
        try {
            evar = URLEncoder.encode(var, "UTF-8") + "=";
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedDataTypeException("Cannot utf-8 encode variable name.");
        }
        int pos = 0;
        ArrayList<String> strs = new ArrayList<String>();
        while ((npos = str.indexOf(38, pos)) >= pos) {
            if (str.substring(pos).startsWith(evar)) {
                strs.add(str.substring(pos + evar.length(), npos));
            }
            pos = npos + 1;
        }
        if (str.substring(pos).startsWith(evar)) {
            strs.add(str.substring(pos + evar.length()));
        }
        Object[] ret = new Object[strs.size()];
        int i = 0;
        for (String s : strs) {
            ret[i] = ParameterHelper.parseParameterString(s);
            ++i;
        }
        return ret;
    }
}

