/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.cycle.node;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.cycle.ReviewCycleCommentType;
import at.cdes.bo.data.cycle.ReviewCyclePositionType;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeListener;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeListenerPositionComparator;
import at.cdes.bo.data.role.Context;
import at.cdes.bo.data.role.RoleType;
import at.cdes.util.TapestryI18nHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ReviewCycleNode
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    public static final int PARALLELREVIEW = 0;
    public static final int SERIALREVIEW = 1;
    public static final int SERIALGRAPHICREVIEW = 2;
    public static final int EMPTYREVIEW = 3;
    public static final int PARALLELGRAPHICREVIEW = 4;
    public static final int SERIALMULTIREALMREVIEW = 5;
    private Integer id;
    private String name;
    private Integer position;
    private ReviewCycleCell reviewCycleCell;
    private ReviewCyclePositionType reviewCyclePositionType;
    private Map nodeCrossCommentConnections;
    private int reviewType;
    private RoleType roleType;
    private RoleType attachedReviewerRoleType;
    private ReviewCycleCommentType reviewCycleCommentType;
    private Map listeners;
    private boolean free;
    private Context defaultPositionRoleContext;
    private Map additionalRoleTypes;
    private String skippingRule;
    private String skippingRuleComment;

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getLocname() {
        return TapestryI18nHelper.getLocalizedString(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public ReviewCycleCell getReviewCycleCell() {
        return this.reviewCycleCell;
    }

    public void setReviewCycleCell(ReviewCycleCell reviewCycleCell) {
        this.reviewCycleCell = reviewCycleCell;
    }

    public ReviewCyclePositionType getReviewCyclePositionType() {
        return this.reviewCyclePositionType;
    }

    public void setReviewCyclePositionType(ReviewCyclePositionType reviewCyclePositionType) {
        this.reviewCyclePositionType = reviewCyclePositionType;
    }

    public boolean isEndNode() {
        return this.getReviewCyclePositionType().isEndType();
    }

    public boolean isEndOfCell() {
        int numberOfNodesOfCell = this.reviewCycleCell.getReviewCycleNodes().size();
        int nodesPos = this.getPosition();
        return nodesPos > 0 && (this.getReviewCycleCell().isEndCell() && numberOfNodesOfCell - 1 == nodesPos || !this.getReviewCycleCell().isEndCell() && numberOfNodesOfCell == nodesPos);
    }

    public boolean isEndOfReviewCycle() {
        return this.reviewCycleCell.isEndCell() && this.isEndNode();
    }

    public Map getNodeCrossCommentConnections() {
        return this.nodeCrossCommentConnections;
    }

    public void setNodeCrossCommentConnections(Map crossCommentConnections) {
        this.nodeCrossCommentConnections = crossCommentConnections;
    }

    public int getReviewType() {
        return this.reviewType;
    }

    public void setReviewType(int reviewType) {
        this.reviewType = reviewType;
    }

    public RoleType getRoleType() {
        return this.roleType;
    }

    public void setRoleType(RoleType roleType) {
        this.roleType = roleType;
    }

    public ReviewCycleCommentType getReviewCycleCommentType() {
        return this.reviewCycleCommentType;
    }

    public void setReviewCycleCommentType(ReviewCycleCommentType reviewCycleCommentType) {
        this.reviewCycleCommentType = reviewCycleCommentType;
    }

    public Map getListeners() {
        return this.listeners;
    }

    public void setListeners(Map listeners) {
        this.listeners = listeners;
    }

    public Collection<ReviewCycleNodeListener> getListenersSortedByPosition() {
        if (this.getListeners() == null) {
            return null;
        }
        ArrayList<ReviewCycleNodeListener> ret = new ArrayList<ReviewCycleNodeListener>();
        ret.addAll(this.getListeners().values());
        Collections.sort(ret, new ReviewCycleNodeListenerPositionComparator());
        return ret;
    }

    public boolean isFree() {
        return this.free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public Context getDefaultPositionRoleContext() {
        return this.defaultPositionRoleContext;
    }

    public void setDefaultPositionRoleContext(Context defaultPositionRoleContext) {
        this.defaultPositionRoleContext = defaultPositionRoleContext;
    }

    public RoleType getAttachedReviewerRoleType() {
        return this.attachedReviewerRoleType;
    }

    public void setAttachedReviewerRoleType(RoleType attachedReviewerRoleType) {
        this.attachedReviewerRoleType = attachedReviewerRoleType;
    }

    public Map getAdditionalRoleTypes() {
        return this.additionalRoleTypes;
    }

    public void setAdditionalRoleTypes(Map additionalRoleTypes) {
        this.additionalRoleTypes = additionalRoleTypes;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ReviewCycleNode.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReviewCycleNode other = (ReviewCycleNode)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public void setSkippingRule(String skippingRule) {
        this.skippingRule = skippingRule;
    }

    public String getSkippingRule() {
        return this.skippingRule;
    }

    public void setSkippingRuleComment(String skippingRuleComment) {
        this.skippingRuleComment = skippingRuleComment;
    }

    public String getSkippingRuleComment() {
        return this.skippingRuleComment;
    }
}

