/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.file;

import at.cdes.bo.data.file.CDESDataFile;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.io.Serializable;
import java.util.Map;

public class FileFinder
implements Serializable {
    static final long serialVersionUID = 1L;
    private Map<String, File> fileRepositoryToPath;
    private Map<String, File> backupRepositoryToPath;

    public void setFileRepositoryToPath(Map<String, File> fileRepositoryToPath) {
        this.fileRepositoryToPath = fileRepositoryToPath;
    }

    public void setBackupRepositoryToPath(Map<String, File> backupRepositoryToPath) {
        this.backupRepositoryToPath = backupRepositoryToPath;
    }

    public File findFile(String fileName, CDESFileRepository kind) throws FileHandleException {
        File file = this.buildFile(fileName, kind);
        if (file.exists()) {
            return file;
        }
        File bf = this.buildBackupFile(fileName, kind);
        if (bf != null && (file = bf).exists()) {
            return file;
        }
        throw new FileHandleException("The file with the path " + file.getAbsolutePath() + " was not found");
    }

    public File findFile(CDESDataFile df) throws FileHandleException {
        File file = this.buildFile(df);
        if (file.exists()) {
            return file;
        }
        File bf = this.buildBackupFile(df);
        if (bf != null && (file = bf).exists()) {
            return file;
        }
        throw new FileHandleException("The file with the path " + file.getAbsolutePath() + " was not found");
    }

    public File buildFile(String fileName, CDESFileRepository kind) throws FileHandleException {
        if (this.fileRepositoryToPath.get(kind.getKey()) == null) {
            throw new FileHandleException("The filepath according to kind was not found. kind = " + (Object)((Object)kind));
        }
        fileName = fileName.replace("\\", File.separator);
        return new File(this.fileRepositoryToPath.get(kind.getKey()), fileName);
    }

    public String getAbsoluteRepositoryFilepath(CDESFileRepository kind) {
        return this.fileRepositoryToPath.get(kind.getKey()).getAbsolutePath();
    }

    public File buildFile(CDESDataFile df) throws FileHandleException {
        if (this.fileRepositoryToPath.get(df.getRepository().getKey()) == null) {
            throw new FileHandleException("The filepath according to kind was not found. kind = " + (Object)((Object)df.getRepository()));
        }
        String subPath = df.getPath().replace("\\", File.separator);
        return new File(this.fileRepositoryToPath.get(df.getRepository().getKey()), subPath);
    }

    public File buildBackupFile(String fileName, CDESFileRepository kind) {
        if (this.backupRepositoryToPath.get(kind.getKey()) == null) {
            return null;
        }
        fileName = fileName.replace("\\", File.separator);
        return new File(this.backupRepositoryToPath.get(kind.getKey()), fileName);
    }

    public File buildBackupFile(CDESDataFile df) {
        if (this.backupRepositoryToPath.get(df.getRepository().getKey()) == null) {
            return null;
        }
        String subPath = df.getPath().replace("\\", File.separator);
        return new File(this.backupRepositoryToPath.get(df.getRepository().getKey()), subPath);
    }

    public String makeUniqueName(String fileName, CDESFileRepository kind) {
        return kind.toPrefix() + ":" + fileName;
    }
}

