/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.role;

import at.cdes.bo.role.RoleMapEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RoleMap
implements Serializable {
    static final long serialVersionUID = 1L;
    private List roles = new ArrayList();

    public void add(Integer id, Integer networkId, Integer projectId, Integer projectParticipantId, Integer organisationPersonId) {
        this.roles.add(new RoleMapEntry(id, networkId, projectId, projectParticipantId, null, organisationPersonId));
    }

    public RoleMapEntry getGlobalRole() {
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getNetworkId() != null || entry.getProjectId() != null || entry.getProjectParticipantId() != null) continue;
            return entry;
        }
        return null;
    }

    public List getNetworkRoles(Integer networkId) {
        if (networkId == null) {
            return new ArrayList();
        }
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getNetworkId() == null || entry.getProjectId() != null || entry.getProjectParticipantId() != null || !entry.getNetworkId().equals(networkId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List getNetworkRoles(Integer networkId, Integer organisationPersonId) {
        if (networkId == null) {
            return new ArrayList();
        }
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getNetworkId() == null || entry.getProjectId() != null || entry.getProjectParticipantId() != null || !entry.getNetworkId().equals(networkId) || entry.getOrganisationPersonId() != null && !entry.getOrganisationPersonId().equals(organisationPersonId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List getNetworks(Integer organisationPersonId) {
        if (organisationPersonId == null) {
            return new ArrayList();
        }
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        ArrayList<Integer> added = new ArrayList<Integer>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getNetworkId() == null || entry.getOrganisationPersonId() != null && !entry.getOrganisationPersonId().equals(organisationPersonId) || added.contains(entry.getNetworkId())) continue;
            l.add(entry);
            added.add(entry.getNetworkId());
        }
        return l;
    }

    public List getProjectRoles(Integer projectId, Integer organisationPersonId) {
        if (projectId == null) {
            return new ArrayList();
        }
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getProjectId() == null || entry.getProjectParticipantId() == null || !entry.getProjectId().equals(projectId) || !entry.getOrganisationPersonId().equals(organisationPersonId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List getProjects(Integer organisationPersonId) {
        if (organisationPersonId == null) {
            return new ArrayList();
        }
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        ArrayList<Integer> added = new ArrayList<Integer>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getProjectId() == null || !entry.getOrganisationPersonId().equals(organisationPersonId) || added.contains(entry.getProjectId())) continue;
            l.add(entry);
            added.add(entry.getProjectId());
        }
        return l;
    }

    public List getSubProjects(Integer organisationPersonId) {
        if (organisationPersonId == null) {
            return new ArrayList();
        }
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        ArrayList<Integer> added = new ArrayList<Integer>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getProjectId() == null || !entry.getOrganisationPersonId().equals(organisationPersonId) || added.contains(entry.getProjectId())) continue;
            l.add(entry);
            added.add(entry.getProjectId());
        }
        return l;
    }

    public List getProjectRoles(Integer projectId) {
        if (projectId == null) {
            return new ArrayList();
        }
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getProjectId() == null || entry.getProjectParticipantId() == null || !entry.getProjectId().equals(projectId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List getAllProjectRoles() {
        ArrayList<RoleMapEntry> l = new ArrayList<RoleMapEntry>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            if (entry.getProjectId() == null || entry.getProjectParticipantId() == null || entry.getProjectId() == null) continue;
            l.add(entry);
        }
        return l;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)this.roles.get(i);
            buf.append(entry.toString());
        }
        return buf.toString();
    }
}

