/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCyclePositionRelease;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.task.AttachedReviewTask;
import at.cdes.bo.data.task.AttachedReviewTaskDone;
import at.cdes.bo.data.task.DocumentTask;
import at.cdes.bo.data.task.DocumentVersionTaskBase;
import at.cdes.bo.data.task.OriginalDocumentTask;
import at.cdes.bo.data.task.OriginalDocumentTaskDone;
import at.cdes.bo.data.task.PlotOrderAcceptanceTask;
import at.cdes.bo.data.task.PlotOrderAcceptanceTaskDone;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.ReviewCycleEntryTaskDone;
import at.cdes.bo.data.task.ReviewCyclePlottTask;
import at.cdes.bo.data.task.ReviewCyclePlottTaskDone;
import at.cdes.bo.data.task.ReviewTask;
import at.cdes.bo.data.task.ReviewTaskDone;
import at.cdes.bo.data.task.ReviewableTask;
import at.cdes.bo.data.task.SelectCellConnectionTask;
import at.cdes.bo.data.task.SelectCellConnectionTaskDone;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.data.task.TaskBase;
import at.cdes.bo.data.task.TaskMonitoringResult;
import at.cdes.db.dao.TaskDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class TaskDAOHibernate
extends HibernateDaoSupport
implements TaskDAO {
    static Logger logger = Logger.getLogger(TaskDAOHibernate.class);

    @Override
    public Task get(Integer id) {
        return (Task)this.getSession().get(TaskBase.class, (Serializable)id);
    }

    @Override
    public Task save(Task cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public Task update(Task cons) {
        if (cons instanceof ReviewableTask) {
            ArrayList rcprs = new ArrayList(((ReviewableTask)cons).getReviewCyclePositionReleases().values());
            cons = (Task)this.getSession().merge((Object)cons);
            for (ReviewCyclePositionRelease rcpr : rcprs) {
                ((ReviewableTask)cons).getReviewCyclePositionReleases().put(rcpr.getId(), rcpr);
            }
            this.getSession().update((Object)cons);
            return cons;
        }
        return (Task)this.getSession().merge((Object)cons);
    }

    @Override
    public void delete(Integer taskId) {
        Task task = (Task)this.getSession().get(TaskBase.class, (Serializable)taskId);
        this.getSession().delete((Object)task);
    }

    @Override
    public List getAllProjectParticipationSelectCellConnectionTodos(Integer ppid) {
        return this.getSession().createCriteria(SelectCellConnectionTask.class).add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppid)).setCacheable(true).list();
    }

    @Override
    public List getAllProjectParticipationReviewTodos(Integer ppid) {
        return this.getSession().createCriteria(ReviewTask.class).add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppid)).setCacheable(true).list();
    }

    @Override
    public List getProjectParticipationReviewTodos(Integer ppid, Integer nodeInstanceId, Integer documentVersionId) {
        Criteria crit = this.getSession().createCriteria(ReviewTask.class);
        crit.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppid));
        crit.add((Criterion)Restrictions.eq((String)"reviewCycleNodeInstanceId", (Object)nodeInstanceId));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId));
        return crit.setCacheable(true).list();
    }

    @Override
    public List getAll(DocumentVersion version) {
        return this.getSession().createCriteria(DocumentVersionTaskBase.class).createCriteria("documentVersion").add(Restrictions.idEq((Object)version.getId())).list();
    }

    @Override
    public List getAllReviewTasksByDocument(Integer documentId) {
        return this.getSession().createCriteria(ReviewTask.class).createCriteria("documentVersion").createCriteria("document").add(Restrictions.idEq((Object)documentId)).list();
    }

    @Override
    public Collection<AttachedReviewTask> getAllAttachedReviewTasksByDocument(Integer documentId) {
        return this.getSession().createCriteria(AttachedReviewTask.class).createCriteria("documentVersion").createCriteria("document").add(Restrictions.idEq((Object)documentId)).list();
    }

    @Override
    public List<AttachedReviewTask> getAllProjectParticipationAttachedReviewTodos(Integer ppId) {
        return this.getSession().createCriteria(AttachedReviewTask.class).add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppId)).setCacheable(true).list();
    }

    @Override
    public List<AttachedReviewTask> getProjectParticipationAttachedReviewTodos(Integer ppid, Integer nodeInstanceId, Integer documentVersionId) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewTask.class);
        crit.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppid));
        crit.add((Criterion)Restrictions.eq((String)"reviewCycleNodeInstanceId", (Object)nodeInstanceId));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId));
        return crit.setCacheable(true).list();
    }

    @Override
    public Collection<ReviewTask> getAllReviewTasks() {
        return this.loadAllHibernate(ReviewTask.class);
    }

    @Override
    public Collection<AttachedReviewTask> getAllAttachedReviewTasks() {
        return this.loadAllHibernate(AttachedReviewTask.class);
    }

    @Override
    public Collection<SelectCellConnectionTask> getAllSelectCellConnectionTasks() {
        return this.loadAllHibernate(SelectCellConnectionTask.class);
    }

    @Override
    public Collection<? extends Task> getAllAttachedReviewTasksByDocumentVersion(Integer docVersionId) {
        List res = this.findHibernate("from AttachedReviewTask where documentVersion.id = ?", docVersionId);
        return res;
    }

    @Override
    public Collection<? extends Task> getAllReviewTasksByDocumentVersion(Integer docVersionId) {
        List res = this.findHibernate("from ReviewTask where documentVersion.id = ?", docVersionId);
        return res;
    }

    @Override
    public Collection<? extends Task> getAllSelectCellConnectionTasks(Integer docVersionId) {
        List res = this.findHibernate("from SelectCellConnectionTask where documentVersion.id = ?", docVersionId);
        return res;
    }

    @Override
    public ReviewCycleEntryTask getReviewCycleEntryTaskByDocument(Integer documentId) {
        return (ReviewCycleEntryTask)this.getSession().createCriteria(ReviewCycleEntryTask.class).createCriteria("document").add(Restrictions.idEq((Object)documentId)).uniqueResult();
    }

    @Override
    public List<ReviewCycleEntryTask> getAllProjectParticipationReviewCycleEntryTodos(Integer ppId) {
        return this.getSession().createCriteria(ReviewCycleEntryTask.class).add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppId)).setCacheable(true).list();
    }

    @Override
    public List getObjectPlannerPlannerReviewCycleEntryTodos(Integer ppid, Integer objectPlannerId) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleEntryTask.class);
        crit.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppid));
        crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerId));
        return crit.setCacheable(true).list();
    }

    @Override
    public Collection<TaskMonitoringResult> getTaskMonitoringResults() {
        return this.loadAllHibernate(TaskMonitoringResult.class);
    }

    @Override
    public void deleteAllTaskMonitoringResults() {
        this.deleteAllHibernate(this.getTaskMonitoringResults());
    }

    @Override
    public TaskMonitoringResult save(TaskMonitoringResult res) {
        Integer id = (Integer)this.getSession().save((Object)res);
        return (TaskMonitoringResult)this.getSession().get(TaskMonitoringResult.class, (Serializable)id);
    }

    @Override
    public Collection<ReviewCyclePlottTask> getAllProjectParticipationReviewCyclePlottTodos(Integer projectParticipationId) {
        return this.getSession().createCriteria(ReviewCyclePlottTask.class).add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId)).setCacheable(true).list();
    }

    @Override
    public ReviewCyclePlottTask getReviewCyclePlottTask(Integer orderStepId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePlottTask.class);
        crit.createCriteria("orderStep").add(Restrictions.idEq((Object)orderStepId));
        return (ReviewCyclePlottTask)crit.uniqueResult();
    }

    @Override
    public ReviewCyclePlottTaskDone getReviewCyclePlottTaskDone(Integer orderStepId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePlottTaskDone.class);
        crit.createCriteria("orderStep").add(Restrictions.idEq((Object)orderStepId));
        return (ReviewCyclePlottTaskDone)crit.uniqueResult();
    }

    @Override
    public Collection<OriginalDocumentTask> getAllProjectParticipationOriginalDocumentTodos(Integer projectParticipationId) {
        return this.getSession().createCriteria(OriginalDocumentTask.class).add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId)).setCacheable(true).list();
    }

    @Override
    public OriginalDocumentTask getOriginalDocumentTask(Integer orderStepId) {
        Criteria crit = this.getSession().createCriteria(OriginalDocumentTask.class);
        crit.createCriteria("orderStep").add(Restrictions.idEq((Object)orderStepId));
        return (OriginalDocumentTask)crit.uniqueResult();
    }

    @Override
    public OriginalDocumentTaskDone getOriginalDocumentTaskDone(Integer orderStepId) {
        Criteria crit = this.getSession().createCriteria(OriginalDocumentTaskDone.class);
        crit.createCriteria("orderStep").add(Restrictions.idEq((Object)orderStepId));
        return (OriginalDocumentTaskDone)crit.uniqueResult();
    }

    @Override
    public Collection getObjectPlannerPlannerSelectCellConnectionTodos(Integer plannerId, Integer objectPlannerId) {
        Criteria crit = this.getSession().createCriteria(SelectCellConnectionTask.class);
        crit.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)plannerId));
        crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerId));
        return crit.setCacheable(true).list();
    }

    @Override
    public Collection getReviewTasksOfDocumentVersion(Integer docVersionId) {
        Criteria crit = this.getSession().createCriteria(ReviewTask.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)docVersionId));
        return crit.list();
    }

    @Override
    public Collection getReviewTasksOfDocumentVersionAndNodeInstance(Integer docVersionId, Integer nodeInstanceId) {
        Criteria crit = this.getSession().createCriteria(ReviewTask.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)docVersionId));
        crit.add((Criterion)Restrictions.eq((String)"reviewCycleNodeInstanceId", (Object)nodeInstanceId));
        return crit.list();
    }

    @Override
    public List getSelectCellConnectionTasksDoneByConnectionResult(Integer cellConnectionResultId) {
        Criteria crit = this.getSession().createCriteria(SelectCellConnectionTaskDone.class);
        crit.createCriteria("reviewCycleCellConnectionResult").add(Restrictions.idEq((Object)cellConnectionResultId));
        return crit.setCacheable(true).list();
    }

    @Override
    public ReviewCycleEntryTaskDone getReviewCycleEntryTaskDoneByEntryResult(Integer entryResultId) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleEntryTaskDone.class);
        crit.createCriteria("reviewCycleEntryResult").add(Restrictions.idEq((Object)entryResultId));
        return (ReviewCycleEntryTaskDone)crit.uniqueResult();
    }

    @Override
    public List getAllPlotOrderAcceptanceTodos(Integer ppid) {
        return this.getSession().createCriteria(PlotOrderAcceptanceTask.class).add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppid)).setCacheable(true).list();
    }

    @Override
    public List<PlotOrderAcceptanceTask> getPlotOrderAcceptanceTasksByPlotOrder(Integer plotOrderId) {
        Criteria crit = this.getSession().createCriteria(PlotOrderAcceptanceTask.class);
        crit.createCriteria("order").add(Restrictions.idEq((Object)plotOrderId));
        return crit.list();
    }

    @Override
    public List<PlotOrderAcceptanceTaskDone> getPlotOrderAcceptanceTasksDoneByPlotOrder(Integer plotOrderId) {
        Criteria crit = this.getSession().createCriteria(PlotOrderAcceptanceTaskDone.class);
        crit.createCriteria("order").add(Restrictions.idEq((Object)plotOrderId));
        return crit.list();
    }

    @Override
    public PlotOrderAcceptanceTask getPlotOrderAcceptanceTaskByPlotOrderAndParticipation(Integer plotOrderId, Integer projectParticipationId) {
        Criteria crit = this.getSession().createCriteria(PlotOrderAcceptanceTask.class);
        crit.createCriteria("order").add(Restrictions.idEq((Object)plotOrderId));
        crit.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        return (PlotOrderAcceptanceTask)crit.uniqueResult();
    }

    @Override
    public List getAllLateReviewTasks(Calendar deadline, Integer projectId) {
        Criteria critReviewTask = this.getSession().createCriteria(ReviewTask.class);
        if (projectId != null) {
            critReviewTask.createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        critReviewTask.add((Criterion)Restrictions.lt((String)"endDate", (Object)deadline));
        Criteria critAttachedReviewTask = this.getSession().createCriteria(AttachedReviewTask.class);
        if (projectId != null) {
            critAttachedReviewTask.createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        critAttachedReviewTask.add((Criterion)Restrictions.lt((String)"endDate", (Object)deadline));
        ArrayList results = new ArrayList();
        results.addAll(critReviewTask.list());
        results.addAll(critAttachedReviewTask.list());
        return results;
    }

    @Override
    public List getAllLateUploadTasks(Calendar deadline, Integer projectId) {
        Criteria ReviewCycleEntryTask2 = this.getSession().createCriteria(ReviewCycleEntryTask.class);
        if (projectId != null) {
            ReviewCycleEntryTask2.createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        ReviewCycleEntryTask2.add((Criterion)Restrictions.lt((String)"endDate", (Object)deadline));
        Criteria SelectCellConnectionTask2 = this.getSession().createCriteria(SelectCellConnectionTask.class);
        if (projectId != null) {
            SelectCellConnectionTask2.createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        SelectCellConnectionTask2.add((Criterion)Restrictions.lt((String)"endDate", (Object)deadline));
        ArrayList results = new ArrayList();
        results.addAll(ReviewCycleEntryTask2.list());
        results.addAll(SelectCellConnectionTask2.list());
        return results;
    }

    @Override
    public List getAttachedReviewTasksOfReviewCycleInstance(ReviewCycleInstance rci) {
        ArrayList tasks = new ArrayList();
        Collection rccis = rci.getReviewCycleCellInstances().values();
        for (ReviewCycleCellInstance rcci : rccis) {
            Collection rcnis = rcci.getReviewCycleNodeInstances().values();
            for (ReviewCycleNodeInstance rcni : rcnis) {
                Criteria crit = this.getSession().createCriteria(AttachedReviewTask.class);
                crit.add((Criterion)Restrictions.eq((String)"reviewCycleNodeInstanceId", (Object)rcni.getId()));
                tasks.addAll(crit.list());
            }
        }
        return tasks;
    }

    @Override
    public List<SelectCellConnectionTask> getSelectCellConnectionTasksForDocument(Integer documentImplId) {
        Criteria crit = this.getSession().createCriteria(SelectCellConnectionTask.class);
        crit.createCriteria("documentVersion").createCriteria("document").add(Restrictions.idEq((Object)documentImplId));
        return crit.list();
    }

    @Override
    public List<Task> getAllTasksOfProject(Integer projectId) {
        Criteria critDocumentTask = this.getSession().createCriteria(DocumentTask.class);
        critDocumentTask.createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        Criteria critDocumentVersionTask = this.getSession().createCriteria(DocumentVersionTaskBase.class);
        critDocumentVersionTask.createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        ArrayList<Task> results = new ArrayList<Task>();
        results.addAll(critDocumentTask.list());
        results.addAll(critDocumentVersionTask.list());
        return results;
    }

    @Override
    public boolean hasPlotTasks(Integer projectParticipationId) {
        Criteria crit1 = this.getSession().createCriteria(ReviewCyclePlottTask.class);
        crit1.add((Criterion)Restrictions.like((String)"projectParticipationId", (Object)projectParticipationId));
        if (!crit1.list().isEmpty()) {
            return true;
        }
        Criteria crit2 = this.getSession().createCriteria(PlotOrderAcceptanceTask.class);
        crit2.add((Criterion)Restrictions.like((String)"projectParticipationId", (Object)projectParticipationId));
        return !crit2.list().isEmpty();
    }

    @Override
    public List getAllPlottTasksOfProject(Integer projectId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePlottTask.class);
        crit.createCriteria("order").createCriteria("project").add(Restrictions.idEq((Object)projectId));
        return crit.list();
    }

    @Override
    public List<AttachedReviewTask> getAllAttachedReviewTasksByParticipation(Integer projectParticipationId) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewTask.class);
        crit.add((Criterion)Restrictions.like((String)"projectParticipationId", (Object)projectParticipationId));
        return crit.list();
    }

    @Override
    public List<Task> getAllDeletableTasksOfSubProject(Integer subProjectId) {
        ArrayList<Task> allTasks = new ArrayList<Task>();
        Criteria crit1 = this.getSession().createCriteria(DocumentTask.class);
        crit1.createCriteria("objectPlanner").createCriteria("object").createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        allTasks.addAll(crit1.list());
        Criteria crit2 = this.getSession().createCriteria(DocumentVersionTaskBase.class);
        crit2.createCriteria("objectPlanner").createCriteria("object").createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        allTasks.addAll(crit2.list());
        ArrayList<Task> allOpenTasks = new ArrayList<Task>();
        for (Task task : allTasks) {
            if (!(task instanceof ReviewCycleEntryTask) && !(task instanceof SelectCellConnectionTask) && !(task instanceof ReviewTask) && !(task instanceof AttachedReviewTask) && !(task instanceof OriginalDocumentTask) && !(task instanceof PlotOrderAcceptanceTask)) continue;
            allOpenTasks.add(task);
        }
        return allTasks;
    }

    @Override
    public boolean isAttachedPositionResult(Integer reviewCyclePositionResultId) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewTaskDone.class);
        crit.createCriteria("reviewCyclePositionResults").add(Restrictions.idEq((Object)reviewCyclePositionResultId));
        return !crit.list().isEmpty();
    }

    @Override
    public List<Task> getAllTasksBySubProject(Integer subProjectId) {
        ArrayList<Task> allTasks = new ArrayList<Task>();
        Criteria crit1 = this.getSession().createCriteria(DocumentTask.class);
        crit1.createCriteria("objectPlanner").createCriteria("object").createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        allTasks.addAll(crit1.list());
        Criteria crit2 = this.getSession().createCriteria(DocumentVersionTaskBase.class);
        crit2.createCriteria("objectPlanner").createCriteria("object").createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        allTasks.addAll(crit2.list());
        return allTasks;
    }

    @Override
    public List<Task> getAllDoneTasksBetween(Integer projectParticipationId, Date fromDate, Date untilDate) {
        Calendar from = null;
        Calendar until = null;
        if (fromDate != null) {
            from = Calendar.getInstance();
            from.setTime(fromDate);
        }
        if (untilDate != null) {
            until = Calendar.getInstance();
            until.setTime(untilDate);
        }
        ArrayList<Task> doneTasks = new ArrayList<Task>();
        Criteria critReviewTasks = this.getSession().createCriteria(ReviewTaskDone.class);
        critReviewTasks.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        if (from != null && until != null) {
            critReviewTasks.add(Restrictions.between((String)"doneDate", (Object)from, (Object)until));
        } else if (from != null) {
            critReviewTasks.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        } else if (until != null) {
            critReviewTasks.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        doneTasks.addAll(critReviewTasks.list());
        Criteria critAttachedReviewTasks = this.getSession().createCriteria(AttachedReviewTaskDone.class);
        critAttachedReviewTasks.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        if (from != null && until != null) {
            critAttachedReviewTasks.add(Restrictions.between((String)"doneDate", (Object)from, (Object)until));
        } else if (from != null) {
            critAttachedReviewTasks.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        } else if (until != null) {
            critAttachedReviewTasks.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        doneTasks.addAll(critAttachedReviewTasks.list());
        Criteria critEntryTasks = this.getSession().createCriteria(ReviewCycleEntryTaskDone.class);
        critEntryTasks.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        if (from != null && until != null) {
            critEntryTasks.add(Restrictions.between((String)"doneDate", (Object)from, (Object)until));
        } else if (from != null) {
            critEntryTasks.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        } else if (until != null) {
            critEntryTasks.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        doneTasks.addAll(critEntryTasks.list());
        Criteria critCellConnectionTasks = this.getSession().createCriteria(SelectCellConnectionTaskDone.class);
        critCellConnectionTasks.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        if (from != null && until != null) {
            critCellConnectionTasks.add(Restrictions.between((String)"doneDate", (Object)from, (Object)until));
        } else if (from != null) {
            critCellConnectionTasks.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        } else if (until != null) {
            critCellConnectionTasks.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        doneTasks.addAll(critCellConnectionTasks.list());
        Criteria critOriginalDocumentTasks = this.getSession().createCriteria(OriginalDocumentTaskDone.class);
        critOriginalDocumentTasks.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        if (from != null && until != null) {
            critOriginalDocumentTasks.add(Restrictions.between((String)"doneDate", (Object)from, (Object)until));
        } else if (from != null) {
            critOriginalDocumentTasks.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        } else if (until != null) {
            critOriginalDocumentTasks.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        doneTasks.addAll(critOriginalDocumentTasks.list());
        Criteria critPlotOrderAcceptanceTasks = this.getSession().createCriteria(PlotOrderAcceptanceTaskDone.class);
        critPlotOrderAcceptanceTasks.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        if (from != null && until != null) {
            critPlotOrderAcceptanceTasks.add(Restrictions.between((String)"doneDate", (Object)from, (Object)until));
        } else if (from != null) {
            critPlotOrderAcceptanceTasks.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        } else if (until != null) {
            critPlotOrderAcceptanceTasks.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        doneTasks.addAll(critPlotOrderAcceptanceTasks.list());
        Criteria critPlotTasks = this.getSession().createCriteria(ReviewCyclePlottTaskDone.class);
        critPlotTasks.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        if (from != null && until != null) {
            critPlotTasks.add(Restrictions.between((String)"doneDate", (Object)from, (Object)until));
        } else if (from != null) {
            critPlotTasks.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        } else if (until != null) {
            critPlotTasks.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        doneTasks.addAll(critPlotTasks.list());
        return doneTasks;
    }

    @Override
    public List<ReviewTask> getAllSignatureFolderReviewTasksForSubProject(Integer subProjectId) {
        Criteria crit = this.getSession().createCriteria(ReviewTask.class);
        crit.createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        crit.add((Criterion)Restrictions.eq((String)"taskStatus", (Object)1));
        return crit.list();
    }

    @Override
    public List<Task> getAllTasksBetweenDates(List<Integer> participationIds, Date fromDate, Date untilDate, int status) {
        Calendar from = null;
        Calendar until = null;
        if (fromDate != null) {
            from = Calendar.getInstance();
            from.setTime(fromDate);
        }
        if (untilDate != null) {
            until = Calendar.getInstance();
            until.setTime(untilDate);
        }
        ArrayList<Task> ret = new ArrayList<Task>();
        ret.addAll(this.getTasksBetweenDatesInternal(ReviewTask.class, participationIds, from, until, status));
        ret.addAll(this.getTasksBetweenDatesInternal(AttachedReviewTask.class, participationIds, from, until, status));
        if (status != 1) {
            ret.addAll(this.getTasksBetweenDatesInternal(ReviewCycleEntryTask.class, participationIds, from, until, null));
            ret.addAll(this.getTasksBetweenDatesInternal(SelectCellConnectionTask.class, participationIds, from, until, null));
            if (fromDate == null && untilDate == null) {
                ret.addAll(this.getTasksBetweenDatesInternal(OriginalDocumentTask.class, participationIds, null, null, null));
                ret.addAll(this.getTasksBetweenDatesInternal(PlotOrderAcceptanceTask.class, participationIds, null, null, null));
                ret.addAll(this.getTasksBetweenDatesInternal(ReviewCyclePlottTask.class, participationIds, null, null, null));
            }
        }
        return ret;
    }

    @Override
    public List<Task> getAllDoneTasksBetweenDates(List<Integer> participationIds, Date fromDate, Date untilDate) {
        Calendar from = null;
        Calendar until = null;
        if (fromDate != null) {
            from = Calendar.getInstance();
            from.setTime(fromDate);
        }
        if (untilDate != null) {
            until = Calendar.getInstance();
            until.setTime(untilDate);
        }
        ArrayList<Task> ret = new ArrayList<Task>();
        ret.addAll(this.getDoneTasksBetweenDatesInternal(ReviewTaskDone.class, participationIds, from, until));
        ret.addAll(this.getDoneTasksBetweenDatesInternal(AttachedReviewTaskDone.class, participationIds, from, until));
        ret.addAll(this.getDoneTasksBetweenDatesInternal(ReviewCycleEntryTaskDone.class, participationIds, from, until));
        ret.addAll(this.getDoneTasksBetweenDatesInternal(SelectCellConnectionTaskDone.class, participationIds, from, until));
        ret.addAll(this.getDoneTasksBetweenDatesInternal(OriginalDocumentTaskDone.class, participationIds, from, until));
        ret.addAll(this.getDoneTasksBetweenDatesInternal(PlotOrderAcceptanceTaskDone.class, participationIds, from, until));
        ret.addAll(this.getDoneTasksBetweenDatesInternal(ReviewCyclePlottTaskDone.class, participationIds, from, until));
        return ret;
    }

    private List<Task> getTasksBetweenDatesInternal(Class clazz, List<Integer> participationIds, Calendar from, Calendar until, Integer status) {
        if (participationIds == null || participationIds.isEmpty()) {
            return new ArrayList<Task>();
        }
        Criteria crit = this.getSession().createCriteria(clazz);
        if (from != null) {
            crit.add((Criterion)Restrictions.gt((String)"endDate", (Object)from));
        }
        if (until != null) {
            crit.add((Criterion)Restrictions.lt((String)"endDate", (Object)until));
        }
        if (status != null) {
            crit.add((Criterion)Restrictions.eq((String)"taskStatus", (Object)status));
        }
        Disjunction disjunction = Restrictions.disjunction();
        for (Integer ppId : participationIds) {
            disjunction.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppId));
        }
        crit.add((Criterion)disjunction);
        return crit.list();
    }

    private List<Task> getDoneTasksBetweenDatesInternal(Class clazz, List<Integer> participationIds, Calendar from, Calendar until) {
        if (participationIds == null || participationIds.isEmpty()) {
            return new ArrayList<Task>();
        }
        Criteria crit = this.getSession().createCriteria(clazz);
        if (from != null) {
            crit.add((Criterion)Restrictions.gt((String)"doneDate", (Object)from));
        }
        if (until != null) {
            crit.add((Criterion)Restrictions.lt((String)"doneDate", (Object)until));
        }
        Disjunction disjunction = Restrictions.disjunction();
        for (Integer ppId : participationIds) {
            disjunction.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)ppId));
        }
        crit.add((Criterion)disjunction);
        return crit.list();
    }

    @Override
    public List<Task> getTasksBetween(Class clazz, Integer projectParticipationId, Date fromDate, Date untilDate, Integer status) {
        Calendar from = null;
        Calendar until = null;
        if (fromDate != null) {
            from = Calendar.getInstance();
            from.setTime(fromDate);
        }
        if (untilDate != null) {
            until = Calendar.getInstance();
            until.setTime(untilDate);
        }
        Criteria crit = this.getSession().createCriteria(clazz);
        if (from != null) {
            crit.add((Criterion)Restrictions.gt((String)"endDate", (Object)from));
        }
        if (until != null) {
            crit.add((Criterion)Restrictions.lt((String)"endDate", (Object)until));
        }
        if (status != null) {
            crit.add((Criterion)Restrictions.eq((String)"taskStatus", (Object)status));
        }
        crit.add((Criterion)Restrictions.eq((String)"projectParticipationId", (Object)projectParticipationId));
        return crit.list();
    }
}

