/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.upload.handler.impl;

import at.cdes.upload.handler.UploadHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadHandlerImpl
implements UploadHandler {
    private static final Logger log = LoggerFactory.getLogger(UploadHandlerImpl.class);
    private long maxUploadDirSize;
    private String uploadDir;
    private File uploadDirFile;

    private static void checkRelPath(String relPath) throws IOException {
        if (relPath.indexOf(47) >= 0 || relPath.indexOf(92) >= 0) {
            throw new IOException("The given path [" + relPath + "] contains directory separators.");
        }
    }

    @Override
    public File getDownload(String relPath) throws IOException {
        UploadHandlerImpl.checkRelPath(relPath);
        return new File(this.uploadDirFile, relPath);
    }

    @Override
    public void deleteItem(String relPath) throws IOException {
        UploadHandlerImpl.checkRelPath(relPath);
        File f = new File(this.uploadDirFile, relPath);
        log.info("Deleting file [" + f + "].");
        if (!f.delete()) {
            throw new IOException("Cannot delete file [" + f + "].");
        }
    }

    @Override
    public List<File> listItems() throws IOException {
        File[] files = this.uploadDirFile.listFiles();
        ArrayList<File> ret = new ArrayList<File>(files.length);
        for (File file : files) {
            if (!file.isFile()) continue;
            ret.add(file);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeUpload(String relPath, FileItem item) throws IOException {
        UploadHandlerImpl.checkRelPath(relPath);
        File f = new File(this.uploadDirFile, relPath);
        try {
            log.info("Storing uploaded file [" + item.getName() + "] to [" + f + "]...");
            item.write(f);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error while writing uploaded file [" + item.getName() + "] to [" + f + "].");
            ioe.initCause(e);
            throw ioe;
        }
        long size = 0L;
        File file = this.uploadDirFile;
        synchronized (file) {
            File[] files;
            for (File file2 : files = this.uploadDirFile.listFiles()) {
                if (!file2.isFile()) continue;
                size += file2.length();
            }
        }
        if (size > this.maxUploadDirSize) {
            f.delete();
            throw new IOException("Storing upload file [" + item.getName() + "] exceeds maximal upload directory size.");
        }
        log.info("Successfully stored uploaded file [" + item.getName() + "] to [" + f + "], directory size is now [" + size + "].");
    }

    public void setMaxUploadDirSize(long maxUploadDirSize) {
        this.maxUploadDirSize = maxUploadDirSize;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
        this.uploadDirFile = new File(this.uploadDir);
    }
}

