/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.upload.servlet;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.clazzes.util.http.sec.HttpLoginService;

public class CdesUploadHttpLoginService
implements HttpLoginService {
    private HttpLoginService delegate;
    private Set<String> allowedUsers;

    public String getLoginUrl() {
        return this.delegate.getLoginUrl();
    }

    public Principal checkLogin(HttpServletRequest request) {
        return this.delegate.checkLogin(request);
    }

    public Locale getLocale(HttpServletRequest request) {
        return this.delegate.getLocale(request);
    }

    public TimeZone getTimeZone(HttpServletRequest request) {
        return this.delegate.getTimeZone(request);
    }

    public List<? extends Group> checkLoginGroups(HttpServletRequest request) {
        return this.delegate.checkLoginGroups(request);
    }

    public boolean checkPermission(HttpServletRequest request, String context) {
        if (context.startsWith("/cdes/cdes-upload")) {
            Principal principal = this.checkLogin(request);
            if (principal == null) {
                return false;
            }
            return this.allowedUsers.contains(principal.getName());
        }
        return this.delegate.checkPermission(request, context);
    }

    public void logout(HttpServletRequest request) {
        this.delegate.logout(request);
    }

    public void setDelegate(HttpLoginService delegate) {
        this.delegate = delegate;
    }

    public void setAllowedUsersString(String allowedUsersString) {
        String[] allowedUsersArray = allowedUsersString.split(",");
        this.allowedUsers = new HashSet<String>(allowedUsersArray.length);
        for (String au : allowedUsersArray) {
            this.allowedUsers.add(au);
        }
    }
}

