/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.upload.servlet;

import at.cdes.upload.handler.UploadHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.clazzes.util.http.ResponseHelper;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.http.sec.HttpCheckLoginHelper;
import org.clazzes.util.http.sec.HttpLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = -5353827637891479564L;
    private static final Logger log = LoggerFactory.getLogger(DownloadServlet.class);
    private HttpLoginService loginService;
    private UploadHandler uploadHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String relPath = req.getParameter("path");
        if (relPath == null) {
            throw new ServletException("No path parameter given for download servlet.");
        }
        if (!HttpCheckLoginHelper.checkPermission((HttpLoginService)this.loginService, (HttpServletRequest)req, (HttpServletResponse)resp)) {
            return;
        }
        File download = this.uploadHandler.getDownload(relPath);
        try (FileInputStream fis = new FileInputStream(download);){
            int n;
            log.info("Delivering file [" + download + "] of length [" + download.length() + "] to client [" + req.getRemoteHost() + "]...");
            resp.setHeader("Conent-Length", String.valueOf(download.length()));
            resp.setContentType(DefaultHttpContext.getInstance().getMimeType(relPath));
            resp.setHeader("Content-Disposition", UrlHelper.getCompatibleContentDispositionAttachmentHeader((String)relPath));
            ResponseHelper.setNoCacheHeaders((HttpServletResponse)resp);
            byte[] buf = new byte[4096];
            ServletOutputStream os = resp.getOutputStream();
            while ((n = fis.read(buf)) > 0) {
                os.write(buf, 0, n);
            }
            log.info("Successfully delivered file [" + download + "] of length [" + download.length() + "] to client [" + req.getRemoteHost() + "].");
        }
    }

    public String getServletInfo() {
        return DownloadServlet.class.getSimpleName();
    }

    public void setLoginService(HttpLoginService loginService) {
        this.loginService = loginService;
    }

    public void setUploadHandler(UploadHandler uploadHandler) {
        this.uploadHandler = uploadHandler;
    }
}

