/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.upload.servlet;

import at.cdes.upload.handler.UploadHandler;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.clazzes.util.http.sec.HttpCheckLoginHelper;
import org.clazzes.util.http.sec.HttpLoginService;
import org.clazzes.util.http.sec.PageTokenService;

public class UploadServlet
extends HttpServlet {
    private static final long serialVersionUID = -5353827637891479564L;
    private HttpLoginService loginService;
    private PageTokenService pageTokenService;
    private long maxUploadSize;
    private UploadHandler uploadHandler;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!HttpCheckLoginHelper.checkPermission((HttpLoginService)this.loginService, (HttpServletRequest)req, (HttpServletResponse)resp)) {
            return;
        }
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            throw new ServletException("Request is not a posted multipart form.");
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(this.maxUploadSize);
        try {
            boolean tokenOK = false;
            List items = upload.parseRequest(req);
            for (FileItem item : items) {
                int bpos;
                if (item.isFormField()) {
                    if (!"pageToken".equals(item.getFieldName())) continue;
                    String pageToken = item.getString();
                    tokenOK = this.pageTokenService.checkPageToken(req, pageToken);
                    continue;
                }
                if (item.getSize() <= 0L) continue;
                if (!tokenOK) {
                    throw new SecurityException("Received files with invalid XSRF page token.");
                }
                String name = item.getName();
                int spos = name.lastIndexOf(47);
                int pos = spos > (bpos = name.lastIndexOf(92)) ? spos : bpos;
                String relPath = name.substring(pos + 1);
                this.uploadHandler.storeUpload(relPath, item);
            }
        }
        catch (FileUploadException e) {
            throw new ServletException("Error parsing multipart request", (Throwable)e);
        }
        resp.sendRedirect("index.vm");
    }

    public String getServletInfo() {
        return UploadServlet.class.getSimpleName();
    }

    public void setLoginService(HttpLoginService loginService) {
        this.loginService = loginService;
    }

    public void setPageTokenService(PageTokenService pageTokenService) {
        this.pageTokenService = pageTokenService;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public void setUploadHandler(UploadHandler uploadHandler) {
        this.uploadHandler = uploadHandler;
    }
}

