/***********************************************************
* $id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
        "cdes/certificate/CertificateHelper",
        "cdes/certificate/RenewCertificateDialog",
        "cdes/core/CdesVoc",
        "cdes/core/DataModel",
        "cdes/util/CodeHelper",
        "cdes/util/CommonEntityHelper",
        "cdes/util/NameHelper",
        "cdes/util/SearchPageHelper",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/dateTime/DateTimeSpinBox",
        "clazzes/dateTime/TimeSpinner",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/JoinHelper",
        "clazzes/util/StringHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/CheckBox",
        "dijit/form/ComboBox",
        "dijit/form/Select",
        "dijit/form/SimpleTextarea",
        "dijit/form/TextBox",
        "dijit/form/ValidationTextBox",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/string",
        "dojo/store/Memory",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
        "dojox/validate/web"
],
function(
         CertificateHelper,
         RenewCertificateDialog,
         CdesVoc,
         DataModel,
         CodeHelper,
         CommonEntityHelper,
         NameHelper,
         SearchPageHelper,
         TinyLog,
         DateHelper,
         DateTimeSpinBox,
         TimeSpinner,
         FancyButton,
         DOMHelper,
         ErrorHelper,
         JoinHelper,
         StringHelper,
         WidgetHelper,
         ContentWidget,
         CheckBox,
         ComboBox,
         Select,
         SimpleTextArea,
         TextBox,
         ValidationTextBox,
         declare,
         lang,
         domClass,
         domConstruct,
         on,
         string,
         Memory,
         i18n,
         validate
         ) {

    ////css-prefix = organisationPersonEdit
    ////i18n-prefix = organisationPersonEdit

    var className = "at.cdes.web.person.OrganisationPersonEditWidget";

    var log = new TinyLog(className);


    var OrganisationPersonEditWidget = declare(className, ContentWidget, {
        constructor : function(params) {
            lang.mixin(this,params);

            // Either injected from outside to share it between different widgets,
            // or constructed here.
            if (this.networkIdToOrganisations == null) {
                this.networkIdToOrganisations = new Object();
            }

            this.validRequestJoins = [];
            this.validExpiresSoonRequestJoins = [];
            this.expiredRequestJoins = [];
            this.invitationRequests = [];
            this.requestRequests = [];
            
            this.topDiv = this.constructTopDiv();
            
            this.allFieldsValid = true;

            this.populateCountrySelect();
        },
        
        getWidgetId : function() {
            return "OrganisationPersonEditWidget";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {

            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute organisationPersonEditTopDiv");

            // Organisation Label
            DOMHelper.createTextNode("div", i18n.organisationLabel, topDiv, "propertyLabel organisationPersonEditOrganisationLabel");

            // OrganisationSelect
            this.organisationMemory = new Memory({
                data : this.getOrganisationMemoryData()
            });
            
            this.organisationComboBox = new ComboBox({
                       label : i18n.organisationLabel,
                       title : i18n.organisationPersonEditOrganisationLabelToolTip,
                       store : this.organisationMemory,
				   queryExpr : "*${0}*", //any search string
				autoComplete : false                
            });
            domClass.add(this.organisationComboBox.domNode, "fixedDialogWidget organisationPersonEditOrganisationTextBox");
            domConstruct.place(this.organisationComboBox.domNode, topDiv);

            WidgetHelper.handleSelectEvents(this.organisationComboBox, lang.hitch(this, function() {
                this.updateDataFromWidgets();
                on.emit(this, "organisationChanged");
                this.updateWidgetState(false);
            }));

            // OrganisationTextBox
            this.organisationTextBox = new TextBox({
                   label : i18n.organisationLabel,
                   title : i18n.organisationLabel,
                disabled : true                
            });
            domClass.add(this.organisationTextBox.domNode, "fixedDialogWidget organisationPersonEditOrganisationTextBox");
            domConstruct.place(this.organisationTextBox.domNode, topDiv);

            // Use Address Button
            if (this.mode == ContentWidget.Mode.CREATE) {
                this.useAddressButton = new FancyButton({
                    label : i18n.organisationPersonEditUseAddressButtonLabel,
                    title : i18n.organisationPersonEditUseAddressButtonToolTip
                });
                domClass.add(this.useAddressButton.domNode, "fixedDialogWidget textButton organisationPersonEditUseAddressButton");
                domConstruct.place(this.useAddressButton.domNode, topDiv);

                on(this.useAddressButton, "click", lang.hitch(this, function() {
                    this.copyOrganisationAddressData();
                }));
            }

            // Certificate Div
            this.certificateDiv = domConstruct.create("div", null, null);
            if (this.mode == ContentWidget.Mode.CREATE) {
                domClass.add(this.certificateDiv, "fixedDialogWidget organisationPersonEditCertificateDivCreate");
            } else {
                domClass.add(this.certificateDiv, "fixedDialogWidget organisationPersonEditCertificateDivEdit");
            }
            domConstruct.place(this.certificateDiv, topDiv);

            var certificateLabelClass = (this.mode == ContentWidget.Mode.CREATE
                                         ? "organisationPersonEditCertificateLabelCreate"
                                         : "organisationPersonEditCertificateLabelEdit");
            this.certificateLabel = DOMHelper.createTextNode("span", i18n.organisationPersonEditCertificateNotPossibleLabel, this.certificateDiv, certificateLabelClass);

            // Certificate buttons; depending on certificate state some of
            // - Invite for certificate request
            // - Issue certificate based on existing request
            // - Renew Certificate
            this.inviteForCertificateButton = this.constructInviteForCertificateButton(this.certificateDiv);
            //this.newCertificateButton = this.constructNewCertificateButton(this.certificateDiv);
            this.renewCertificateButton = this.constructRenewCertificateButton(this.certificateDiv);

            // OrganisationalUnitTextBox
            DOMHelper.createTextNode("div", i18n.organisationPersonEditOrganisationalUnitLabel, topDiv, "propertyLabel organisationPersonEditOrganisationalUnitLabel");
            this.organisationalUnitTextBox = new TextBox({
                label : i18n.organisationPersonEditOrganisationalUnitLabel,
                title : i18n.organisationPersonEditOrganisationalUnitToolTip,
			maxLength : 80
            });
            domClass.add(this.organisationalUnitTextBox.domNode, "fixedDialogWidget organisationPersonEditOrganisationalUnitTextBox");
            domConstruct.place(this.organisationalUnitTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.organisationalUnitTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));

            // AddressTextBox
            DOMHelper.createTextNode("div", i18n.addressLabel, topDiv, "propertyLabel organisationPersonEditAddressLabel");
            this.addressTextBox = new SimpleTextArea({
                label : i18n.addressLabel,
                title : i18n.addressLabel,
    		maxLength : 255
            });
            domClass.add(this.addressTextBox.domNode, "fixedDialogWidget organisationPersonEditAddressTextBox");
            domConstruct.place(this.addressTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.addressTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.addressTextBox, true);

            // PostalCodeTextBox
            DOMHelper.createTextNode("div", i18n.postalCodeLabel, topDiv, "propertyLabel organisationPersonEditPostalCodeLabel");
            this.postalCodeTextBox = new TextBox({
                label : i18n.postalCodeLabel,
                title : i18n.postalCodeLabel,
    		maxLength : 10
            });
            domClass.add(this.postalCodeTextBox.domNode, "fixedDialogWidget organisationPersonEditPostalCodeTextBox");
            domConstruct.place(this.postalCodeTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.postalCodeTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.postalCodeTextBox, true);

            // LocalityNameTextBox
            DOMHelper.createTextNode("div", i18n.localityNameLabel, topDiv, "propertyLabel organisationPersonEditLocalityNameLabel");
            this.localityNameTextBox = new TextBox({
                label : i18n.localityNameLabel,
                title : i18n.localityNameLabel,
    		maxLength : 30
            });
            domClass.add(this.localityNameTextBox.domNode, "fixedDialogWidget organisationPersonEditLocalityNameTextBox");
            domConstruct.place(this.localityNameTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.localityNameTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.localityNameTextBox, true);

            // CountrySelect
            DOMHelper.createTextNode("div", i18n.countryLabel, topDiv, "propertyLabel organisationPersonEditCountryLabel");
            this.countrySelect = new Select({
                label : i18n.countryLabel,
                title : i18n.countryLabel
            });
            domClass.add(this.countrySelect.domNode, "fixedDialogWidget organisationPersonEditCountrySelect");
            domConstruct.place(this.countrySelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.countrySelect, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.countrySelect, true);

            // PhoneTextBox
            DOMHelper.createTextNode("div", i18n.phoneLabel, topDiv, "propertyLabel organisationPersonEditPhoneLabel");
            this.phoneTextBox = new TextBox({
                label : i18n.phoneLabel,
                title : i18n.phoneLabel,
    		maxLength : 40
            });
            domClass.add(this.phoneTextBox.domNode, "fixedDialogWidget organisationPersonEditPhoneTextBox");
            domConstruct.place(this.phoneTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.phoneTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.phoneTextBox, true);

            // MobileTextBox
            DOMHelper.createTextNode("div", i18n.mobileLabel, topDiv, "propertyLabel organisationPersonEditMobileLabel");
            this.mobileTextBox = new TextBox({
                label : i18n.mobileLabel,
                title : i18n.mobileLabel,
    		maxLength : 40
            });
            domClass.add(this.mobileTextBox.domNode, "fixedDialogWidget organisationPersonEditMobileTextBox");
            domConstruct.place(this.mobileTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.mobileTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));

            // FaxTextBox
            DOMHelper.createTextNode("div", i18n.faxLabel, topDiv, "propertyLabel organisationPersonEditFaxLabel");
            this.faxTextBox = new TextBox({
                label : i18n.faxLabel,
                title : i18n.faxLabel,
    		maxLength : 40
            });
            domClass.add(this.faxTextBox.domNode, "fixedDialogWidget organisationPersonEditFaxTextBox");
            domConstruct.place(this.faxTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.faxTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));

            // InactiveCheckBox
            this.inactiveCheckBox = new CheckBox({
                label : i18n.organisationPersonEditInactiveLabel,
                title : i18n.organisationPersonEditInactiveToolTip
            });
            domClass.add(this.inactiveCheckBox.domNode, "fixedDialogWidget organisationPersonEditInactiveCheckBox");
            domConstruct.place(this.inactiveCheckBox.domNode, topDiv);
            WidgetHelper.handleCheckBoxEvents(this.inactiveCheckBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            this.inactiveLabel = DOMHelper.createTextNode("div", i18n.organisationPersonEditInactiveLabel, topDiv, "fixedDialogWidget organisationPersonEditInactiveLabel");

            // MailTextBox
            DOMHelper.createTextNode("div", i18n.mailLabel, topDiv, "propertyLabel organisationPersonEditMailLabel");
            this.mailTextBox = new ValidationTextBox({
                label : i18n.mailLabel,
        		required: true,
        		validator: dojox.validate.isEmailAddress,
        		invalidMessage: i18n.noValidMailLabel,
    			maxLength : 80
            });
            domClass.add(this.mailTextBox.domNode, "fixedDialogWidget organisationPersonEditMailTextBox");
            domConstruct.place(this.mailTextBox.domNode, topDiv);
            this.handleMailTextBoxEvents(this.mailTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.mailTextBox, true);

            // RetiredCommentTextBox
            this.retiredCommentTextBox = new SimpleTextArea({
                label : i18n.organisationPersonEditRetiredCommentLabel,
                title : i18n.organisationPersonEditRetiredCommentLabel,
    		maxLength : 255
            });
            domClass.add(this.retiredCommentTextBox.domNode, "fixedDialogWidget organisationPersonEditRetiredCommentTextBox");
            domConstruct.place(this.retiredCommentTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.retiredCommentTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));

            // MailSendModeSelect
            DOMHelper.createTextNode("div", i18n.organisationPersonEditMailSendModeLabel, topDiv, "propertyLabel organisationPersonEditMailSendModeLabel");
            this.mailSendModeSelect = new Select({
                   label : i18n.organisationPersonEditMailSendModeLabel,
                   title : i18n.organisationPersonEditMailSendModeToolTip,
                 options : [ CdesVoc.MailSendMode.NEVER, CdesVoc.MailSendMode.BRIEF, CdesVoc.MailSendMode.ALWAYS ],
                disabled : !!this.mailSendModeDisabled
            });
            domClass.add(this.mailSendModeSelect.domNode, "fixedDialogWidget organisationPersonEditMailSendModeSelect");
            domConstruct.place(this.mailSendModeSelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.mailSendModeSelect, lang.hitch(this, this.callUpdateWidgetStateWithEvents));

            // MailSendTimeDateTimeSpinBox
            this.mailSendTimeLabel = DOMHelper.createTextNode("div", i18n.organisationPersonEditMailSendTimeLabel, topDiv,
                                                              "propertyLabel organisationPersonEditMailSendTimeLabel");
            this.mailSendTimeSpinner = new TimeSpinner({
                    label : i18n.organisationPersonEditMailSendTimeLabel,
                    title : i18n.organisationPersonEditMailSendTimeToolTip,
                precision : "m",
                      css : "fixedDialogWidget organisationPersonEditMailSendTimeSpinner",
                   parent : topDiv,
                 listener : lang.hitch(this, this.callUpdateWidgetStateWithEvents),
                 disabled : !!this.mailSendModeDisabled                
            });

            // Placed at the end, since handling the async call triggers updateWidgetState, which needs some of
            // the widgets constructed above.
            if (this.mode == ContentWidget.Mode.CREATE) {
                this.triggerPopulateOrganisationSelect(this.organisationIdsInUse);
                delete this.organisationIdsInUse;
            }

            return topDiv;
        },
		
		handleMailTextBoxEvents : function(textBox, fct) {
			on(textBox, "change", function() { if (!textBox.get("disabled")) { fct(); }});
			on(textBox, "keyUp", function() { if (!textBox.get("disabled")) { fct(); }});			
		},		
        
        getOrganisationMemoryData : function(organisationJoins, usedOrganisationIds) {
            this.nameToOrganisationId = new Object();

            var data = [];
            if (organisationJoins) {

                var currentlySelectedOrganisationId = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
                for (var n = 0; n < organisationJoins.length; n++) {
                    var organisationJoin = organisationJoins[n];
                    if (usedOrganisationIds != null && organisationJoin.organisationId in usedOrganisationIds
                        && organisationJoin.organisationId != currentlySelectedOrganisationId) {
                        // Do nothing, just ignore the Organisation as it is already in use elsewhere, and shouldn't be selectable here.
                    } else {
                        this.idToOrganisationJoin[organisationJoin.organisationId] = organisationJoin;
                        data.push({ name : organisationJoin.organisationName, id : organisationJoin.organisationId });
                        this.nameToOrganisationId[organisationJoin.organisationName] = organisationJoin.organisationId;
                    }
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name : i18n.pleaseChoose, id : CdesVoc.PLEASE_CHOOSE });
            return data;
        },        

        copyOrganisationAddressData : function() {
            var organisationId = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
            if (organisationId == null) {
                var organisationLabel = this.organisationComboBox.get("value");
                if (organisationLabel != null) {
                    organisationId = this.nameToOrganisationId[organisationLabel.trim()];
                }
            }
            
            var organisationJoin = this.idToOrganisationJoin[organisationId];

            this.organisationPersonJoin.organisationPersonCountryId = organisationJoin.organisationCountryId;
            this.organisationPersonJoin.organisationPersonFacsimileNumber = organisationJoin.organisationFacsimileNumber;
            this.organisationPersonJoin.organisationPersonEmailAddress = organisationJoin.organisationEmailAddress;
            this.organisationPersonJoin.organisationPersonPostalAddress = organisationJoin.organisationPostalAddress;
            this.organisationPersonJoin.organisationPersonPostalCode = organisationJoin.organisationPostalCode;
            this.organisationPersonJoin.organisationPersonLocalityName = organisationJoin.organisationLocalityName;
            this.organisationPersonJoin.organisationPersonStateOrProvinceName = organisationJoin.organisationStateOrProvinceName;
            this.organisationPersonJoin.organisationPersonMobileTelephoneNumber = organisationJoin.organisationMobileTelephoneNumber;
            this.organisationPersonJoin.organisationPersonTelephoneNumber = organisationJoin.organisationTelephoneNumber;

            this.updateWidgetsFromData();
            this.callUpdateWidgetStateWithEvents();
        },

        constructInviteForCertificateButton : function(parentDiv) {
            var button = new FancyButton({
                    title : i18n.certificateListInviteForCertificateButtonCaption,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 inviteCertificateButton"
            });

            domClass.add(button.domNode, "organisationPersonEditCertificateButton");
            domConstruct.place(button.domNode, parentDiv);

            on(button, "click", lang.hitch(this, function() {
                if (this.parentWidget != null && this.parentWidget.getMode() == ContentWidget.Mode.CREATE) {
                    this.parentWidget.prepareSave(true, lang.hitch(this, function() {
                        this.updateOrganisationPersonJoinFromPerson();
                        CertificateHelper.askInviteForCertificate({
                               certificateJoin : this.organisationPersonJoin,
                            applicationContext : this.applicationContext,
                                    baseWidget : this,
                               successCallback : lang.hitch(this, this.reloadCallback)
                        });
                    }));
                } else if (this.organisationPersonJoin.organisationPersonId < 0) {
                    this.saveNewOrganisationPersonAndAskInviteForCertificate();
                } else {
                    this.updateOrganisationPersonJoinFromPerson();
                    CertificateHelper.askInviteForCertificate({
                           certificateJoin : this.organisationPersonJoin,
                        applicationContext : this.applicationContext,
                                baseWidget : this,
                           successCallback : lang.hitch(this, this.reloadCallback)
                    });
                }
            }));
            return button;
        },
/*
        constructNewCertificateButton : function(parentDiv) {
            var button = new FancyButton({
                    title : i18n.certificateListNewCertificateButtonCaption,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 newCertificateButton"
            });

            domClass.add(button.domNode, "organisationPersonEditCertificateButton");
            domConstruct.place(button.domNode, parentDiv);

            on(button, "click", lang.hitch(this, function() {
                var maxExpiresSoonJoin = this.getCertificateRequestJoinWithMaxValidTo(this.newBasedOnExistingCandidates);

                if (maxExpiresSoonJoin != null) {
                    CertificateHelper.doIssueCertificate({
                        applicationContext : this.applicationContext,
                                   joinDto : maxExpiresSoonJoin,
                                personJoin : this.organisationPersonJoin,
                                baseWidget : this,
                           successCallback : lang.hitch(this, this.reloadCallback)                    
                    });
                }
            }));
            return button;
        },      
*/
        constructRenewCertificateButton : function(parentDiv) {
            var button = new FancyButton({
                    title : i18n.certificateListRenewButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 renewCertificateButton"
            });

            domClass.add(button.domNode, "organisationPersonEditCertificateButton");
            domConstruct.place(button.domNode, parentDiv);

            on(button, "click", lang.hitch(this, function() {
                var maxJoin = this.getCertificateRequestJoinWithMaxValidTo(this.renewableCertificateRequestJoins);

                if (maxJoin) {
                    var dialog = new RenewCertificateDialog({
                        applicationContext : this.applicationContext,
                                     title : i18n.renewCertificateDialogCaption,
                              defaultWidth : 700,
                             defaultHeight : 220,
                                   joinDto : maxJoin,
                                personJoin : this.organisationPersonJoin,
                           successCallback : lang.hitch(this, this.reloadCallback)                    
                    });
                    dialog.show();                  
                }
            }));
            return button;
        },

        saveNewOrganisationPersonAndAskInviteForCertificate : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldOrganisationPersonId = this.organisationPersonJoin.organisationPersonId;

            var organisationPerson = { id : null };
            // Don't copy the negative id, the server needs to see a null id for new OrganisationPersons
            JoinHelper.copyJoinAttributes(this.organisationPersonJoin, "organisationPerson", organisationPerson, null,
                                          ["organisationalUnitName", "personId", "organisationId",
                                           "postalAddress", "postalCode", "localityName", "stateOrProvinceName",
                                           "telephoneNumber", "mobileTelephoneNumber", "facsimileTelephoneNumber",
                                           "emailAddress", "retiredFlag", "retiredComment",
                                           "emailSendTime", "emailSendMode",
                                           "countryId"]);

            this.oldOrganisationPersonJoin = JoinHelper.clone(this.organisationPersonJoin, DataModel.OPJOIN_ORGANISATION_PERSON_ATTRIBUTES);

            this.registerAsyncOperationStarted(OrganisationPersonEditWidget.AsyncOperation.SAVE_AND_INVITE);

            var personService = this.applicationContext.getService("personService");
            personService.saveOrganisationPerson(organisationPersonId, organisationPerson).then(
                lang.hitch(this, function(organisationPerson) {
                    this.registerAsyncOperationFinished(OrganisationPersonEditWidget.AsyncOperation.SAVE_AND_INVITE);

                    this.parentWidget.moveOrganisationPersonOPInfo(oldOrganisationPersonId, organisationPerson.id);

                    JoinHelper.copyJoinAttributes(organisationPerson, null, this.organisationPersonJoin, "organisationPerson",
                                                  ["id", "organisationalUnitName", "personId", "organisationId",
                                                   "postalAddress", "postalCode", "localityName", "stateOrProvinceName",
                                                   "telephoneNumber", "mobileTelephoneNumber", "facsimileTelephoneNumber",
                                                   "emailAddress", "retiredFlag", "retiredComment",
                                                   "emailSendTime", "emailSendMode",
                                                   "countryId"]);

                    this.updateOrganisationPersonJoinFromPerson();

                    this.mode = ContentWidget.Mode.EDIT;
                    
                    CertificateHelper.askInviteForCertificate({
                           certificateJoin : this.organisationPersonJoin,
                        applicationContext : this.applicationContext,
                                baseWidget : this,
                           successCallback : lang.hitch(this, this.reloadCallback)
                    });                    
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : OrganisationPersonEditWidget.AsyncOperation.SAVE_AND_INVITE,
                                opName : "saveOrganisationPerson",
                               message : i18n.organisationPersonEditSaveAndInviteFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [saveOrganisationPerson]", err);
                    }));
        },

        resetOldOrganisationPersonJoin : function() {
            this.oldOrganisationPersonJoin = JoinHelper.clone(this.organisationPersonJoin, DataModel.OPJOIN_ORGANISATION_PERSON_ATTRIBUTES);            
        },

        getCertificateRequestJoinWithMaxValidTo : function(joins) {
            var maxValidTo = null;
            var maxJoin = null;
            for (var n = 0; n < joins.length; n++) {
                var join = joins[n];
                if (join.certificateCertValidTo != null) {
                    if (maxValidTo == null || maxValidTo < join.certificateCertValidTo) {
                        maxJoin = join;
                    }
                }
            }
            // Only joins without certValidTo
            if (maxJoin == null && joins.length > 0) {
                maxJoin = joins[0];
            }
            return maxJoin;                
        },        

        callUpdateWidgetStateWithEvents : function() {
            this.updateWidgetState(false);
        },

        updateWidgetState : function(omitEvents) {


            if (this.mode == ContentWidget.Mode.CREATE) {
                domClass.remove(this.organisationComboBox.domNode, "hidden");
                domClass.add(this.organisationTextBox.domNode, "hidden");

                domClass.add(this.certificateDiv, "hidden");
                domClass.add(this.inactiveCheckBox.domNode, "hidden");
                domClass.add(this.retiredCommentTextBox.domNode, "hidden");
                domClass.add(this.inactiveLabel, "hidden");

                var organisationId = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
                var organisationLabel = this.organisationComboBox.get("value");
                if (organisationId == null && organisationLabel != null && organisationLabel.trim().length > 0
                    && !(organisationLabel.trim() in this.nameToOrganisationId)) {
                    domClass.add(this.organisationComboBox.domNode, "errorField");
                    WidgetHelper.setMustField(this.organisationComboBox, false);
                } else {
                    domClass.remove(this.organisationComboBox.domNode, "errorField");
                    WidgetHelper.setMustField(this.organisationComboBox, true);
                }
            } else {
                domClass.remove(this.organisationTextBox.domNode, "hidden");
                domClass.add(this.organisationComboBox.domNode, "hidden");

                domClass.remove(this.certificateDiv, "hidden");
                domClass.remove(this.inactiveCheckBox.domNode, "hidden");
                domClass.remove(this.retiredCommentTextBox.domNode, "hidden");
                domClass.remove(this.inactiveLabel, "hidden");

                if (this.useAddressButton != null) {
                    domClass.add(this.useAddressButton.domNode, "hidden");
                }
            }

            this.updateDataFromWidgets();

            /* MailSendMode */
            var mailSendMode = WidgetHelper.getSelectValue(this.mailSendModeSelect);
            var showMailSendTime = (mailSendMode == CdesVoc.MailSendMode.BRIEF.value);
            if (showMailSendTime) {
                domClass.remove(this.mailSendTimeLabel, "hidden");
                domClass.remove(this.mailSendTimeSpinner.getContainer(), "hidden");
            } else {
                domClass.add(this.mailSendTimeLabel, "hidden");
                domClass.add(this.mailSendTimeSpinner.getContainer(), "hidden");
            }

            /* Empty must field states */
            var organisationSelectValue = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
            if (organisationSelectValue == null) {
                var label = this.organisationComboBox.get("value");
                if (label != null) {
                    organisationSelectValue = this.nameToOrganisationId[label.trim()];
                }
            }
            if (organisationSelectValue == null || organisationSelectValue == CdesVoc.PLEASE_CHOOSE) {
				domClass.add(this.organisationComboBox.domNode, "emptyField");
		    } else {
				domClass.remove(this.organisationComboBox.domNode, "emptyField");
		    }
            WidgetHelper.updateEmptyTextBoxState(this.addressTextBox);
            WidgetHelper.updateEmptyTextBoxState(this.postalCodeTextBox);
            WidgetHelper.updateEmptyTextBoxState(this.localityNameTextBox);
            WidgetHelper.updateEmptyTextBoxState(this.phoneTextBox);
            this.updateEmptyEmailTextBoxState(this.mailTextBox);
            WidgetHelper.updateEmptySelectState(this.countrySelect);

            /* Field disabled state */
            var disabled = this.isAsyncOperationRunning() || this.mode == ContentWidget.Mode.SHOW;
            this.addressTextBox.set("disabled", disabled);
            this.postalCodeTextBox.set("disabled", disabled);
            this.localityNameTextBox.set("disabled", disabled);
            this.countrySelect.set("disabled", disabled);
            this.inactiveCheckBox.set("disabled", disabled);
            this.retiredCommentTextBox.set("disabled", disabled);
            this.organisationalUnitTextBox.set("disabled", disabled);
            this.phoneTextBox.set("disabled", disabled);
            this.mobileTextBox.set("disabled", disabled);
            this.faxTextBox.set("disabled", disabled);
            this.mailTextBox.set("disabled", disabled);
            this.mailSendModeSelect.set("disabled", disabled || this.mailSendModeDisabled);
            this.mailSendTimeSpinner.setDisabled(disabled || this.mailSendModeDisabled);

            if (this.mode == ContentWidget.Mode.CREATE) {
                var organisationId = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
                if (organisationId == null) {
                    var organisationLabel = this.organisationComboBox.get("value");
                    if (organisationLabel != null) {
                        organisationId = this.nameToOrganisationId[organisationLabel.trim()];
                    }
                }
                var useAddressButtonDisabled = (organisationId == null || organisationId == CdesVoc.PLEASE_CHOOSE);
                this.useAddressButton.set("disabled", useAddressButtonDisabled);
            }

            /* AllFieldsValid */
            var organisationId = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
            if (organisationId == null) {
                var organisationLabel = this.organisationComboBox.get("value");
                if (organisationLabel != null) {
                    organisationId = this.nameToOrganisationId[organisationLabel.trim()];
                }
            }
            var organisationValid = this.mode != ContentWidget.Mode.CREATE
            || (organisationId != null && organisationId != CdesVoc.PLEASE_CHOOSE);
            var countryId = WidgetHelper.getSelectValue(this.countrySelect);
            var allFieldsValid = organisationValid
					            && WidgetHelper.isTextBoxValid(this.addressTextBox)
							    && WidgetHelper.isTextBoxValid(this.postalCodeTextBox)
							    && WidgetHelper.isTextBoxValid(this.localityNameTextBox)
							    && WidgetHelper.isTextBoxValid(this.phoneTextBox)
							    && WidgetHelper.isTextBoxValid(this.mailTextBox) && this.isEmailTextBoxValid(this.mailTextBox)
							    && countryId != null;
            
            /* Certificates */
            var validCount = this.validRequestJoins.length;
            var validExpiresSoonCount = this.validExpiresSoonRequestJoins.length;
            var expiredCount = this.expiredRequestJoins.length;
            var invitationCount = this.invitationRequests.length;
            var requestCount = this.requestRequests.length;
            var disableCertificateButtons = false;

            if (this.mode == ContentWidget.Mode.CREATE) {
                if (allFieldsValid && (this.parentWidget == null || this.parentWidget.getMode() != ContentWidget.Mode.CREATE || this.parentWidget.isValid())) {
                    DOMHelper.setInnerText(this.certificateLabel, i18n.organisationPersonEditSaveAndCertifyLabel);
                } else {
                    DOMHelper.setInnerText(this.certificateLabel, i18n.organisationPersonEditCertificatePleaseCorrectFields);
                    disableCertificateButtons = true;
                }
            } else if (this.mode == ContentWidget.Mode.EDIT) {
                if (validCount == 0 && validExpiresSoonCount == 0 && expiredCount == 0 && invitationCount == 0 && requestCount == 0) {
                    DOMHelper.setInnerText(this.certificateLabel, i18n.organisationPersonEditCertificateNoneLabel);
                } else {
                    var validLabel = validCount > 0 ? string.substitute(i18n.organisationPersonEditValidCertificates, { count : validCount }) : null;
                    var validExpiresSoonLabel = validExpiresSoonCount > 0 ? string.substitute(i18n.organisationPersonEditValidExpiresSoonCertificates,
                                                                                              { count : validExpiresSoonCount }) : null;
                    var expiredLabel = expiredCount > 0 ? string.substitute(i18n.organisationPersonEditExpiredCertificates, { count : expiredCount }) : null;
                    var invitationLabel = invitationCount > 0 ? string.substitute(i18n.organisationPersonEditInvitations, { count : invitationCount }) : null;
                    var requestLabel = requestCount > 0 ? string.substitute(i18n.organisationPersonEditRequests, { count : requestCount }) : null;

                    var label = i18n.organisationPersonEditCertificateLabel;
                    var first = true;
                    if (validLabel != null) {
                        label += validLabel;
                        first = false;
                    }
                    if (validExpiresSoonLabel != null) {
                        label += (first ? "" : ", ") + validExpiresSoonLabel;
                        first = false;
                    }

                    if (validLabel == null && validExpiresSoonLabel == null) {
                        if (expiredLabel != null) {
                            label += (first ? "" : ", ") + expiredLabel;
                            first = false;
                        }
                        if (invitationLabel != null) {
                            label += (first ? "" : ", ") + invitationLabel;
                            first = false;
                        }
                        if (requestLabel != null) {
                            label += (first ? "" : ", ") + requestLabel;
                            first = false;
                        }
                    }

                    DOMHelper.setInnerText(this.certificateLabel, label);
                }
            } else if (this.mode == ContentWidget.Mode.SHOW){
                    DOMHelper.setInnerText(this.certificateLabel, "");
                    disableCertificateButtons = true;
            } else {
                throw new Error("Illegal mode [" + this.mode + "] found in OrganisationPersonEditWidget.");
            }

            var invitePossible;
            var renewPossible;
            var newPossible;
            if (this.organisationPersonJoin != null) {
                var createPleaseCorrect = (this.mode == ContentWidget.Mode.CREATE && !allFieldsValid);
                var noPersonLogin = StringHelper.isEmpty(this.organisationPersonJoin.personLogin) || StringHelper.isEmpty(this.organisationPersonJoin.personPassword);
                var anyValid = validCount > 0 || validExpiresSoonCount > 0;
                var validButOnlyExpiresSoon = anyValid && !this.validFound;
                
                invitePossible = !disableCertificateButtons && (noPersonLogin || !anyValid) && invitationCount == 0 && requestCount == 0 && !createPleaseCorrect;
                renewPossible = !disableCertificateButtons && validCount == 0 && this.renewableCertificateRequestJoins.length > 0 && !noPersonLogin;
                newPossible = !disableCertificateButtons && !anyValid && this.newBasedOnExistingCandidates.length > 0; // || noCertificate || noCertificateOldRequest);
            } else {
                invitePossible = false;
                renewPossible = false;
                newPossible = false;
            }

            if (invitePossible && this.hasCertificateAdministration) {
                domClass.remove(this.inviteForCertificateButton.domNode, "hidden");
            } else {
                domClass.add(this.inviteForCertificateButton.domNode, "hidden");
            }
            if (renewPossible && this.hasCertificateAdministration) {
                domClass.remove(this.renewCertificateButton.domNode, "hidden");
            } else {
                domClass.add(this.renewCertificateButton.domNode, "hidden");
            }
/*            if (newPossible && this.hasCertificateAdministration) {
                domClass.remove(this.newCertificateButton.domNode, "hidden");
            } else {
                domClass.add(this.newCertificateButton.domNode, "hidden");
            }
*/
            /* ValidStateChange event */
            if (allFieldsValid != this.allFieldsValid) {
                this.allFieldsValid = allFieldsValid;
                if (!omitEvents) {
                    on.emit(this, "validStateChange");
                }                
            }

            var changed = JoinHelper.isChanged(this.oldOrganisationPersonJoin, this.organisationPersonJoin, DataModel.OPJOIN_ORGANISATION_PERSON_ATTRIBUTES);
            if (changed != this.changed) {
                this.changed = changed;
                if (!omitEvents) {
                    on.emit(this, "changedStateChange");
                }
            }
        },

        reloadCallback : function() {
            on.emit(this, "doReload");
        },
        
		isEmailTextBoxValid : function(textBox) {
			return validate.isEmailAddress(textBox.get("value"))
		},
		
		updateEmptyEmailTextBoxState : function(textbox) {
			if (WidgetHelper.isTextBoxEmpty(textbox) || !this.isEmailTextBoxValid(this.mailTextBox)) {
				domClass.add(textbox.domNode, "emptyField");
			} else {
				domClass.remove(textbox.domNode, "emptyField");
			}
		},

        setData : function(params) {
            this.person = params.person;
            this.organisationPersonJoin = params.organisationPersonJoin;
            this.oldOrganisationPersonJoin = JoinHelper.clone(this.organisationPersonJoin, DataModel.OPJOIN_ORGANISATION_PERSON_ATTRIBUTES);
            this.certificateRequestJoins = params.certificateRequestJoins;
            //this.administratedNetworks = params.administratedNetworks;

            this.validRequestJoins = [];
            this.validExpiresSoonRequestJoins = [];
            this.expiredRequestJoins = [];
            this.invitationRequests = [];
            this.requestRequests = [];

            this.renewableCertificateRequestJoins = [];
            this.newBasedOnExistingCandidates = [];
            for (var n = 0; n < this.certificateRequestJoins.length; n++) {
                var certificateRequestJoin = this.certificateRequestJoins[n];
                var requestType = certificateRequestJoin.certificateRequestRequestType;

                // Compare UNION ALL in CertificateDAO.getCertificateRequestJoinsWithRequestsByPerson
                if (certificateRequestJoin.certificateId != null && requestType != "Invitation" && requestType != "Request") {
                    CertificateHelper.updateCertificateStatus(certificateRequestJoin);

                    var validExpiresSoon = certificateRequestJoin.status == CdesVoc.CertificateStatus.VALID_EXPIRES_SOON;
                    var valid = certificateRequestJoin.status == CdesVoc.CertificateStatus.VALID;
                    var expired = certificateRequestJoin.status == CdesVoc.CertificateStatus.EXPIRED;
                    var maySign = certificateRequestJoin.certificateMaySign;
                    var requestId = certificateRequestJoin.certificateRequestId;
                    var requestType = certificateRequestJoin.certificateRequestRequestType;
                    var supportedRequestType = (requestType == "Accepted" || requestType == "pkcs10" || requestType == "spkac");
                    
                    if (valid) {
                        this.validRequestJoins.push(certificateRequestJoin);
                    }
                    if (validExpiresSoon) {
                        this.validExpiresSoonRequestJoins.push(certificateRequestJoin);
                    }
                    if (expired) {
                        this.expiredRequestJoins.push(certificateRequestJoin);
                    }
                    if ((validExpiresSoon || expired) && maySign) {
                        this.renewableCertificateRequestJoins.push(certificateRequestJoin);
                    }
                    if (!valid && !validExpiresSoon && requestId != null && supportedRequestType) {
                        this.newBasedOnExistingCandidates.push(certificateRequestJoin);
                    }
                } else if (certificateRequestJoin.certificateRequestId != null) {
                    if (requestType == "Invitation") {
                        this.invitationRequests.push(certificateRequestJoin);
                    } else if (requestType == "Request") {
                        this.requestRequests.push(certificateRequestJoin);
                    }
                }
            }
            
            this.reload();
        },
        
        reload : function() {
            this.updateWidgetsFromData();
        },

        updateWidgetsFromData : function() {
            if (this.mode == ContentWidget.Mode.CREATE) {
                var oldOrganisation = this.organisationComboBox.get("value");
                if (oldOrganisation == null || oldOrganisation.length == 0) {
                    SearchPageHelper.setComboBoxValue(this.organisationComboBox, CdesVoc.PLEASE_CHOOSE);
                }
            } else if (this.mode == ContentWidget.Mode.EDIT || this.mode == ContentWidget.Mode.SHOW) {
                var organisationName = this.organisationPersonJoin.organisationName;
                this.organisationTextBox.set("value", organisationName);                
            } else {
                throw new Error("Illegal mode [" + this.mode + "] found in OrganisationPersonEditWidget.");
            }

            var organisationalUnit = this.organisationPersonJoin.organisationPersonOrganisationalUnitName;
            this.organisationalUnitTextBox.set("value", organisationalUnit);

            var address = this.organisationPersonJoin.organisationPersonPostalAddress;
            this.addressTextBox.set("value", address);

            var postalCode = this.organisationPersonJoin.organisationPersonPostalCode;
            this.postalCodeTextBox.set("value", postalCode);

            var localityName = this.organisationPersonJoin.organisationPersonLocalityName;
            this.localityNameTextBox.set("value", localityName);

            if (this.countriesInitialized) {
                var countryId = this.organisationPersonJoin.organisationPersonCountryId;
                WidgetHelper.setSelectValue(this.countrySelect, countryId);
            }

            var phone = this.organisationPersonJoin.organisationPersonTelephoneNumber;
            this.phoneTextBox.set("value", phone);

            var mobile = this.organisationPersonJoin.organisationPersonMobileTelephoneNumber;
            this.mobileTextBox.set("value", mobile);

            var fax = this.organisationPersonJoin.organisationPersonFacsimileTelephoneNumber;
            this.faxTextBox.set("value", fax);

            var email = this.organisationPersonJoin.organisationPersonEmailAddress;
            this.mailTextBox.set("value", email);

            var retiredFlag = this.organisationPersonJoin.organisationPersonRetiredFlag;
            this.inactiveCheckBox.set("checked", retiredFlag);

            var retiredComment = this.organisationPersonJoin.organisationPersonRetiredComment;
            this.retiredCommentTextBox.set("value", retiredComment);

            var emailSendModeCode = this.organisationPersonJoin.organisationPersonEmailSendMode;
            var emailSendMode = CodeHelper.getMailSendModeByCode(emailSendModeCode);
            WidgetHelper.setSelectValue(this.mailSendModeSelect, emailSendMode);

            if (emailSendMode == CdesVoc.MailSendMode.BRIEF.value) {
                var minutesSinceMidnight = this.organisationPersonJoin.organisationPersonEmailSendTime;
                var secondsSinceMidnight = minutesSinceMidnight * 60;
                this.mailSendTimeSpinner.setData(secondsSinceMidnight);
            }
        },

        updateOrganisationPersonJoinFromPerson : function() {
            JoinHelper.copyJoinAttributes(this.person, null, this.organisationPersonJoin, "person", DataModel.PERSON_ATTRIBUTES);
        },

        updateDataFromWidgets : function() {
            if (this.organisationPersonJoin == null) {
                return;
            }
            
            if (this.mode == ContentWidget.Mode.CREATE) {
                var organisationId = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
                if (organisationId == null) {
                    var organisationLabel = this.organisationComboBox.get("value");
                    if (organisationLabel != null) {
                        organisationId = this.nameToOrganisationId[organisationLabel.trim()];
                    }
                }
                
                if (organisationId != null && organisationId != CdesVoc.PLEASE_CHOOSE) {
                    var organisationName = this.idToOrganisationJoin[organisationId].organisationName;

                    this.organisationPersonJoin.organisationPersonOrganisationId = organisationId;
                    this.organisationPersonJoin.organiationId = organisationId;
                    this.organisationPersonJoin.organisationName = organisationName;
                } else {
                    this.organisationPersonJoin.organisationPersonOrganisationId = null;
                    this.organisationPersonJoin.organiationId = null;
                    this.organisationPersonJoin.organisationName = null;
                }
            }

            this.organisationPersonJoin.organisationPersonOrganisationalUnitName = this.organisationalUnitTextBox.get("value");
            this.organisationPersonJoin.organisationPersonPostalAddress = this.addressTextBox.get("value");
            this.organisationPersonJoin.organisationPersonPostalCode = this.postalCodeTextBox.get("value");
            this.organisationPersonJoin.organisationPersonLocalityName = this.localityNameTextBox.get("value");
            this.organisationPersonJoin.organisationPersonCountryId = WidgetHelper.getSelectValue(this.countrySelect);
            this.organisationPersonJoin.organisationPersonTelephoneNumber = this.phoneTextBox.get("value");
            this.organisationPersonJoin.organisationPersonMobileTelephoneNumber = this.mobileTextBox.get("value");
            this.organisationPersonJoin.organisationPersonFacsimileTelephoneNumber = this.faxTextBox.get("value");
            this.organisationPersonJoin.organisationPersonEmailAddress = this.mailTextBox.get("value");
            this.organisationPersonJoin.organisationPersonRetiredFlag = !!this.inactiveCheckBox.get("checked");
            this.organisationPersonJoin.organisationPersonRetiredComment = this.retiredCommentTextBox.get("value");
        },

        populateCountrySelect : function() {
            this.registerAsyncOperationStarted(OrganisationPersonEditWidget.AsyncOperation.FETCH_COUNTRIES);

            var deferred = CommonEntityHelper.getOrLoadCountries(this.applicationContext);
            deferred.then(
                lang.hitch(this, function(countries) {
                    this.registerAsyncOperationFinished(OrganisationPersonEditWidget.AsyncOperation.FETCH_COUNTRIES);

                    var countrySelectOptions = CommonEntityHelper.getDefaultCountrySelectOptions(countries);
                    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.countrySelect, countrySelectOptions);

                    if (this.organisationPersonJoin != null) {
                        var countryId = this.organisationPersonJoin.opCountryId;
                        WidgetHelper.setSelectValue(this.countrySelect, countryId);
                    }

                    this.countriesInitialized = true;
                }),
                lang.hitch(this, function(err) {
                    log.error("Error while fetching countries, details should be recorded by handler inside CommonEntityHelper.", err);
                    this.registerAsyncOperationFinished(OrganisationPersonEditWidget.AsyncOperation.FETCH_COUNTRIES);
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getOrLoadCountries]", err);
                    }));            
        },

        triggerPopulateOrganisationSelect : function(usedOrganisationIds) {
            var networkId = this.applicationContext.getPageContextNetworkId();
            if (networkId in this.networkIdToOrganisations) {
                var organisations = this.networkIdToOrganisations[networkId] != null ? this.networkIdToOrganisations[networkId] : [];
                this.populateOrganisationPersonSelect(organisations, usedOrganisationIds);
            } else {
                this.registerAsyncOperationStarted(OrganisationPersonEditWidget.AsyncOperation.GET_ORGANISATIONS);

                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var organisationService = this.applicationContext.getService("organisationService");
                organisationService.getNetworkOrganisationJoins(organisationPersonId, this.administratedNetworks).then(
                    lang.hitch(this, function(organisationJoins) {
                        this.populateOrganisationPersonSelect(organisationJoins, usedOrganisationIds);
                        this.registerAsyncOperationFinished(OrganisationPersonEditWidget.AsyncOperation.GET_ORGANISATIONS);
                    }), lang.hitch(this, function(err) {
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : OrganisationPersonEditWidget.AsyncOperation.GET_ORGANISATIONS,
                                    opName : "getNetworkOrganisationJoins",
                                   message : i18n.organisationPersonEditWidgetGetNetworkOrganisationNamesFailed
                        });
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [getNetworkOrganisationNames]", err);
                        }));
            }
        },

        populateOrganisationPersonSelect : function(organisationJoins, usedOrganisationIds) {
            this.idToOrganisationJoin = new Object();

            var name = this.organisationComboBox.get("value");
            var id = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;

            var organisationMemoryData = this.getOrganisationMemoryData(organisationJoins, usedOrganisationIds);
            this.organisationMemory.setData(organisationMemoryData);

            if (id == null && name == null) {
                id = CdesVoc.PLEASE_CHOOSE;
            }

            if (id != null && this.organisationComboBox.store != null) {
                var item = this.organisationComboBox.store.get(id);
                if (item != null) {
                    this.organisationComboBox.set("value", item.name);
                }
                this.organisationComboBox.item = item;
            } else {
                this.organisationComboBox.set("value", name);                
            }

/*            var currValue = WidgetHelper.getSelectValue(this.organisationSelect);
            if (currValue == null && options.length > 0) {
                WidgetHelper.setSelectValue(this.organisationSelect, CdesVoc.PLEASE_CHOOSE);
            }*/
        },

        getSelectedOrganisationId : function() {
            if (this.mode == ContentWidget.Mode.CREATE) {
                var organisationId = this.organisationComboBox.item != null ? this.organisationComboBox.item.id : null;
                if (organisationId == null) {
                    var organisationLabel = this.organisationComboBox.get("value");
                    if (organisationLabel != null) {
                        organisationId = this.nameToOrganisationId[organisationLabel.trim()];
                    }                    
                }
                if (organisationId == CdesVoc.PLEASE_CHOOSE) {
                    return null;
                } else {
                    return organisationId;
                }
            } else if (this.mode == ContentWidget.Mode.EDIT || this.mode == ContentWidget.Mode.SHOW) {
                return this.organisationPersonJoin.organisationId;
            } else {
                throw new Error("Illegal mode [" + this.mode + "] found in OrganisationPersonEditWidget.");
            }
        },

        updateOrganisationSelect : function(organisationIds) {
            if (this.mode == ContentWidget.Mode.CREATE) {
                this.triggerPopulateOrganisationSelect(organisationIds);
            }
        }
    });

    OrganisationPersonEditWidget.AsyncOperation = {
        SAVE_AND_INVITE : "SaveAndInvite",
        GET_ORGANISATIONS : "GetOrganisations",
        FETCH_COUNTRIES : "FetchCountries"
    };

    return OrganisationPersonEditWidget;
});
