/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationEdit
////i18n-prefix = planningNotificationEdit


define([ "cdes/core/CdesVoc",
    "cdes/widget/CalendarSpinner",
    "cdes/widget/ContextBar",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateTimeSpinBox",
    "clazzes/form/FancyButton",
    "clazzes/form/MultiWidget",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dijit/form/Form",
    "dijit/form/Select",
    "dijit/form/TextBox",
    "dijit/form/Textarea",
    "dijit/form/ValidationTextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/string",
    "dojox/form/Uploader",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
    CalendarSpinner,
    ContextBar,         
    TinyLog,
    DateTimeSpinBox,
    FancyButton,
    MultiWidget,
    topic,
    DOMHelper,                
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    Button,
    Form,
    Select,
    TextBox,
    Textarea,                
    ValidationTextBox,
    domClass,
    domConstruct,
    domStyle,
    on,
    declare,
    lang,
    string,
    Uploader,
    i18n) {

    var className = "at.cdes.web.planning.notification.PlanningNotificationEditPage";

    var log = new TinyLog(className);

    var PlanningNotificationEditPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.updateWidgetState();

            this.loadEditInfo();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationEditPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationEditCreateCaption, captionBarDiv, "cdesGeneralPageCaption");

            if (this.sharepoint) {
                // Save button
                this.saveButton = new Button({
                    label : i18n.saveButtonCaption,
                    title : i18n.planningNotificationEditSaveSharepointToolTip
                });
                domClass.add(this.saveButton.domNode, "planningNotificationEditSaveButton");
                domConstruct.place(this.saveButton.domNode, captionBarDiv);

                on(this.saveButton, "click", lang.hitch(this, this.save));
            }

            // Save and exit button
            this.saveAndExitButton = new Button({
                label : i18n.saveAndExitButtonCaption,
                title : i18n.planningNotificationEditSaveToolTip
            });
            domClass.add(this.saveAndExitButton.domNode, "planningNotificationEditSaveAndExitButton");
            domConstruct.place(this.saveAndExitButton.domNode, captionBarDiv);

            on(this.saveAndExitButton, "click", lang.hitch(this, this.saveAndExit));

            // Abort button
            this.abortButton = new Button({
                label : i18n.abortButtonCaption,
                title : this.sharepoint ? i18n.planningNotificationEditAbortSharepointToolTip : i18n.abortToolTip
            });
            domClass.add(this.abortButton.domNode, "planningNotificationEditAbortButton");
            domConstruct.place(this.abortButton.domNode, captionBarDiv);
            on(this.abortButton, "click", lang.hitch(this, this.abort));

            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationEditPageContentDiv");

            // ProjectSelect
            DOMHelper.createTextNode("div", i18n.planningNotificationColumnProjectLabel, contentDiv, "propertyLabel planningNotificationEditProjectLabel");
            this.projectSelect = new Select({
                   label : i18n.planningNotificationColumnProjectLabel,
                   title : i18n.planningNotificationEditProjectToolTip,
                tabIndex : 10                
            });
            domClass.add(this.projectSelect.domNode, "fixedDialogWidget planningNotificationEditProjectSelect");
            domConstruct.place(this.projectSelect.domNode, contentDiv);
            WidgetHelper.handleSelectEvents(this.projectSelect, lang.hitch(this, this.updateWidgetState));

            // NameTextBox
            DOMHelper.createTextNode("div", i18n.planningNotificationEditTitleLabel, contentDiv, "propertyLabel planningNotificationEditNameLabel");
            this.nameTextBox = new Textarea({
                    label : i18n.planningNotificationColumnTitleLabel,
                    title : i18n.planningNotificationEditNameToolTip,
                maxLength : 110,
                 tabIndex : 12                
            });
            domClass.add(this.nameTextBox.domNode, "fixedDialogWidget planningNotificationEditNameTextArea");
            domConstruct.place(this.nameTextBox.domNode, contentDiv);
            WidgetHelper.handleTextBoxEvents(this.nameTextBox, lang.hitch(this, this.updateWidgetState));
            WidgetHelper.setMustField(this.nameTextBox, true);

            // CommentTextarea
            DOMHelper.createTextNode("div", i18n.planningNotificationColumnCommentLabel, contentDiv, "propertyLabel planningNotificationEditCommentLabel");
            this.commentTextArea = new Textarea({
                    label : i18n.planningNotificationColumnCommentLabel,
                    title : i18n.planningNotificationEditCommentToolTip,
                 tabIndex : 11,                
                maxLength : 2047        
            });
            domClass.add(this.commentTextArea.domNode, "fixedDialogWidget planningNotificationEditCommentTextArea");
            domConstruct.place(this.commentTextArea.domNode, contentDiv);
            WidgetHelper.handleTextBoxEvents(this.commentTextArea, lang.hitch(this, this.updateWidgetState));

            // Upload
            this.constructAndConfigureFileUpload(contentDiv);

            return contentDiv;
        },

        constructAndConfigureFileUpload : function(contentDiv) {        
            // Import form etc.
            var importFrame = this.applicationContext.getFancyIFrame();

            this.importForm = new Form({method : "post", encType : "multipart/form-data"});
            domClass.add(this.importForm.domNode, "planningNotificationEditUploadForm");
            domConstruct.place(this.importForm.domNode, contentDiv);

            this.importForm.set("target", importFrame.id);

            this.documentLoadRegistration = on(importFrame, "documentLoad", lang.hitch(this, function(event) {
                this.tempFileName = event.document ? event.document.body.innerHTML : null;
                this.planningNotification.type = 0;
                if (log.isDebugEnabled()) {
                    log.debug("Received tempFileName = [" + this.tempFileName + "]");
                }

                this.updateWidgetState();               
            }));            

            // Import
            this.fileUploadLabel = DOMHelper.createTextNode("div", i18n.planningNotificationEditFileUploadLabel, contentDiv, "propertyLabel planningNotificationEditFileLabel");
            this.filePathTextBox = new TextBox({
                   label : i18n.planningNotificationEditFilePathLabel,
                   title : i18n.planningNotificationEditFilePathToolTip,
                disabled : true 
            });
            domClass.add(this.filePathTextBox.domNode, "fixedDialogWidget planningNotificationEditFilePathTextBox");
            domConstruct.place(this.filePathTextBox.domNode, contentDiv);       

            DOMHelper.createTextNode("div", i18n.planningNotificationEditFilePathLabel, contentDiv, "propertyLabel planningNotificationEditUploadLabel");
            this.uploader = new dojox.form.Uploader({
                    name : "uploadedFile",
                multiple : false,
                    type : "file",
                   label : i18n.chooseFileShort,
                tabIndex : 13
            });
            domClass.add(this.uploader.domNode, "fixedDialogWidget planningNotificationEditFileUploadUpload");
            domConstruct.place(this.uploader.domNode, this.importForm.domNode);  

            var url = "/cdes-dojo-impl/tempFileUpload";
            this.uploader.set("url", url);
            this.importForm.set("action", url);

            this.uploader.startup();

            on(this.uploader, "change", lang.hitch(this, function(fileInfos) {
                if (fileInfos.length > 0 && fileInfos[0].name != null) {
                    this.uploadedFileName = fileInfos[0].name;
                } else {
                    this.uploadedFileName = null;
                }

                this.tempFileName = null;
                this.updateWidgetState();               

                this.importForm.submit();
            }));

            // Replace file by MSP file button
            this.replaceByMspButton = new Button({
                label : i18n.planningNotificationEditReplaceByMspButtonCaption,
                title : i18n.planningNotificationEditReplaceByMspButtonToolTip
            });
            domClass.add(this.replaceByMspButton.domNode, "fixedDialogWidget planningNotificationEditReplaceByMspButton");
            domConstruct.place(this.replaceByMspButton.domNode, contentDiv);

            this.uploadStatusNodeLong = DOMHelper.createTextNode("div", "", contentDiv,
                "fixedDialogWidget planningNotificationEditUploadStatusLong");
            this.uploadStatusNodeShort = DOMHelper.createTextNode("div", "", contentDiv,
                "fixedDialogWidget planningNotificationEditUploadStatusShort");
            this.uploadStatusNodeFile = domConstruct.create("div", null, null);
            domClass.add(this.uploadStatusNodeFile, "fixedDialogWidget planningNotificationEditUploadStatusFile");
            domConstruct.place(this.uploadStatusNodeFile, contentDiv);                                                          

            on(this.replaceByMspButton, "click", lang.hitch(this, this.replaceByMsp));


            this.uploadStatusFileNode = domConstruct.create("span", null, this.uploadStatusNodeFile);

            this.deleteUploadedFileButton = new FancyButton({
                    title : i18n.planningNotificationEditDeleteFileToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(this.deleteUploadedFileButton.domNode, "planningNotificationEditDeleteFileButton listButton");
            domConstruct.place(this.deleteUploadedFileButton.domNode, this.uploadStatusNodeFile);       

            on(this.deleteUploadedFileButton, "click", lang.hitch(this, function() {
                // TODO Delete temp file at server side as well
                this.planningNotification.filename = null;
                this.uploadedFileName = null;
                this.tempFileName = null;
                this.updateWidgetState();               
            }));
        },

        loadEditInfo : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();

            this.registerAsyncOperationStarted(PlanningNotificationEditPage.AsyncOperation.LOAD_EDIT_INFO);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.getPlanningNotificationEditInfo(organisationPersonId, networkId, [ "editPlanningNotification" ]).then(
                lang.hitch(this, function(editInfo) {               
                    this.registerAsyncOperationFinished(PlanningNotificationEditPage.AsyncOperation.LOAD_EDIT_INFO);

                    this.projects = editInfo.projects;
                    this.templates = editInfo.planningNotificationTemplates;
                    this.templateIdToMetaTags = editInfo.templateIdToMetaTags;                  

                    var projectIdToSelect = null;
                    var options = [];
                    for (var n = 0; n < this.projects.length; n++) {
                        options.push({ value : this.projects[n].id, label : this.projects[n].name });
                        if (this.mode == ContentWidget.Mode.CREATE && this.projects[n].id == this.projectId) {
                            projectIdToSelect = this.projects[n].id;
                        }                           
                    }				
                    if (options != null){
			            options.sort(function(dataOne, dataTwo) {
			                if (dataOne.label == null) {
			                    return 1;
			                } else if (dataTwo.label == null) {
			                    return -1;
			                } else {
			                    return dataOne.label.localeCompare(dataTwo.label);
			                }                       
			            });                 
					}
                    this.projectSelect.set("options", options);
                    if (projectIdToSelect != null) {
                        this.projectSelect.set("value", projectIdToSelect);
                        this.projectId = null;                  
                    }                       

                    this.chosenTemplate = (this.templates.length > 0 ? this.templates[0] : null);
                    if (this.chosenTemplate == null) {
                        topic.publish("message/error", {
                                 message : i18n.planningNotificationEditNoTemplateError,
                            showInDialog : true
                        });
                    } else {
                        var metaTags = this.templateIdToMetaTags[this.chosenTemplate.id];
                        if (metaTags == null) {
                            metaTags = [];
                        }                           
                        this.initializeDynamicWidgets(metaTags);                        
                        this.reload();
                    }
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationEditPage.AsyncOperation.LOAD_EDIT_INFO,
                                opName : "getPlanningNotificationEditInfo",
                               message : i18n.planningNotificationEditPageGetEditInfoFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPlanningNotificationEditInfo]", err);
                    }));
        },          

        initializeDynamicWidgets : function(metaTags) {
            this.idToMetaTagInfo = new Object();
            for (var n = 0; n < metaTags.length; n++) {
                var metaTag = metaTags[n];                
                var cssClass = metaTag.cssClass;
                var cssRules = metaTag.cssRules;
                var multiple = metaTag.multiple;
                var tagFormat = metaTag.tagFormat;
                var mandatory = !!metaTag.mandatory;            
                var name = metaTag.name;
                var position = metaTag.position;
                var tabIndex = (position * 100);                

                if (cssClass == null) {
                    log.error("Cannot place edit widget for metaTag [" + name + "] since it has no css class; will ignore it.");
                    continue;                    
                }                    

                document.getElementsByTagName("head")[0].appendChild(DOMHelper.createTextNode("style", cssRules)); 

                var labelCssClass = "planningNotificationEdit" + cssClass + "Label";
                var widgetCssClass = "planningNotificationEdit" + cssClass + "Widget";

                DOMHelper.createTextNode("div", name, this.contentDiv, "propertyLabel " + labelCssClass);

                var currWidget = null;
                if (multiple) {
                    var constructorFct = null;
                    var getterFct = null;
                    var setterFct = null;               
                    if (tagFormat == 0) {         // TAG_FORMAT_TEXT

                        constructorFct = function() {
                            var textBox = new TextBox({
                                maxLength : 127
                            });
                            WidgetHelper.setMustField(textBox, mandatory);
                            return textBox;                     
                        };
                        getterFct = function(widget) {
                            return widget.get("value");
                        };
                        setterFct = function(widget, value) {
                            widget.set("value", value);                         
                        };
                    } else if (tagFormat == 1) {  // TAG_FORMAT_DATE

                        constructorFct = function() {
                            var spinner = new CalendarSpinner({
                                          pattern : i18n.datePattern,
                                         timeZone : this.applicationContext.getTimeZone(),
                                       dndEnabled : false,
                                rowObjectToString : null
                            });
                            spinner.setMustField(mandatory);
                            return spinner;                     
                        };
                        getterFct = function(widget) {
                            return widget.getUtcSeconds();
                        };
                        setterFct = function(widget, value) {
                            widget.setUtcSeconds(value);
                        };                          
                    } else {
                        throw new Error("TagFormat [" + tagFormat + "] is not yet supported, see at.cdes.oldGwtDto.MetaTagDTO");
                    }                                       

                    var addLabel = string.substitute(i18n.planningNotificationEditAddMultiLabel, {
                        name : name
                    });
                    var deleteLabel = string.substitute(i18n.planningNotificationEditDeleteMultiLabel, {
                        name : name
                    });

                    var addButtonCssClass = "planningNotificationEdit" + cssClass + "AddButton";
                    var lineWidgetCssClass = "planningNotificationEdit" + cssClass + "LineWidget";
                    var lineRemoveButtonCssClass = "planningNotificationEdit" + cssClass + "LineRemoveButton";                  

                    currWidget = new MultiWidget({
                                  addButtonLabel : addLabel,
                              addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
                               addButtonCssClass : addButtonCssClass,
                               deleteButtonLabel : deleteLabel,
                           deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
                              lineWidgetCssClass : lineWidgetCssClass,
                        lineRemoveButtonCssClass : lineRemoveButtonCssClass,                    
                                  constructorFct : constructorFct,
                                       getterFct : getterFct,
                                       setterFct : setterFct,
                                        tabIndex : tabIndex,
                                   tabIndexRange : 100                        
                    });                     
                    // TODO (currently not relevant) --- implement a counterpart to handle...Events,
                    // to call updateWidgetState triggered by changes on this widget.  As we currently
                    // have just TextBox-widgets here, this is not relevant, but as soon as we have
                    // DateTimeSpinBox widgets here (which actually can be invalid), this needs to be
                    // addressed.               
                } else {
                    if (tagFormat == 0) {         // TAG_FORMAT_TEXT
                        currWidget = new TextBox({
                            tabIndex : tabIndex
                        });                                                    
                        WidgetHelper.handleTextBoxEvents(currWidget, lang.hitch(this, this.updateWidgetState));
                        WidgetHelper.setMustField(currWidget, mandatory);
                    } else if (tagFormat == 1) {  // TAG_FORMAT_DATE

                        currWidget = new CalendarSpinner({
                                      pattern : i18n.datePattern,
                                     timeZone : this.applicationContext.getTimeZone(),
                                   dndEnabled : false,
                            rowObjectToString : null,                   
                                     tabIndex : tabIndex
                        });                         
                        WidgetHelper.handleSpinnerEvents(currWidget, lang.hitch(this, this.updateWidgetState));
                        WidgetHelper.setMustField(currWidget, mandatory);
                    } else {
                        throw new Error("TagFormat [" + tagFormat + "] is not yet supported, see at.cdes.oldGwtDto.MetaTagDTO");
                    }
                }

                domClass.add(currWidget.domNode, "fixedDialogWidget " + widgetCssClass);
                domConstruct.place(currWidget.domNode, this.contentDiv);

                this.idToMetaTagInfo[metaTag.id] = {
                    metaTag : metaTag,
                     widget : currWidget
                };
            }
        },          

        resize : function(newSize) {
            var totalHeight = newSize.h;

            var width = this.captionBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
            //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
            - this.captionBarDiv.offsetHeight
            - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
        },

        setData : function() {

        },

        reload : function() {
            //this.contextBar.reload();

            if (this.mode == ContentWidget.Mode.CREATE) {
                if (this.sharepointPlanningNotificationInfo != null) {
                    this.planningNotification = this.sharepointPlanningNotificationInfo.planningNotification;
                    this.planningNotification.id = null;
                    this.planningNotification.type = 1;
                    this.planningNotification.networkId = this.applicationContext.getPageContextPnNetworkId();                  
                    this.planningNotification.projects = this.sharepointPlanningNotificationInfo.projects;
                    this.planningNotification.metaTagIdToDateMetaInformations = this.sharepointPlanningNotificationInfo.metaTagIdToDateMetaInformations;
                    this.planningNotification.metaTagIdToTextMetaInformations = this.sharepointPlanningNotificationInfo.metaTagIdToTextMetaInformations;
                } else {
                    this.planningNotification = {
                                                  title : "",
                                                comment : "",
                                                   type : 0,   // PlanningNotificationType.UPLOADED
                         planningNotificationTemplateId : null,
                                               projects : [],
                        metaTagIdToDateMetaInformations : new Object(),
                        metaTagIdToTextMetaInformations : new Object(),
                                              networkId : this.applicationContext.getPageContextPnNetworkId()
                    };
                }
                this.updateWidgetsFromData();           
            } else {
                var planningNotificationService = this.applicationContext.getService("planningNotificationService");
                this.registerAsyncOperationStarted(PlanningNotificationEditPage.AsyncOperation.LOAD);

                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                planningNotificationService.getPlanningNotificationJoin(organisationPersonId, this.id).then(
                    lang.hitch(this, function(planningNotificationInfo) {
                        this.planningNotification = planningNotificationInfo.planningNotification;
                        this.planningNotification.projects = planningNotificationInfo.projects;
                        this.planningNotification.metaTagIdToDateMetaInformations = planningNotificationInfo.metaTagIdToDateMetaInformations;
                        this.planningNotification.metaTagIdToTextMetaInformations = planningNotificationInfo.metaTagIdToTextMetaInformations;

                        var removableMetaInformationIdsList = planningNotificationInfo.removableMetaInformationIds;
                        this.removableMetaInformationIds = new Object();
                        for (var n = 0; n < removableMetaInformationIdsList.length; n++) {
                            this.removableMetaInformationIds[removableMetaInformationIdsList[n]] = true;
                        }

                        this.updateWidgetsFromData();
                        this.registerAsyncOperationFinished(PlanningNotificationEditPage.AsyncOperation.LOAD);
                    }),
                    lang.hitch(this, function(err) {
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : PlanningNotificationEditPage.AsyncOperation.LOAD,
                                    opName : "getPlanningNotificationJoin",
                                   message : i18n.planningNotificationEditGetJoinFailed
                        });
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [getPlanningNotificationJoin]", err);
                        }));
            }               
        },

        save : function() {
            this.doSave(lang.hitch(this, function() {
                if (this.saveBackPage != null) {
                    this.applicationContext.setPage(this.saveBackPage, new Object(), this.saveBackParams);
                }
            }));                
        },

        saveAndExit : function() {
            this.doSave(lang.hitch(this, function() {               
                if (this.backPage != null) {
                    this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
                }
            }));                
        },

		checkForDuplicates : function(saveInfo) {
            var metaTags = this.templateIdToMetaTags[this.chosenTemplate.id];
            var baulosMetaTag = null;
            for (var n = 0; n < metaTags.length; n++) {
                if (metaTags[n].multiple) {
                    baulosMetaTag = metaTags[n];
                    break;
                }
            }

            if (baulosMetaTag != null) {
                var baulosMetaTagId = baulosMetaTag.id;
                var textMetaInformations = saveInfo.textMetaInformations;
                var baulosMetaInformations = this.planningNotification.metaTagIdToTextMetaInformations[baulosMetaTagId];
                if (baulosMetaInformations != null) {
                    var baulose = new Object();
                    for (var n = 0; n < baulosMetaInformations.length; n++) {
                        var name = baulosMetaInformations[n].value;
                        var effectiveName = name != null ? name.toLowerCase() : null;
                        if (effectiveName != null) {
                            if (effectiveName in baulose) {
                                return name;
                            }
                            baulose[effectiveName] = true;
                        }
                    }
                    for (var baulos in baulose) {
                        console.info("Found baulos [" + baulos + "]");                        
                    }
                }
            }
            return null;
        },

        doSave : function(callbackFct) {
            this.updateDataFromWidgets();

            var saveInfo = this.getSaveInfo();

            var duplicateBaulos = this.checkForDuplicates(saveInfo);
            if (duplicateBaulos != null) {
                var errorMessage = string.substitute(i18n.planningNotificationEditDuplicateBaulosError, {
                    baulos : duplicateBaulos
                });
                window.alert(errorMessage);
                return;
            }

            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(PlanningNotificationEditPage.AsyncOperation.SAVE);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            planningNotificationService.saveOrUpdatePlanningNotification(saveInfo).then(
                lang.hitch(this, function(errorMessage) {
                    this.registerAsyncOperationFinished(PlanningNotificationEditPage.AsyncOperation.SAVE);

                    if (errorMessage != null) {
                        topic.publish("message/error", errorMessage, true);
                    } else {
                        topic.publish("message/ok", i18n.planningNotificationEditSaveSuccessful);

                        callbackFct();
                    }
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationEditPage.AsyncOperation.SAVE,
                                opName : "saveOrUpdatePlanningNotification",
                               message : i18n.planningNotificationEditSaveFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [saveOrUpdatePlanningNotification]", err);
                    }));            
        },

        abort : function() {
            if (this.abortBackPage != null) {
                this.applicationContext.setPage(this.abortBackPage, new Object(), this.abortBackParams);
            } else if (this.backPage != null) {
                this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
            }                        
        },

        replaceByMsp : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();

            this.registerAsyncOperationStarted(PlanningNotificationEditPage.AsyncOperation.COPY_SHAREPOINT_FILE_TO_CDES);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.copySharepointFileToCdes(organisationPersonId, this.planningNotification.id).then(
                lang.hitch(this, function(editInfo) {               
                    this.registerAsyncOperationFinished(PlanningNotificationEditPage.AsyncOperation.COPY_SHAREPOINT_FILE_TO_CDES);

                    this.reload();
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationEditPage.AsyncOperation.COPY_SHAREPOINT_FILE_TO_CDES,
                                opName : "copySharepointFileToCdes",
                               message : i18n.planningNotificationEditCopySharepointFileFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [copySharepointFileToCdes]", err);
                    }));            
        },

        getSaveInfo : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var planningNotification = {
                                            id : this.planningNotification.id,
                                         title : this.planningNotification.title,
                                       comment : this.planningNotification.comment,
                                          type : this.planningNotification.type,
                                          path : this.planningNotification.path,
                                sharepointLink : this.planningNotification.sharepointLink,                            
                planningNotificationTemplateId : this.chosenTemplate.id,
                                      filename : this.planningNotification.filename,
                                     networkId : (this.mode == ContentWidget.Mode.CREATE ? this.planningNotification.networkId : null)
            };
            var projectId = this.projectSelect.get("value");

            var textMetaTagIds = [];
            var textMetaInformations = [];
            for (var metaTagId in this.planningNotification.metaTagIdToTextMetaInformations) {
                var currentTextMetaInformations = this.planningNotification.metaTagIdToTextMetaInformations[metaTagId];
                for (var n = 0; n < currentTextMetaInformations.length; n++) {
                    textMetaTagIds.push(metaTagId);
                    textMetaInformations.push(currentTextMetaInformations[n]);                  
                }
            }

            var dateMetaTagIds = [];
            var dateMetaInformations = [];
            for (var metaTagId in this.planningNotification.metaTagIdToDateMetaInformations) {
                var currentDateMetaInformations = this.planningNotification.metaTagIdToDateMetaInformations[metaTagId];
                for (var n = 0; n < currentDateMetaInformations.length; n++) {
                    dateMetaTagIds.push(metaTagId);
                    dateMetaInformations.push(currentDateMetaInformations[n]);                  
                }
            }

            var saveInfo = {
                organisationPersonId : organisationPersonId,
                planningNotification : planningNotification,
                           projectId : projectId,
                      textMetaTagIds : textMetaTagIds,
                textMetaInformations : textMetaInformations,
                      dateMetaTagIds : dateMetaTagIds,
                dateMetaInformations : dateMetaInformations,
                        tempFileName : this.tempFileName,
                    originalFileName : this.uploadedFileName                
            };
            return saveInfo;            
        },          

        updateWidgetState : function() {
            if (this.mode == ContentWidget.Mode.CREATE) {
                DOMHelper.setInnerText(this.captionDiv, i18n.planningNotificationEditCreateCaption);
                //                              this.saveAndExitButton.set("label", i18n.createButtonCaption);
                this.saveAndExitButton.set("title", this.sharepoint ? i18n.planningNotificationEditCreateSharepointToolTip : i18n.planningNotificationEditCreateToolTip);
            } else if (this.mode == ContentWidget.Mode.EDIT) {
                DOMHelper.setInnerText(this.captionDiv, i18n.planningNotificationEditEditCaption);
                //                              this.saveAndExitButton.set("label", i18n.saveButtonCaption);
                this.saveAndExitButton.set("title", i18n.planningNotificationEditSaveToolTip);
            } else {
                throw new Error("Mode [" + this.mode + "] is not supported.");
            }

            domClass.replace(this.uploadStatusNodeLong, "invisible", "visible");
            domClass.replace(this.uploadStatusNodeShort, "invisible", "visible");
            domClass.replace(this.uploadStatusNodeFile, "invisible", "visible");
            domConstruct.empty(this.uploadStatusNodeLong);

            if (this.initialized) {
                WidgetHelper.updateEmptySpinnerState(this.nameTextBox);
            }

            if (this.uploadedFileName != null) {
                // User chose a file
                if (this.tempFileName == null) {
                    // An upload is running
                    domClass.replace(this.uploadStatusNodeShort, "visible", "invisible");
                    var message = string.substitute(i18n.uploadStatusUploadRunning, {
                        fileName : this.uploadedFileName
                    });
                    DOMHelper.setInnerText(this.uploadStatusNodeShort, message);                
                } else {
                    // An upload has finished
                    domClass.replace(this.uploadStatusNodeLong, "visible", "invisible");

                    var fileName = this.uploadedFileName != null ? this.uploadedFileName : i18n.unknown;
                    DOMHelper.createTextNode("span", i18n.planningNotificationEditUploadFinishedPrefix + " ", this.uploadStatusNodeLong);
                    DOMHelper.createTextNode("span", fileName, this.uploadStatusNodeLong, "planningNotificationEditUploadFinishedFileName");
                    DOMHelper.createTextNode("span", " " + i18n.planningNotificationEditUploadFinishedPostfix, this.uploadStatusNodeLong);                   
                }
            } else if (this.planningNotification == null || this.planningNotification.filename == null) {
                // Planning notification not yet has a file
                this.uploader.set("label", i18n.chooseFileShort);
                domClass.replace(this.uploadStatusNodeShort, "visible", "invisible");
                DOMHelper.setInnerText(this.uploadStatusNodeShort, i18n.uploadStatusNoFileChosen);              
            } else {
                // Planning notification has a file attachment
                this.uploader.set("label", i18n.replaceFileShort);
                domClass.replace(this.uploadStatusNodeFile, "visible", "invisible");
                DOMHelper.setInnerText(this.uploadStatusFileNode, this.planningNotification.filename);          
            }

            var allFieldsValid = WidgetHelper.isTextBoxValid(this.nameTextBox)
            && this.projects.length > 0;            

            for (var metaTagId in this.idToMetaTagInfo) {
                var metaTagInfo = this.idToMetaTagInfo[metaTagId];
                var metaTag = metaTagInfo.metaTag;
                var widget = metaTagInfo.widget;

                if (metaTag.multiple) {
                    if (metaTag.tagFormat == CdesVoc.TagFormat.DATE) {
                        allFieldsValid &= widget.isValid(function(w) { return w.isValid(); });
                        // TODO: Implement case multiple && mandatory if needed.
                    } else if (metaTag.tagFormat == CdesVoc.TagFormat.TEXT) {
                        allFieldsValid &= WidgetHelper.isTextBoxValid(widget);
                    }                       
                } else {
                    if (metaTag.tagFormat == CdesVoc.TagFormat.DATE) {
                        widget.updateEmptySpinnerState();
                        allFieldsValid &= widget.isValid();                     

                    } else if (metaTag.tagFormat == CdesVoc.TagFormat.TEXT) {
                        WidgetHelper.updateEmptyTextBoxState(widget);
                        allFieldsValid &= WidgetHelper.isTextBoxValid(widget);
                    }                       
                }                   
            }               

            if (this.saveButton != null) {
                this.saveButton.set("disabled", !allFieldsValid || this.isAsyncOperationRunning());     
            }           
            this.saveAndExitButton.set("disabled", !allFieldsValid || this.isAsyncOperationRunning());
            this.replaceByMspButton.set("disabled", this.planningNotification == null
                || this.planningNotification.sharepointLink == null
                || this.planningNotification.sharepointLink.length == 0);                
        },

        updateWidgetsFromData : function() {
            this.nameTextBox.set("value", this.planningNotification.title);
            this.commentTextArea.set("value", this.planningNotification.comment);
            this.filePathTextBox.set("value", this.planningNotification.sharepointLink);

            // m:n in datamodel, but 1:n in practice
            for (var n = 0; n < this.planningNotification.projects.length; n++) {
                var found = false;
                for (var z = 0; z < this.projects.length; z++) {
                    found |= this.projects[z].id == this.planningNotification.projects[n].id;                    
                }

                if (!found) {
                    topic.publish("message/error", "The planning notification project is not part of the dropdown, something is wrong here.");
                }                    

                this.projectSelect.set("value", this.planningNotification.projects[n].id);
                break;          
            }

            var selectedProjectId = this.projectSelect.get("value");
            if (selectedProjectId == null || selectedProjectId == "") {
                var options = this.projectSelect.get("options");
                if (options.length > 0) {
                    this.projectSelect.set("value", options[0].value);
                }                   
            }               

            for (var metaTagId in this.idToMetaTagInfo) {
                var metaTag = this.idToMetaTagInfo[metaTagId].metaTag;
                var widget = this.idToMetaTagInfo[metaTagId].widget;
                var multiple = metaTag.multiple;
                var tagFormat = metaTag.tagFormat;              

                var metaInformations = null;
                if (tagFormat == CdesVoc.TagFormat.TEXT) {
                    metaInformations = (metaTag.id in this.planningNotification.metaTagIdToTextMetaInformations
                        ? this.planningNotification.metaTagIdToTextMetaInformations[metaTag.id] : []);
                } else if (tagFormat == CdesVoc.TagFormat.DATE) {
                    metaInformations = (metaTag.id in this.planningNotification.metaTagIdToDateMetaInformations
                        ? this.planningNotification.metaTagIdToDateMetaInformations[metaTag.id] : []);
                } else {
                    throw new Error("TagFormat [" + tagFormat + "] is not supported.");
                }

                if (multiple) {
                    var tokenInfos = [];
                    for (var n = 0; n < metaInformations.length; n++) {
                        var id = metaInformations[n].metaInformationId;
                        log.info("Added metaInformationId [" + id + "] to MultiWidget.");                       
                        tokenInfos.push({
                                value : metaInformations[n].value,
                                   id : id,
                            removable : (id == null || (id in this.removableMetaInformationIds && this.removableMetaInformationIds[id]))
                        });                         
                    }

                    widget.set("value", tokenInfos);

                    if (tokenInfos.length == 0) {
                        widget.add();
                    }
                } else {
                    var value = metaInformations.length > 0 ? metaInformations[0].value : null;

                    if (tagFormat == CdesVoc.TagFormat.TEXT) {
                        widget.set("value", value);
                    } else if (tagFormat == CdesVoc.TagFormat.DATE) {
                        widget.setUtcSeconds(value);
                    } else {
                        throw new Error("TagFormat [" + tagFormat + "] is not supported.");
                    }
                }                   
            }               

            this.initialized = true;
        },          

        updateDataFromWidgets : function() {
            this.planningNotification.title = this.nameTextBox.get("value");
            this.planningNotification.comment = this.commentTextArea.get("value");
            this.projectId = this.projectSelect.get("value");

            for (var metaTagId in this.idToMetaTagInfo) {
                var metaTag = this.idToMetaTagInfo[metaTagId].metaTag;
                var widget = this.idToMetaTagInfo[metaTagId].widget;
                var multiple = metaTag.multiple;
                var tagFormat = metaTag.tagFormat;

                var oldMetaInformations = null;
                if (tagFormat == CdesVoc.TagFormat.TEXT) {
                    oldMetaInformations = (metaTag.id in this.planningNotification.metaTagIdToTextMetaInformations
                        ? this.planningNotification.metaTagIdToTextMetaInformations[metaTag.id] : []);
                } else if (tagFormat == CdesVoc.TagFormat.DATE) {
                    oldMetaInformations = (metaTag.id in this.planningNotification.metaTagIdToDateMetaInformations
                        ? this.planningNotification.metaTagIdToDateMetaInformations[metaTag.id] : []);
                } else {
                    throw new Error("TagFormat [" + tagFormat + "] is not supported.");
                }

                if (multiple) {
                    var metaInformationIdToOldMetaInformation = new Object();
                    for (var n = 0; n < oldMetaInformations.length; n++) {
                        metaInformationIdToOldMetaInformation[oldMetaInformations[n].metaInformationId] = oldMetaInformations[n];
                    }                       

                    var newMetaInformations = [];
                    var tokenInfos = widget.get("value");
                    for (var n = 0; n < tokenInfos.length; n++) {
                        var value = tokenInfos[n].value;
                        if ((tagFormat == CdesVoc.TagFormat.TEXT && value != null && value.trim().length > 0)
                            || (tagFormat == CdesVoc.TagFormat.DATE && value != null)) {

                            var tokenInfo = tokenInfos[n];                  
                            var metaInformationId = tokenInfos[n].id;
                            if (metaInformationId != null && metaInformationId in metaInformationIdToOldMetaInformation) {
                                var newMetaInformation = metaInformationIdToOldMetaInformation[metaInformationId];
                                newMetaInformation.value = tokenInfo.value;
                                newMetaInformations.push(newMetaInformation);                       
                            } else {
                                newMetaInformations.push({
                                    metaInformationId : metaInformationId,
                                                value : tokenInfo.value                         
                                });                             
                            }
                        }
                    }

                    if (tagFormat == CdesVoc.TagFormat.TEXT) {
                        this.planningNotification.metaTagIdToTextMetaInformations[metaTag.id] = newMetaInformations;
                    } else if (tagFormat == CdesVoc.TagFormat.DATE) {
                        this.planningNotification.metaTagIdToDateMetaInformations[metaTag.id] = newMetaInformations;
                    } else {
                        throw new Error("TagFormat [" + tagFormat + "] is not supported.");
                    }
                } else {
                    var metaInformation = oldMetaInformations.length > 0 ? oldMetaInformations[0] : null;
                    if (metaInformation == null) {
                        metaInformation = {
                            metaTagId : metaTagId                       
                        };                          
                    }                       

                    if (tagFormat == CdesVoc.TagFormat.TEXT) {
                        metaInformation.value = widget.get("value");
                        this.planningNotification.metaTagIdToTextMetaInformations[metaTag.id] = [ metaInformation ];
                    } else if (tagFormat == CdesVoc.TagFormat.DATE) {
                        metaInformation.value = widget.getUtcSeconds();
                        this.planningNotification.metaTagIdToDateMetaInformations[metaTag.id] = [ metaInformation ];
                    } else {
                        throw new Error("TagFormat [" + tagFormat + "] is not supported.");
                    }
                }
            }               
        },          

        destroy : function() {
            this.inherited(arguments);
            if (this.documentLoadRegistration != null) {
                this.documentLoadRegistration.remove(); 
            }           
        }
    });

    PlanningNotificationEditPage.AsyncOperation = {
        COPY_SHAREPOINT_FILE_TO_CDES : "CopySharepointFileToCdes",
        LOAD_EDIT_INFO : "LoadEditInfo",
        LOAD : "Load",
        SAVE : "Save"   
    };

    return PlanningNotificationEditPage;
});
