/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/


define([ "cdes/planning/order/PlanningNotificationOrderImportWidget",
	"cdes/planning/order/PlanningNotificationOrderListWidget",
	"clazzes/TinyLog",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/InfoDialog",
	"dijit/form/Button",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(PlanningNotificationOrderImportWidget,
			PlanningNotificationOrderListWidget,
			TinyLog,
			topic,
			DOMHelper,
			ErrorHelper,
			ContentWidget,
			InfoDialog,
			Button,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderImportPage";

	var log = new TinyLog(className);

	var PlanningNotificationOrderImportPage = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.reload();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationOrderImportPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationOrderImportPageCaption, captionBarDiv, "cdesGeneralPageCaption");

			this.importButton = this.constructImportButton(captionBarDiv);
			this.abortButton = this.constructAbortButton(captionBarDiv);	    

			return captionBarDiv;
		},

		constructImportButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.importButtonCaption,
				title : i18n.planningNotificationListImportButtonToolTip
			});
			domClass.add(button.domNode, "planningNotificationOrderImportImportButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, this.doImport));

			return button;	    
		},

		doImport : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var tempFileName = this.importWidget.getTempFileName();

			this.registerAsyncOperationStarted(PlanningNotificationOrderImportWidget.AsyncOperation.UPLOAD);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.importPlanningNotificationOrdersFromCsv(organisationPersonId, this.planningNotificationId, tempFileName).then(
					lang.hitch(this, function(importLines) {
						this.registerAsyncOperationFinished(PlanningNotificationOrderImportWidget.AsyncOperation.UPLOAD);

						this.showResultDialog(importLines);		    

						if (this.backPage != null) {
							this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
						}                        
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderImportWidget.AsyncOperation.UPLOAD,
							opName : "importPlanningNotificationOrdersFromCsv",
							message : i18n.planningNotificationOrderImportFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [importPlanningNotificationOrdersFromCsv]", err);
							}));                        
		},

		constructAbortButton : function(captionBarDiv) {
			var button = new Button({
				label : i18n.abortButtonCaption,
				title : i18n.abortButtonCaption
			});
			domClass.add(button.domNode, "planningNotificationOrderImportAbortButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				if (this.backPage != null) {
					this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
				}                        
			}));		

			return button;	    
		},	

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationOrderImportPageContentDiv");

			this.importWidget = new PlanningNotificationOrderImportWidget({
				applicationContext : this.applicationContext,
				backPage : this.backPage,
				backParams : this.backParams,
				planningNotificationId : this.id
			});
			this.importWidgetDiv = this.importWidget.getContainer();
			domConstruct.place(this.importWidgetDiv, contentDiv);	    
			on(this.importWidget, "fileUploaded", lang.hitch(this, this.reload));

			this.listWidget = new PlanningNotificationOrderListWidget({
				applicationContext : this.applicationContext,
				backPage : "planningNotificationOrderList",
				backParams : new Object(),
				showActions : false
			});

			this.listWidgetDiv = this.listWidget.getContainer();
			domConstruct.place(this.listWidgetDiv, contentDiv);

			return contentDiv;
		},

		resize : function(newSize) {
			var totalHeight = newSize.h;

			var tableHeight = totalHeight
			- this.captionBarDiv.offsetHeight
			- this.importWidgetDiv.offsetHeight		
			- 20;

			this.listWidget.resize({ h : tableHeight });
		},

		setData : function() {

		},

		reload : function() {
			var tempFileName = this.importWidget.getTempFileName();
			if (tempFileName == null) {
				this.listWidget.setData({
					planningNotificationOrderInfos : [],
					columnSettings : this.getColumnSettings()
				});		    
				this.updateWidgetState();
			} else {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

				this.registerAsyncOperationStarted(PlanningNotificationOrderImportPage.AsyncOperation.LOAD_PREVIEW);
				var planningNotificationService = this.applicationContext.getService("planningNotificationService");
				planningNotificationService.getPlanningNotificationOrderCsvImportPreview(organisationPersonId, this.planningNotificationId, tempFileName).then(
						lang.hitch(this, function(importLines) {
							this.registerAsyncOperationFinished(PlanningNotificationOrderImportPage.AsyncOperation.LOAD_PREVIEW);

							var error = false;
							for (var n = 0; n < importLines.length; n++) {
								var importLine = importLines[n];
								if (importLine.error) {
									this.listWidget.setData({
										planningNotificationOrderInfos : [],
										columnSettings : this.getColumnSettings()
									});		    

									this.showErrorDialog(importLines);
									error = true;
									break;			    
								}			    
							}			

							if (!error) {
								var orderInfos = [];
								for (var n = 0; n < importLines.length; n++) {
									var orderInfo = importLines[n].planningNotificationOrderInfo;
									orderInfo.orderJoin.planningNotificationOrderWorkflowEntityId = -n;				
									orderInfo.orderJoin.planningNotificationOrderSerialNumber = n;
									orderInfos.push(orderInfo);
								}

								/*			    orderInfos.sort(function(orderInfoOne, orderInfoTwo) {
				if (orderInfoOne.orderJoin.planningNotificationOrderText == null) {
				    return 1;
				} else if (orderInfoTwo.orderJoin.planningNotificationOrderText == null) {
				    return -1;   
				} else {
				    return orderInfoOne.orderJoin.planningNotificationOrderText.localeCompare(orderInfoTwo.orderJoin.planningNotificationOrderText);
				}				    
			    });				
								 */
								this.listWidget.setData({
									planningNotificationOrderInfos : orderInfos,
									columnSettings : this.getColumnSettings(),
									noSort : true				
								});		    
//								this.listWidget.sort("text");
							}
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : PlanningNotificationOrderImportPage.AsyncOperation.LOAD_PREVIEW,
								opName : "importPlanningNotificationOrdersFromCsv",
								message : i18n.planningNotificationOrderImportFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [importPlanningNotificationOrdersFromCsv]", err);
								}));            
			}		
		},

		showErrorDialog : function(importLines) {
			var errorMessage = null;
			for (var n = 0; n < importLines.length; n++) {
				var importLine = importLines[n];
				if (importLine.error) {
					errorMessage = importLine.message;
				}		    
			}

			if (errorMessage != null) {
				InfoDialog.showError({
					message : errorMessage,
					title : i18n.planningNotificationOrderImportFailedSummaryCaption
				});
			}
		},	

		updateWidgetState : function() {
			var tempFileName = this.importWidget.getTempFileName();
			this.importButton.set("disabled", tempFileName == null);	    
		},

		getColumnSettings : function() {
			return {
				showSerialNumber : false,
				showText : true,
				showPlanningNotification : true,
				showProject : true,
				showSubjectArea : true,
				showAuthorizedInspector : true,
				showReference : false,
				showStatutoryDuty : true,
				showInvalidated : true,
				showWorkflowNode : false,
				showState : false,
				showDocumentPage : true,
				showDocumentPosition : true,
				showSource : true,
				showPersonInCharge : false,
				showStatutoryDutyFrom : false,
				showStatutoryDutyTo : false,
				showStatutoryDutyInterval : false,
				showStatutoryDutyLeadTime : false,
				showStatutoryDutyExpired : false,
				showSubmitAuthority : true,
				showTag : false,
				showComment : true,
				showActions : false		
			};                
		},

		showResultDialog : function(importLines) {
			var numberOfSuccess = 0;
			var errorMessage = null;
			for (var n = 0; n < importLines.length; n++) {
				var importLine = importLines[n];
				if (importLine.error) {
					errorMessage = importLine.message;
				} else {
					numberOfSuccess++;
				}		    
			}

			if (errorMessage != null) {
				InfoDialog.showError({
					message : errorMessage,
					title : i18n.planningNotificationOrderImportFailedSummaryCaption
				});
			} else {
				var serialNumberString = "";
				for (var n = 0; n < importLines.length; n++) {
					serialNumberString += importLines[n].serialNumber;
					if (n < importLines.length - 1) {
						serialNumberString += ", ";
					}			
				}

				var resultString = string.substitute(i18n.planningNotificationOrderImportResult, {
					serialNumbers : serialNumberString
				});		    

				InfoDialog.open({
					title : i18n.planningNotificationOrderImportResultSummaryCaption,
					content : DOMHelper.createTextNode("div", resultString, null, null),
					buttons : [ { type : InfoDialog.Button.OK } ]
				});

				topic.publish("message/ok", resultString);		
			}
		},

		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanningNotificationOrderImportPage.AsyncOperation = {
			LOAD_PREVIEW : "LoadPreview"
	};

	return PlanningNotificationOrderImportPage;
});
