define([ 
	"cdes/widget/util/DnDCellWidget",
	"clazzes/TinyLog",
	"clazzes/topic",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/dateTime/FancyDate",
	"clazzes/util/WidgetHelper",
	"dijit/Calendar",
	"dijit/popup",
	"dijit/_HasDropDown",
	"dijit/_WidgetBase",
	"dijit/form/Button",
	"dojo/dom-attr",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-geometry",
	"dojo/dom-style",
	"dojo/keys",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"
	],
	function(
			DnDCellWidget,
			TinyLog,
			topic,
			DateTimeSpinBox,
			FancyDate,
			WidgetHelper,
			Calendar,
			popup,
			_HasDropDown,
			_WidgetBase,
			Button,
			domAttr,
			domClass,
			domConstruct,
			domGeometry,
			domStyle,
			Keys,
			on,
			declare,
			lang,
			i18n
	) {

	var className = "at.cdes.widget.CalendarSpinner";

	var log = new TinyLog(className);

	var CalendarSpinner = declare(className, [_WidgetBase, _HasDropDown, DnDCellWidget ], {

		buildRendering : function() {
			this.inherited(arguments);

			/* Prevent accidentally disabling the DateTimeSpinBox because disabled == undefined */
			if (this.disabled == null) {
				this.disabled = false;
			}

			this.domNode = domConstruct.create("div", null, null);
			if (this.tableClass) {
				domClass.add(this.domNode, this.tableClass);
			}

			// Date Spinner
			this.dateTimeSpinBox = new DateTimeSpinBox({
				           label : this.label,
				           title : this.title,
				         pattern : this.pattern,
				        disabled : this.disabled,
				        timeZone : this.timeZone,
			    immediateChangeEvent : true,
                                        tabIndex : (this.tabIndex != null ? this.tabIndex : null)
			});
			domConstruct.place(this.dateTimeSpinBox.domNode, this.domNode);

			on(this.dateTimeSpinBox, "change", lang.hitch(this, function() {
				on.emit(this, "change");
			}));

			on(this.dateTimeSpinBox, "keyup", lang.hitch(this, function(e) {
				on.emit(this, "keyup", e);
			}));

			on(this.dateTimeSpinBox, "click", lang.hitch(this, function(e) {
				on.emit(this, "click", e);
			}));	    

			// Icon for opening the calendar
			var calendarButtonIcon = domConstruct.create("div", null, this.domNode);
			domClass.add(calendarButtonIcon, "cdesWebIcon17x18 openCalendarIcon fixedDialogWidget");


			var totalWidth = domStyle.get(this.domNode, "width");

			domStyle.set(this.dateTimeSpinBox.domNode, "width", undefined);
			if (!this.disabled && this.dndEnabled) {
				this.dnDButtonCell = this.constructDnDButtonCell(this.domNode, "pullUpDownIcon fixedDialogWidget calendarSpinnerRightIcon");
				domClass.add(calendarButtonIcon, "calendarSpinnerLeftIcon");
				domClass.add(this.dateTimeSpinBox.domNode, "fixedDialogWidget calendarSpinnerSpinBoxWithDnD");
				domStyle.set(this.dateTimeSpinBox.domNode, "width", "auto");
			} else {
				domClass.add(calendarButtonIcon, "calendarSpinnerRightIcon");
				domClass.add(this.dateTimeSpinBox.domNode, "fixedDialogWidget calendarSpinnerSpinBoxWithoutDnD");
				domStyle.set(this.dateTimeSpinBox.domNode, "width", "auto");
			}

			on(this.dateTimeSpinBox, "click", lang.hitch(this, function(e) { 
				if (!this.dateTimeSpinBox.get("disabled")) {
					if (e.target && e.target.parentNode && e.target.parentNode._cssState == "dijitDownArrowButton") {
						this.emitValueChangeTopic("decrement");	
					} else if (e.target && e.target.parentNode && e.target.parentNode._cssState == "dijitUpArrowButton") {
						this.emitValueChangeTopic("increment");
					} else {
						this.emitValueChangeTopic("set");
					}					
				}
			}));
			// Changed from keyUp to keyup, for the new clazzes/form/NumberSpinner, seems to be ok for old dijit/form/NumberSpinners.
			on(this.dateTimeSpinBox, "keyup", lang.hitch(this, function(e) { 
				if (!this.dateTimeSpinBox.get("disabled")) { 
					if (e.keyCode == Keys.DOWN_ARROW) {
						this.emitValueChangeTopic("decrement");
					} else if (e.keyCode == Keys.UP_ARROW) {
						this.emitValueChangeTopic("increment");
					} else {
						this.emitValueChangeTopic("set");
					}
				}
			}));    		

			WidgetHelper.handleSpinnerEvents(this.dateTimeSpinBox, lang.hitch(this, this.emitValueChangeTopic));

			// Allow opening the calendar for information purposes.  closeDropDown will ignore any changes made in the calendar, if
			// _disabled is true.  Unfortunately, when using the this.disabled variable, the standard _HasDropDown code will 
			// absolutely prevent opening the dropdown; thus we have to use another variable for our internal purposes.
			this._disabled = this.disabled;
			delete this.disabled;

			this._buttonNode = calendarButtonIcon;
		},
		
    	updateWidgetsState : function() {
    		if(/*this.disabled &&*/ !this.dndEnabled){
//    			domConstruct.destroy(this._buttonNode);
    			domConstruct.destroy(this.dnDButtonCell);
				domClass.remove(this._buttonNode, "calendarSpinnerLeftIcon");
				domClass.add(this._buttonNode, "calendarSpinnerRightIcon");
				domClass.remove(this.dateTimeSpinBox.domNode, "calendarSpinnerSpinBoxWithDnD");
				domClass.add(this.dateTimeSpinBox.domNode, "fixedDialogWidget calendarSpinnerSpinBoxWithoutDnD");
    		}
    	},

		setMustField : function(mustField) {
			WidgetHelper.setMustField(this.dateTimeSpinBox, mustField);
		},	    

		updateEmptySpinnerState : function() {
			WidgetHelper.updateEmptySpinnerState(this.dateTimeSpinBox);	    
		},	    

		openDropDown : function() {
			var fancyDate = this.get("value").value;
			var jsDate = (fancyDate != null ? new Date(fancyDate.getYear(), fancyDate.getMonth() - 1, fancyDate.getDay()) : new Date());

			this.calendar = new Calendar({
				value : jsDate
			});
			this.dropDown = this.calendar;

			// onChange is only called if the user actually chooses a Date, *not* in case of Escape.  
			// Compare discussion in https://bugs.dojotoolkit.org/ticket/18592
			on(this.dropDown, "change", lang.hitch(this, function() {    			
				if (this.calendar && !this._disabled) {
					var jsDate = this.calendar.get("value");
					var fancyDate = this.get("value").value;
					if (fancyDate == null) {
						fancyDate = new FancyDate({
							day : jsDate.getDate(),
							month : jsDate.getMonth() + 1,
							year : jsDate.getFullYear(),
							timeZone : this.timeZone
						});
					} else {
						fancyDate.setDay(jsDate.getDate());
						fancyDate.setMonth(jsDate.getMonth() + 1);
						fancyDate.setYear(jsDate.getFullYear());            		
					}            	

					this.dateTimeSpinBox.set("value", fancyDate);
				}

				this.emitValueChangeTopic("set");
			}));

			this.inherited(arguments);
		},

		closeDropDown: function(focus) {
			this.inherited(arguments);

			if (focus && !(this._disabled)) {
				this.dateTimeSpinBox.focus();	
			}            

			delete this.calendar;
			delete this.dropDown;
		},

		setEditorValue : function(date, priorityChange) {
			this.dateTimeSpinBox.set("value", date, priorityChange);
		},

		getEditorValue : function() {
			return this.dateTimeSpinBox.get("value");
		},

		getUtcSeconds : function() {
			var editorValue = this.getEditorValue();
			return editorValue ? editorValue.getUtcSeconds() : null;
		},

		setUtcSeconds : function(utcSeconds, priorityChange) {
			if (utcSeconds != null) {
				var fancyDate = new FancyDate({
					utcSeconds : utcSeconds,
					timeZone : this.timeZone
				});
				this.setEditorValue(fancyDate, priorityChange);
			} else {
				this.setEditorValue(null, priorityChange);
			}		
		},

		isValid : function() {
			return this.dateTimeSpinBox.isValid();
		},

		_setDisabledAttr : function(disabled) {
			this.disabled = disabled;
			this.dateTimeSpinBox.set("disabled", disabled);	    
		},

		_setDndEnabledAttr : function(dndEnabled) {
			this.dndEnabled = dndEnabled;
		},

		_setRequiredAttr : function(required) {
			this.dateTimeSpinBox.set("required", required);
			if (required) {
				domClass.add(this.dateTimeSpinBox.domNode, "mustField");
			} else {
				domClass.remove(this.dateTimeSpinBox.domNode, "mustField");
			}		
		}
	});

	return CalendarSpinner;
});
