define([ 
        "cdes/core/DataModel",
        "cdes/util/CommonEntityHelper",
        "cdes/util/NameHelper",
        "clazzes/TinyLog",
        "clazzes/form/FancyComboBox",
        "clazzes/form/FancyComboBoxMenu",
        "clazzes/form/MultiWidget",
        "clazzes/util/DOMHelper",
        "clazzes/util/JoinHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/ComboBox",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dijit/form/ValidationTextBox",
        "dijit/form/SimpleTextarea",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
        "dojo/store/Memory",
        "dojox/validate/web"
],
function(
         DataModel,
         CommonEntityHelper,
         NameHelper,
         TinyLog,
         FancyComboBox,
         FancyComboBoxMenu,
         MultiWidget,
         DOMHelper,
         JoinHelper,
         WidgetHelper,
         ContentWidget,
         ComboBox,
         Select,
         TextBox,
         ValidationTextBox,
         SimpleTextArea,
         domClass,
         domConstruct,
         on,
         declare,
         lang,
         i18n,
         Memory,
         validate
         ) {
    

    var className = "at.cdes.web.organisation.OrganisationEditWidget";

    var log = new TinyLog(className);
    
    var OrganisationEditWidget = declare(className, ContentWidget, {
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.topDiv = this.constructTopDiv();
            
            this.allFieldsValid = true;
            this.populateCountrySelect();
        },
        
        getWidgetId : function() {
            return "OrganisationEditWidget";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute organisationEditTopDiv");
            
            // Network
            DOMHelper.createTextNode("div", i18n.nameLabel, topDiv, "propertyLabel organisationEditNameLabel");
/*
            this.siteTypeMultiWidget = new MultiWidget({
                          addButtonLabel : i18n.organisationEditNetworkAddLabel,
                      addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
                       addButtonCssClass : "planningNotificationOrderEditSiteTypeAddButton",
                       deleteButtonLabel : "deleteLabel",
                   deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
                      lineWidgetCssClass : "planningNotificationOrderEditSiteTypeLineWidget",
                lineRemoveButtonCssClass : "planningNotificationOrderEditSiteTypeRemoveButton",                 
                          constructorFct : lang.hitch(this, this.networkEditConstructorFct),
                               getterFct : lang.hitch(this, this.networkEditGetterFct),
                               setterFct : lang.hitch(this, this.networkEditSetterFct)
            });            
*/
            // NameTextBox
            DOMHelper.createTextNode("div", i18n.nameLabel, topDiv, "propertyLabel organisationEditNameLabel");
            this.nameComboBox = new FancyComboBox({
                            label : i18n.nameLabel,
                            title : this.mode != ContentWidget.Mode.SHOW?i18n.organisationEditWidgetNameLabelToolTip:"",
		        queryExpr : "*${0}*",
		     autoComplete : false,
		    dropDownClass : FancyComboBoxMenu,
        menuItemClassName : "organisationEditNameComboBoxMenuItem",
                maxLength : 80
            });
            domClass.add(this.nameComboBox.domNode, "fixedDialogWidget organisationEditNameTextBox");
            domConstruct.place(this.nameComboBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.nameComboBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.nameComboBox, true);

            // PostalAddressTextBox
            DOMHelper.createTextNode("div", i18n.addressLabel, topDiv, "propertyLabel organisationEditPostalAddressLabel");
            this.postalAddressTextBox = new SimpleTextArea({
                label : i18n.addressLabel,
                title : i18n.addressLabel,
                maxLength : 255
            });
            domClass.add(this.postalAddressTextBox.domNode, "fixedDialogWidget organisationEditPostalAddressTextBox");
            domConstruct.place(this.postalAddressTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.postalAddressTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.postalAddressTextBox, true);

            // PostalCodeTextBox
            DOMHelper.createTextNode("div", i18n.postalCodeLabel, topDiv, "propertyLabel organisationEditPostalCodeLabel");
            this.postalCodeTextBox = new TextBox({
                label : i18n.postalCodeLabel,
                title : i18n.postalCodeLabel,
                maxLength : 10
            });
            domClass.add(this.postalCodeTextBox.domNode, "fixedDialogWidget organisationEditPostalCodeTextBox");
            domConstruct.place(this.postalCodeTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.postalCodeTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.postalCodeTextBox, true);

            // LocalityNameTextBox
            DOMHelper.createTextNode("div", i18n.localityNameLabel, topDiv, "propertyLabel organisationEditLocalityNameLabel");
            this.localityNameTextBox = new TextBox({
                label : i18n.localityNameLabel,
                title : i18n.localityNameLabel,
                maxLength : 30
            });
            domClass.add(this.localityNameTextBox.domNode, "fixedDialogWidget organisationEditLocalityNameTextBox");
            domConstruct.place(this.localityNameTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.localityNameTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.localityNameTextBox, true);

            // CountrySelect
            DOMHelper.createTextNode("div", i18n.countryLabel, topDiv, "propertyLabel organisationEditCountryLabel");
            this.countrySelect = new Select({
                label : i18n.countryLabel,
                title : i18n.countryLabel
            });
            domClass.add(this.countrySelect.domNode, "fixedDialogWidget organisationEditCountrySelect");
            domConstruct.place(this.countrySelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.countrySelect, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.countrySelect, true);

            // PhoneTextBox
            DOMHelper.createTextNode("div", i18n.phoneLabel, topDiv, "propertyLabel organisationEditPhoneLabel");
            this.phoneTextBox = new TextBox({
                label : i18n.phoneLabel,
                title : i18n.phoneLabel,
                maxLength : 40
            });
            domClass.add(this.phoneTextBox.domNode, "fixedDialogWidget organisationEditPhoneTextBox");
            domConstruct.place(this.phoneTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.phoneTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));
            WidgetHelper.setMustField(this.phoneTextBox, true);

            // MobileTextBox
            DOMHelper.createTextNode("div", i18n.mobileLabel, topDiv, "propertyLabel organisationEditMobileLabel");
            this.mobileTextBox = new TextBox({
                label : i18n.mobileLabel,
                title : i18n.mobileLabel,
                maxLength : 40
            });
            domClass.add(this.mobileTextBox.domNode, "fixedDialogWidget organisationEditMobileTextBox");
            domConstruct.place(this.mobileTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.mobileTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));

            // FaxTextBox
            DOMHelper.createTextNode("div", i18n.faxLabel, topDiv, "propertyLabel organisationEditFaxLabel");
            this.faxTextBox = new TextBox({
                label : i18n.faxLabel,
                title : i18n.faxLabel,
                maxLength : 40
            });
            domClass.add(this.faxTextBox.domNode, "fixedDialogWidget organisationEditFaxTextBox");
            domConstruct.place(this.faxTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.faxTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));

            // MailTextBox
            DOMHelper.createTextNode("div", i18n.mailLabel, topDiv, "propertyLabel organisationEditMailLabel");
            this.mailTextBox = new ValidationTextBox({
                label : i18n.mailLabel,
        		validator: dojox.validate.isEmailAddress,
        		invalidMessage: i18n.noValidMailLabel,
    			maxLength : 80
            });
            domClass.add(this.mailTextBox.domNode, "fixedDialogWidget organisationEditMailTextBox");
            domConstruct.place(this.mailTextBox.domNode, topDiv);
            this.handleMailTextBoxEvents(this.mailTextBox, lang.hitch(this, this.callUpdateWidgetStateWithEvents));


            return topDiv;
        },
        
        updateWidgetState : function(omitEvents) {
            this.updateDataFromWidgets();

            WidgetHelper.updateEmptyTextBoxState(this.nameComboBox);
            WidgetHelper.updateEmptyTextBoxState(this.postalAddressTextBox);
            WidgetHelper.updateEmptyTextBoxState(this.postalCodeTextBox);
            WidgetHelper.updateEmptyTextBoxState(this.localityNameTextBox);
            WidgetHelper.updateEmptySelectState(this.countrySelect);
            WidgetHelper.updateEmptyTextBoxState(this.phoneTextBox);
            
            var disabled = this.isAsyncOperationRunning() || this.mode == ContentWidget.Mode.SHOW;
            this.nameComboBox.set("disabled", disabled);
            this.postalAddressTextBox.set("disabled", disabled);
            this.postalCodeTextBox.set("disabled", disabled);
            this.localityNameTextBox.set("disabled", disabled);
            this.countrySelect.set("disabled", disabled);
            this.phoneTextBox.set("disabled", disabled);
            this.mobileTextBox.set("disabled", disabled);
            this.faxTextBox.set("disabled", disabled);
            this.mailTextBox.set("disabled", disabled);

            var nameValid = WidgetHelper.isTextBoxValid(this.nameComboBox);
            var postalAddressValid = WidgetHelper.isTextBoxValid(this.postalAddressTextBox);
            var postalCodeValid = WidgetHelper.isTextBoxValid(this.postalCodeTextBox);
            var localityNameValid = WidgetHelper.isTextBoxValid(this.localityNameTextBox);
            var countryValid = WidgetHelper.getSelectValue(this.countrySelect) != null;
            var phoneValid = WidgetHelper.isTextBoxValid(this.phoneTextBox);
            var emailValid = this.isEmailTextBoxValid(this.mailTextBox)

            var allFieldsValid = nameValid && postalAddressValid && postalCodeValid && localityNameValid && countryValid && phoneValid && emailValid;
            if (allFieldsValid != this.allFieldsValid) {
                this.allFieldsValid = allFieldsValid;
                if (!omitEvents)
                	on.emit(this, "validStateChange");
            }

            var changed = JoinHelper.isChanged(this.oldOrganisationJoin, this.organisationJoin, DataModel.ORGANISATION_JOIN_ATTRIBUTES);
            if (changed != this.changed) {
                this.changed = changed;
                if (!omitEvents)
                	on.emit(this, "changedStateChange");
            }
        },

        setOrganisations : function(organisations) {
            var data = [];
            if (organisations) {
                for (var n = 0; n < organisations.length; n++) {
                    data.push({
                        name : NameHelper.getOrganisationName(organisations[n]),
                          id : organisations[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            var nameMemory = new Memory({
                data : data
            });
            this.nameComboBox.set("store", nameMemory);
        },        
        
		isEmailTextBoxValid : function(textBox) {
			return textBox.get("value").length == 0 || validate.isEmailAddress(textBox.get("value"))
		},
		
		handleMailTextBoxEvents : function(textBox, fct) {
			on(textBox, "change", function() { if (!textBox.get("disabled")) { fct(); }});
			on(textBox, "keyUp", function() { if (!textBox.get("disabled")) { fct(); }});			
		},		

        callUpdateWidgetStateWithEvents : function() {
            this.updateWidgetState(false);
        },

        setData : function(organisationJoin) {
            this.organisationJoin = organisationJoin;

            // Don't reset oldOrganisationJoin when we set data afterwards from updateWidgetsFromData.
            // This would disturb our ability to control button state based on the changed flag.
            if (this.oldOrganisationJoin == null) {
                this.resetOldOrganisationJoin();
            }
            this.reload();
        },

        resetOldOrganisationJoin : function() {
            this.oldOrganisationJoin = JoinHelper.clone(this.organisationJoin, DataModel.ORGANISATION_JOIN_ATTRIBUTES);            
        },
        
        reload : function() {
            this.updateWidgetsFromData();
            this.updateWidgetState();
        },

        populateCountrySelect : function() {
            this.registerAsyncOperationStarted(OrganisationEditWidget.AsyncOperation.FETCH_COUNTRIES);

            var deferred = CommonEntityHelper.getOrLoadCountries(this.applicationContext);
            deferred.then(
                lang.hitch(this, function(countries) {
                    this.registerAsyncOperationFinished(OrganisationEditWidget.AsyncOperation.FETCH_COUNTRIES);

                    var countrySelectOptions = CommonEntityHelper.getDefaultCountrySelectOptions(countries);
                    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.countrySelect, countrySelectOptions);

                    if (this.organisationJoin != null) {
                        var countryId = this.organisationJoin.organisationCountryId;
                        WidgetHelper.setSelectValue(this.countrySelect, countryId);
                    }

                    this.countriesInitialized = true;
                }),
                lang.hitch(this, function(err) {
                    log.error("Error while fetching countries, details should be recorded by handler inside CommonEntityHelper.", err);
                    this.registerAsyncOperationFinished(OrganisationEditWidget.AsyncOperation.FETCH_COUNTRIES);
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getOrLoadCountries]", err);
                    }));            
        },

        updateWidgetsFromData : function() {
            if (this.organisationJoin != null) {
                this.nameComboBox.set("value", this.organisationJoin.organisationName);
                this.postalAddressTextBox.set("value", this.organisationJoin.organisationPostalAddress);
                this.postalCodeTextBox.set("value", this.organisationJoin.organisationPostalCode);
                this.localityNameTextBox.set("value", this.organisationJoin.organisationLocalityName);
                WidgetHelper.setSelectValue(this.countrySelect, this.organisationJoin.organisationCountryId);
                this.phoneTextBox.set("value", this.organisationJoin.organisationTelephoneNumber);
                this.mobileTextBox.set("value", this.organisationJoin.organisationMobileTelephoneNumber);
                this.faxTextBox.set("value", this.organisationJoin.organisationFacsimileTelephoneNumber);
                this.mailTextBox.set("value", this.organisationJoin.organisationEmailAddress);
            }
        },

        updateDataFromWidgets : function() {
            if (this.organisationJoin != null) {
                this.organisationJoin.organisationName = this.nameComboBox.get("value");
                this.organisationJoin.organisationPostalAddress = this.postalAddressTextBox.get("value");
                this.organisationJoin.organisationPostalCode = this.postalCodeTextBox.get("value");
                this.organisationJoin.organisationLocalityName = this.localityNameTextBox.get("value");
                this.organisationJoin.organisationCountryId = WidgetHelper.getSelectValue(this.countrySelect);
                this.organisationJoin.organisationTelephoneNumber = this.phoneTextBox.get("value");
                this.organisationJoin.organisationMobileTelephoneNumber = this.mobileTextBox.get("value");
                this.organisationJoin.organisationFacsimileTelephoneNumber = this.faxTextBox.get("value");
                this.organisationJoin.organisationEmailAddress = this.mailTextBox.get("value");
            }
        }
    });

    OrganisationEditWidget.AsyncOperation = {
        FETCH_COUNTRIES : "FetchCountries"
    };
    
    return OrganisationEditWidget;
});
