define([
    "clazzes/LoginGuardRpcService",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/JobHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/util/StringHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "cdes/util/PasswordValidator",
    "cdes/util/SecurityQuestionValidator",
    "dijit/form/Button",
    "dijit/form/TextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/string",
//         "dojo/text!/cdes/svc/adminServiceWeb?smd",
    //        "dojo/text!/cdes-dojo-impl/jobStatus?smd",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
       function(
    	   LoginGuardRpcService,
    	   TinyLog,
    	   DOMHelper,
           ErrorHelper,
           JobHelper,
           WidgetHelper,
           StringHelper,
    	   ContentWidget,
    	   InfoDialog,
           PasswordValidator,
           SecurityQuestionValidator,
    	   Button,
	   	   TextBox,
    	   domClass,
    	   domConstruct,
    	   domStyle,
           ioQuery,
    	   on,
    	   declare,
    	   lang,
           string,
	   //    		 adminServiceSmd,
	   //    		 jobStatusServiceSmd,
    	   i18n
       ) {

	   var className = "at.cdes.web.challengeLogin.ChallengeLoginPage";

	   var log = new TinyLog(className);

	   var ChallengeLoginPage = declare(className, ContentWidget, {

    	   constructor : function(params) {
    		   lang.mixin(this,params);
    		   this.uuid = null;

		       this.userNameRegExp = new RegExp("^([a-z]|[A-Z])([a-z]|[A-Z]|[0-9]|_|-|\\.)*$");
		       this.securityAnswerRegExp = new RegExp("^([a-z]|[A-Z]|ö|Ö|ä|Ä|ü|Ü|ß| |[0-9]|_|-|\\.)*$");

		       this.state = ChallengeLoginPage.State.INPUT;

		       //		//this.adminService = new LoginGuardRpcService(json.parse(adminServiceSmd));
		       //    		this.jobStatusService = new LoginGuardRpcService(json.parse(jobStatusServiceSmd));

    		   this.topDiv = this.constructTopDiv();

    		   this.allFieldsValid = true;

           	   this.setData();
    	   },

    	   getWidgetId : function() {
    		   return "ChallengeLoginPage";
   	   },

    	   getDataId : function() {
    		   return null;
    	   },

    	   getContainer : function() {
    		   return this.topDiv;
    	   },

    	   constructTopDiv : function() {
    		   var topDiv = domConstruct.create("div", null, null);

    		   // Caption Bar
    		   this.captionBarDiv = this.constructCaptionBar();
    		   domClass.add(this.captionBarDiv, "challengeLoginPageCaptionBar");
    		   domConstruct.place(this.captionBarDiv, topDiv);

    		   this.constructNoDataDiv(topDiv);
		       this.constructContentDiv(topDiv);
		       this.constructFinishedDiv(topDiv);

		       //    		this.buttonDiv = this.constructButtonDiv();
		       //    		domClass.add(this.buttonDiv, "importAdminPageButtonDiv");
		       //    		domConstruct.place(this.buttonDiv, topDiv);

    		   return topDiv;
    	   },

    	   constructCaptionBar : function() {
    		   // Caption Bar consisting of caption and context bar right of the caption
    		   var captionBarDiv = domConstruct.create("div", null, null);

    		   // Caption
    		   this.captionDiv = DOMHelper.createTextNode("h1", i18n.challengeLoginPageCaption, captionBarDiv, "challengeLoginPageCaption");

    		   return captionBarDiv;
    	   },

    	   constructNoDataDiv : function(topDiv) {
    		   this.noDataDiv = DOMHelper.createTextNode("div", i18n.challengeLoginPageNoDataFound, topDiv, "invisible");
    	   },

	       constructContentDiv : function(topDiv) {
		       this.contentDiv = domConstruct.create("div", null, topDiv);
		       domClass.add(this.contentDiv, "fixedDialogWidget challengeLoginContentDiv visible");
		       domConstruct.place(this.contentDiv, topDiv);

		       DOMHelper.createTextNode("div", i18n.challengeLoginLoginSectionLabel, this.contentDiv, "fixedDialogWidget challengeLoginLoginSectionLabel");

		       DOMHelper.createTextNode("div", i18n.challengeLoginUserNameLabel, this.contentDiv, "propertyLabel challengeLoginUserNameLabel");
		       this.userNameTextBox = new TextBox({
		           label : i18n.challengeLoginUserNameLabel,
		           title : i18n.challengeLoginUserNameToolTip
		       });
		       domClass.add(this.userNameTextBox.domNode, "fixedDialogWidget challengeLoginUserNameTextBox");
		       domConstruct.place(this.userNameTextBox.domNode, this.contentDiv);
		       WidgetHelper.handleTextBoxEvents(this.userNameTextBox, lang.hitch(this, this.updateWidgetState));

		       DOMHelper.createTextNode("div", i18n.challengeLoginPasswordLabel, this.contentDiv, "propertyLabel challengeLoginPasswordLabel");
		       this.passwordTextBox = new TextBox({
		           label : i18n.challengeLoginPasswordLabel,
		           title : i18n.challengeLoginPasswordToolTip,
		           type : "password"
		       });
		       domClass.add(this.passwordTextBox.domNode, "fixedDialogWidget challengeLoginPasswordTextBox");
		       domConstruct.place(this.passwordTextBox.domNode, this.contentDiv);
		       WidgetHelper.handleTextBoxEvents(this.passwordTextBox, lang.hitch(this, this.updateWidgetState));

		       DOMHelper.createTextNode("div", i18n.challengeLoginPasswordTwoLabel, this.contentDiv, "propertyLabel challengeLoginPasswordTwoLabel");
		       this.passwordTwoTextBox = new TextBox({
		           label : i18n.challengeLoginPasswordTwoLabel,
		           title : i18n.challengeLoginPasswordTwoToolTip,
		           type : "password"
		       });
		       domClass.add(this.passwordTwoTextBox.domNode, "fixedDialogWidget challengeLoginPasswordTwoTextBox");
		       domConstruct.place(this.passwordTwoTextBox.domNode, this.contentDiv);
		       WidgetHelper.handleTextBoxEvents(this.passwordTwoTextBox, lang.hitch(this, this.updateWidgetState));

		       DOMHelper.createTextNode("div", i18n.challengeLoginSecurityQuestionSectionLabel, this.contentDiv, "fixedDialogWidget challengeLoginSecurityQuestionSectionLabel");

		       DOMHelper.createTextNode("div", i18n.challengeLoginPasswordQuestionLabel, this.contentDiv, "propertyLabel challengeLoginSecurityQuestionLabel");
		       this.questionTextBox = new TextBox({
		           label : i18n.challengeLoginPasswordQuestionLabel,
		           title : i18n.challengeLoginPasswordQuestionToolTip
		       });
		       domClass.add(this.questionTextBox.domNode, "fixedDialogWidget challengeLoginSecurityQuestionTextBox");
		       domConstruct.place(this.questionTextBox.domNode, this.contentDiv);
		       WidgetHelper.handleTextBoxEvents(this.questionTextBox, lang.hitch(this, this.updateWidgetState));

		       DOMHelper.createTextNode("div", i18n.challengeLoginPasswordAnswerLabel, this.contentDiv, "propertyLabel challengeLoginSecurityAnswerLabel");
		       this.answerTextBox = new TextBox({
		           label : i18n.challengeLoginPasswordAnswerLabel,
		           title : i18n.challengeLoginPasswordAnswerToolTip
		       });
		       domClass.add(this.answerTextBox.domNode, "fixedDialogWidget challengeLoginSecurityAnswerTextBox");
		       domConstruct.place(this.answerTextBox.domNode, this.contentDiv);
		       WidgetHelper.handleTextBoxEvents(this.answerTextBox, lang.hitch(this, this.updateWidgetState));

		       // Hint
		       this.hintLine = domConstruct.create("div", null, null);
		       domClass.add(this.hintLine, "fixedDialogWidget challengeLoginHintLine invisible");
		       domConstruct.place(this.hintLine, this.contentDiv);

		       this.hintIcon = domConstruct.create("div", null, this.hintLine);
	    	   domClass.add(this.hintIcon, "challengeLoginHintIcon clazzesWarnIcon32");

	    	   // Hint Div
	    	   this.hintSpan = DOMHelper.createTextNode("span", "", this.hintLine, "challengeLoginHintSpan");

    		   this.requestButton = new Button({
    		       label : i18n.challengeLoginRequestCertificateButtonLabel,
    		       title : i18n.challengeLoginRequestCertificateButtonToolTip,
    		       onClick : lang.hitch(this, this.initializeRequestCertificate)
    		   });
    		   domClass.add(this.requestButton.domNode, "fixedDialogWidget challengeLoginRequestButton");
    		   domConstruct.place(this.requestButton.domNode, this.contentDiv);
	       },

	       constructFinishedDiv : function(topDiv) {
		       this.finishedDiv = domConstruct.create("div", null, null);
		       domClass.add(this.finishedDiv, "fixedDialogWidget challengeLoginFinishedDiv invisible");
		       domConstruct.place(this.finishedDiv, topDiv);

		       this.finishedStateDiv = domConstruct.create("h4", null, null);
		       domClass.add(this.finishedStateDiv, "fixedDialogWidget challengeLoginFinishedStateDiv");
		       domConstruct.place(this.finishedStateDiv, this.finishedDiv);

		       var sequenceList = domConstruct.create("ol", null, null);
		       domClass.add(sequenceList, "fixedDialogWidget challengeLoginSequenceList");
		       domConstruct.place(sequenceList, this.finishedDiv);

		       var pdfNode = domConstruct.create("li", null, null);
		       domConstruct.place(pdfNode, sequenceList);

		       this.pleasePrintNode = DOMHelper.createTextNode("span", i18n.challengeLoginPleasePrintPdfLabel, pdfNode, "challengeLoginPleasePrintPdfLabel");
//    		   this.generatePdfButton = this.constructGeneratePdfButton();
//		       domConstruct.place(this.generatePdfButton.domNode, pdfNode);
/*
		       var contactList = domConstruct.create("ul", null, null);
		       domClass.add(contactList, "challengeLoginContactList");
		       domConstruct.place(contactList, pdfNode);

		       this.facsimileDiv = DOMHelper.createTextNode("li", "", contactList, null);
		       this.mailDiv = DOMHelper.createTextNode("li", "", contactList, null);
*/
		       this.challengeLoginReceiveLabel = DOMHelper.createTextNode("li", i18n.challengeLoginReceiveLabel, sequenceList, null);
		       DOMHelper.createTextNode("li", i18n.challengeLoginLoginLabel, sequenceList, "challengeLoginLoginLabel");
	       },

    	   setData : function() {
    		   this.reload();
    	   },
/*
    	   constructGeneratePdfButton : function() {
    		   var generatePdfButton = new Button({
                   label : i18n.challengeLoginPdfLabel,
		           showLabel : false,
                   title : i18n.challengeLoginPleasePrintPdfLabel,
		           onClick : lang.hitch(this, function() {
            		   this.doGeneratePdf();
		           }),
		           iconClass : "exportToPdfButton",
		           "class" : "cdesWebButton17x18 gridButton",
		           _destroyOnRemove : true
       	 	   });
               domClass.add(generatePdfButton.domNode, "challengeLoginGeneratePdfButton");
    		   return generatePdfButton;
    	   },

           doGeneratePdf : function() {
    		   var challengeLoginService = this.applicationContext.getService("challengeLoginService");

    		   this.registerAsyncOperationStarted(ChallengeLoginPage.AsyncOperation.GENERATE_PDF);
			   challengeLoginService.triggerGenerateCertificateRequestPdf().then(lang.hitch(this, function(jobId) {
				   JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					   var parameterString = ioQuery.objectToQuery({
						   jobId : jobId
					   });
					   return "/cdes-dojo-impl/challengeDownload?" + parameterString;
				   });

				   this.registerAsyncOperationFinished(ChallengeLoginPage.AsyncOperation.GENERATE_PDF);
			   }), lang.hitch(this, function(err){
   				   ErrorHelper.processAsyncError({
                       err : err,
                       widget : this,
                       asyncOperation : ChallengeLoginPage.AsyncOperation.GENERATE_PDF,
                       opName : "triggerGenerateCertificateRequestPdf",
                       message : i18n.challengeLoginGeneratePdfFailed
   				   });
			   }))
                   .otherwise(lang.hitch(this, function(err) {
				       log.error("Handling the results of executing triggerGenerateCertificateRequestPdf failed", err);
			       }));
           },
*/

    	   reload : function() {
    		   var challengeLoginService = this.applicationContext.getService("challengeLoginService");

    		   // If the previous search still runs, cancel it
    		   if (this.deferred != null) {
    			   //this.deferred.cancel();
    			   delete this.deferred;
    		   }

    		   // Trigger async search request
    		   this.deferred = challengeLoginService.getCertificateRequestPersonJoinByChallengeOne();

    		   // Update button state etc.
    		   this.registerAsyncOperationStarted(ChallengeLoginPage.AsyncOperation.GET_DATA);
    	       this.deferred.then(
		           lang.hitch(this, function(certficateRequestPersonInfo) {

		        	   this.loaded = true;
			           this.certificateRequestPersonJoin = certficateRequestPersonInfo.certificateRequestPersonJoin;
			           this.hasUserPolicyPath = certficateRequestPersonInfo.hasUserPolicyPath;
                       this.securityAnswerMinLength = certficateRequestPersonInfo.securityAnswerMinLength;
                       this.passwordMinLength = certficateRequestPersonInfo.passwordMinLength;
					   this.updateWidgetsFromData();

    			       delete this.deferred;
    	    		   this.registerAsyncOperationFinished(ChallengeLoginPage.AsyncOperation.GET_DATA);
   		           }),
   		           lang.hitch(this, function(err) {
			           delete this.deferred;

   			           ErrorHelper.processAsyncError({
                           err : err,
                           widget : this,
			               asyncOperation : ChallengeLoginPage.AsyncOperation.GET_DATA,
                           opName : "getPersonByChallengeOne",
                           message : i18n.challengeLoginFetchPersonDataFailed
   			           });
		           })
    		   ).otherwise(lang.hitch(this, function(err) {
    		       log.error("Error while processing the results of calling getPersonByChallengeOne: ", err);
    		   }));
    	   },

           initializeRequestCertificate : function() {
			   if (this.hasAlreadyValidLogin){
		            InfoDialog.showQuestion({
		                  title : i18n.challengeLoginRequestCertificateButtonLabel,
		                message : i18n.challengeLoginUserNameAlreadyExistsWarning,
		                buttons : [
		                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
		                        this.requestCertificate();
		                    })},
		                    { type : InfoDialog.Button.NO }
		                ]
		            });

			   }else
			   		this.requestCertificate();

           },

           requestCertificate : function() {
	           var userName = this.userNameTextBox.get("value");
	           var password = this.passwordTextBox.get("value");
	           var passwordTwo = this.passwordTwoTextBox.get("value");
	           var question = this.questionTextBox.get("value");
	           var answer = this.answerTextBox.get("value");

	           if (password != passwordTwo) {
		           throw new Error("Something is very string, equality of the two entered passwords should be checked by updateWidgetState; why was the button active?");
	           }

    	       var challengeLoginService = this.applicationContext.getService("challengeLoginService");
    	       var requestDeferred = challengeLoginService.requestCertificate(userName, password, question, answer);

    	       // Update button state etc.
    	       this.registerAsyncOperationStarted(ChallengeLoginPage.AsyncOperation.REQUEST);
    	       requestDeferred.then(
		           lang.hitch(this, function(certificateRequestResult) {
                           if (certificateRequestResult.result != null) {
                              window.alert(certificateRequestResult.result);
                           } else {
         		      this.reload();
                           }
    	    	       this.registerAsyncOperationFinished(ChallengeLoginPage.AsyncOperation.REQUEST);
   		           }),
   		           lang.hitch(this, function(err) {
                               var i18nMessage = i18n.challengeLoginRequestFailed;

   		               ErrorHelper.processAsyncError({
                           err : err,
                           widget : this,
			               asyncOperation : ChallengeLoginPage.AsyncOperation.REQUEST,
                           opName : "requestCertificate",
                           message : i18nMessage
   		               });
		           })
    	       ).otherwise(lang.hitch(this, function(err) {
    		       log.error("Error while processing the results of calling requestCertificate: ", err);
    	       }));
           },

    	   updateWidgetState : function() {
	           if (this.certificateRequestPersonJoin == null) {
	        	   if (this.loaded) {
	        		   this.state = ChallengeLoginPage.State.NO_DATA;
	        	   } else {
	        		   this.state = ChallengeLoginPage.State.NOT_YET_LOADED;
	        	   }
	           } else if (this.certificateRequestPersonJoin.certificateRequestRequestType == "Invitation") {
		           this.state = ChallengeLoginPage.State.INPUT;
	           } else if (this.certificateRequestPersonJoin.certificateRequestRequestType == "Request") {
		           this.state = ChallengeLoginPage.State.JUST_FINISHED;
	           }

    	       var operationRunning = this.isAsyncOperationRunning();

	           var userName = this.userNameTextBox.get("value");
	           var password = this.passwordTextBox.get("value");
	           var passwordTwo = this.passwordTwoTextBox.get("value");
	           var question = this.questionTextBox.get("value");
	           var answer = this.answerTextBox.get("value");

	           DOMHelper.setInnerText(this.captionDiv, string.substitute(i18n.challengeLoginPageCaption, {
	                givenName : this.certificateRequestPersonJoin != null && !StringHelper.isEmpty(this.certificateRequestPersonJoin.createdForPersonGivenName) ? this.certificateRequestPersonJoin.createdForPersonGivenName : "",
	                  surName : this.certificateRequestPersonJoin != null && !StringHelper.isEmpty(this.certificateRequestPersonJoin.createdForPersonSurName) ? this.certificateRequestPersonJoin.createdForPersonSurName : ""
	           }));

	           domClass.replace(this.contentDiv, "invisible", "visible");
	           domClass.replace(this.finishedDiv, "invisible", "visible");
	           domClass.replace(this.noDataDiv, "invisible", "visible");
	           if (this.state == ChallengeLoginPage.State.INPUT) {
		           domClass.replace(this.contentDiv, "visible", "invisible");
	           } else if (this.state == ChallengeLoginPage.State.NO_DATA) {
		           domClass.replace(this.noDataDiv, "visible", "invisible");
	           } else if (this.state == ChallengeLoginPage.State.JUST_FINISHED) {
		           domClass.replace(this.finishedDiv, "visible", "invisible");
		           DOMHelper.setInnerText(this.finishedStateDiv, i18n.challengeLoginJustFinishedState);
/*
		           var facsimile = this.certificateRequestPersonJoin.createdByOrgPersonFacsimileTelephoneNumber;
		           if (facsimile == null || facsimile.length == 0)
		           		facsimile = "-";
		           DOMHelper.setInnerText(this.facsimileDiv, string.substitute(i18n.challengeLoginFacsimileLabel, {
		               facsimile : facsimile
		           }));
		           var mail = this.certificateRequestPersonJoin.createdByOrgPersonEmailAddress;
		           if (mail == null || mail.length == 0)
		           		mail = "-";
		           DOMHelper.setInnerText(this.mailDiv, string.substitute(i18n.challengeLoginMailLabel, {
		               mail : mail
		           }));
*/
	           }

               const passwordValidationError = PasswordValidator.validate(password, this.passwordMinLength);
               const answerValidationError = SecurityQuestionValidator.validateAnswer(answer, this.securityAnswerMinLength);

	           var hintText = null;
			   var passwordTooShortWarning = string.substitute(i18n.challengeLoginPasswordTooShortWarning, {
	                		 passwordMinLength : !StringHelper.isEmpty(this.passwordMinLength) ? this.passwordMinLength : "",
	           });
	       if (userName == null || userName.length == 0 ) {
	           hintText = i18n.challengeLoginNoUserNameWarning;
	       } else if (userName == "root") {
	           hintText = i18n.challengeLoginRootWarning;
	       } else if (!userName.match(this.userNameRegExp)) {
	           hintText = i18n.challengeLoginIllegalUserNameWarning;
	       } else if (passwordValidationError !== "OK") {
                   switch (passwordValidationError) {
                   case "MISSING":
	               hintText = i18n.challengeLoginPasswordMissingWarning;
                       break;
                   case "TOO_SHORT":
	               hintText = passwordTooShortWarning;
                       break;
                   case "ILLEGAL_CHARS":
                       hintText = i18n.passwordIllegalCharsWarning;
                       break;
                   case "LACKING_DIVERSITY":
	               hintText = i18n.challengeLoginPasswordLackingDiversityWarning;
                       break;
                   default:
                       break;
                   }
	       } else if (password != passwordTwo) {
	        	   hintText = i18n.challengeLoginPasswordsDontMatchWarning;
	           } else if (question == null || question.length == 0) {
	        	   hintText = i18n.challengeLoginNoQuestionWarning;
               } else if (answerValidationError !== "OK") {
                   hintText = SecurityQuestionValidator.getAnswerMessage(answerValidationError, this.securityAnswerMinLength);
               }
	           if (this.state == ChallengeLoginPage.State.JUST_FINISHED)
	        	   hintText = null;

	           DOMHelper.setInnerText(this.hintSpan, hintText);

	           var allFieldsValid = (hintText == null);


/*	           var allFieldsValid = userName != null && userName.length > 0
		               && userName != "root"
		               && userName.match(this.userNameRegExp)
		               && (password == passwordTwo)
		               && password != null && password.length >= 6
		               && question != null && question.length >= 1 && answer != null && answer.length >= 1
		               && answer.match(this.securityAnswerRegExp);*/

		       if (allFieldsValid || this.state == ChallengeLoginPage.State.JUST_FINISHED || this.state == ChallengeLoginPage.State.NOT_YET_LOADED) {
		    	   domClass.replace(this.hintLine, "invisible", "visible");
		       } else {
		           domClass.replace(this.hintLine, "visible", "invisible");
		       }

	           this.requestButton.set("disabled", operationRunning || !allFieldsValid);
    	   },

           updateWidgetsFromData : function() {
//			   if (this.hasUserPolicyPath){
					DOMHelper.setInnerText(this.pleasePrintNode, i18n.challengeLoginHasUserPolicyPathPleasePrintPdfLabel);
					DOMHelper.setInnerText(this.challengeLoginReceiveLabel, i18n.challengeLoginHasUserPolicyPathReceiveLabel);
					// delete the following
//					this.generatePdfButton.domNode.remove();
//		       		this.facsimileDiv.remove();
//		       		this.mailDiv.remove();
//			   }
   			   this.hasAlreadyValidLogin = false;
	           if (this.certificateRequestPersonJoin.createdForPersonLogin != null && this.certificateRequestPersonJoin.createdForPersonPassword != null){
	           		this.hasAlreadyValidLogin = true;
	           		this.userNameTextBox.set("value", this.certificateRequestPersonJoin.createdForPersonLogin);
	           }
	           if (this.certificateRequestPersonJoin.createdForPersonQuestion != null)
	           		this.questionTextBox.set("value", this.certificateRequestPersonJoin.createdForPersonQuestion);
           },

    	   resize : function(newSize) {
		       // Account for margin = 8 of body
		       domStyle.set(this.topDiv, "width", (newSize.w - 16) + "px");
		       domStyle.set(this.topDiv, "height", (newSize.h - 16 - 4) + "px");
	       }
    });

	    ChallengeLoginPage.AsyncOperation = {
  	            GET_DATA : "GetData",
		         REQUEST : "Request",
            GENERATE_PDF : "GeneratePdf"
	    };

	   ChallengeLoginPage.State = {
	       NOT_YET_LOADED : "NotYetLoaded",
	       NO_DATA : "NoData",
	       INPUT : "Input",
	       JUST_FINISHED : "JustFinished"
	   };

	   return ChallengeLoginPage;
});
