/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/


define([ "cdes/core/CdesVoc",
        "cdes/planning/workflow/WorkflowActivityResultListWidget",
        "cdes/util/SearchPageHelper",
        "cdes/widget/msp/MspTreeUrlChooseDialog",
        "cdes/widget/util/WidgetFactory",
        "clazzes/ClazzesVoc",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/JobHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/EditDialog",
        "clazzes/widgets/layout/FancyContentPane",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/CheckBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/on",
        "dojo/_base/lang",
        "dojo/store/Memory",
		"dojo/string",
        "require",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
         WorkflowActivityResultListWidget,
         SearchPageHelper,
         MspTreeUrlChooseDialog,
         WidgetFactory,
         ClazzesVoc,
         TinyLog,
         FancyButton,
         topic,
         DOMHelper,
         ErrorHelper,
         JobHelper,
         WidgetHelper,
         ChooseDialog,
         ContentWidget,
         EditDialog,
         FancyContentPane,
         InfoDialog,
         CheckBox,
         domClass,
         domConstruct,
         domStyle,
         ioQuery,
         on,
         lang,
         Memory,
		 string,
         require,
         i18n) {

    var className = "at.cdes.web.planning.util.PlanningNotificationHelper";

    var log = new TinyLog(className);

    var PlanningNotificationHelper = {

        handleProjectSelectChange : function(projectSelect, planningNotificationComboBox, projectIdToPlanningNotifications, lastProjectId, preserveDocument) {
            // summary:
            //     Given a Select containing projects (with the project id as value), a ComboBox containing planning notifications
            //     (with their ids as id, and their titles as name), this function populates the ComboBox with the
            //     planning notifications matching the currently selected project.

            var projectId = WidgetHelper.getSelectValue(projectSelect);

            if (projectId != lastProjectId) {
                var data = [];

                if (projectId == null || projectId == CdesVoc.WHATEVER) {
                    // If no project is selected, or for whatever obscure reasons a unknown project, simply show all PlanningNotifications

                    for (var p in projectIdToPlanningNotifications) {
                        for (var n = 0; projectIdToPlanningNotifications[p] != null && n < projectIdToPlanningNotifications[p].length; n++) {
                            var planningNotification = projectIdToPlanningNotifications[p][n];
                            data.push({
                                  id : planningNotification.id,
                                name : planningNotification.title
                            });
                        }
                    }
                } else {
                    var planningNotifications = projectIdToPlanningNotifications[projectId];
                    for (var n = 0; planningNotifications && n < planningNotifications.length; n++) {
                        var planningNotification = planningNotifications[n];
                        data.push({
                              id : planningNotification.id,
                            name : planningNotification.title
                        });
                    }
                }

                data.sort(function(dataOne, dataTwo) {
                    if (dataOne.name == null) {
                        return 1;
                    } else if (dataTwo.name == null) {
                        return -1;
                    } else {
                        return dataOne.name.localeCompare(dataTwo.name);
                    }
                });
                data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });

                var planningNotificationMemory = new Memory({
                    data : data
                });
                planningNotificationComboBox.set("store", planningNotificationMemory);
                if (preserveDocument == null || preserveDocument == false) {
                    planningNotificationComboBox.set("value", []);
                }
            }

            return projectId;
        },

        handleProjectSelectChangeProjectParticipation : function(projectSelect, positionPersonSelect, projectIdToProjectParticipationJoins, lastProjectId, preserveValues) {
            // summary:
            //     Given a Select containing projects (with the project id as value), a SelectBox containing ProjectParticipationJoins
            //     (with their ids as id, and their titles as name), this function populates the SelectBox with the
            //     ProjectParticipationJoins matching the currently selected project.

            var projectId = WidgetHelper.getSelectValue(projectSelect);

            if (projectId != lastProjectId) {
 				var participations = [];
                if (projectId == null || projectId == CdesVoc.WHATEVER) {
                    // If no project is selected, or for whatever obscure reasons a unknown project, simply show all ProjectParticipationJoins
                    for (var p in projectIdToProjectParticipationJoins) {
                        for (var n = 0; projectIdToProjectParticipationJoins[p] != null && n < projectIdToProjectParticipationJoins[p].length; n++) {
                            var join = projectIdToProjectParticipationJoins[p][n];
							var label = string.substitute(i18n.projectParticipantNameOrganisationFirstwComment, {
								organisationName : join.organisationName,
								personGivenName : join.personGivenName,
								personSurName : join.personSurName,
			   	 				projectParticipationComment : (join.projectParticipationComment!=null && join.projectParticipationComment.length>0)?(" - "+join.projectParticipationComment):""
							});
							label += " [" + join.cdesRoleName + "] - " + join.projectName;
			    participations.push({ label : label, value : join.projectParticipantId,
                                                  orgPersonId : join.organisationPersonId });
                        }
                    }
                } else {
	                var participationJoins = projectIdToProjectParticipationJoins[projectId];
					for (var n = 0; n < participationJoins.length; n++) {
						var join = participationJoins[n];
						var label = string.substitute(i18n.projectParticipantNameOrganisationFirstwComment, {
							organisationName : join.organisationName,
							personGivenName : join.personGivenName,
							personSurName : join.personSurName,
		   	 				projectParticipationComment : (join.projectParticipationComment!=null && join.projectParticipationComment.length>0)?(" - "+join.projectParticipationComment):""
						});
						label += " [" + join.cdesRoleName + "]";
					    participations.push({ label : label, value : join.projectParticipantId,
                                                                  orgPersonId : join.organisationPersonId });
					}
				}
	            if (participations != null){
		            participations.sort(function(dataOne, dataTwo) {
		                if (dataOne.label == null) {
		                    return 1;
		                } else if (dataTwo.label == null) {
		                    return -1;
		                } else {
		                    return dataOne.label.localeCompare(dataTwo.label);
		                }
		            });
				}
				options = [{ label : i18n.whatever, value : CdesVoc.WHATEVER }];
				options = options.concat(participations);

                positionPersonSelect.set("options", options);

                if (preserveValues == null || preserveValues == false) {
                    positionPersonSelect.set("value", []);
                }
            }

            return projectId;
        },

        processProjectChange : function(params) {
            // summary:
            //     Adapts the given projectSelect to a possibly changed projectIdToProject map (which defines
            //     which projects the Select is supposed to offer).  Tries to keep the previously selected
            //     project, if possible.
            //     The aim of this function is mainly handling changes of the network selected in the context
            //     (only projects in that network will be offered)

            var projectSelect = params.projectSelect;
            var projectIdToProject = params.projectIdToProject;
            var initialProjectId = params.initialProjectId;
            var addWhateverOption = params.addWhateverOption;
            var noWhateverDefault = params.noWhateverDefault;

            var oldProjectId = projectSelect.get("value");
            if (oldProjectId != null && oldProjectId == "") {
                oldProjectId = null;
            }

            var oldProjectIdStillValid = false;
            var options = [];
            if (addWhateverOption) {
                oldProjectIdStillValid |= (oldProjectId == CdesVoc.WHATEVER);
                options.push({ label : i18n.whatever, value : CdesVoc.WHATEVER });
            }
            for (var id in projectIdToProject) {
                oldProjectIdStillValid |= (oldProjectId == id);
                options.push({ value : id, label : '(' + projectIdToProject[id].code + ') ' + projectIdToProject[id].name});
            }

            options.sort(function(optionOne, optionTwo) {
                if (optionOne.value == CdesVoc.WHATEVER) {
                    return -1;
                } else if (optionTwo.value == CdesVoc.WHATEVER) {
                    return 1;
                } else {
                    return optionOne.label.localeCompare(optionTwo.label);
                }
            });

            var defaultValue = null;
            for (var n = 0; n < options.length; n++) {
                if (options[n].value != CdesVoc.WHATEVER || !noWhateverDefault) {
                    defaultValue = options[n].value;
                    break;
                }
            }

            projectSelect.reset();
            projectSelect.set("options", options);

            if ((initialProjectId != null && initialProjectId in projectIdToProject) || (initialProjectId == CdesVoc.WHATEVER && !noWhateverDefault)) {
                projectSelect.set("value", initialProjectId);
            } else if (oldProjectIdStillValid) {
                projectSelect.set("value", oldProjectId);
            } else if (defaultValue != null) {
                projectSelect.set("value", defaultValue);
            } else {
                projectSelect.set("value", null);
                // Caution, hack to work around the Dojo bug preventing the removal of the selected value, once all options are removed.
                // See https://bugs.dojotoolkit.org/ticket/17081 (as of March 2017 in state "Closed / Patch welcome...")
                projectSelect._setDisplay("");
            }
        },

        createEmptyPlanningNotificationOrderJoin : function(idToStatutoryDuty) {
            var defaultStatutoryDutyId = null;
            for (var id in this.idToStatutoryDuty) {
                if (this.idToStatutoryDuty[id].name != null && this.idToStatutoryDuty[id].name.indexOf("Keine") != -1) {
                    defaultStatutoryDutyId = id;
                    break;
                }
            }

            var orderJoin = {
                                 planningNotificationOrderText : "",
                     planningNotificationOrderDocumentPosition : "",
                  planningNotificationOrderAuthorizedInspector : "",
                              planningNotificationOrderComment : "",
                         planningNotificationOrderSerialNumber : null,
                         planningNotificationOrderDocumentPage : "",
                               planningNotificationOrderSource : "",
                      planningNotificationOrderSubmitAuthority : false,
                      planningNotificationOrderStatutoryDutyId : defaultStatutoryDutyId,
                    planningNotificationOrderStatutoryDutyFrom : null,
                      planningNotificationOrderStatutoryDutyTo : null,
                planningNotificationOrderStatutoryDutyInterval : null,
                planningNotificationOrderStatutoryDutyLeadTime : null,
                 planningNotificationOrderStatutoryDutyExpired : false,
                                              personInChargeId : null,
                                                 subjectAreaId : null,
                                                     siteTypes : []
            };

            return orderJoin;
        },

        getPlanningNotificationOrderForSave : function(orderJoin, mode) {
            var planningNotificationOrder = {
                       workflowEntityId : orderJoin.planningNotificationOrderWorkflowEntityId,
                 planningNotificationId : orderJoin.planningNotificationId,
                                   text : orderJoin.planningNotificationOrderText,
                       documentPosition : orderJoin.planningNotificationOrderDocumentPosition,
                    authorizedInspector : orderJoin.planningNotificationOrderAuthorizedInspector,
                                comment : orderJoin.planningNotificationOrderComment,
                           serialNumber : orderJoin.planningNotificationOrderSerialNumber,
                           documentPage : orderJoin.planningNotificationOrderDocumentPage,
                                 source : orderJoin.planningNotificationOrderSource,
                environmentallyRelevant : orderJoin.planningNotificationOrderEnvironmentallyRelevant,
                        submitAuthority : orderJoin.planningNotificationOrderSubmitAuthority,
                        statutoryDutyId : orderJoin.planningNotificationOrderStatutoryDutyId,
                      statutoryDutyFrom : orderJoin.planningNotificationOrderStatutoryDutyFrom,
                        statutoryDutyTo : orderJoin.planningNotificationOrderStatutoryDutyTo,
                  statutoryDutyInterval : orderJoin.planningNotificationOrderStatutoryDutyInterval,
                  statutoryDutyLeadTime : orderJoin.planningNotificationOrderStatutoryDutyLeadTime,
                   statutoryDutyExpired : orderJoin.planningNotificationOrderStatutoryDutyExpired,
                          exportedToMsp : orderJoin.planningNotificationOrderExportedToMsp,
                       personInChargeId : orderJoin.personInChargeId,
                          subjectAreaId : orderJoin.subjectAreaId
            };

            if (mode == ContentWidget.Mode.CREATE) {
                planningNotificationOrder.planningNotificationId = orderJoin.planningNotificationId;
            }

            return planningNotificationOrder;
        },

        saveOrUpdatePlanningNotificationOrder : function(params) {
            var applicationContext = params.applicationContext;
            var widget = params.widget;
            var mode = params.mode;
            var asyncOperation = params.asyncOperation;
            var orderJoin = params.orderJoin;
            var callbackFct = params.callbackFct;

            var planningNotificationOrder = PlanningNotificationHelper.getPlanningNotificationOrderForSave(orderJoin, mode);
            var invalidated = orderJoin.workflowEntityInvalidated;
            var tagIds = [];
            for (var n = 0; orderJoin.tags != null && n < orderJoin.tags.length; n++) {
                tagIds.push(orderJoin.tags[n].id);
            }

            var siteTypeIds = [];
            for (var n = 0; orderJoin.siteTypes != null && n < orderJoin.siteTypes.length; n++) {
                siteTypeIds.push(orderJoin.siteTypes[n].id);
            }

            var referenceIds = [];
            for (var n = 0; orderJoin.referenceInfos != null && n < orderJoin.referenceInfos.length; n++) {
                referenceIds.push(orderJoin.referenceInfos[n].planningNotificationOrder.workflowEntityId);
            }

            var planningNotificationService = applicationContext.getService("planningNotificationService");
            widget.registerAsyncOperationStarted(asyncOperation);

            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
            planningNotificationService.saveOrUpdatePlanningNotificationOrder(organisationPersonId, planningNotificationOrder, invalidated, tagIds, siteTypeIds, referenceIds).then(
                lang.hitch(this, function(workflowEntityId) {
                    widget.registerAsyncOperationFinished(asyncOperation);

                    topic.publish("message/ok", i18n.planningNotificationOrderEditSaveSuccessful);

                    callbackFct(workflowEntityId);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : widget,
                        asyncOperation : asyncOperation,
                                opName : "saveOrUpdatePlanningNotificationOrder",
                               message : i18n.planningNotificationOrderEditSaveFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [saveOrUpdatePlanningNotificationOrder]", err);
                    }));
        },

        openReviewProtocolInDialog : function(params) {
            var workflowEntityId = params.workflowEntityId;
            var applicationContext = params.applicationContext;

            require(["cdes/planning/task/ReviewProtocolPage"], function(ReviewProtocolPage) {
                var contentWidget = new ReviewProtocolPage({
                    applicationContext : applicationContext,
                                    id : workflowEntityId
                });

                var editDialog = new EditDialog({
                    contentWidget : contentWidget,
                    defaultWidth  : 1200,
                    defaultHeight : 600,
                            title : i18n.workflowReviewProtocolPageCaption,
                          buttons : [ { type : ClazzesVoc.Button.CLOSE, noTitle : true } ]
                });

                editDialog.setData({
                });

                editDialog.show();

                on(editDialog, "dialogClosed", function() {
                    contentWidget.destroy();
                });

                on(contentWidget, "finished", lang.hitch(this, function() {
                    editDialog.destroy();
                    contentWidget.destroy();
                }));

            });
        },

        renderReferenceCell : function(referenceInfos, refWidget, referenceDestination) {
            var referenceDiv = domConstruct.create("div", null, null);

            var referenceOrders = [];

            for (var n = 0; n < referenceInfos.length; n++) {
                var referenceInfo = referenceInfos[n];
                var referenceOrder = referenceInfo.planningNotificationOrder;
                referenceOrder.workflowEntityInvalidated = !!referenceInfo.workflowEntity.invalidated;
                referenceOrder._followReferenceBlocked = (referenceInfo.planningNotification.id == null);
                referenceOrders.push(referenceOrder);
            }

            referenceOrders.sort(function(orderOne, orderTwo) {
                return (orderOne.serialNumber != null ? orderOne.serialNumber : 0) - (orderTwo.serialNumber != null ? orderTwo.serialNumber : 0);
            });

            for (var n = 0; n < referenceOrders.length; n++) {
                var referenceOrder = referenceOrders[n];
                var link = domConstruct.create("span", { title : i18n.planningNotificationOrderReferenceLinkToolTip }, null);

                domClass.add(link, "pseudoLink");
                if (referenceOrder.workflowEntityInvalidated) {
                    domClass.add(link, "pseudoLinkInvalidated");
                }

                DOMHelper.setInnerText(link, referenceOrder.serialNumber);

                domConstruct.place(link, referenceDiv);

                PlanningNotificationHelper.followReferenceLink(link, refWidget, referenceDestination, referenceOrder);
            }

            return referenceDiv;
        },

        followReferenceLink : function(link, refWidget, referenceDestination, referenceOrder) {
            on(link, "click", lang.hitch(refWidget, function() {
                if (referenceOrder._followReferenceBlocked) {
                    InfoDialog.showError({
                          title : i18n.privilegeMissingDialogCaption,
                        message : i18n.planningNotificationOrderReferenceNoFollowPrivilege
                    });
                } else if (referenceDestination == "ReviewProtocol") {
                    PlanningNotificationHelper.openReviewProtocolInDialog({
                          workflowEntityId : referenceOrder.workflowEntityId,
                        applicationContext : refWidget.applicationContext
                    });
                } else {
                    this.applicationContext.setPage("planningNotificationOrderEdit",
                                                    { mode : ContentWidget.Mode.EDIT, id : referenceOrder.workflowEntityId },
                                                    { backPage : refWidget.backPage, backParams : refWidget.backParams });
                }
            }));
        },

        getStepWidget : function(stepWidgets, widgetId) {
            for (var n = 0; n < stepWidgets.length; n++) {
                if (stepWidgets[n].getWidgetId() == widgetId) {
                    return stepWidgets[n];
                }
            }

            return null;
        },

        getPlanningNotificationSearchModel : function(_this) {
            // summary:
            //     Returns the search model for planning notifications.
            //     Expects the following objects / references inside the this-pointer:
            //     planningNotificationMultiComboBox, commentTextBox, projectSelect, applicationContext,
            //     idToMetaTagInfo

            var planningNotificationEntries = _this.planningNotificationMultiComboBox.get("value");
            var comment = _this.notificationCommentTextBox.get("value");

            var networkId = _this.applicationContext.getPageContextPnNetworkId();
            var selectedProjectValue = WidgetHelper.getSelectValue(_this.projectSelect);

            var textMetaTagIdToValue = new Object();
            var dateMetaTagIdToFrom = new Object();
            var dateMetaTagIdToTo = new Object();

            for (var id in _this.idToMetaTagInfo) {
                var metaTagInfo = _this.idToMetaTagInfo[id];
                var metaTag = metaTagInfo.metaTag;
                if (metaTag.tagFormat == 0) {         // TAG_FORMAT_TEXT
                    textMetaTagIdToValue[id] = metaTagInfo.primaryWidget.get("value");
                } else if (metaTag.tagFormat == 1) {  // TAG_FORMAT_DATE
                    dateMetaTagIdToFrom[id] = metaTagInfo.primaryWidget.getUtcSeconds();
                    dateMetaTagIdToTo[id] = metaTagInfo.secondaryWidget.getUtcSeconds();
                } else {
                    throw new Error("TagFormat [" + metaTag.tagFormat + "] is not yet supported, see at.cdes.oldGwtDto.MetaTagDTO");
                }
            }

            var searchModel = {
                planningNotificationEntries : planningNotificationEntries,
                                   comment : comment,
                      organisationPersonId : _this.applicationContext.getPageContextOrganisationPersonId(),
                                 networkId : networkId,
                                 projectId : selectedProjectValue == CdesVoc.WHATEVER ? null : selectedProjectValue,
                      textMetaTagIdToValue : textMetaTagIdToValue,
                       dateMetaTagIdToFrom : dateMetaTagIdToFrom,
                         dateMetaTagIdToTo : dateMetaTagIdToTo
            };

            return searchModel;
        },


        getPlanningNotificationOrderSearchModel : function(_this) {
            var selectedProjectValue = WidgetHelper.getSelectValue(_this.projectSelect);
            var selectedPersonInChargeValue = WidgetHelper.getSelectValue(_this.personInChargeSelect);
            var selectedStatutoryDutyValue = WidgetHelper.getSelectValue(_this.statutoryDutySelect);
            var selectedWorkflowEntityStatusValue = WidgetHelper.getSelectValue(_this.stateSelect);
            var allStatutoryDuties = false;
            if (selectedStatutoryDutyValue == "_ALL_") {
                selectedStatutoryDutyValue = null;
                allStatutoryDuties = true;
            }

            var planningNotificationEntries = _this.planningNotificationMultiComboBox.get("value");

            var searchModel = {
                                  networkId : _this.applicationContext.getPageContextPnNetworkId(),
                       organisationPersonId : _this.applicationContext.getPageContextOrganisationPersonId(),
                planningNotificationEntries : planningNotificationEntries,
                               serialNumber : _this.serialNumberSpinner.get("value"),
                                  projectId : selectedProjectValue == CdesVoc.WHATEVER ? null : selectedProjectValue,
                                invalidated : WidgetFactory.getBooleanSelectValue(_this.invalidatedSelect),
                                      state : selectedWorkflowEntityStatusValue != CdesVoc.WHATEVER ? selectedWorkflowEntityStatusValue : null,
                                  reference : _this.referenceTextBox.get("value"),
                    environmentallyRelevant : WidgetFactory.getBooleanSelectValue(_this.environmentallyRelevantSelect),
                            statutoryDutyId : selectedStatutoryDutyValue != CdesVoc.WHATEVER ? selectedStatutoryDutyValue : null,
                         allStatutoryDuties : allStatutoryDuties,
                                       text : _this.textTextBox.get("value"),
                                     baulos : _this.orderBaulosTextBox.get("value"),
                        authorizedInspector : _this.authorizedInspectorTextBox.get("value"),
                      statutoryDutyFromFrom : _this.statutoryDutyFromFromSpinner.getUtcSeconds(),
                        statutoryDutyFromTo : _this.statutoryDutyFromToSpinner.getUtcSeconds(),
                        statutoryDutyToFrom : _this.statutoryDutyToFromSpinner.getUtcSeconds(),
                          statutoryDutyToTo : _this.statutoryDutyToToSpinner.getUtcSeconds(),
                      statutoryDutyInterval : _this.intervalSpinner.get("value"),
                      statutoryDutyLeadTime : _this.leadTimeSpinner.get("value"),
                       statutoryDutyExpired : WidgetFactory.getBooleanSelectValue(_this.statutoryDutyExpiredSelect),
                               documentPage : _this.documentPageTextBox.get("value"),
                           documentPosition : _this.documentPositionTextBox.get("value"),
                                     source : _this.sourceTextBox.get("value"),
                           personInChargeId : selectedPersonInChargeValue != CdesVoc.WHATEVER ? selectedPersonInChargeValue : null,
                                       tags : _this.tagTextBox.get("value"),
                            submitAuthority : WidgetFactory.getBooleanSelectValue(_this.submitAuthoritySelect),
                                    comment : _this.orderCommentTextBox.get("value")
            };

            SearchPageHelper.setAllableComboBoxValueToSearchModel(_this.subjectAreaComboBox, searchModel,
                                                                  "subjectAreaId", "subjectAreaName");

            if (_this.dueDateFromSpinner != null) {
                searchModel.dueDateFrom = _this.dueDateFromSpinner.getUtcSeconds();
            }

            if (_this.dueDateToSpinner != null) {
                searchModel.dueDateTo = _this.dueDateToSpinner.getUtcSeconds();
            }

            if (_this.dueDateRemarkSelect != null) {
                var dueDateRemark = WidgetHelper.getSelectValue(_this.dueDateRemarkSelect);
                searchModel.dueDateRemark = dueDateRemark != CdesVoc.WHATEVER ? dueDateRemark : null;
            }

            if (_this.positionPersonSelect != null) {
                var organisationPersonIds = _this.positionPersonSelect.get("value");
                var passedOrganisationPersonIds = [];
                for (var n = 0; n < organisationPersonIds.length; n++) {
                    if (organisationPersonIds[n] != null && organisationPersonIds[n] != CdesVoc.WHATEVER) {
                        passedOrganisationPersonIds.push(organisationPersonIds[n]);
                    }
                }

                searchModel.organisationPersonIds = passedOrganisationPersonIds;
            }

            return searchModel;
        },

        getPlanningNotificationReviewSearchModel : function(_this) {

		    var workflowNodeTemplateId = _this.workflowNodeNameSelect.get("value");
            workflowNodeTemplateId = workflowNodeTemplateId != CdesVoc.WHATEVER ? workflowNodeTemplateId : null;;
            var baulos = _this.reviewBaulosTextBox.get("value");

            var searchModel = {
                       	workflowNodeTemplateId : workflowNodeTemplateId,
          								baulos : baulos
            };
            return searchModel;
        },

        convertSearchModelPlanningNotificationEntriesForServer : function(searchModel) {
            var entries = searchModel.planningNotificationEntries!=null ? searchModel.planningNotificationEntries : [];
            var planningNotificationTitles = [];
            var planningNotificationIds = [];
            for (var n = 0; n < entries.length; n++) {
                var entry = entries[n];
                if (entry.id != CdesVoc.MagicSelectOption.ALL && (entry.title == null || entry.title.trim() != i18n.allOption)) {
                    if (entry.id != null) {
                        planningNotificationIds.push(entry.id);
                    } else if (entry.title != null && entry.title.trim().length > 0) {
                        planningNotificationTitles.push(entry.title);
                    }
                }
            }
            searchModel.planningNotificationEntries = null;
            searchModel.planningNotificationIds = planningNotificationIds;
            searchModel.planningNotificationTitles = planningNotificationTitles;
        },

        triggerExportReport : function(applicationContext, finalWidget, config, columnToWidth, sortSpecs, askForMsp) {
            // Options
            var reportName = config.options.reportName;

            var type = config.options.reportType;
            if (type == null) {
                throw new Error("Type is missing");
            }

            var projectId = config.options.projectId;

            var fileFormat = config.options.fileFormat;
            var fileFormatForServer = fileFormat != null ? fileFormat : null;
            if (fileFormatForServer == null) {
                throw new Error("File format is missing");
            }
            var fileName = config.options.fileName;

            var layoutFormat = config.options.layoutFormat;
            if (layoutFormat == null) {
                throw new Error("Layout format is missing");
            }

            var headerFontSize = config.options.headerFontSize;
            var dataFontSize = config.options.dataFontSize;
            var doIncludeOverallStatusGraphic = config.options.includeOverallStatusGraphic;
            var doIncludeOrderStatusGraphics = config.options.includeOrderStatusGraphics;

            // Cover
            var coverComment = config.options.comment;
            var coverCommentTwo = config.options.commentTwo;

            var planningNotificationSearchModel = config.data.notificationSearchModel;
            var planningNotificationOrderSearchModel = config.data.orderSearchModel;
            var planningReviewSearchModel = config.data.reviewSearchModel;
            var columnSettings = config.data.columnSettings;

            planningNotificationOrderSearchModel.subjectAreaId
            = planningNotificationOrderSearchModel.subjectAreaId != CdesVoc.MagicSelectOption.ALL
            ? planningNotificationOrderSearchModel.subjectAreaId : null;

            PlanningNotificationHelper.convertSearchModelPlanningNotificationEntriesForServer(planningNotificationSearchModel);

            // Assembling options
            var options = {
                           organisationPersonId : applicationContext.getPageContextOrganisationPersonId(),
                                      networkId : applicationContext.getPageContextPnNetworkId(),
                                     reportName : reportName,
                                           type : type,
                                      projectId : projectId,
                                       fileType : fileFormatForServer,
                                       fileName : fileName,
                                         layout : layoutFormat,
                                 headerFontSize : headerFontSize,
                                   dataFontSize : dataFontSize,
                    includeOverallStatusGraphic : doIncludeOverallStatusGraphic,
                     includeOrderStatusGraphics : doIncludeOrderStatusGraphics,
                                   coverComment : coverComment,
                                coverCommentTwo : coverCommentTwo,
                planningNotificationSearchModel : planningNotificationSearchModel,
                               orderSearchModel : planningNotificationOrderSearchModel,
                              reviewSearchModel : planningReviewSearchModel,
                                 columnSettings : columnSettings,
                                  columnToWidth : columnToWidth,
                                      sortSpecs : sortSpecs
            };

            topic.publish("message/info", i18n.planningNotificationReportExportStarted);

            finalWidget.registerAsyncOperationStarted(PlanningNotificationHelper.AsyncOperation.EXPORT);
            var planningNotificationService = applicationContext.getService("planningNotificationService");
            planningNotificationService.triggerExportReport(options).then(lang.hitch(finalWidget, function(jobId) {
                JobHelper.registerJobStatusQueryForDownload(applicationContext, jobId, function(jobId) {
                    topic.publish("message/ok", i18n.planningNotificationReportExportFinished);

                    var suffix;
                    if (fileFormatForServer == CdesVoc.ReportFileFormat.PDF.value || fileFormatForServer == CdesVoc.ReportFileFormat.PDF_LIST.value) {
                        suffix = ".pdf";
                    } else {
                        suffix = ".xls";
                    }

                    var parameterString = ioQuery.objectToQuery({
                           jobId : jobId,
                        fileName : fileName != null && fileName.trim().length > 0 ? fileName + suffix : undefined
                    });
                    return "/cdes-dojo-impl/download?" + parameterString;
                }, askForMsp ? function() { PlanningNotificationHelper.askForMspPostProcessorFunction(applicationContext, jobId); } : null);

                this.registerAsyncOperationFinished(PlanningNotificationHelper.AsyncOperation.EXPORT);
            }), lang.hitch(finalWidget, function(err){
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : finalWidget,
                    asyncOperation : PlanningNotificationHelper.AsyncOperation.EXPORT,
                            opName : "triggerExportReport",
                           message : i18n.planningNotificationReportExportFailed
                });
            })).otherwise(
                lang.hitch(finalWidget, function(err) {
                    log.error("Handling the results of executing triggerExportReport failed", err);
                }));
        },

        askForMspPostProcessorFunction : function(applicationContext, jobId) {
            InfoDialog.showQuestion({
                  title : i18n.planningNotificationHelperAskExportToMspCaption,
                message : i18n.planningNotificationHelperAskExportToMspMessage,
                buttons : [
                           { type : InfoDialog.Button.YES, fct : function() {
                               PlanningNotificationHelper.chooseMspItemForExport(applicationContext, jobId);
                           }},
                           { type : InfoDialog.Button.NO }
                ]
            });
        },

        chooseMspItemForExport : function(applicationContext, jobId) {
            var chooseDialog = new MspTreeUrlChooseDialog({
                applicationContext : applicationContext,
                             title : i18n.planningNotificationHelperChooseMspItemForExportCaption,
                           buttons : [
                                      { type : ChooseDialog.Button.CHOOSE,
                                          name : "selectButton"/*,
                                          label : i18n.workflowNodeEditAddParticipantButtonCaption,
                                          title : i18n.workflowNodeEditAddParticipantButtonToolTip*/
                                      },
                                      { type : InfoDialog.Button.ABORT,
                                          title : i18n.abortToolTip }
                           ],
                      defaultWidth : 800,
                     defaultHeight : 400
            });

            on(chooseDialog, "valueChosen", function(chooseInfo) {
                PlanningNotificationHelper.exportJobResultToMspItem(applicationContext, jobId, chooseInfo);
            });
            chooseDialog.show(null);
        },

        exportJobResultToMspItem : function(applicationContext, jobId, chooseInfo) {
            // chooseInfo = { url, mspItem }

            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
            var jobStatusService = applicationContext.getService("jobStatusService");
            var mspDestUrl = chooseInfo.url;

            topic.publish("message/info", i18n.planningNotificationReportExportToMspRuns);

            var mspService = applicationContext.getService("mspService");
            mspService.triggerExportPlanningNotificationReportToMsp(organisationPersonId, jobId, mspDestUrl).then(function(jobId) {
                JobHelper.registerJobStatusQueryForGettingResult({
                               jobId : jobId,
                    jobStatusService : jobStatusService
                }).then(lang.hitch(this, function() {
                    topic.publish("message/ok", i18n.planningNotificationReportExportToMspFinished);
                }), lang.hitch(this, function(err) {
                    topic.publish("message/error", i18n.planningNotificationReportMspExportFailed);
                })).otherwise(function(err) {
                    log.error("Handling the results for registerJobStatusQueryForGettingResult failed.");
                });
            }, function(err) {
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : null,
                    asyncOperation : null,
                            opName : "triggerExportPlanningNotificationReporttoMsp",
                           message : i18n.planningNotificationReportMspExportFailed
                });
            }).otherwise(
                function(err) {
                    log.error("Handling the results of executing triggerExportPlanningNotificationReportToMsp failed", err);
                });
        },

        constructEmptyReportConfig : function() {
            return {
                options : new Object(),
                  cover : new Object(),
                   data : {
                       notificationSearchModel : new Object(),
                              orderSearchModel : new Object(),
                             reviewSearchModel : new Object(),
                                columnSettings : {
                                    metaTagIdToShow : new Object()
                                }
                   }
            };
        },

        getSelectOptionsForMap : function(map, labelAttribute, defaultOption, firstRegularOption) {
            var options = [];
            if (defaultOption != null) {
                options.push(defaultOption);
            }
            for (var id in map) {
                var v = map[id];
                options.push({ value : id, label : v[labelAttribute] });
            }

            options.sort(function(optionOne, optionTwo) {
                if (defaultOption != null && defaultOption.value == optionOne.value) {
                    return -1;
                } else if (defaultOption != null && defaultOption.value == optionTwo.value) {
                    return 1;
                } else if (firstRegularOption != null && optionOne.label.indexOf(firstRegularOption) == 0) {
                    return -1;
                } else if (firstRegularOption != null && optionTwo.label.indexOf(firstRegularOption) == 0) {
                    return 1;
                } else {
                    return optionOne.label.localeCompare(optionTwo.label);
                }
            });

            return options;
        },

        populateStatutoryDutySelect : function(statutoryDutySelect, idToStatutoryDuty) {
            var statutoryDutyOptions = [{ label : i18n.whatever, value : CdesVoc.WHATEVER }];
            var statutoryDuties = [];
            for (var id in idToStatutoryDuty) {
                var statutoryDuty = idToStatutoryDuty[id];
                if (!statutoryDuty.isStatutoryDuty) {
                    statutoryDutyOptions.push({ value : statutoryDuty.id, label : statutoryDuty.name });
                } else {
                    statutoryDuties.push(statutoryDuty);
                }
            }
            statutoryDutyOptions.push({ value : "_ALL_", label : i18n.planningNotificationOrderSearchAllStatutoryDuties });

            statutoryDuties.sort(function(statutoryDutyOne, statutoryDutyTwo) {
                var nameOne = statutoryDutyOne.name != null ? statutoryDutyOne.name : "";
                var nameTwo = statutoryDutyTwo.name != null ? statutoryDutyTwo.name : "";
                return nameOne.localeCompare(nameTwo);
            });

            for (var n = 0; n < statutoryDuties.length; n++) {
                var statutoryDuty = statutoryDuties[n];
                statutoryDutyOptions.push({ value : statutoryDuty.id, label : statutoryDuty.name });
            }
            WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(statutoryDutySelect, statutoryDutyOptions);
        },

        getI18nParameter : function(expr) {
            switch (expr) {
                case "Baulos":
                return i18n.planningNotificationMetaTag_Baulos;
                break;
                case "GZ":
                return i18n.planningNotificationMetaTag_GZ;
                break;
                case "Behörde":
                return i18n.planningNotificationMetaTag_Behörde;
                break;
                case "Verfahren":
                return i18n.planningNotificationMetaTag_Verfahren;
                break;
                case "Dokumentendatum":
                return i18n.planningNotificationMetaTag_Dokumentendatum;
                break;
                case "Gültigkeit":
                return i18n.planningNotificationMetaTag_Gültigkeit;
                break;
                case "Abschnitt":
                return i18n.planningNotificationMetaTag_Abschnitt;
                break;
                case "Strecke":
                return i18n.planningNotificationMetaTag_Strecke;
                break;
                case "km von":
                return i18n.planningNotificationMetaTag_kmvon;
                break;
                case "km bis":
                return i18n.planningNotificationMetaTag_kmbis;
                break;
                case "Schlagwort":
                return i18n.planningNotificationMetaTag_Schlagwort;
                break;
                default:
                return expr;
            }
        },

        constructHistoryListWidget : function(params) {
            var applicationContext = params.applicationContext;
            var historyButtonFct = params.historyButtonFct;
            var updateBaulosFct = params.updateBaulosFct;
            var openReviewsFct = params.openReviewsFct;
            var historyPostResizeFct = params.historyPostResizeFct;
            var enableBaulosFilter = params.enableBaulosFilter;

            var historyDiv = domConstruct.create("div", null, null);
            domClass.add(historyDiv, "refNodeOfPositionAbsolute");

            // History Tab
            var historyTabDiv = domConstruct.create("div", null, null);
            domClass.add(historyTabDiv, "fixedDialogWidget workflowReviewTab workflowReviewHistoryTab");
            domConstruct.place(historyTabDiv, historyDiv);

            // History Button
            var historyButton = new FancyButton({
                label : i18n.reviewProtocolHistoryCaption,
                title : i18n.reviewProtocolHistoryCaption
            });
            domClass.add(historyButton.domNode, "fixedDialogWidget clazzesFancyButton workflowReviewHistoryButton");
            domConstruct.place(historyButton.domNode, historyTabDiv);
            on(historyButton, "click", historyButtonFct);

            if (enableBaulosFilter) {
                // Show All CheckBox
                var showAllCheckBox = new CheckBox({
                    label : i18n.reviewProtocolHistoryShowAllLabel,
                    title : i18n.reviewProtocolHistoryShowAllLabel
                });
                domClass.add(showAllCheckBox.domNode, "fixedDialogWidget workflowReviewShowAllCheckBox");
                domConstruct.place(showAllCheckBox.domNode, historyDiv);
                WidgetHelper.handleCheckBoxEvents(showAllCheckBox, updateBaulosFct);

                DOMHelper.createTextNode("div", i18n.reviewProtocolHistoryShowAllLabel, historyDiv, "fixedDialogWidget workflowReviewShowAllLabel");
            }

            // Open Tab
            var openTabDiv = domConstruct.create("div", null, null);
            domClass.add(openTabDiv, "fixedDialogWidget workflowReviewTab workflowReviewOpenTab");
            domConstruct.place(openTabDiv, historyDiv);

            // Open Reviews Button
            var openReviewsButton = new FancyButton({
                label : i18n.reviewProtocolOpenReviewsCaption,
                title : i18n.reviewProtocolOpenReviewsCaption
            });
            domClass.add(openReviewsButton.domNode, "fixedDialogWidget clazzesFancyButton workflowReviewOpenReviewsButton");
            domConstruct.place(openReviewsButton.domNode, openTabDiv);
            on(openReviewsButton, "click", openReviewsFct);

            // History Widget
            var historyListWidget = new WorkflowActivityResultListWidget({
                applicationContext : applicationContext
            });
            var historyListWidgetDiv = historyListWidget.getContainer();
            domClass.add(historyListWidgetDiv, "fixedDialogWidget workflowReviewHistoryListDiv");
            domConstruct.place(historyListWidgetDiv, historyDiv);

            historyListWidget.restoreColumnWidths();

            var historyContentPane = new FancyContentPane({
                           content : historyDiv,
                postResizeFunction : historyPostResizeFct
            });

            return {
                          historyDiv : historyDiv,
                       historyTabDiv : historyTabDiv,
                       historyButton : historyButton,
                   openReviewsButton : openReviewsButton,
                     showAllCheckBox : showAllCheckBox,
                          openTabDiv : openTabDiv,
                   historyListWidget : historyListWidget,
                historyListWidgetDiv : historyListWidgetDiv,
                  historyContentPane : historyContentPane
            };
        },

        updateHistoryTabs : function(tabInfos, activeTab) {
            // tabInfos: [{ tabDiv, tabConstant }]

            for (var n = 0; n < tabInfos.length; n++) {
                var tabInfo = tabInfos[n];
                var tabDiv = tabInfo.tabDiv;
                domClass.remove(tabDiv, "active");

                var tabConstant = tabInfo.tabConstant;
                if (tabConstant == activeTab) {
                    domClass.add(tabDiv, "active");
                }
            }
        },

        getOpenTaskJoinsByOpenTaskInfos : function(openTaskInfos) {
            var openTaskJoins = [];
            for (var n = 0; n < openTaskInfos.length; n++) {
                var openTaskInfo = openTaskInfos[n];
                var openTaskJoin = openTaskInfo.taskJoin;

                openTaskJoins.push({
                        workflowActivityWorkflowNodeName : openTaskJoin.workflowNodeTemplateName,
                             workflowNodePositionBaulose : openTaskInfo.workflowNodePositionBaulose ? openTaskInfo.workflowNodePositionBaulose : [],
                    workflowNodeInitiatorPositionBaulose : openTaskInfo.workflowNodeInitiatorPositionBaulose ? openTaskInfo.workflowNodeInitiatorPositionBaulose : [],
                                        organisationName : openTaskJoin.organisationName,
                                           personSurName : openTaskJoin.personSurName,
                                         personGivenName : openTaskJoin.personGivenName,
                               initiatorOrganisationName : openTaskJoin.initiatorOrganisationName,
                                  initiatorPersonSurName : openTaskJoin.initiatorPersonSurName,
                                initiatorPersonGivenName : openTaskJoin.initiatorPersonGivenName
                });
            }
            return openTaskJoins;
        },

    };

    PlanningNotificationHelper.AsyncOperation = {
        EXPORT : "Export"
    };

    return PlanningNotificationHelper;

});
