define([
        "clazzes/TinyLog",
        "clazzes/util/StringHelper",
        "dojo/string",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		TinyLog,
    		StringHelper,
    		string,
    		i18n
    		) {
	
	var className = "at.cdes.web.util.NameHelper";
	
	var log = new TinyLog(className);
	
    var NameHelper = {
    	
    	getPersonCommonName : function(dto, prefix) {
    		if (prefix == null) {
    			prefix = "";
    		}
    		
    		var givenName = dto[prefix.length == 0 ? "givenName" : prefix + "GivenName"];
    		var surName = dto[prefix.length == 0 ? "surName" : prefix + "SurName"];
    		
    		if (!StringHelper.isEmpty(givenName) && !StringHelper.isEmpty(surName)) {
    			return string.substitute(i18n.commonName, {
    				givenName : givenName,
    				  surName : surName
    			});
    		} else if (givenName != null && !StringHelper.isEmpty(givenName)) {
    			return givenName;
    		} else if (surName != null && !StringHelper.isEmpty(surName)) {
    			return surName; 
    		} else {
    			return "";
    		}
    	},
    	
    	getPersonInverseCommonName : function(dto, prefix) {
    		if (prefix == null) {
    			prefix = "";
    		}
    		
    		var givenName = dto[prefix.length == 0 ? "givenName" : prefix + "GivenName"];
    		var surName = dto[prefix.length == 0 ? "surName" : prefix + "SurName"];    		

    		if (givenName && givenName.length > 0) {
    			if (surName && surName.length > 0) {
    				return surName + " " + givenName;	
    			} else {
    				return givenName;
    			}
    		} else {
    			if (surName && surName.length > 0) {
    				return surName;
    			} else {
    				return i18n.nothing;
    			}    			
    		}
    	},
    	
        getOrganisationName : function(dto, prefix) {
            if (prefix == null) {
                prefix = "";
            }
    		var name = dto[prefix.length == 0 ? "name" : prefix + "Name"];
    		if (name && name.length > 0)
            	return name;
        	else
            	return "";
        },            
    	
    	getOrganisationPersonDtoName : function(dto, prefixOrg, prefixPerson) {
    		
    		var orgName = dto[(prefixOrg == null || prefixOrg.length == 0) ? "name" : prefixOrg + "Name"];
    		var givenName = dto[(prefixPerson == null || prefixPerson.length == 0) ? "givenName" : prefixPerson + "GivenName"];
    		var surName = dto[(prefixPerson == null || prefixPerson.length == 0) ? "surName" : prefixPerson + "SurName"];
    		
    		if (!StringHelper.isEmpty(orgName) && !StringHelper.isEmpty(givenName) && !StringHelper.isEmpty(surName)) {
    			return string.substitute(i18n.organisationCommonName, {
    				organisationName : orgName,
    				personCommonName : surName + ' ' + givenName
    			});
    		} else {
    			return "";
    		}
    	},

    	getOrganisationPersonName : function(params) {
    		var person = params.person;
    	    var organisation = params.organisation;
            var organisationPersonJoin = params.organisationPersonJoin;

            if (organisationPersonJoin != null) {
                return NameHelper.getPersonInverseCommonName(organisationPersonJoin, "person")
                    + " (" + NameHelper.getOrganisationName(organisationPersonJoin, "organisation") + ")"; 
            } else {
    		return NameHelper.getPersonInverseCommonName(person, "") + " (" + organisation.name + ")"; 
            }
    	}
    };
    return NameHelper;
});
