/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = metaTagEdit
////i18n-prefix = metaTagEdit

define([ "clazzes/TinyLog",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/CheckBox",
	"dijit/form/Button",
	"dijit/form/Form",
	"dijit/form/NumberSpinner",
	"dijit/form/Select",
	"dijit/form/TextBox",
	"dijit/form/Textarea",
	"dijit/form/ValidationTextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",	 
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/string",
	"dojox/encoding/base64",
	"dojox/form/Uploader",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(TinyLog,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			CheckBox,
			Button,		
			Form,
			NumberSpinner,
			Select,
			TextBox,
			Textarea,
			ValidationTextBox,
			domClass,
			domConstruct,
			domStyle,
			on,
			declare,
			lang,
			string,
			base64,
			Uploader,
			i18n) {

	var className = "at.cdes.web.planning.template.MetaTagEditPage";

	var log = new TinyLog(className);

	var MetaTagEditPage = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;

			this.reload();
		},

		getWidgetId : function() {
			return "MetaTagEditPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			var captionLabel;
			if (this.mode == ContentWidget.Mode.CREATE) {
				captionLabel = i18n.metaTagEditCreatePageCaption;
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				captionLabel = i18n.metaTagEditEditPageCaption;
			} else {
				throw new Error("Unsupported mode [" + this.mode + "]");
			}		
			this.captionDiv = DOMHelper.createTextNode("h1", captionLabel, captionBarDiv, "cdesGeneralPageCaption");

			return captionBarDiv;
		},

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "metaTagEditPageContentDiv");

			// NameTextBox
			DOMHelper.createTextNode("div", i18n.metaTagListNameColumn, contentDiv, "propertyLabel metaTagEditNameLabel");
			this.nameTextBox = new ValidationTextBox({
				label : i18n.metaTagListNameColumn,
				title : i18n.metaTagEditNameToolTip,
				maxLength : 127	
			});
			domClass.add(this.nameTextBox.domNode, "fixedDialogWidget metaTagEditNameTextBox");
			domConstruct.place(this.nameTextBox.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.nameTextBox, lang.hitch(this, this.updateWidgetState));
			WidgetHelper.setMustField(this.nameTextBox, true);

			// TypeSelect
			DOMHelper.createTextNode("div", i18n.metaTagListTypeColumn, contentDiv, "propertyLabel metaTagEditTypeLabel");
			var typeOptions = [
				{ value : "0", label : i18n.metaTagPlanningNotificationType },
				{ value : "1", label : i18n.metaTagWorkflowNodePositionType },	    
				{ value : "2", label : i18n.metaTagWorkflowNodePositionOptionalType }
				];
			this.typeSelect = new Select({
				label : i18n.metaTagListTypeColumn,
				title : i18n.metaTagEditTypeToolTip,
				options : typeOptions		
			});
			domClass.add(this.typeSelect.domNode, "fixedDialogWidget metaTagEditTypeSelect");
			domConstruct.place(this.typeSelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.typeSelect, lang.hitch(this, this.updateWidgetState));

			// TagFormatSelect
			DOMHelper.createTextNode("div", i18n.metaTagListTagFormatColumn, contentDiv, "propertyLabel metaTagEditTagFormatLabel");
			var tagFormatOptions = [
				{ value : "0", label : i18n.metaTagTextTagFormat },
				{ value : "1", label : i18n.metaTagDateTagFormat },	    
				{ value : "2", label : i18n.metaTagDateTimeTagFormat }
				];		
			this.tagFormatSelect = new Select({
				label : i18n.metaTagListTagFormatColumn,
				title : i18n.metaTagEditTagFormatToolTip,
				options : tagFormatOptions		
			});
			domClass.add(this.tagFormatSelect.domNode, "fixedDialogWidget metaTagEditTagFormatSelect");
			domConstruct.place(this.tagFormatSelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.tagFormatSelect, lang.hitch(this, this.updateWidgetState));

			// PositionNumberSpinner
			DOMHelper.createTextNode("div", i18n.metaTagListPositionColumn, contentDiv, "propertyLabel metaTagEditPositionLabel");
			this.positionSpinner = new NumberSpinner({
				label : i18n.metaTagListPositionColumn,
				title : i18n.metaTagEditPositionToolTip
			});
			domClass.add(this.positionSpinner.domNode, "fixedDialogWidget metaTagEditPositionSpinner");
			domConstruct.place(this.positionSpinner.domNode, contentDiv);
			WidgetHelper.handleSpinnerEvents(this.positionSpinner, lang.hitch(this, this.updateWidgetState));
			WidgetHelper.setMustField(this.positionSpinner, true);

			// MultipleCheckBox
			DOMHelper.createTextNode("div", i18n.metaTagListMultipleColumn, contentDiv, "propertyLabel metaTagEditMultipleLabel");
			this.multipleCheckBox = new CheckBox({
				label : i18n.metaTagListMultipleColumn,
				title : i18n.metaTagEditMultipleToolTip
			});
			domClass.add(this.multipleCheckBox.domNode, "fixedDialogWidget metaTagEditMultipleCheckBox");
			domConstruct.place(this.multipleCheckBox.domNode, contentDiv);
			WidgetHelper.handleCheckBoxEvents(this.multipleCheckBox, lang.hitch(this, this.updateWidgetState));

			// PrioritySelect
			DOMHelper.createTextNode("div", i18n.metaTagEditPriorityLabel, contentDiv, "propertyLabel metaTagEditPriorityLabel");
			var priorityOptions = [{ label : i18n.metaTagEditShowAlwaysPriority, value : "0" },
				{ label : i18n.metaTagEditShowOnRequestPriority, value : "1" }
			];				   
			this.prioritySelect = new Select({
				label : i18n.metaTagEditPriorityLabel,
				title : i18n.metaTagEditPriorityToolTip,
				options : priorityOptions		
			});
			domClass.add(this.prioritySelect.domNode, "fixedDialogWidget metaTagEditPrioritySelect");
			domConstruct.place(this.prioritySelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.prioritySelect, lang.hitch(this, this.updateWidgetState));

			// MandatoryCheckBox
			DOMHelper.createTextNode("div", i18n.metaTagListMandatoryColumn, contentDiv, "propertyLabel metaTagEditMandatoryLabel");
			this.mandatoryCheckBox = new CheckBox({
				label : i18n.metaTagListMandatoryColumn,
				title : i18n.metaTagEditMandatoryToolTip
			});
			domClass.add(this.mandatoryCheckBox.domNode, "fixedDialogWidget metaTagEditMandatoryCheckBox");
			domConstruct.place(this.mandatoryCheckBox.domNode, contentDiv);
			WidgetHelper.handleCheckBoxEvents(this.mandatoryCheckBox, lang.hitch(this, this.updateWidgetState));

			// SharepointReferenceTextBox
			DOMHelper.createTextNode("div", i18n.metaTagListSharepointReferenceNameColumn, contentDiv, "propertyLabel metaTagEditSharepointReferenceLabel");
			this.sharepointReferenceTextBox = new ValidationTextBox({
				label : i18n.metaTagListSharepointReferenceNameColumn,
				title : i18n.metaTagEditSharepointReferenceToolTip,
				maxLength : 127		
			});
			domClass.add(this.sharepointReferenceTextBox.domNode, "fixedDialogWidget metaTagEditSharepointReferenceTextBox");
			domConstruct.place(this.sharepointReferenceTextBox.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.sharepointReferenceTextBox, lang.hitch(this, this.updateWidgetState));

			// CssClassTextBox
			DOMHelper.createTextNode("div", i18n.metaTagListCssClassColumn, contentDiv, "propertyLabel metaTagEditCssClassLabel");
			this.cssClassTextBox = new ValidationTextBox({
				label : i18n.metaTagListCssClassColumn,
				title : i18n.metaTagEditCssClassToolTip,
				maxLength : 255	
			});
			domClass.add(this.cssClassTextBox.domNode, "fixedDialogWidget metaTagEditCssClassTextBox");
			domConstruct.place(this.cssClassTextBox.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.cssClassTextBox, lang.hitch(this, this.updateWidgetState));
			WidgetHelper.setMustField(this.cssClassTextBox, true);	    

			// Import form etc.
			var uploadUrl = "/cdes-dojo-impl/fileUpload";	    

			var importFrame = this.applicationContext.getFancyIFrame();

			this.importForm = new Form({method : "post", encType : "multipart/form-data"});
			domClass.add(this.importForm.domNode, "planDeliverNewForm");
			domConstruct.place(this.importForm.domNode, contentDiv);

			this.importForm.set("action", uploadUrl);
			this.importForm.set("target", importFrame.id);

			this.documentLoadRegistration = on(importFrame, "documentLoad", lang.hitch(this, function(event) {
				var content = event.document ? event.document.body.innerHTML : null;
				log.info("Received content [" + content + "]");











				// Alternative Dojo code
				// 	var decodedContent = base64.decode(content);
				var decodedContent = atob(content);

				this.cssRulesTextArea.set("value", decodedContent);
				this.updateWidgetState();
			}));

			// CssRulesTextarea
			DOMHelper.createTextNode("div", i18n.metaTagEditCssRulesLabel, contentDiv, "propertyLabel metaTagEditCssRulesLabel");

			this.uploader = new dojox.form.Uploader({
				name : "uploadedFile",
				multiple : false,
				type : "file",
				label : i18n.chooseFile
			});
			domClass.add(this.uploader.domNode, "metaTagEditCssRulesUpload");
			domConstruct.place(this.uploader.domNode, this.importForm.domNode);  
			this.uploader.set("url", uploadUrl);
			this.uploader.startup();

			on(this.uploader, "change", lang.hitch(this, function(fileInfos) {
				/*    			var message;
    			if (fileInfos.length > 0 && fileInfos[0].name != null) {
        			this.uploadedFileName = fileInfos[0].name;
    				var message = string.substitute(i18n.uploadStatusUploadRunning, {
        				fileName : fileInfos[0].name
        			});    			
    			} else {
    				this.uploadedFileName = null;
    				message = "";
    			}
    			DOMHelper.setInnerText(this.uploadStatusNode, message);*/

				this.importForm.submit();
			}));

			this.cssRulesTextArea = new Textarea({
				label : i18n.metaTagEditCssRulesLabel,
				title : i18n.metaTagEditCssRulesToolTip
			});
			domClass.add(this.cssRulesTextArea.domNode, "fixedDialogWidget metaTagEditCssRulesTextArea");
			domConstruct.place(this.cssRulesTextArea.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.cssRulesTextArea, lang.hitch(this, this.updateWidgetState));
			WidgetHelper.setMustField(this.cssRulesTextArea, true);

			// Save button
			var saveLabel;
			if (this.mode == ContentWidget.Mode.CREATE) {
				saveLabel = i18n.saveAndExitButtonCaption;
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				saveLabel = i18n.saveAndExitButtonCaption;
			} else {
				throw new Error("Mode [" + this.mode + "] not supported.");
			}		

			this.saveButton = new Button({
				label : saveLabel,
				title : i18n.planningNotificationTemplateEditSaveToolTip
			});
			domClass.add(this.saveButton.domNode, "fixedDialogWidget metaTagEditSaveButton");
			domConstruct.place(this.saveButton.domNode, contentDiv);

			//	    on(this.saveButton, "click", lang.hitch(this, this.save));
			on(this.saveButton, "click", lang.hitch(this, this.save));

			// Abort button
			this.abortButton = new Button({
				label : i18n.abortButtonCaption,
				title : i18n.planningNotificationTemplateEditAbortToolTip
			});
			domClass.add(this.abortButton.domNode, "fixedDialogWidget metaTagEditAbortButton");
			domConstruct.place(this.abortButton.domNode, contentDiv);
			on(this.abortButton, "click", lang.hitch(this, this.abort));

			return contentDiv;
		},

		resize : function(newSize) {
			var totalHeight = newSize.h;

			var contentHeight = totalHeight
			- this.captionBarDiv.offsetHeight
			- 16;

			domStyle.set(this.contentDiv, "height", contentHeight + "px");
		},

		setData : function() {

		},

		reload : function() {
			if (this.mode == ContentWidget.Mode.CREATE) {
				this.metaTag = new Object();
				this.metaTag.multiple = false;		
				this.updateWidgetsFromData();		
				this.updateWidgetState();
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				var planningNotificationService = this.applicationContext.getService("planningNotificationService");
				this.registerAsyncOperationStarted(MetaTagEditPage.AsyncOperation.LOAD);

				planningNotificationService.getMetaTag(this.id).then(
						lang.hitch(this, function(metaTag) {
							this.metaTag = metaTag;

							this.updateWidgetsFromData();
							this.registerAsyncOperationFinished(MetaTagEditPage.AsyncOperation.LOAD);
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : MetaTagEditPage.AsyncOperation.LOAD,
								opName : "getMetaTag",
								message : i18n.metaTagEditLoadFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [getMetaTag]", err);
								}));
			}
		},

		updateWidgetState : function() {
			WidgetHelper.updateEmptySpinnerState(this.positionSpinner);
			WidgetHelper.updateEmptyTextBoxState(this.nameTextBox);
			WidgetHelper.updateEmptyTextBoxState(this.cssClassTextBox);
			WidgetHelper.updateEmptyTextBoxState(this.cssRulesTextArea);

			var allFieldsValid = this.positionSpinner.isValid()
			&& WidgetHelper.isTextBoxValid(this.nameTextBox)
			&& WidgetHelper.isTextBoxValid(this.cssClassTextBox)
			&& WidgetHelper.isTextBoxValid(this.cssRulesTextArea);
			this.saveButton.set("disabled", !allFieldsValid);
		},

		updateWidgetsFromData : function() {
			this.positionSpinner.set("value", this.metaTag.position);
			this.nameTextBox.set("value", this.metaTag.name);
			this.sharepointReferenceTextBox.set("value", this.metaTag.sharepointReferenceName);
			this.tagFormatSelect.set("value", this.metaTag.tagFormat);
			this.multipleCheckBox.set("checked", !!this.metaTag.multiple);
			this.prioritySelect.set("value", this.metaTag.priority);
			this.mandatoryCheckBox.set("checked", !!this.metaTag.mandatory);	    
			this.typeSelect.set("value", this.metaTag.type);
			this.cssClassTextBox.set("value", this.metaTag.cssClass);
			this.cssRulesTextArea.set("value", this.metaTag.cssRules);
		},	    

		updateDataFromWidgets : function() {
			this.metaTag.position = this.positionSpinner.get("value");
			this.metaTag.name = this.nameTextBox.get("value");
			this.metaTag.sharepointReferenceName = this.sharepointReferenceTextBox.get("value");
			this.metaTag.tagFormat = this.tagFormatSelect.get("value");
			this.metaTag.multiple = !!this.multipleCheckBox.get("checked");
			this.metaTag.priority = this.prioritySelect.get("value");
			this.metaTag.mandatory = !!this.mandatoryCheckBox.get("checked");
			this.metaTag.type = this.typeSelect.get("value");
			this.metaTag.cssClass = this.cssClassTextBox.get("value");
			this.metaTag.cssRules = this.cssRulesTextArea.get("value");
		},	    

		save : function() {
			this.updateDataFromWidgets();

			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			this.registerAsyncOperationStarted(MetaTagEditPage.AsyncOperation.SAVE);
			if (this.mode == ContentWidget.Mode.CREATE) {
				planningNotificationService.saveMetaTag(this.planningNotificationTemplateId, this.metaTag).then(
						lang.hitch(this, function() {
							this.registerAsyncOperationFinished(MetaTagEditPage.AsyncOperation.SAVE);

							if (this.backPage != null) {
								this.applicationContext.setPage(this.backPage, this.backParams);
							}
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : MetaTagEditPage.AsyncOperation.SAVE,
								opName : "saveMetaTag",
								message : i18n.metaTagEditCreationFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [updateMetaTag]", err);
								}));
			} else if (this.mode == ContentWidget.Mode.EDIT) {
				planningNotificationService.updateMetaTag(this.metaTag).then(
						lang.hitch(this, function() {
							this.registerAsyncOperationFinished(MetaTagEditPage.AsyncOperation.SAVE);

							if (this.backPage != null) {
								this.applicationContext.setPage(this.backPage, this.backParams);
							}
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : MetaTagEditPage.AsyncOperation.SAVE,
								opName : "updateMetaTag",
								message : i18n.metaTagEditUpdateFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [updateMetaTag]", err);
								}));
			} else {
				throw new Error("Mode [" + this.mode + "] is not supported.");		
			}	    
		},	    

		abort : function() {
			if (this.backPage != null) {
				this.applicationContext.setPage(this.backPage, this.backParams);
			}
		},	    

		destroy : function() {
			this.inherited(arguments);
			if (this.documentLoadRegistration != null) {
				this.documentLoadRegistration.remove();
			}	    
		}
	});

	MetaTagEditPage.AsyncOperation = {
			LOAD : "Load",
			SAVE : "Save"	
	};

	return MetaTagEditPage;
});
