/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/plot/PlotHelper",
    "cdes/util/ActionHelper",
    "cdes/util/CodeHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    PlotHelper,
    ActionHelper,
    CodeHelper,
    ListWidget,
    TinyLog,
    ErrorHelper,
    ContentWidget,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    domClass,
    domConstruct,
    declare,
    lang,
    Memory,
    Trackable,
    i18n
) {

    var className = "at.cdes.web.plot.PlotOrderTemplateItemListWidget";

    var log = new TinyLog(className);

    var PlotOrderTemplateItemListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlotOrderTemplateItemListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "plotOrderTemplateItemList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
                    field : "_paperQuality",
                       id : "plottPropertiesPaperQuality",
		formatter : lang.hitch(this, this.paperQualityFormatter),                
                 sortable : true,
                    label : i18n.plotOrderItemPaperQualityCaption
            });

            columns.push({
                   field : "_color",
                      id : "plottPropertiesIsInColor",
                sortable : true,
                   label : i18n.plotOrderItemColorCaption
            });

            columns.push({
                    field : "_margin",
                       id : "plottPropertiesMargin",
		formatter : lang.hitch(this, this.marginFormatter),                
                 sortable : true,
                    label : i18n.plotOrderItemMarginCaption
            });

            columns.push({
                   field : "_mirror",
                      id : "plottPropertiesMirror",
                sortable : true,
                   label : i18n.plotOrderItemMirrorCaption
            });

            columns.push({
                   field : "plottPropertiesScale",
                      id : "plottPropertiesScale",
                sortable : true,
                   label : i18n.plotOrderItemScaleCaption
            });            
            
            columns.push({
                   field : "_count",
                      id : "plottPropertiesCount",
                sortable : true,
                   label : i18n.plotOrderItemCountCaption
            });

            columns.push({
                   field : "_area",
                      id : "area",
                sortable : true,
                   label : i18n.plotOrderItemAreaCaption
            });

            return columns;
        },

    	paperQualityFormatter : function(_paperQuality, itemJoin) {
    		return _paperQuality;
    	},
    	
    	marginFormatter : function(_margin, itemJoin) {
    		return _margin;
    	},

        constructTopDiv : function() {
            this.constructGrid({
		idProperty : "plottOrderItemTemplateId", 
            	    gridId : "plotOrderTemplateItemListGrid",
                 gridClass : "Grid"                
            });
            return this.grid.domNode;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.itemJoins = params.itemJoins;
    	    this.updateAuxiliaryData();
            this.reload();
        },

        reload : function(params) {
            this.setStoreData(this.itemJoins);

//            this.grid.set("sort", "plottPropertiesScale", false);
//            this.grid.updateSortArrow(this.grid.sort);
        },

    	updateAuxiliaryData : function() {
    	    for (var n = 0; n < this.itemJoins.length; n++) {
    		var itemJoin = this.itemJoins[n];
                itemJoin._color = PlotHelper.getColorString(itemJoin.plottPropertiesIsInColor);                    
    		itemJoin._paperQuality = itemJoin.plottPropertiesPaperQuality;
    		itemJoin._margin = itemJoin.plottPropertiesMargin;
    		
    		itemJoin._mirror = CodeHelper.getBooleanYesNo(itemJoin.plottPropertiesMirror);
    		itemJoin._count = PlotHelper.getCountString(itemJoin.plottPropertiesCount);
    		itemJoin._areaValue = PlotHelper.getArea({
                llx : itemJoin.plottPropertiesLlx,
                lly : itemJoin.plottPropertiesLly,
                urx : itemJoin.plottPropertiesUrx,
                ury : itemJoin.plottPropertiesUry,
              scale : itemJoin.plottPropertiesScale,
              count : itemJoin.plottPropertiesCount                        
                });
                itemJoin._area = PlotHelper.getLongAreaString(itemJoin._areaValue);
            }
        },            

        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    PlotOrderTemplateItemListWidget.AsyncOperation = {

    };

    return PlotOrderTemplateItemListWidget;
});
