/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = organisationMemberList
//// i18n-prefix = organisationMemberList


define(["cdes/util/NameHelper",
        "cdes/widget/base/ListWidget",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
         NameHelper,
         ListWidget,
         TinyLog,
         FancyButton,
         DOMHelper,
         ContentWidget,
         domClass,
         domConstruct,
         on,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.organisation.OrganisationMemberListWidget";

    var log = new TinyLog(className);

    var OrganisationMemberListWidget = declare(className, ListWidget, {

        dataAttributeName : "organisationPersonJoins",

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "OrganisationMemberListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "organisationMemberList/columnWidths",
        defaultColumnWidth : 130,

        columnIdToDefaultWidth : {
        },            

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            return [organisationPersonId];
        },        

        constructColumns : function() {
            var columns = [];

            columns.push({
                    field : "_nameString",
                       id : "personId",
                renderCell : lang.hitch(this, this.renderName),
                 sortable : true,
                    label : i18n.nameLabel
            });

            columns.push({
                   field : "organisationPersonOrganisationalUnitName",
                      id : "organisationPersonOrganisationalUnitName",
              renderCell : lang.hitch(this, this.renderUnitName),
                sortable : true,
                   label : i18n.organisationalUnitLabel
            });            

            columns.push({
                   field : "organisationPersonTelephoneNumber",
                      id : "organisationPersonTelephoneNumber",
              renderCell : lang.hitch(this, this.renderTelephoneNumber),
                sortable : true,
                   label : i18n.phoneLabel
            });            

            columns.push({
                     field : "id",
                        id : "actions",
                renderCell : lang.hitch(this, this.renderActionCell),
                  sortable : false,
                     label : i18n.actionColumnCaption
            });

            return columns;
        },

        nameFormatter : function(personId, organisationPersonJoin) {
            return NameHelper.getPersonInverseCommonName(organisationPersonJoin, "person");
        },

        renderName : function(organisationPersonJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            var personName = NameHelper.getPersonInverseCommonName(organisationPersonJoin, "person");
            var personNameSpan = DOMHelper.createTextNode("div", personName, cellDiv);
			if (organisationPersonJoin.organisationPersonRetiredFlag)
            	domClass.add(personNameSpan, "personListOrganisationRowInvalidated");
            else
            	domClass.add(personNameSpan, "personListOrganisationRow");
            return cellDiv;            
        },

        renderUnitName : function(organisationPersonJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            var unitName = organisationPersonJoin.organisationPersonOrganisationalUnitName;
            var personNameSpan = DOMHelper.createTextNode("div", unitName, cellDiv);
			if (organisationPersonJoin.organisationPersonRetiredFlag)
            	domClass.add(personNameSpan, "personListOrganisationRowInvalidated");
            else
            	domClass.add(personNameSpan, "personListOrganisationRow");
            return cellDiv;            
        },

        renderTelephoneNumber : function(organisationPersonJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            var telephoneNumber = organisationPersonJoin.organisationPersonTelephoneNumber;
            var personNameSpan = DOMHelper.createTextNode("div", telephoneNumber, cellDiv);
			if (organisationPersonJoin.organisationPersonRetiredFlag)
            	domClass.add(personNameSpan, "personListOrganisationRowInvalidated");
            else
            	domClass.add(personNameSpan, "personListOrganisationRow");
            return cellDiv;            
        },

        renderActionCell : function(organisationPersonJoin, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);
            if ("showPerson" in this.actions || "editPerson" in this.actions) {
                var mailButton = this.constructMailButton(organisationPersonJoin);
                domConstruct.place(mailButton.domNode, buttonDiv);
            }
            if ("editPerson" in this.actions && this.mode != ContentWidget.Mode.SHOW) {
                var editButton = this.constructEditButton(organisationPersonJoin);
                domConstruct.place(editButton.domNode, buttonDiv);
            } else if ("showPerson" in this.actions) {
                var showButton = this.constructShowButton(organisationPersonJoin);
                domConstruct.place(showButton.domNode, buttonDiv);
            }

            return buttonDiv;
        },

        constructMailButton : function(organisationPersonJoin) {
            var button = new FancyButton({
                    title : i18n.organisationMemberListMailToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 sendMailButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function(event) {
                this.applicationContext.setPage("sendEmail",
                                                { organisationPersonId : organisationPersonJoin.organisationPersonId },
                                                null, "organisationEdit",
                                                { id : this.organisationJoin.organisationId, mode : this.mode });
            }));

            return button;
        },

        constructShowButton : function(organisationPersonJoin) {
            var button = new FancyButton({
                    title : i18n.organisationMemberListShowToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 showButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("personEdit",
                                                { mode : ContentWidget.Mode.SHOW, id : organisationPersonJoin.personId },
                                                null, "organisationEdit",
                                                { id : this.organisationJoin.organisationId, mode : this.mode });
            }));
            return button;
        },

        constructEditButton : function(organisationPersonJoin) {
            var button = new FancyButton({
                    title : i18n.organisationMemberListEditToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("personEdit",
                                                { mode : ContentWidget.Mode.EDIT, id : organisationPersonJoin.personId },
                                                null, "organisationEdit",
                                                { id : this.organisationJoin.organisationId, mode : this.mode });
            }));
            return button;
        },

        constructTopDiv : function() {
            var grid = this.constructGrid({
                idProperty : "organisationPersonId", 
                    gridId : this.gridId != null ? this.gridId : "OrganisationMemberListGrid",
                 gridClass : "OnDemandGrid"
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                this.applicationContext.storeInLocalStorage([organisationPersonId], "/organisationMemberList/sort", e.sort);
            }));

            /*
            aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
                var joinDto = args[0];
                this.updateRowClass(row, joinDto);
                return row;
            }));
            */

            return grid;            
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.organisationJoin = params.organisationJoin;
            this.organisationPersonJoins = params.organisationPersonJoins;
            this.actions = params.actions;

            /*
            this.organisationJoins = [];
            for (var n = 0; n < organisationInfos.length; n++) {
                var organisationInfo = organisationInfos[n];
                var organisationJoin = organisationInfo.organisationJoin;
                organisationJoin.actions = DataHelper.getAsSet(organisationInfo.actions);
                organisationJoin.networks = organisationInfo.networks;
                organisationJoin.networkIds = new Object();
                if (organisationJoin.networks != null) {
                    for (var z = 0; z < organisationJoin.networks.length; z++) {
                        organisationJoin.networkIds[organisationJoin.networks[z].id] = true;
                    }
                }

                this.organisationJoins.push(organisationJoin);
            }
            */

            this.updateAuxiliaryData();

            this.reload();
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                var organisationPersonJoin = this.organisationPersonJoins[n];
                this.updateAuxiliaryDataForJoinDto(organisationPersonJoin);
            }
        },

        updateAuxiliaryDataForJoinDto : function(organisationPersonJoin) {
            organisationPersonJoin._nameString = this.nameFormatter(null, organisationPersonJoin);
        },

        updateRowClass : function(domNode, organisationJoin) {
            /*
            domClass.remove(domNode, "personListForeignNetworkRow");

            var contextNetworkId = this.applicationContext.getPageContextNetworkId();
            var organisationNetworkIds = organisationJoin.networkIds;
            if (!(contextNetworkId in organisationNetworkIds)) {
                domClass.add(domNode, "personListForeignNetworkRow");
            }
            */
        },

        reload : function(params) {
            this.setStoreData(this.organisationPersonJoins);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId], "/organisationMemberList/sort");

            if (oldSort == null) {
                this.applicationContext.storeInLocalStorage([organisationPersonId], "/organisationMemberList/sort", this.grid.get("sort"));
            } else {
                this.grid.set("sort", oldSort);
            }           

            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },

        getRowId : function(organisationPersonJoin) {
            return organisationPersonJoin.organisationPersonId;
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    OrganisationMemberListWidget.AsyncOperation = {
    };

    return OrganisationMemberListWidget;
});
