/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = reviewSign
//// i18n-prefix = reviewSign


define([ "cdes/planning/task/ReviewSignListWidget",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dijit/form/TextBox",
    "dijit/form/ValidationTextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/keys",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(ReviewSignListWidget,
    TinyLog,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    InfoDialog,
    TextBox,
    ValidationTextBox,
    domClass,
    domConstruct,
    domStyle,
    Keys,
    on,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.planning.task.ReviewSignWidget";

    var log = new TinyLog(className);

    var ReviewSignWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.changed = true;

            this.allFieldsValid = false;
        },

        getWidgetId : function() {
            return "ReviewSignWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // List Widget
            this.listWidget = new ReviewSignListWidget({
                applicationContext : this.applicationContext,
                             batch : this.batch                
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domConstruct.place(this.listWidgetDiv, topDiv);

            this.pseudoUserTextBox = new TextBox({

            });
            domClass.add(this.pseudoUserTextBox.domNode, "fixedDialogWidget reviewSignPseudoUser");
            domConstruct.place(this.pseudoUserTextBox.domNode, topDiv);            

            // Sign
            DOMHelper.createTextNode("div", i18n.passwordLabel, topDiv, "propertyLabel reviewSignPasswordLabel");
            this.passwordTextBox = new ValidationTextBox({
                   label : i18n.passwordLabel,
                   title : i18n.reviewSignPasswordToolTip,
                    type : "password",
                tabIndex : 1        
            });
            domClass.add(this.passwordTextBox.domNode, "fixedDialogWidget reviewSignPasswordTextBox");
            domConstruct.place(this.passwordTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.passwordTextBox, lang.hitch(this, this.updateWidgetState));
            on(this.passwordTextBox.domNode, "keyup", lang.hitch(this, this.signIfEnter));
            
            this.listWidget.restoreColumnWidths();

            return topDiv;
        },

        signIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER) {
                this.save();
                on.emit(this, "triggerClose");      
            }
        },

        postResizeFunction : function(newSize) {
            var totalHeight = newSize.h;

            var contentHeight = totalHeight
            - 16;

            domStyle.set(this.topDiv, "height", contentHeight + "px");
            this.listWidget.resize({ h : contentHeight - 35});
        },

        setData : function(params) {
            this.tokenInfos = params.tokenInfos;            
            this.listWidget.setData(this.tokenInfos);
        },

        reload : function() {
        },

        save : function() {
            var signInfos = [];
            for (var n = 0; n < this.tokenInfos.length; n++) {
                var currTokenInfo = this.tokenInfos[n];
                var tempFileToOriginalFileName = new Object();
                for (var z = 0; z < currTokenInfo.fileInfos.length; z++) {
                    tempFileToOriginalFileName[currTokenInfo.fileInfos[z].fileName] = currTokenInfo.fileInfos[z].originalFileName;
                }

                signInfos.push({
                                  organisationPersonId : this.applicationContext.getPageContextOrganisationPersonId(),
                                       workflowTokenId : currTokenInfo.workflowTokenId,
                    workflowNodePositionResultOptionId : currTokenInfo.workflowNodePositionResultOptionId,
                 planningNotificationOrderSerialNumber : currTokenInfo.planningNotificationOrderSerialNumber,
                                               comment : currTokenInfo.comment,
                                              password : this.passwordTextBox.get("value"),
                            tempFileToOriginalFileName : tempFileToOriginalFileName                    
                });
            }                

            if (this.batch) {
                this.registerAsyncOperationStarted(ReviewSignWidget.AsyncOperation.SIGN_BATCH);
                var planningNotificationService = this.applicationContext.getService("planningNotificationService");
                planningNotificationService.batchSignWorkflowNodePositionResults(signInfos).then(
                    lang.hitch(this, function(errorStrings) {
                        this.registerAsyncOperationFinished(ReviewSignWidget.AsyncOperation.SIGN_BATCH);
                        var errorString = "Folgende Aufgaben wurden wegen Fehler ignoriert: ";
                        for (var n = 0; n < errorStrings.length; n++) {
	                        errorString += errorStrings[n] + (n < errorStrings.length-1?" ":"");
						}
						errorString += "Öffnen Sie das Prüfinterface und wählen Sie das entsprechende Ergebnis."
            			var infoDialog = new InfoDialog({
				                        title : i18n.error,
				                      content : errorString,
				                 defaultWidth : 350,
				                defaultHeight : 150,
				                      buttons : [{    type : InfoDialog.Button.OK }]                                 
			            });
			            if (errorStrings.length > 0)
        					infoDialog.show();
                        on.emit(this, "batchSignCompleted");
                    }),
                    lang.hitch(this, function(err) {
						var message = i18n.reviewSignBatchSignFailed;
	               		if (err.message != null && err.message.indexOf("NoSuchFileException") != -1)
	               			message = i18n.reviewSignBatchNoSuchFileException;

                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : ReviewSignWidget.AsyncOperation.SIGN_BATCH,
                                    opName : "batchSignWorkflowNodePositionResults",
                                   message : message
                        });
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [batchSignWorkflowNodePositionResults]", err);
                        }));            
            } else {
                // In non-batch mode, we sign exactly one review
                var signInfo = signInfos[0];

                this.registerAsyncOperationStarted(ReviewSignWidget.AsyncOperation.SIGN);
                var planningNotificationService = this.applicationContext.getService("planningNotificationService");
                planningNotificationService.signWorkflowNodePositionResult(signInfo).then(
                    lang.hitch(this, function() {
                        this.registerAsyncOperationFinished(ReviewSignWidget.AsyncOperation.SIGN);
                        
                        if (this.nextTaskJoin != null) {
                            this.applicationContext.setPage("workflowReview",
                                { id : this.nextTaskJoin.workflowTokenId },
                                {
                                      backPage : this.backPage,
                                    backParams : this.backParams,
                                     taskJoins : this.taskJoins
                                });
                        } else {
                            this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
                        }
                    }),
                    lang.hitch(this, function(err) {
						var message = i18n.reviewSignSignFailed;
	               		if (err.message != null && err.message.indexOf("NoSuchFileException") != -1)
	               			message = i18n.reviewSignNoSuchFileException;
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : ReviewSignWidget.AsyncOperation.SIGN,
                                    opName : "signWorkflowNodePositionResult",
                                   message : message
                        });
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while calling function [signWorkflowNodePositionResult]", err);
                        }));            
            }                
        },

        updateWidgetState : function() {
            var password = this.passwordTextBox.get("value");
            var allFieldsValid = password != null && password.length > 0;
            if (allFieldsValid != this.allFieldsValid) {
                this.allFieldsValid = allFieldsValid;
                on.emit(this, "validStateChange");
            }       
        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    ReviewSignWidget.AsyncOperation = {
        SIGN : "Sign",
        SIGN_BATCH : "SignBatch"        
    };

    return ReviewSignWidget;
});
