/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = metaTagList
////i18n-prefix = metaTagList

define([ "cdes/util/ActionHelper",
	"cdes/widget/base/ListWidget",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
	"clazzes/topic",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/InfoDialog",
	"dgrid/OnDemandGrid",
	"dgrid/extensions/ColumnResizer",
	"dgrid/extensions/DijitRegistry",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dstore/Memory",
	"dstore/Trackable",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(ActionHelper,
			ListWidget,
			TinyLog,
			FancyButton,
			topic,
			ErrorHelper,
			ContentWidget,
			InfoDialog,
			OnDemandGrid,
			ColumnResizer,
			DijitRegistry,
			domClass,
			domConstruct,
			on,
			declare,
			lang,
			Memory,
			Trackable,
			i18n) {

	var className = "at.cdes.web.planning.template.MetaTagListWidget";

	var log = new TinyLog(className);

	var MetaTagListWidget = declare(className, ListWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "MetaTagListWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

        columnWidthKey : "metaTagList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            return [organisationPersonId ];
        },

		constructColumns : function() {
			var columns = [];

			columns.push({
				field : "position",
				id : "position",
				sortable : true,
				label : i18n.metaTagListPositionColumn
			});

			columns.push({
				field : "name",
				id : "name",
				sortable : true,
				label : i18n.metaTagListNameColumn
			});

			columns.push({
				field : "type",
				id : "type",
				formatter : lang.hitch(this, this.typeFormatter),
				sortable : true,
				label : i18n.metaTagListTypeColumn
			});

			columns.push({
				field : "tagFormat",
				id : "tagFormat",
				formatter : lang.hitch(this, this.tagFormatFormatter),
				sortable : true,
				label : i18n.metaTagListTagFormatColumn
			});

			columns.push({
				field : "sharepointReferenceName",
				id : "sharepointReferenceName",
				sortable : true,
				label : i18n.metaTagListSharepointReferenceNameColumn
			});

			columns.push({
				field : "multiple",
				id : "multiple",
				formatter : lang.hitch(this, this.multipleFormatter),
				sortable : true,
				label : i18n.metaTagListMultipleColumn
			});     

			columns.push({
				field : "priority",
				id : "priority",
				formatter : lang.hitch(this, this.priorityFormatter),
				sortable : true,
				label : i18n.metaTagEditPriorityLabel
			});

			columns.push({
				field : "mandatory",
				id : "mandatory",
				formatter : lang.hitch(this, this.mandatoryFormatter),
				sortable : true,
				label : i18n.metaTagListMandatoryColumn
			});     

			columns.push({
				field : "cssClass",
				id : "cssClass",
				sortable : true,
				label : i18n.metaTagListCssClassColumn
			});

			columns.push({
				field : "TODO", // TODO
				id : "actions",
				renderCell : lang.hitch(this, this.renderActionCell),
				sortable : false,
				label : i18n.actionColumnCaption
			});

			return columns;
		},

		tagFormatFormatter : function(tagFormat, metaTag) {
			if (tagFormat == 0) {
				return i18n.metaTagTextTagFormat;
			} else if (tagFormat == 1) {
				return i18n.metaTagDateTagFormat;
			} else if (tagFormat == 2) {
				return i18n.metaTagDateTimeTagFormat;
			} else {
				return "---";
			}       
		},

		multipleFormatter : function(multiple, metaTag) {
			if (multiple) {
				return i18n.yes;
			} else {
				return i18n.no;
			}       
		},      

		priorityFormatter : function(priority, metaTag) {
			if (priority == 0) {
				return i18n.metaTagListShowAlwaysPriority;
			} else if (priority == 1) {
				return i18n.metaTagListShowOnRequestPriority;
			} else {
				return "---";
			}		
		},	    

		mandatoryFormatter : function(mandatory, metaTag) {
			if (mandatory) {
				return i18n.yes;
			} else {
				return i18n.no;
			}       
		},      

		typeFormatter : function(type, metaTag) {
			if (type == 0) {
				return i18n.metaTagPlanningNotificationType;
			} else if (type == 1) {
				return i18n.metaTagWorkflowNodePositionType;
			} else if (type == 2) {
				return i18n.metaTagWorkflowNodePositionOptionalType;
			} else {
				return "---";
			}       
		},      

		renderActionCell : function(dataObject, data, cell) {
			var buttonDiv = domConstruct.create("div", null, null);

			if (true) { // TODO
				var editButton = this.constructEditButton(dataObject);
				domConstruct.place(editButton.domNode, buttonDiv);
			}

			if (true) {
				var deleteButton = this.constructDeleteButton(dataObject);
				domConstruct.place(deleteButton.domNode, buttonDiv);		
			}		    

			return buttonDiv;
		},

		constructEditButton : function(metaTag) {
			var button = new FancyButton({
				title : i18n.metaTagListEditToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
			});
			domClass.add(button.domNode, "listButton");
			on(button, "click", lang.hitch(this, function() {
				this.applicationContext.setPage("metaTagEdit",
						{ mode : ContentWidget.Mode.EDIT, id : metaTag.id },
						{ backPage : this.backPage, backParams : this.backParams });
			}));

			return button;
		},


		constructDeleteButton : function(metaTag) {
			var button = new FancyButton({
				title : i18n.metaTagListDeleteToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
			});
			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
				InfoDialog.showQuestion({
					title : i18n.metaTagListAskDeleteCaption,
					message : i18n.metaTagListAskDeleteQuestion,
					buttons : [
						{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
							this.doDeleteMetaTag(metaTag);
						})},    			           
						{ type : InfoDialog.Button.NO }
						]
				});
			}));
			return button;
		},

		doDeleteMetaTag : function(metaTag) {	
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			this.registerAsyncOperationStarted(MetaTagListWidget.AsyncOperation.DELETE);

			planningNotificationService.deleteMetaTag(metaTag).then(
					lang.hitch(this, function(result) {
						this.registerAsyncOperationFinished(MetaTagListWidget.AsyncOperation.DELETE);
						if (!result) {
							topic.publish("message/error", {
								message : i18n.metaTagListDeleteNotPossible,
								showInDialog : true,
								details : null
							}); 
						} else {
							on.emit(this, "doSearch");
						}			    
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : MetaTagListWidget.AsyncOperation.DELETE,
							opName : "deleteMetaTag",
							message : i18n.metaTagListDeleteMetaTagFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [deleteMetaTag]", err);
							}));
		},	    

		constructTopDiv : function() {
			return this.constructGrid({
				idProperty : "id", 
				gridId : "MetaTagListWidgetGrid"
			}); 
		},

		resize : function(newSize) {
			this.grid.resize(newSize);
		},

		setData : function(params) {
			this.metaTags = params.metaTags;
			this.reload();
		},

		reload : function(params) {

			this.store.setData(this.metaTags);

			this.grid.set("sort", "position", false);
			this.grid.updateSortArrow(this.grid.sort);
			this.grid.refresh();
		},

		destroy : function() {
			this.inherited(arguments);

			this.grid.destroy();
		}
	});

	MetaTagListWidget.AsyncOperation = {
			DELETE : "Delete"
	};

	return MetaTagListWidget;
});
