/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
        "cdes/util/I18nHelper",
        "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/util/DOMHelper",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
    "dojo/string"
], function(
            I18nHelper,
            NameHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    DOMHelper,
    domClass,
    domConstruct,
    domStyle,
    on,    
    declare,
    lang,
    i18n,
    string
) {

    var className = "at.cdes.review.ReviewProtocolResultListWidget";

    var log = new TinyLog(className);

    var ReviewProtocolResultListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolResultListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "reviewProtocolResultList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

	    columns.push({
		     field : "_reviewer",
			id : "reviewer",
                renderCell : lang.hitch(this, this.renderReviewer),
		  sortable : true,
		    label : i18n.reviewProtocolResultReviewerCaption
	    });

	    columns.push({
		     field : "_realm",
			id : "realm",
                renderCell : lang.hitch(this, this.renderRealm),
		  sortable : true,
		    label : i18n.reviewProtocolResultRealmCaption
	    });

	    columns.push({
		    field : "_reviewDate",
		       id : "reviewDate",
                formatter : lang.hitch(this, this.formatReviewDate),
		 sortable : true,
		    label : i18n.reviewProtocolResultDateCaption
	    });

	    columns.push({
		     field : "_review",
			id : "review",
     	renderCell  : lang.hitch(this, this.renderReview),
		  sortable : true,
		     label : i18n.reviewProtocolResultReviewCaption
	    });

	    columns.push({
		     field : "_result",
		        id : "result",
                 formatter : lang.hitch(this, this.formatResult),
		  sortable : true,
		     label : i18n.reviewProtocolResultResultCaption
	    });

            return columns;            
        },

        getPositionMainPersonString : function(positionJoin) {
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionMainPerson");
            var result = string.substitute(i18n.deputyPerson, {
                person : personCommonName
            });
            return result;            
        },

        getPositionMainPersonWithOrganisationString : function(positionJoin) {
            var organisationName = positionJoin.positionMainOrganisationName;
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionMainPerson");
            var result = string.substitute(i18n.deputyPersonWithOrganisation, {
                person : personCommonName,
                organisation : organisationName                
            });
            return result;            
        },

        getPositionPersonString : function(positionJoin) {
            var organisationName = positionJoin.positionOrganisationName;
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionPerson");
            var result = string.substitute(i18n.organisationCommonName, {
                organisationName : organisationName,
                personCommonName : personCommonName                
            });
            return result;
        },            

        renderReviewer : function(resultJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
			DOMHelper.createTextNode("div", this.getPositionPersonString(resultJoin), cellDiv, null);
            if (!resultJoin.positionParticipantMainParticipantFlag || resultJoin.positionParticipantInactiveFlag) {
			    if (resultJoin.positionOrganisationId != resultJoin.positionMainOrganisationId) {
	                DOMHelper.createTextNode("div", this.getPositionMainPersonWithOrganisationString(resultJoin), cellDiv, "reviewProtocolPositionDeputy");
	            } else if (resultJoin.positionPersonId != resultJoin.positionMainPersonId) {
	                DOMHelper.createTextNode("div", this.getPositionMainPersonString(resultJoin), cellDiv, "reviewProtocolPositionDeputy");
	            }
            }
            return cellDiv;
        },

        renderRealm : function(positionJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            if (positionJoin.realmCode != null) {
                DOMHelper.createTextNode("span", positionJoin.realmCode, cellDiv, "reviewProtocolPositionRealmCodeLabel");
            }
            if (positionJoin.realmName != null) {
                DOMHelper.createTextNode("span", positionJoin.realmName, cellDiv, "reviewProtocolPositionRealmNameLabel");
            }                
            return cellDiv;            
        },

        formatReviewDate : function(date, resultJoin) {
            var resultDate;
            if (this.isCellConnectionJoin(resultJoin)) {
                resultDate = resultJoin.destVersionCellConnectionResultResultDate;
            } else {
                resultDate = resultJoin.reviewCycleEntryResultResultDate;
            }                

    	    if (resultDate != null) {
    			return DateHelper.formatUtcSecondsWithTimeZone(resultDate, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern); 
    	    } else {
    			return "";
    	    }

            return "";            
        },

        renderReview : function(positionJoin, data, cell) {
            var referenceDiv = domConstruct.create("div", null, null);
            var comment = "";
            var node;
            if (this.isCellConnectionJoin(positionJoin)) {
                comment = positionJoin.connectionResultStatementResultComment!=null?positionJoin.connectionResultStatementResultComment:"";
            } else {
                comment = positionJoin.reviewCycleEntryStatementResultComment!=null?positionJoin.reviewCycleEntryStatementResultComment:"";
            }
            // Safe html thanks to server side
        	var node = domConstruct.create("div", { innerHTML : comment });
            domClass.add(node, "reviewProtocolPositionComment");                    
            domConstruct.place(node, referenceDiv);                
            return referenceDiv;            
        },            

        formatResult : function(_comment, resultJoin) {
            var resultOptionId;
            if (this.isCellConnectionJoin(resultJoin)) {
                resultOptionId = resultJoin.connectionResultStatementResultReviewCycleResultOptionId;
            } else {
                resultOptionId = resultJoin.reviewCycleEntryStatementResultReviewCycleResultOptionId;
            }

            var resultOption = resultOptionId != null ? this.reviewContext.getResultOption(resultOptionId) : null;            
            if (resultOption != null && resultOption.name != null) {
                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                var resultOptionName = I18nHelper.getCurrentLocaleString(resultOption.name, locale);
                return resultOptionName;
            } else {
                return "";
            }                
        },            

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

	    var grid = this.constructGrid({
		idProperty : "_id", 
		    gridId : "ReviewProtocolResultGrid",
                 gridClass : "Grid"
	    });
            /*            
	    on(grid, "dgrid-sort", lang.hitch(this, function(e) {
		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		var networkId = this.applicationContext.getPageContextPnNetworkId();
		this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", e.sort);
	    }));
            */
            domConstruct.place(grid, topDiv);

            return topDiv;
        },

        setData : function(params) {
            this.resultJoins = params.resultJoins;
            this.reviewContext = params.reviewContext;

            this.reload();
        },

        reload : function() {
            this.updateAuxiliaryData();
            this.setStoreData(this.resultJoins);
            this.grid.resize();
        },

        isCellConnectionJoin : function(resultJoin) {
            return resultJoin.destVersionCellConnectionResultId != null;
        },            

	updateAuxiliaryData : function() {
            for (var n = 0; n < this.resultJoins.length; n++) {
                var resultJoin = this.resultJoins[n];
                resultJoin._reviewer = this.getPositionPersonString(resultJoin);
                if (!resultJoin.positionParticipantMainParticipantFlag || resultJoin.positionParticipantInactiveFlag) {
					if (resultJoin.positionOrganisationId != resultJoin.positionMainOrganisationId) {
                    	resultJoin._reviewer += this.getPositionMainPersonWithOrganisationString(resultJoin);
		            } else if (resultJoin.positionPersonId != resultJoin.positionMainPersonId) {
                    	resultJoin._reviewer += this.getPositionMainPersonString(resultJoin);
		            }
                }    

                resultJoin._realm = "";
                if (resultJoin.realmCode != null) {
                    resultJoin._realm += resultJoin.realmCode;
                }
                if (resultJoin.realmName != null) {
                    resultJoin._realm += resultJoin.realmName;
                }                                
                //resultJoin._reviewDate = this.formatReviewDate(null, resultJoin);
                //resultJoin._review = this.formatReview(null, resultJoin);
                //resultJoin._result = this.formatResult(null, resultJoin);
            }
	},

        updateWidgetState : function() {

        },

        resize : function(newSize) {
            // We need to perform the resize in two steps.
            // First set the desired width, and some arbitrary height.
            var width = newSize.w + 0.01;
            var height = this.getActualHeight();
            this.grid.resize({ w : width, h : height });
        },

        destroy : function() {
            this.inherited(arguments);
            this.grid.destroy();
        }
    });

    ReviewProtocolResultListWidget.AsyncOperation = {
        DELETE : "Delete"
    };        

    return ReviewProtocolResultListWidget;
});
