/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([
        "clazzes/TinyLog",
        "clazzes/util/ErrorHelper",
        "dojo/Deferred",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(TinyLog,
            ErrorHelper,
            Deferred,
            i18n
            ) {
    
    var className = "at.cdes.web.util.CommonEntityHelper";
    
    var log = new TinyLog(className);
    
    var CommonEntityHelper = {

        getOrLoadCountries : function(applicationContext) {
            var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
            
            var countries = applicationContext.getCountries();
            if (countries != null) {
                var deferred = new Deferred();
                deferred.resolve(countries);
                return deferred;
            } else {
                var utilService = applicationContext.getUtilService();
                var deferred = utilService.getAllCountries(organisationPersonId);
                deferred.then(function(countries) {
                    applicationContext.setCountries(countries);
                }, function(err) {                
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : null,
                                opName : "getAllCountries",
                               message : i18n.applicationContextLoadCountriesFailed
                    });
                }).otherwise(function(err) {
                    log.error("Error while processing the results of a call to getCountries: ", err);
                });
                return deferred;
            }
        },

        getCountryLanguageAttribute : function() {
            var locale = dojo.locale;
            if (locale != null && locale.indexOf("de") == 0) {
                return "descDe";
            } else {
                return "descEn";
            }
        },

        getDefaultCountrySelectOptions : function(countries) {
            var code2ToCountry = new Object();
            for (var n = 0; n < countries.length; n++) {
                var country = countries[n];
                var code2 = country.code2;
                code2ToCountry[code2] = country;
            }

            var options = [];
            var attribute = CommonEntityHelper.getCountryLanguageAttribute();
            for (code2 in code2ToCountry) {
                CommonEntityHelper.addSelectOptionIfExists(code2ToCountry, code2, options, attribute);
            }
            
            options.sort(function(optionOne, optionTwo) {
                return optionOne.label.localeCompare(optionTwo.label);
            });

            return options;

/*
| BE    | BEL   |  56 | BELGIUM                                      | Belgien                                      |
| BG    | BGR   | 100 | BULGARIA                                     | Bulgarien                                    |
| DK    | DNK   | 208 | DENMARK                                      | Dänemark                                     |
| DE    | DEU   | 276 | GERMANY                                      | Deutschland                                  |
| EE    | EST   | 233 | ESTONIA                                      | Estland                                      |
| FI    | FIN   | 246 | FINLAND                                      | Finnland                                     |
| FR    | FRA   | 250 | FRANCE                                       | Frankreich                                   |
| GR    | GRC   | 300 | GREECE                                       | Griechenland                                 |
| IE    | IRL   | 372 | IRELAND                                      | Irland                                       |
| IT    | ITA   | 380 | ITALY                                        | Italien                                      |
| HR    | HRV   | 191 | CROATIA                                      | Kroatien                                     |
| LV    | LVA   | 428 | LATVIA                                       | Lettland                                     |
| LI    | LIE   | 438 | LIECHTENSTEIN                                | Liechtenstein                                |
| LT    | LTU   | 440 | LITHUANIA                                    | Litauen                                      |
| LU    | LUX   | 442 | LUXEMBOURG                                   | Luxemburg                                    |
| MT    | MLT   | 470 | MALTA                                        | Malta                                        |
| NL    | NLD   | 528 | NETHERLANDS                                  | Niederlande                                  |
| PL    | POL   | 616 | POLAND                                       | Polen                                        |
| PT    | PRT   | 620 | PORTUGAL                                     | Portugal                                     |
| RO    | ROU   | 642 | ROMANIA                                      | Rumänien                                     |
| SE    | SWE   | 752 | SWEDEN                                       | Schweden                                     |
| CH    | CHE   | 756 | SWITZERLAND                                  | Schweiz                                      |
| SK    | SVK   | 703 | SLOVAKIA                                     | Slowakei                                     |
| SI    | SVN   | 705 | SLOVENIA                                     | Slowenien                                    |
| ES    | ESP   | 724 | SPAIN                                        | Spanien                                      |
| CZ    | CZE   | 203 | CZECH REPUBLIC                               | Tschechien                                   |
| HU    | HUN   | 348 | HUNGARY                                      | Ungarn                                       |
| CY    | CYP   | 196 | CYPRUS                                       | Zypern                                       |
*/

        },

        addSelectOptionIfExists : function(code2ToCountry, code2, options, attribute) {
            if (code2 in code2ToCountry) {
                var country = code2ToCountry[code2];
                options.push({ value : country.id, label : country[attribute] });
                delete code2ToCountry[code2];
            }
        }      

    };

    return CommonEntityHelper;
});
