define([ 
         "cdes/util/CodeHelper",
         "cdes/widget/document/DocumentNumberSpinBox",
         "cdes/widget/util/DnDCellWidget",
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/util/DataHelper",
         "clazzes/util/DOMHelper",
         "clazzes/form/FancySelect",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/layout/InfoDialog",
         "dijit/_WidgetBase",
         "dijit/form/Select",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 CodeHelper,
    		 DocumentNumberSpinBox,
    		 DnDCellWidget,
    		 TinyLog,
    		 topic,
    		 DataHelper,
    		 DOMHelper,
    		 FancySelect,
             WidgetHelper,
             InfoDialog,
    		 _WidgetBase,
    		 Select,
    		 domClass,
    		 domConstruct,
    		 on,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.widget.document.DocumentNumberEditor";

	var log = new TinyLog(className);
	
    var DocumentNumberEditor = declare(className, [_WidgetBase, DnDCellWidget], {
    	
    	// summary:
    	//     Editor for document numbers in the plan deliver catalogue.
    	
    	// objectPlannerGetter:
    	//	   Parameterless function returning the object/objectPlanner/projectParticipation joinDto to be used for the corresponding
    	//	   contents in the DocumentNumberEditor
    	
    	buildRendering : function() {
    		this.inherited(arguments);   		
    		
    		var project = this.applicationContext.getPageContextProject();
    		var documentNumberPartGroupId = project ? project.documentNumberPartGroupId : null;
    		this.partInfos = [];
    		
    		this.errors = new Object();
    		
    		this.domNode = domConstruct.create("div", null, null);
    		//this.domNode = domConstruct.create("table", null, null);
    		//var tr = domConstruct.create("tr", null, this.domNode);
    		
    		if (documentNumberPartGroupId != null) {
    			var documentNumberGroup = this.applicationContext.getDocumentNumberGroup(documentNumberPartGroupId);
    			
    			if (documentNumberGroup != null) {
        			this.masterData = this.applicationContext.getMasterData(documentNumberGroup.masterDataSetId);
        			var numberParts = (this.masterData && documentNumberPartGroupId in this.masterData.groupIdToDocumentNumberParts 
        									? this.masterData.groupIdToDocumentNumberParts[documentNumberPartGroupId] : null);
        			
        			for (var n = 0; numberParts && n < numberParts.length; n++) {
        				var numberPart = numberParts[n];
        				var component = CodeHelper.getDocNumberComponentByOgnlPath(numberPart.ognlRule);
        				
        				var editorNode;
        				if (component == CodeHelper.DocumentNumberComponent.DOCUMENT_TYPE_CODE) {
        					var editor = this.constructDocumentTypeSelect(this.masterData);
        					domClass.add(editor.domNode, "documentNumberEditorWidget");
        					this.handleDocumentTypeSelectEvents(editor);
        					editorNode = editor.domNode;
        				} else if (component == CodeHelper.DocumentNumberComponent.DOCUMENT_TYPE_GROUP_CODE) {
//        					var editor = this.constructDocumentTypeSelect(this.masterData); // TODO: output group as label, fetch document type from DOCUMENT_TYPE_CODE
        					
        					// TODO: Event handling
        					
//        					editorNode = editor.domNode;
        					var editor = domConstruct.create("span", null, null);
        					editorNode = editor;
        				} else if (component == CodeHelper.DocumentNumberComponent.DOCUMENT_NUMBER) {        					
        					var editor = this.constructDocumentNumberSpinner(numberPart);
        					domClass.add(editor.domNode, "documentNumberEditorWidget");        					
        					this.handleDocumentNumberSpinnerEvents(editor);
        					editorNode = editor.domNode;
        					domClass.add(editorNode, "documentNumberEditorDocNumberSpinner");
        				} else {
        					var editor = domConstruct.create("span", null, null);
        					editorNode = editor;
        				}
        				
        				//var td = domConstruct.create("td", null, tr);
        				//domConstruct.place(editorNode, td);
        				domConstruct.place(editorNode, this.domNode);
        				
        				if (numberPart.seperator != null && n < numberParts.length - 1) {
        					var separatorSpan = domConstruct.create("span", null, null);
        					DOMHelper.setInnerText(separatorSpan, numberPart.seperator);
        					domConstruct.place(separatorSpan, this.domNode);        					
        					
        					//var separatorTd = domConstruct.create("td", null, null);
        					//DOMHelper.setInnerText(separatorTd, numberPart.seperator);
        					//domConstruct.place(separatorTd, tr);
        				}
        				
        				this.partInfos.push({
        					component : component,
        					   editor : editor,
					   	   numberPart : numberPart
        				});
        			}
        			
        			//this.constructDnDButtonCell(tr, "pullDownIcon");
        			if (this.dndStartTopic) {
        				this.constructDnDButtonCell(this.domNode, "pullDownIcon");	
        			}        			
    			}
    		}
    	},
    	
    	handleDocumentTypeSelectEvents : function(editor) {
			WidgetHelper.handleSelectEvents(editor, lang.hitch(this, function() {
				// Clone this.documentNumberInfo.  If we would not do this, the event handling inside
				// dgrid would eat up the change event, since it things that nothing has changed
				// (i.e. we have to make the reference change, not just the contents inside the object)
				this.cloneDocumentNumberInfo();
				
				var documentTypeId = editor.get("value");
				//get documentType object
    			var documentType = documentTypeId != null && documentTypeId in this.masterData.idToDocumentType 
										? this.masterData.idToDocumentType[documentTypeId] : null;
				
				//check, if a group was selected and prevent this
				if (documentType._children)
	    			InfoDialog.showError({ title : i18n.documentNumberEditorNumberGroupSelectedCaption, message : i18n.documentNumberEditorNumberGroupSelectedMessage });    			
				else
					this.documentNumberInfo.documentTypeId = documentTypeId;
					
				this.setEditorValue(this.documentNumberInfo);
				on.emit(this, "change");
			}));    		
    	},
    	
    	handleDocumentNumberSpinnerEvents : function(editor) {
			WidgetHelper.handleSpinnerEvents(editor, lang.hitch(this, function() {
				// See above why we clone() here.
				this.cloneDocumentNumberInfo();
				this.documentNumberInfo.number = editor.get("value");
				on.emit(this, "change");
			}));    		
    	},
    	
    	constructDocumentTypeSelect : function(masterData) {
    		var options = [];
    		
    		var documentTypes = [];
    		for (var id in masterData.idToDocumentType) {
    			var documentType = masterData.idToDocumentType[id];
    			if (documentType.documentTypeGroupId == null) {
    				documentTypes.push(documentType);	
    			}
    		}
    		
    		this.addToDocumentTypeOptions(options, documentTypes, 0);

    		var documentTypeSelect = new FancySelect({
    			  label : i18n.documentNumberEditorTypeSelectLabel,
    			  title : i18n.documentNumberEditorTypeSelectToolTip,
    			options : options
    		});
    		return documentTypeSelect;
    	},
    	
    	addToDocumentTypeOptions : function(options, documentTypes, indendation) {
    		documentTypes.sort(function(documentTypeOne, documentTypeTwo) {
    			return documentTypeOne.code - documentTypeTwo.code;
    		});
    		
    		for (var n = 0; n < documentTypes.length; n++) {
    			var documentType = documentTypes[n];
    			var longLabel = (documentType._children == null || documentType._children.length == 0 
    					? documentType.code + " - " + documentType.name : "<b>" + documentType.code + " - " + documentType.name + "</b>");
    			for (var z = 0; z < indendation; z++) {
    				longLabel = "&#160;&#160;&#160;" + longLabel;
    			}
    			
    			options.push({
    				    label : documentType.code,
    				longLabel : longLabel,
    				    value : documentType.id
    			});
    			
    			if (documentType._children != null && documentType._children.length > 0) {
    				this.addToDocumentTypeOptions(options, documentType._children, indendation + 1);
    			}
    		}
    	},
    	
    	constructDocumentNumberSpinner : function(numberPart) {
    		var documentNumberSpinner = new DocumentNumberSpinBox({
    			            label : i18n.documentNumberEditorNumberSpinnerLabel,
    			            title : i18n.documentNumberEditorNumberSpinnerToolTip,
    			numberPartPattern : numberPart.format
    		});
    		
    		return documentNumberSpinner;
    	},
    	
    	setEditorValue : function(value, priorityChange) {
    		
    		// TODO: Is taking things like the project code from the page context ok?
    		
   			this.documentNumberInfo = value;
   			
   			for (var n = 0; n < this.partInfos.length; n++) {
   				var component = this.partInfos[n].component;
   				var editor = this.partInfos[n].editor;
   				var numberPart = this.partInfos[n].numberPart;
    				
   				switch(component) {
   					case CodeHelper.DocumentNumberComponent.DOCUMENT_TYPE_CODE:
   						editor.set("value", this.documentNumberInfo.documentTypeId, false);
   						break;
   					case CodeHelper.DocumentNumberComponent.DOCUMENT_TYPE_GROUP_CODE:
   						var documentType = this.documentNumberInfo.documentTypeId != null && this.documentNumberInfo.documentTypeId in this.masterData.idToDocumentType 
												? this.masterData.idToDocumentType[this.documentNumberInfo.documentTypeId] : null;
						var documentTypeGroup = documentType.documentTypeGroupId != null && documentType.documentTypeGroupId in this.masterData.idToDocumentType
												? this.masterData.idToDocumentType[documentType.documentTypeGroupId] : null;
//						editor.set("value", documentTypeGroup);    						
   						DOMHelper.setInnerText(editor, documentTypeGroup ? documentTypeGroup.code : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.DOCUMENT_NUMBER:
   						editor.set("value", this.documentNumberInfo.number, false);
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECTPLANNER_CODE:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;
   						DOMHelper.setInnerText(editor, objectPlannerJoinDto ? objectPlannerJoinDto.objectPlannerCode : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECTPLANNER_RELEASE_CODE:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;
   						DOMHelper.setInnerText(editor, objectPlannerJoinDto ? objectPlannerJoinDto.objectPlannerReleaseCode : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECT_CODE_FULL:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;   						
   						var code = objectPlannerJoinDto ? objectPlannerJoinDto.objectCode : "";
   						
   						var objectTypeId = objectPlannerJoinDto ? objectPlannerJoinDto.objectObjectTypeId : null;
   						var objectType = objectTypeId != null ? this.masterData.idToObjectType[objectTypeId] : null;
   						if (objectType != null) {
   							code += objectType.code;
   						}
   						DOMHelper.setInnerText(editor, code)
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECT_RELEASE_CODE_FULL:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;   						
   						var code = objectPlannerJoinDto != null && objectPlannerJoinDto.objectReleaseCode != null ? objectPlannerJoinDto.objectReleaseCode : "";
   						
   						var objectTypeId = objectPlannerJoinDto ? objectPlannerJoinDto.objectReleaseObjectTypeId : null;
   						var objectType = objectTypeId != null ? this.masterData.idToObjectType[objectTypeId] : null;
   						if (objectType != null) {
   							code += objectType.code;
   						}
   						DOMHelper.setInnerText(editor, code)
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECT_CODE:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;   						
   						DOMHelper.setInnerText(editor, objectPlannerJoinDto ? objectPlannerJoinDto.objectCode : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECT_RELEASE_CODE:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;   						
   						DOMHelper.setInnerText(editor, objectPlannerJoinDto ? objectPlannerJoinDto.objectReleaseCode : "");   						
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECT_TYPE_CODE:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;   						
   						var objectTypeId = objectPlannerJoinDto ? objectPlannerJoinDto.objectObjectTypeId : null;
   						DOMHelper.setInnerText(editor, objectTypeId != null ? this.masterData.idToObjectType[objectTypeId].code : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.OBJECT_RELEASE_TYPE_CODE:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;   						
   						var objectTypeId = objectPlannerJoinDto ? objectPlannerJoinDto.objectReleaseObjectTypeId : null;
   						DOMHelper.setInnerText(editor, objectTypeId != null ? this.masterData.idToObjectType[objectTypeId].code : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.SUBPROJECT_CODE:
   						var subProject = this.applicationContext.getPageContextSubProject();
   						DOMHelper.setInnerText(editor, (subProject.code != null ? subProject.code : "") + (subProject.number != null ? subProject.number : ""));
   						break;
   					case CodeHelper.DocumentNumberComponent.SUBPROJECT_CODE_WITHOUTNUMBER:
   						var subProject = this.applicationContext.getPageContextSubProject();
   						DOMHelper.setInnerText(editor, (subProject.code != null ? subProject.code : ""));
   						break;
   					case CodeHelper.DocumentNumberComponent.SUBPROJECT_NUMBER:
   						var subProject = this.applicationContext.getPageContextSubProject();
   						//CodeHelper.formatStringCode(numberPart.format, documentNumberInfo.subProjectNumber);
   						DOMHelper.setInnerText(editor, (subProject.number != null ? CodeHelper.formatIntegerCode(numberPart.format, subProject.number) : ""));
   						break;
   					case CodeHelper.DocumentNumberComponent.SUBPROJECT_TYPE_CODE:
   						var subProject = this.applicationContext.getPageContextSubProject();
   						var subProjectTypeId = subProject ? subProject.subProjectTypeId : null;
   						DOMHelper.setInnerText(editor, subProjectTypeId ? this.masterData.idToSubProjectType[subProjectTypeId].code : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.PROJECT_CODE:
   						var project = this.applicationContext.getPageContextProject();
   						var projectCode = project ? project.code : null;
   						DOMHelper.setInnerText(editor, projectCode ? projectCode : "");
   						break;
   					case CodeHelper.DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID:
   						// See DocumentNumberEditor.extractEditorInfoFromJoinDto - that function extracts the needed JoinDto attributes to documentNumberInfo
   						var objectPlannerJoinDto = this.objectPlannerGetter ? this.objectPlannerGetter() : this.documentNumberInfo;   						
   						DOMHelper.setInnerText(editor, objectPlannerJoinDto ? objectPlannerJoinDto.projectParticipationCustomerId : "");
   						break;
   					default:
   						log.warn("Found unknown component of numberpart: ", component);
   				}
   			}

        },
        
        getEditorValue : function() {
        	return this.documentNumberInfo;
        },
        
        updateDataFromWidgets : function() {
        	for (var n = 0; n < this.partInfos.length; n++) {
        		var component = this.partInfos[n].component;
        		var editor = this.partInfos[n].editor;
        		switch (component) {
        			case CodeHelper.DocumentNumberComponent.DOCUMENT_TYPE_CODE:
        				var documentType = editor.get("value");
        				this.documentNumberInfo.documentTypeId = documentType;
        				break;
        			case CodeHelper.DocumentNumberComponent.DOCUMENT_NUMBER:
        				var documentNumber = editor.get("value");
        				this.documentNumberInfo.number = documentNumber;
        				break;
        		}
        	}        	
        },
        
        updateWidgetsFromData : function() {
        	for (var n = 0; n < this.partInfos.length; n++) {
        		var component = this.partInfos[n].component;
        		var editor = this.partInfos[n].editor;
        		switch (component) {
        			case CodeHelper.DocumentNumberComponent.DOCUMENT_TYPE_CODE:
        				editor.set("value", this.documentNumberInfo.documentTypeId);
        				break;
        			case CodeHelper.DocumentNumberComponent.DOCUMENT_NUMBER:
        				editor.set("value", this.documentNumberInfo.number);
        				break;
        		}
        	}        	
        },
        
        getDocumentNumberEditor : function() {
        	for (var n = 0; n < this.partInfos.length; n++) {
        		if (this.partInfos[n].component == CodeHelper.DocumentNumberComponent.DOCUMENT_NUMBER) {
        			return this.partInfos[n].editor;
        		}
        	}
        	return null;
        },
        
        setDocumentNumberError : function(message) {
        	var editor = this.getDocumentNumberEditor();
        	if (editor && editor.domNode) {
    			domClass.add(editor.domNode, "errorField");
    			editor.set("title", message);
    			
    			this.errors.documentNumberError = true;
    			this.errors.documentNumberErrorMessage = message;
        	}
        },
        
        dropDocumentNumberError : function() {
        	var editor = this.getDocumentNumberEditor();

        	// Editor might have been removed already from the dom tree. 
        	if (editor && editor.domNode) {
    			domClass.remove(editor.domNode, "errorField");
    			editor.set("title", i18n.documentNumberEditorNumberSpinnerToolTip);
    			
    			this.errors.documentNumberError = false;
        	}        	
        },
        
        hasDocumentNumberError : function() {
        	return !!this.errors.documentNumberError;
        },
        
        getDocumentNumberErrorMessage : function() {
        	return this.errors.documentNumberErrorMessage;
        },
        
        cloneDocumentNumberInfo : function() {
        	var newDocumentNumberInfo = new Object();
        	for (var a in this.documentNumberInfo) {
        		newDocumentNumberInfo[a] = this.documentNumberInfo[a]; 
        	}
        	this.documentNumberInfo = newDocumentNumberInfo;
        }
    });
    
    DocumentNumberEditor.extractEditorInfo = function(document) {
    	document._documentNumberInfo = {
    	    _creationIndex : document._creationIndex,
    		documentTypeId : document.documentTypeId,
    		        number : document.number
    	};
    };
    
    DocumentNumberEditor.extractEditorInfoFromJoinDto = function(applicationContext, numberParts, joinDto) {
		var project = applicationContext.getPageContextProject();
		var documentNumberPartGroupId = project ? project.documentNumberPartGroupId : null;
		var documentNumberGroup = documentNumberPartGroupId ? applicationContext.getDocumentNumberGroup(documentNumberPartGroupId) : null;
		var masterData = documentNumberGroup ? applicationContext.getMasterData(documentNumberGroup.masterDataSetId) : null;
		
		var documentType = masterData && joinDto.documentDocumentTypeId ? masterData.idToDocumentType[joinDto.documentDocumentTypeId] : null;
    	var documentTypeGroup = masterData && documentType && documentType.documentTypeGroupId != null 
    							? masterData.idToDocumentType[documentType.documentTypeGroupId] : null;
    							
    	var objectType = masterData && joinDto.objectObjectTypeId ? masterData.idToObjectType[joinDto.objectObjectTypeId] : null;
    	var objectReleaseObjectType = masterData && joinDto.objectReleaseObjectTypeId != null ? masterData.idToObjectType[joinDto.objectReleaseObjectTypeId] : null;
    	var subProjectType = masterData && joinDto.subProjectSubProjectTypeId ? masterData.idToSubProjectType[joinDto.subProjectSubProjectTypeId] : null;
    	
    	joinDto._documentNumberInfo = {
    	                  _creationIndex : joinDto.documentId,
    	                     numberParts : DataHelper.clone(numberParts), 
    		              documentTypeId : joinDto.documentDocumentTypeId,
    		                documentType : documentType, 
    		           documentTypeGroup : documentTypeGroup,
    		                          id : joinDto.documentId,
    		                      number : joinDto.documentNumber,
    		             objectPlannerId : joinDto.objectPlannerId,
                       objectPlannerCode : joinDto.objectPlannerCode,
                objectPlannerReleaseCode : joinDto.objectPlannerReleaseCode,
                                objectId : joinDto.objectId,
                              objectCode : joinDto.objectCode,
                          subProjectCode : joinDto.subProjectCode,
                          subProjectType : subProjectType,
                             projectCode : joinDto.projectCode,
                      objectObjectTypeId : joinDto.objectObjectTypeId,
                              objectType : objectType,
                       objectReleaseCode : joinDto.objectReleaseCode,
               objectReleaseObjectTypeId : joinDto.objectReleaseObjectTypeId,
                 objectReleaseObjectType : objectReleaseObjectType,
          projectParticipationCustomerId : joinDto.projectParticipationCustomerId
    	};
    };    
    
    
    return DocumentNumberEditor;
});    
