define([
         "cdes/certificate/CertificateColumnWidget",
         "cdes/certificate/CertificateHelper",
         "cdes/certificate/CertificateListWidget",
         "cdes/certificate/CertificateSearchWidget",
         "cdes/util/ActionHelper",
         "cdes/widget/ContextBar",
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/LoginGuardXhr",
         "clazzes/dateTime/DateHelper",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/layout/InfoDialog",
         "dijit/form/Button",
         "dijit/form/TextBox",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/dom-style",
         "dojo/on",
         "dojo/string",
         "dojox/uuid/generateTimeBasedUuid",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 CertificateColumnWidget,
    		 CertificateHelper,
    		 CertificateListWidget,
    		 CertificateSearchWidget,
    		 ActionHelper,
    		 ContextBar,
    		 TinyLog,
    		 topic,
    		 LoginGuardXhr,
    		 DateHelper,
    		 DOMHelper,
    		 ErrorHelper,
    		 WidgetHelper,
    		 ContentWidget,
             InfoDialog,
    		 Button,
    		 TextBox,
    		 domClass,
    		 domConstruct,
    		 domStyle,
    		 on,
    		 string,
    		 generateTimeBasedUuid,
    		 declare,
    		 lang,
    		 i18n
    		 ) {

	var className = "at.cdes.web.certificate.CertificatePage";

	var log = new TinyLog(className);

    var CertificatePage = declare(className, ContentWidget, {

    	constructor : function(params) {
    		lang.mixin(this,params);

    		this.topDiv = this.constructTopDiv();

    		//registerBasePage
    		var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
    		var pageName = "certificates";

    		tabSessionContextService.addToPageList(dojoConfig.tabSessionId, pageName, true).then(lang.hitch(this, function() {
			}),
			lang.hitch(this, function(err) {
		        ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : null,
                            opName : "UpdatePageContextService",
                           message : i18n.updatePageContextServiceFailedMessage
		        });
			})).otherwise(lang.hitch(this, function(err) {
				log.error("Error while processing UpdatePageContextService: ", err);
			}));

 			this.updateWidgetState();
			//if (searchInfo.enableAutoInitSearch)  //not yet available
				this.reload();

    		this.allFieldsValid = true;
    	},

    	getWidgetId : function() {
    		return "CertificatePage";
    	},

    	getDataId : function() {
    		return null;
    	},

    	getContainer : function() {
    		return this.topDiv;
    	},

    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);

    		// Caption Bar
    		this.captionBarDiv = this.constructCaptionBar();
    		domClass.add(this.captionBarDiv, "certificatePageCaptionBar");
    		domConstruct.place(this.captionBarDiv, topDiv);

    		// Search Widget
    		this.searchWidget = new CertificateSearchWidget({
    			applicationContext : this.applicationContext
    		});
    		this.searchWidgetDiv = this.searchWidget.getContainer();
    		domConstruct.place(this.searchWidgetDiv, topDiv);
    		on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));
    		on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));

    		// Column Widget
    		this.columnWidget = new CertificateColumnWidget({
    			applicationContext : this.applicationContext
    		});
    		this.columnWidgetDiv = this.columnWidget.getContainer();
    		domConstruct.place(this.columnWidgetDiv, topDiv);
    		on(this.columnWidget, "titlePaneToggled", lang.hitch(this, this.resize));
    		on(this.columnWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));
    		this.columnWidget.setData(this.getDefaultColumnSettings(null));

    		// Status Bar
    		this.statusBarDiv = this.constructStatusBar();
    		domClass.add(this.statusBarDiv, "certificatePageStatusBar");
    		domConstruct.place(this.statusBarDiv, topDiv);

    		// List Widget
    		this.listWidget = new CertificateListWidget({
    			applicationContext : this.applicationContext
    		});
    		this.listWidgetDiv = this.listWidget.getContainer();
    		domConstruct.place(this.listWidgetDiv, topDiv);

            this.searchWidget.initialize();

    		// Reload data after certain operations which change state have been performed
    		on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

    		return topDiv;
    	},

        broadcastUserPolicy: function() {
            InfoDialog.showQuestion({
                title: i18n.broadcastUserPolicyConfirmationTitle,
                message: i18n.broadcastUserPolicyConfirmationMessage,
                buttons: [
                    {
                        type: InfoDialog.Button.YES,
                        fct: lang.hitch(this, function() {
                            this.applicationContext.getService("certificateService").broadcastUserPolicy(this.applicationContext.getPageContextOrganisationPersonId());
                        }),
                    }, {
                        type: InfoDialog.Button.ABORT,
                    }
                ],
            });
        },

    	constructCaptionBar : function() {
    		// Caption Bar consisting of caption and context bar right of the caption
    		var captionBarDiv = domConstruct.create("div", null, null);
//    		domClass.add(captionBarDiv, "planDeliverCatalogueCaptionBar");

    		// Caption
    		this.captionDiv = DOMHelper.createTextNode("h1", i18n.certificatePageCaption, captionBarDiv, "certificatePageCaption");
/*
            this.applicationContext.getService("certificateService").isBroadcastUserPolicyButtonAvailable(this.applicationContext.getPageContextOrganisationPersonId())
                .then(lang.hitch(this, function(isAvailable) {
                    if (!isAvailable) {
                        return;
                    }
                    this.broadcastUserPolicyButton = new Button({
                        label: i18n.broadcastUserPolicyLabel,
                        title: i18n.broadcastUserPolicyToolTip,
                        onClick: lang.hitch(this, this.broadcastUserPolicy),
                    });
                    domConstruct.place(this.broadcastUserPolicyButton.domNode, captionBarDiv);
                }));
*/
/*
    		// Generating a unique name for the button group, to avoid problems if the widget is ever inserted multiple times into the same application
    		var uuid = generateTimeBasedUuid();

    		// Certificate Radio Button
			this.certificateRadioButton = new RadioButton({
				 name : "CertificateViewMode_" + uuid,
				label : i18n.certificateSearchCertificateViewLabel,
				title : i18n.certificateSearchCertificateViewToolTip
			});
			domClass.add(this.certificateRadioButton.domNode, "certificateSearchCertificateViewRadioButton");
			domConstruct.place(this.certificateRadioButton.domNode, captionBarDiv);
			WidgetHelper.onRadioButtonGUIChange(this.certificateRadioButton, lang.hitch(this, this.onModeRadioButtonsChanged));

			DOMHelper.createTextNode("div", i18n.certificateSearchCertificateViewLabel, captionBarDiv, "certificateSearchCertificateViewLabel");

    		// Request Radio Button
			this.requestRadioButton = new RadioButton({
				 name : "CertificateViewMode_" + uuid,
				label : i18n.certificateSearchRequestViewLabel,
				title : i18n.certificateSearchRequestViewToolTip
			});
			domClass.add(this.requestRadioButton.domNode, "certificateSearchRequestViewRadioButton");
			domConstruct.place(this.requestRadioButton.domNode, captionBarDiv);
			WidgetHelper.onRadioButtonGUIChange(this.requestRadioButton, lang.hitch(this, this.onModeRadioButtonsChanged));

			DOMHelper.createTextNode("div", i18n.certificateSearchRequestViewLabel, captionBarDiv, "certificateSearchRequestViewLabel");

    		// Invitations Radio Button
			this.invitationsRadioButton = new RadioButton({
				 name : "CertificateViewMode_" + uuid,
				label : i18n.certificateSearchInvitationsViewLabel,
				title : i18n.certificateSearchInvitationsViewToolTip
			});
			domClass.add(this.invitationsRadioButton.domNode, "certificateSearchInvitationsViewRadioButton");
			domConstruct.place(this.invitationsRadioButton.domNode, captionBarDiv);
			WidgetHelper.onRadioButtonGUIChange(this.invitationsRadioButton, lang.hitch(this, this.onModeRadioButtonsChanged));

			DOMHelper.createTextNode("div", i18n.certificateSearchInvitationsViewLabel, captionBarDiv, "certificateSearchInvitationsViewLabel");

    		// Persons without Certificate Radio Button
			this.personsWithoutCertificateRadioButton = new RadioButton({
				 name : "CertificateViewMode_" + uuid,
				label : i18n.certificateSearchPersonsWithoutCertificateViewLabel,
				title : i18n.certificateSearchPersonsWithoutCertificateViewToolTip
			});
			domClass.add(this.personsWithoutCertificateRadioButton.domNode, "certificateSearchPersonsWithoutCertificateViewRadioButton");
			domConstruct.place(this.personsWithoutCertificateRadioButton.domNode, captionBarDiv);
			WidgetHelper.onRadioButtonGUIChange(this.personsWithoutCertificateRadioButton, lang.hitch(this, this.onModeRadioButtonsChanged));

			DOMHelper.createTextNode("div", i18n.certificateSearchPersonsWithoutCertificateViewLabel, captionBarDiv, "certificateSearchPersonsWithoutCertificateViewLabel");
  */

    		return captionBarDiv;
    	},

    	constructStatusBar : function() {
    		var statusBarDiv = domConstruct.create("div", null, null);
    		domClass.add(statusBarDiv, "refNodeOfPositionAbsolute");

    		this.statusDiv = DOMHelper.createTextNode("div", i18n.notYetSearched, statusBarDiv, "fixedDialogWidget certificatePageStatusDiv");

    		// Quick Search
    		DOMHelper.createTextNode("div", i18n.quickSearchLabel, statusBarDiv, "propertyLabel certificatePageQuickSearchLabel");
    		this.quickSearchTextBox = new TextBox({
    			label : i18n.quickSearchLabel,
    			title : i18n.quickSearchToolTip
    		});
    		domClass.add(this.quickSearchTextBox.domNode, "fixedDialogWidget certificatePageQuickSearchTextBox");
    		domConstruct.place(this.quickSearchTextBox.domNode, statusBarDiv);
    		WidgetHelper.handleTextBoxEvents(this.quickSearchTextBox, lang.hitch(this, this.processQuickSearchChange));

    		this.quickSearchClearButton = new Button({
    				  label : i18n.quickSearchClearLabel,
    			      title : i18n.quickSearchClearToolTip,
    			    onClick : lang.hitch(this, this.clearQuickSearch)
    		});
    		domClass.add(this.quickSearchClearButton.domNode, "fixedDialogWidget certificatePageQuickSearchClearButton");
    		domConstruct.place(this.quickSearchClearButton.domNode, statusBarDiv);

    		return statusBarDiv;
    	},

    	resize : function(newSize) {

    		if (newSize) {
    			this.lastNewSize = newSize;
    		}
    		var totalHeight = this.lastNewSize.h;

    		var tableWidth = this.searchWidgetDiv.offsetWidth;
    		var tableHeight = totalHeight
    					//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
    					- this.captionBarDiv.offsetHeight
    					- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom")
    					- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
    					- this.statusBarDiv.offsetHeight
    					- 16;
    		this.listWidget.resize({ w : tableWidth, h : tableHeight });
    	},

    	setData : function() {
    		// Search model is fetched automatically from searchWidget, thus nothing is to be done here.
    	},

    	reload : function() {
    		//this.contextBar.reload();

    		DOMHelper.setInnerText(this.statusDiv, i18n.searchRuns);
    		/*
    		if (!this.listWidgetInitialized) {

    			this.listWidgetInitialized = true;
    		}*/

	    	this.listWidget.setData({ data : [], columnSettings : this.columnWidget.getColumnSettings(), networkIdToActions : new Object() });


    		this.updateWidgetState();

    		if (this.searchWidget.isAlreadyInitialized()) {
    			this.reloadData();
    		}
    	},

    	reloadData : function() {
    		// Set up searchmodel
    		var searchModel = this.searchWidget.getSearchModel();

    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		this.applicationContext.storeInLocalStorage([organisationPersonId], "/certificate/search", searchModel);

    		var certificateService = this.applicationContext.getService("certificateService");

    		// If the previous search still runs, cancel it
    		if (this.joinDeferred != null) {
    			log.info("Previous joinDeferred still runs, will cancel it.");
    			this.joinDeferred.cancel();
    		}

    		var prevSeconds = DateHelper.getCurrentTimeSeconds();
    		var contextOrganisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

    		this.registerAsyncOperationStarted(CertificatePage.AsyncOperation.GET_DATA);
    		this.joinDeferred = certificateService.getCertificateJoin(contextOrganisationPersonId, searchModel);
    		this.joinDeferred.then(lang.hitch(this, function(certificateSearchResult) {

    			var certificateJoins = certificateSearchResult.certificateJoins;

    			// Server: Map<Long, Set<String>> is received here as Map<Long, List<String>> and thus we convert it back.
    			var networkIdToActions = ActionHelper.convertNetworkIdToActions(certificateSearchResult.networkActions);
				var globalActions = new Object();
				for (var n = 0; n < certificateSearchResult.globalActions.length; n++) {
					globalActions[certificateSearchResult.globalActions[n]] = true;
				}                        

    			this.certificateJoins = CertificateHelper.preprocessCertificateJoins(certificateJoins);
    			this.updateAuxiliaryData();

    			var postSeconds = DateHelper.getCurrentTimeSeconds();
				log.info("Queried certificates after " + (postSeconds - prevSeconds) + "s");

				var searchInfoString = this.getSearchInfoString(this.certificateJoins);
				topic.publish("message/ok", searchInfoString);
				DOMHelper.setInnerText(this.statusDiv, searchInfoString);

    			var columnSettings = this.getColumnSettingsForReload(searchModel);
    			this.listWidget.setSearchModel(searchModel);
    			this.listWidget.setData({
    				                  data : this.certificateJoins,
    				    networkIdToActions : networkIdToActions,
    				    	 globalActions : globalActions,
    				        columnSettings : columnSettings,
                    	 userPolicyVersion : certificateSearchResult.userPolicyVersion,
                    	    userPolicyPath : certificateSearchResult.userPolicyPath,
    	   certificateAdministrationGlobal : certificateSearchResult.certificateAdministrationGlobal,
    	      passwordExpireExtendInterval : certificateSearchResult.passwordExpireExtendInterval
   				});
				delete this.joinDeferred;

				postSeconds = DateHelper.getCurrentTimeSeconds();
				log.info("Populated list after " + (postSeconds - prevSeconds) + "s");

	    		this.registerAsyncOperationFinished(CertificatePage.AsyncOperation.GET_DATA);
				this.updateWidgetState();
    		}),
   			lang.hitch(this, function(err) {
   				delete this.joinDeferred;

		        ErrorHelper.processAsyncError({
                                 err : err,
                              widget : this,
                      asyncOperation : CertificatePage.AsyncOperation.GET_DATA,
                              opName : "getCertificateJoin",
                             message : i18n.certificatePageGetDataFailed
		        });
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling getPlotOrderJoin: ", err);
    		}));
    	},

    	updateAuxiliaryData : function() {
    		for (var n = 0; n < this.certificateJoins.length; n++) {
    			var joinDto = this.certificateJoins[n];
    			var status = "";

    			if (joinDto.unionClause == CertificateListWidget.CertificateJoinComponent.WITHOUT_CERTIFICATE) {
    				if (joinDto.certificateId == null) {
    					joinDto.status = CertificateListWidget.Status.NO_CERTIFICATE;
    				} else {
    					joinDto.status = CertificateListWidget.Status.EXPIRED;
    				}
    			} else if (joinDto.unionClause == CertificateListWidget.CertificateJoinComponent.WITHOUT_CERTIFICATE_OlDREQUEST) {
    				joinDto.status = CertificateListWidget.Status.NO_CERTIFICATE_OlDREQUEST;
    			} else if (joinDto.certificateRequestId != null && joinDto.certificateRequestRequestType == "Invitation") {
    				joinDto.status = CertificateListWidget.Status.INVITATION;
    			} else if (joinDto.certificateRequestId != null && joinDto.certificateRequestRequestType == "Request") {
    				joinDto.status = CertificateListWidget.Status.REQUEST;
    			} else if (joinDto.certificateId != null) {
    				CertificateHelper.updateCertificateStatus(joinDto);
    			} else {
    				joinDto.status = CertificateListWidget.Status.INCONSISTENT;
    			}
    		}
    	},

    	getColumnSettingsForReload : function(searchModel) {
    		var columnSettings = this.columnWidget.getColumnSettings();
    		if (!columnSettings.manualColumns) {
    			columnSettings = this.getAutomaticColumnSettings(searchModel);
    			this.columnWidget.setData(columnSettings);
    		}
    		return columnSettings;
    	},

    	getDefaultColumnSettings : function(searchModel) {
       		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var oldColumnSettings = this.applicationContext.getFromLocalStorage([organisationPersonId], "/certificate/columns");
    		if (oldColumnSettings != null) {
    			return oldColumnSettings;
    		} else {
    			return this.getAutomaticColumnSettings(searchModel);
    		}
    	},

    	getAutomaticColumnSettings : function(searchModel) {
    		var showCertificates = searchModel != null ? (searchModel.showValid || searchModel.showExpired || searchModel.showValidExpiredSoon) : true;
    		var showInvitations = searchModel != null ? searchModel.showInvitations : false;
    		var showRequests = searchModel != null ? searchModel.showRequested : false;
    		var showWithoutCertificate = searchModel != null ? searchModel.showPersonsWithoutCertificate : false;

			return {
		               showName : true,
	                showNetwork : showCertificates || showInvitations || showRequests,
	           showOrganisation : true,
      	              showValid : showCertificates || showWithoutCertificate,
	                 showIssuer : showCertificates,
	                 showStatus : true,
		         showInvitation : showInvitations || showRequests,
	              showInvitator : showInvitations || showRequests,
	              showRequested : showRequests,
	           showSerialNumber : false
			};
    	},

    	processColumnsChanged : function(columnId) {
	    var columnSettings = this.columnWidget.getColumnSettings();
	    this.listWidget.setColumns(columnSettings, columnId);
	    this.manualColumns = true;
    	},

    	getSearchInfoString : function(joinDtos) {
    		var numberOfValid = 0;
    		var numberOfExpired = 0;
    		var numberOfInvitations = 0;
    		var numberOfRequests = 0;
    		var numberOfPersonsWithoutCertificate = 0;
    		var numberOfInconsistent = 0;
			var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();

    		for (var n = 0; n < joinDtos.length; n++) {
    			var joinDto = joinDtos[n];
    			var expired = joinDto.certificateId != null && (joinDto.certificateCertValidFrom == null || joinDto.certificateCertValidTo == null
				   || joinDto.certificateCertValidFrom > currentTimeSeconds
				   || joinDto.certificateCertValidTo < currentTimeSeconds);
				var locked =   (joinDto.certificateMayLogin != null && joinDto.certificateMayLogin == 0)
				    || (joinDto.certificateMaySign != null && joinDto.certificateMaySign == 0);

				if (locked || expired) {
					numberOfExpired++;
				} else if (joinDto.status == CertificateListWidget.Status.VALID_EXPIRES_SOON || joinDto.status == CertificateListWidget.Status.VALID) {
    				numberOfValid++;
    			} else if (joinDto.status == CertificateListWidget.Status.EXPIRED) {
    				numberOfExpired++;
    			} else if (joinDto.status == CertificateListWidget.Status.INVITATION) {
    				numberOfInvitations++;
    			} else if (joinDto.status == CertificateListWidget.Status.REQUEST) {
    				numberOfRequests++;
    			} else if (joinDto.status == CertificateListWidget.Status.NO_CERTIFICATE) {
    				numberOfPersonsWithoutCertificate++;
    			} else {
    				numberOfInconsistent++;
    			}
    		}

    		var tokens = [];

    		var s = "";
    		if (numberOfValid > 0 && numberOfExpired > 0) {
    			s += string.substitute(i18n.certificatePageValidSearchInfo, {
    				numberOfValid : numberOfValid
    			});
    			s += " " + i18n.and + " ";
    			s+= string.substitute(i18n.certificatePageExpiredSearchInfo, {
    				numberOfExpired : numberOfExpired
    			});
    		} else if (numberOfValid > 0) {
    			s += string.substitute(i18n.certificatePageValidSearchInfo, {
    				numberOfValid : numberOfValid
    			});
    		} else if (numberOfExpired > 0) {
    			s += string.substitute(i18n.certificatePageExpiredSearchInfo, {
    				numberOfExpired : numberOfExpired
    			});
    		} else {
    			// Nothing found, display a general info message.
    			s = null;
    		}

    		if (s != null) {
       			tokens.push(string.substitute(i18n.certificatePageCertificates, {
       				certificateInfo : s
       			}));
    		}

    		if (numberOfInvitations > 0) {
    			tokens.push(string.substitute(i18n.certificatePageInvitationsSearchInfo, {
    				numberOfInvitations : numberOfInvitations
    			}));
    		}
    		if (numberOfRequests > 0) {
    			tokens.push(string.substitute(i18n.certificatePageRequestsSearchInfo, {
    				numberOfRequests : numberOfRequests
    			}));
    		}
    		if (numberOfPersonsWithoutCertificate > 0) {
    			tokens.push(string.substitute(i18n.certificatePagePersonsWithoutCertificateSearchInfo, {
    				numberOfPersons : numberOfPersonsWithoutCertificate
    			}));
    		}
    		if (numberOfInconsistent > 0) {
    			tokens.push(string.substitute(i18n.certificatePageInconsistentSearchInfo, {
    				numberOfInconsistent : numberOfInconsistent
    			}));
    		}

    		var tokenString = "";
    		if (tokens.length == 0) {
    			return i18n.certificatePageNoneFoundSearchInfo;
    		} else {
    			tokenString += tokens[0];
    		}
    		for (var n = 1; n < tokens.length - 1; n++) {
    			tokenString += ", " + tokens[n];
    		}
    		if (tokens.length >= 2) {
    			tokenString += " " + i18n.and + " " + tokens[tokens.length - 1];
    		}

    		return string.substitute(i18n.certificatePageSearchInfo, {
    			tokens : tokenString
    		});

    		// 3 gültige und 4 abgelaufene Zertifikate, 1 Einladung, 2 Anforderungen und 3 Personen ohne Zertifikat gefunden
    	},

    	processQuickSearchChange : function() {
    		var newSearch = this.quickSearchTextBox.get("value");
    		if (newSearch != this.lastQuickSearch) {
    			this.listWidget.filter(newSearch);
    			this.lastQuickSearch = newSearch;
    		}
    	},

    	clearQuickSearch : function() {
    		this.quickSearchTextBox.set("value", "", false);
    		this.processQuickSearchChange();
    	},

    	updateWidgetState : function() {
    		var operationRunning = this.isAsyncOperationRunning();
    	},

    	destroy : function() {
    		this.inherited(arguments);
    		this.listWidget.destroy();
    	}
    });

    CertificatePage.AsyncOperation = {
    		GET_DATA : "GetData"
    };

    return CertificatePage;
});
