/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationSharepointImport
////i18n-prefix = planningNotificationSharepointImport


define([ "cdes/core/CdesVoc",
	"cdes/planning/notification/PlanningNotificationColumnWidget",
	"cdes/planning/notification/PlanningNotificationListWidget",
	"cdes/planning/notification/SharepointTreeModel",
	"cdes/util/ColumnHelper",
	"cdes/widget/ContextBar",
	"clazzes/ClazzesTree",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateHelper",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/FancyContentPane",
	"dijit/form/Button",
	"dijit/layout/BorderContainer",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CdesVoc,
			PlanningNotificationColumnWidget,
			PlanningNotificationListWidget,
			SharepointTreeModel,
			ColumnHelper,
			ContextBar,
			ClazzesTree,
			TinyLog,
			DateHelper,
			topic,
			DOMHelper,
			ErrorHelper,
			ContentWidget,
			FancyContentPane,
			Button,
			BorderContainer,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.notification.PlanningNotificationSharepointImportPage";

	var log = new TinyLog(className);

	var PlanningNotificationSharepointImportPage = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.reloadSearchInfo();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationSharepointImportPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationSharepointImportPageCaption, captionBarDiv, "cdesGeneralPageCaption");

			// Abort button
			this.abortButton = new Button({
				label : i18n.abortButtonCaption,
				title : i18n.abortToolTip
			});
			domClass.add(this.abortButton.domNode, "planningNotificationSharepointImportAbortButton");
			domConstruct.place(this.abortButton.domNode, captionBarDiv);
			on(this.abortButton, "click", lang.hitch(this, this.abort));

			return captionBarDiv;
		},

		abort : function() {
			if (this.backPage != null) {
				this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
			} else {
				this.applicationContext.setPage("planningNotificationList", new Object(), new Object());
			}                                  
		},	

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationSharepointImportPageContentDiv");

			this.borderContainer = new BorderContainer({
				design  : "headline",
				"class" : "occupyWholeParent"
			});

			this.constructTree();
			this.tree.set("region", "left");
			this.tree.set("splitter", true);
			this.borderContainer.addChild(this.tree);

			this.constructGridSection();
			this.gridSectionContentPane.set("region", "center");
			this.borderContainer.addChild(this.gridSectionContentPane);	    

			domConstruct.place(this.borderContainer.domNode, contentDiv);
			this.borderContainer.startup();
			this.tree.resize({ w : 350 });	    

			return contentDiv;
		},

		constructTree : function() {
			this.treeModel = new SharepointTreeModel({
				applicationContext : this.applicationContext,
				metaTags : this.metaTags		
			});

			this.tree = new ClazzesTree({
				showRoot : false,
				model : this.treeModel,
				persist : false,
				autoExpand : false
				//    		dndController : myDnDSource
			});

			this.onTreeClickHandle = dojo.connect(this.tree, "onClick", lang.hitch(this, this.handleTreeClick));
		},	    

		handleTreeClick : function(item, node, event) {
			if (item.type == "FOLDER") {
				if (item.documents != null) {
					this.showFolderDocuments(item);
				} else {
					topic.publish("message/info", i18n.sharePointLoadFolderDocumentsStarted);

					var mspService = this.applicationContext.getService("mspService");
					mspService.getFolderDocuments(item.path, item.guid, this.sharepointReferenceNames).then(
							lang.hitch(this,function(documents){
								topic.publish("message/ok", string.substitute(i18n.sharePointLoadFolderDocumentsFinished, {
									count : documents.length
								}));				

								item.documents = documents;
								this.showFolderDocuments(item);
							}),
							lang.hitch(this,function(err){
								ErrorHelper.processAsyncError({
									err : err,
									widget : this,
									asyncOperation : null,
									opName : "getFolderDocuments",
									message : i18n.sharePointTreeModelGetFolderDocumentsFailed
								});						    	 
							}))
							.otherwise(lang.hitch(this,function(err){
								log.error("Handler of getFolderDocuments failed", err);
							}));
				}
			}
		},

		showFolderDocuments : function(item) {
			var planningNotificationInfos = [];

			var id = 0;
			var documents = item.documents;
			for (var n = 0; n < documents.length; n++) {
				var document = documents[n];
				var planningNotification = {
						id : "sharepoint_" + id,
						title : document.title,
						sharepointLink : document.path,		    
						type : CdesVoc.PlanningNotificationType.REFERENCED		
				};

				var mspMetaTags = document.metaTags != null ? document.metaTags : new Object();

				var metaTagIdToDateMetaInformations = new Object();
				var metaTagIdToTextMetaInformations = new Object();
				for (var z = 0; z < this.metaTags.length; z++) {
					var metaTagId = this.metaTags[z].id;
					var tagFormat = this.metaTags[z].tagFormat;
					var multiple = this.metaTags[z].multiple;
					var sharepointReferenceName = this.metaTags[z].sharepointReferenceName;
					if (sharepointReferenceName != null) {
						sharepointReferenceName = sharepointReferenceName.substring(4); // Remove "ows_" prefix

						if (sharepointReferenceName.indexOf("-") == 0) {
							sharepointReferenceName = sharepointReferenceName.substring(1);			    
						}											     
					}

					if (sharepointReferenceName in mspMetaTags) {
						if (tagFormat == CdesVoc.TagFormat.TEXT) {
							log.info("sharepointReferenceName= "+sharepointReferenceName+", value= "+mspMetaTags[sharepointReferenceName]);
							if (multiple){
								var mspMetaTagStr = mspMetaTags[sharepointReferenceName];
								var mspMetaTagStrArray = mspMetaTagStr.split(";");
								var tokenInfos = [];
								for (var s = 0; s < mspMetaTagStrArray.length; s++) {
									var mspMetaTagSepStr = mspMetaTagStrArray[s].trim();
									tokenInfos.push({
										value : mspMetaTagSepStr
									});			    
								}
								metaTagIdToTextMetaInformations[metaTagId] = tokenInfos;
							}else{
								metaTagIdToTextMetaInformations[metaTagId] = [{
									value : mspMetaTags[sharepointReferenceName]
								}];				
							}
						} else if (tagFormat == CdesVoc.TagFormat.DATE) {
							var dateString = mspMetaTags[sharepointReferenceName];
							var firstSpace = dateString.indexOf(" ");
							if (firstSpace != -1) {
								dateString = dateString.substring(0, firstSpace);
							}

							log.info("datestring now " + dateString);
							var utcSeconds;
							if (dateString != null) {
								var fancyDate = DateHelper.parseToDate(dateString, i18n.datePattern, this.applicationContext.getTimeZone());
								if (fancyDate != null) {
									utcSeconds = fancyDate.getUtcSeconds();
								} else {
									utcSeconds = null;
								}
							} else {
								utcSeconds = null;
							}

							metaTagIdToDateMetaInformations[metaTagId] = [{
								value : utcSeconds
							}];				
						} else {
							throw new Error("Unsupported tagFormat [" + tagFormat + "]");
						}			    
					}
				}		    

				var planningNotificationInfo = {
						planningNotification : planningNotification,
						projects : [],
						metaTagIdToDateMetaInformations : metaTagIdToDateMetaInformations,
						metaTagIdToTextMetaInformations : metaTagIdToTextMetaInformations,
						removableMetaInformationIds : []
				};

				planningNotificationInfos.push(planningNotificationInfo);
				id++;		
			}		

			this.listWidget.setData({
				planningNotificationInfos : planningNotificationInfos
			});		    
		},	    

		constructGridSection : function() {
			var gridSectionDiv = domConstruct.create("div", null, null);

			// Column Widget
			this.columnWidget = new PlanningNotificationColumnWidget({
				applicationContext : this.applicationContext,
				mode : PlanningNotificationColumnWidget.Mode.SHAREPOINT,
				localStoragePath : "planningNotificationSharepoint/columns"
			});
			this.columnWidgetDiv = this.columnWidget.getContainer();
			domConstruct.place(this.columnWidgetDiv, gridSectionDiv);
			on(this.columnWidget, "titlePaneToggled", lang.hitch(this, this.emitTriggerResize));
			on(this.columnWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));

			// List Widget
			this.listWidget = new PlanningNotificationListWidget({
				applicationContext : this.applicationContext,
				mode : PlanningNotificationListWidget.Mode.SHAREPOINT,
				backPage : "planningNotificationSharepointImport",
				backParams : new Object()
			});
			this.listWidgetDiv = this.listWidget.getContainer();
			domClass.add(this.listWidgetDiv, "planningNotificationSharepointImportList");
			domConstruct.place(this.listWidgetDiv, gridSectionDiv);

			this.gridSectionContentPane = new FancyContentPane({
				content : gridSectionDiv,
				postResizeFunction : lang.hitch(this, this.postResizeGridSectionContentPane)		
			});
			domClass.add(this.gridSectionContentPane.domNode, "innerContainer");
		},

		postResizeGridSectionContentPane : function(newSize) {
			var columnDivHeight = this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom");
			var height = newSize.h - columnDivHeight - 5;
			this.listWidget.resize({ h : height });	    
		},	    

		emitTriggerResize : function() {
			on.emit(this, "triggerResize");
		},

		processColumnsChanged : function() {
			var columnSettings = this.columnWidget.getColumnSettings();
			this.listWidget.setColumns(columnSettings);
			this.manualColumns = true;            
		},

		resize : function(newSize) {
			if (this.contentDiv != null) {
				var totalHeight = newSize.h;

				var contentWidth = this.captionBarDiv.offsetWidth - 15;
				var contentHeight = totalHeight
				//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
				- this.captionBarDiv.offsetHeight
				- 16;

				domStyle.set(this.contentDiv, "height", contentHeight + "px");
				this.borderContainer.resize({ w : contentWidth, h : contentHeight });
			}
		},

		reloadSearchInfo : function(includeMetaTags) {
			var networkId = this.applicationContext.getPageContextPnNetworkId();

			this.registerAsyncOperationStarted(PlanningNotificationSharepointImportPage.AsyncOperation.LOAD_META_TAGS);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getAllMetaTags().then(
					lang.hitch(this, function(metaTags) {		    
						this.registerAsyncOperationFinished(PlanningNotificationSharepointImportPage.AsyncOperation.LOAD_META_TAGS);

						this.metaTags = metaTags;
						this.sharepointReferenceNames = [];
						for (var n = 0; this.metaTags != null && n < this.metaTags.length; n++) {
							if (this.metaTags[n].sharepointReferenceName != null) {
								this.sharepointReferenceNames.push(this.metaTags[n].sharepointReferenceName.substring(4)); // Remove "ows_" at beginning
							}
						}		

						// Content
						this.contentDiv = this.constructContentDiv();
						domConstruct.place(this.contentDiv, this.topDiv);

						metaTags.sort(function(metaTagOne, metaTagTwo) {
							return (metaTagOne.position != null ? metaTagOne.position : 0) - (metaTagTwo.position != null ? metaTagTwo.position : 0);
						});

						for (var n = 0; n < metaTags.length; n++) {
							var cssRules = metaTags[n].cssRules;
							document.getElementsByTagName("head")[0].appendChild(DOMHelper.createTextNode("style", cssRules));
						}			

						this.columnWidget.initialize(metaTags);
						this.listWidget.initialize(metaTags);

						var defaultColumnSettings = ColumnHelper.getDefaultColumnSettings(this.applicationContext, this, null, "planningNotificationSharepoint/columns");
						this.columnWidget.setData(defaultColumnSettings);

						this.emitTriggerResize();
						this.reload();		    
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationSharepointImportPage.AsyncOperation.LOAD_META_TAGS,
							opName : "getAllMetaTags",
							message : i18n.planningNotificationSharepointImportGetMetaTagsFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getAllMetaTags]", err);
							}));
		},

		setData : function() {

		},

		reload : function() {
			//this.contextBar.reload();

			this.listWidget.setData({ planningNotificationInfos : [], columnSettings : this.columnWidget.getColumnSettings() });
		},

		updateWidgetState : function() {

		},

		getAutomaticColumnSettings : function(searchModel) {
			return {
				showTitle : true
			};		
		},

		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanningNotificationSharepointImportPage.AsyncOperation = {
			LOAD_META_TAGS : "LoadMetaTags"
	};

	return PlanningNotificationSharepointImportPage;
});
