/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = workflowReviewResult
////i18n-prefix = workflowReviewResult


define([ "cdes/planning/task/ReviewSignWidget",
	"clazzes/ClazzesVoc",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/EditDialog",
	"clazzes/widgets/layout/InfoDialog",
	"dijit/Editor",
	"dijit/_editor/plugins/EnterKeyHandling",
	"dijit/form/Button",
	"dijit/form/CheckBox",
	"dijit/form/Form",
	"dijit/form/RadioButton",
	"dijit/form/TextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/io-query",
	"dojo/json",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojox/form/Uploader",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(ReviewSignWidget,
			ClazzesVoc,
			TinyLog,
			FancyButton,
			topic,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			EditDialog,
			InfoDialog,
			Editor,
			EnterKeyHandling,
			Button,
			CheckBox,
			Form,
			RadioButton,
			TextBox,
			domClass,
			domConstruct,
			domStyle,
			ioQuery,
			json,
			on,
			string,
			declare,
			lang,
			Uploader,		
			i18n) {

	var className = "at.cdes.web.planning.task.WorkflowReviewResultWidget";

	var log = new TinyLog(className);

	var WorkflowReviewResultWidget = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.firstResize = true;
			this.topDiv = this.constructTopDiv();

			this.fileInfos = [{
				label : i18n.fileUploadNoFileSelected,
				fileName : null,
				originalFileName : null		
			}];
			this.resultInfos = [];	    
			this.updateFileInfos();
			this.updateWidgetState();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "WorkflowReviewResultWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);
			domClass.add(topDiv, "refNodeOfPositionAbsolute");

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h3", "", topDiv, "cdesGeneralPageCaption fixedDialogWidget workflowReviewResultCaptionDiv");

			// InitiatorTextBox
			DOMHelper.createTextNode("div", i18n.workflowReviewResultInitiatorLabel, topDiv, "propertyLabel workflowReviewResultInitiatorLabel");
			this.initiatorTextBox = new TextBox({
				label : i18n.workflowReviewResultInitiatorLabel,
				title : i18n.workflowReviewResultInitiatorToolTip,
				disabled : true
			});
			domClass.add(this.initiatorTextBox.domNode, "fixedDialogWidget workflowReviewResultInitiatorTextBox");
			domConstruct.place(this.initiatorTextBox.domNode, topDiv);

			// MainParticipantTextBox
			DOMHelper.createTextNode("div", i18n.workflowReviewResultMainParticipantLabel, topDiv, "propertyLabel workflowReviewResultMainParticipantLabel");
			this.mainParticipantTextBox = new TextBox({
				label : i18n.workflowReviewResultMainParticipantLabel,
				title : i18n.workflowReviewResultMainParticipantToolTip,
				disabled : true
			});
			domClass.add(this.mainParticipantTextBox.domNode, "fixedDialogWidget workflowReviewResultMainParticipantTextBox");
			domConstruct.place(this.mainParticipantTextBox.domNode, topDiv);

			this.resultDiv = domConstruct.create("div", null, null);
			domClass.add(this.resultDiv, "fixedDialogWidget workflowReviewResultResultDiv");
			domConstruct.place(this.resultDiv, topDiv);

			// Editor
			this.editor = this.constructEditor();	    
			domClass.add(this.editor.domNode, "fixedDialogWidget workflowReviewResultEditor");
			domConstruct.place(this.editor.domNode, topDiv);	    

			// Upload
			this.constructAndConfigureFileUpload(topDiv);

			// File information
			this.fileInfoDiv = domConstruct.create("div", null, null);
			domClass.add(this.fileInfoDiv, "fixedDialogWidget workflowReviewResultFileInfoDiv");
			domConstruct.place(this.fileInfoDiv, topDiv);	    

			// Buttons
			this.constructButtonDiv(topDiv);	    

			return topDiv;
		},

		constructAndConfigureFileUpload : function(topDiv) {	
			// Import form etc.
			var importFrame = this.applicationContext.getFancyIFrame();

			this.importForm = new Form({method : "post", encType : "multipart/form-data"});
			domClass.add(this.importForm.domNode, "fixedDialogWidget workflowReviewResultImportForm");
			domConstruct.place(this.importForm.domNode, topDiv);

			this.importForm.set("target", importFrame.id);

			log.info("Setting up documentLoad");
			this.documentLoadRegistration = on(importFrame, "documentLoad", lang.hitch(this, function(e) {
                if (e.document.title != null && e.document.title.indexOf("Error") != -1) {
					//Unsupported Media Type
					if (e.document.title.indexOf("415") != -1)
                    	topic.publish("message/error", i18n.uploadFailedWrongType, true);
                	else
                    	topic.publish("message/error", i18n.uploadFaile, true);

                } else {
	
					log.info("Called documentLoad with event", e);
	
					var newFileInfos = [];
					for (var n = 0; n < this.fileInfos.length; n++) {
						if (this.fileInfos[n].fileName != null) {
							newFileInfos.push(this.fileInfos[n]);
						}
					}
	
					this.fileInfos = newFileInfos;		    
	
					var tempFileName = e.document ? e.document.body.innerHTML : null;
					if (log.isDebugEnabled()) {
						log.debug("Received tempFileName = [" + tempFileName + "]");
					}
	
					this.fileInfos.push({
						label : this.uploadedFileName,
						fileName : tempFileName,
						originalFileName : this.uploadedFileName		    
					});		    

					this.updateFileInfos();
				}				
			}));		

			// Import
			this.fileUploadLabel = DOMHelper.createTextNode("div", i18n.attachmentFileLabel, topDiv, "propertyLabel workflowReviewResultFileUploadLabel");
			this.uploader = new dojox.form.Uploader({
				name : "uploadedFile",
				multiple : false,
				type : "file",
				label : i18n.chooseFile
			});
			domClass.add(this.uploader.domNode, "fixedDialogWidget workflowReviewResultFileUpload");
			domConstruct.place(this.uploader.domNode, this.importForm.domNode);

			var parameterString = ioQuery.objectToQuery({
				allowedDocType : "pdfNoFileAttachment"
			});
      		var url = "/cdes-dojo-impl/tempFileUpload?" + parameterString;       		
			this.uploader.set("url", url);
			this.importForm.set("action", url);

			this.uploader.startup();

			on(this.uploader, "change", lang.hitch(this, function(fileInfos) {
				log.info("Called uploader change with fileInfos ", fileInfos);
				
				var fileSizeInfos = [];
				for (var n = 0; n < fileInfos.length; n++) {
					fileSizeInfos.push({ first : fileInfos[n].name, second : fileInfos[n].size });		    
				}

				this.registerAsyncOperationStarted(WorkflowReviewResultWidget.AsyncOperation.CHECK_SIZE);

				var planningNotificationService = this.applicationContext.getService("planningNotificationService");
				planningNotificationService.checkPlanningReviewFileSize(fileSizeInfos).then(
						lang.hitch(this, function(message) {
							this.registerAsyncOperationFinished(WorkflowReviewResultWidget.AsyncOperation.CHECK_SIZE);

							if (message == null) {
								// Size ok
								if (fileInfos.length > 0 && fileInfos[0].name != null) {
									this.uploadedFileName = fileInfos[0].name;
								} else {
									this.uploadedFileName = null;
								}

								this.updateWidgetState();		

								this.importForm.submit();
							} else {
								topic.publish("message/error", message, true);
							}			
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : WorkflowReviewResultWidget.AsyncOperation.CHECK_SIZE,
								opName : "checkPlanningReviewFileSize",
								message : i18n.workflowReviewResultCheckFileSizeFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [checkPlanningReviewFileSize]", err);
								}));
			}));

			/*
       	    this.deleteUploadedFileButton = new FancyButton({
		    title : i18n.planningNotificationEditDeleteFileToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
       	    });

	    domClass.add(this.deleteUploadedFileButton.domNode, "planningNotificationEditDeleteFileButton listButton");
	    domConstruct.place(this.deleteUploadedFileButton.domNode, this.uploadStatusNodeFile);	    

	    on(this.deleteUploadedFileButton, "click", lang.hitch(this, function() {
		this.planningNotification.filename = null;
		this.uploadedFileName = null;
		this.tempFileName = null;
		this.updateWidgetState();		
	    }));
			 */
		},

		updateFileInfos : function() {
			this.fileInfos.sort(function(fileInfoOne, fileInfoTwo) {
				return fileInfoOne.label.localeCompare(fileInfoTwo.label);
			});		

			domConstruct.empty(this.fileInfoDiv);

			for (var n = 0; n < this.fileInfos.length; n++) {
				var fileInfo = this.fileInfos[n];
				var fileDiv = domConstruct.create("div", null, null);
				domClass.add(fileDiv, "refNodeOfPositionAbsolute workflowReviewResultFileDiv");
				domConstruct.place(fileDiv, this.fileInfoDiv);

				var labelDiv = DOMHelper.createTextNode("span", fileInfo.label, fileDiv, "");
				if (fileInfo.fileName != null) {
					var deleteButton = this.constructFileDeleteButton(fileInfo.fileName);
					domConstruct.place(deleteButton.domNode, fileDiv);		
				}
			}		
		},

		constructEditor : function() {
			var editor = new Editor({
				styleSheets: "/cdes/cdesEditor.css",
				height : "40px",
				plugins : [     "undo", "redo", "|", "cut", "copy", "paste", 
					"|", "bold", "italic", "underline", "strikethrough", "subscript", "superscript", "|",
					/* {name : "fontSize", plainText : true}, "|", */
					"removeFormat", EnterKeyHandling]
			});

			return editor;	    
		},

		constructFileDeleteButton : function(fileName) {
			var button = new FancyButton({
				title : i18n.workflowReviewResultDeleteButton,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
			});

			domClass.add(button.domNode, "workflowReviewResultDeleteFileButton");

			on(button, "click", lang.hitch(this, function() {
				// TODO Delete temp file at server side as well

				var newFileInfos = [];
				for (var n = 0; n < this.fileInfos.length; n++) {
					if (this.fileInfos[n].fileName != fileName) {
						newFileInfos.push(this.fileInfos[n]);
					}
				}

				if (newFileInfos.length == 0) {
					newFileInfos.push({
						label : i18n.fileUploadNoFileSelected,
						fileName : null,
						originalFileName : null	
					});
				}

				this.fileInfos = newFileInfos;
				this.updateFileInfos();		
			}));

			return button;
		},

		constructButtonDiv : function(topDiv) {
			var buttonDiv = domConstruct.create("div", null, null);
			domClass.add(buttonDiv, "fixedDialogWidget workflowReviewResultButtonDiv");
			domConstruct.place(buttonDiv, topDiv);	    

			this.taskNumberLabel = DOMHelper.createTextNode("div", "", buttonDiv, "fixedDialogWidget workflowReviewResultTaskNumberLabel");

			// Sign button
			this.signButton = new Button({
				label : i18n.signButtonCaption,
				title : i18n.workflowReviewResultSignButtonToolTip
			});
			domClass.add(this.signButton.domNode, "fixedDialogWidget workflowReviewResultSignButton");
			domConstruct.place(this.signButton.domNode, buttonDiv);

			on(this.signButton, "click", lang.hitch(this, this.sign));

			// Batch button
			this.batchButton = new Button({
				label : i18n.batchSignButtonCaption,
				title : i18n.workflowReviewResultBatchButtonToolTip
			});
			domClass.add(this.batchButton.domNode, "fixedDialogWidget workflowReviewResultBatchButton");
			domConstruct.place(this.batchButton.domNode, buttonDiv);

			on(this.batchButton, "click", lang.hitch(this, this.addToBatchSign));

			this.toNextCheckBox = new CheckBox({

			});                
			domClass.add(this.toNextCheckBox.domNode, "fixedDialogWidget workflowReviewResultToNextCheckBox");
			domConstruct.place(this.toNextCheckBox.domNode, buttonDiv);

			DOMHelper.createTextNode("div", i18n.workflowReviewResultToNextLabel, buttonDiv, "fixedDialogWidget workflowReviewResultToNextLabel");

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			var toNext = !!this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationTask/jumpToNextTask");
			this.toNextCheckBox.set("checked", toNext);            

			// Abort button
			this.abortButton = new Button({
				label : i18n.abortButtonCaption,
				title : i18n.abortToolTip
			});
			domClass.add(this.abortButton.domNode, "fixedDialogWidget workflowReviewResultAbortButton");
			domConstruct.place(this.abortButton.domNode, buttonDiv);
			on(this.abortButton, "click", lang.hitch(this, this.abort));

			// Skip button
			this.skipButton = new Button({
				label : i18n.skipButtonCaption,
				title : i18n.workflowReviewResultSkipToolTip
			});
			domClass.add(this.skipButton.domNode, "fixedDialogWidget workflowReviewResultSkipButton");
			domConstruct.place(this.skipButton.domNode, buttonDiv);
			on(this.skipButton, "click", lang.hitch(this, this.skip));

		},

		getSelectedResultOption : function() {
			var selectedResultOption = null;
			for (var n = 0; n < this.resultInfos.length; n++) {
				if (this.resultInfos[n].radioButton.get("checked")) {
					selectedResultOption = this.resultInfos[n].resultOption;
					break;		    
				}		    
			}
			return selectedResultOption;            
		},

		storeToNextInLocalStorage : function() {
			var toNext = this.toNextCheckBox.get("checked");

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationTask/jumpToNextTask", !!toNext);
		},            

		sign : function() {
			var selectedResultOption = this.getSelectedResultOption();

			if (selectedResultOption == null) {
				InfoDialog.showError({
					title : i18n.workflowReviewResultNoResultChosenCaption,
					message : i18n.workflowReviewResultNoResultChosenText
				});
				return;		
			}

			var fileInfosToPass = [];
			for (var n = 0; n < this.fileInfos.length; n++) {
				if (this.fileInfos[n].fileName != null) {
					fileInfosToPass.push(this.fileInfos[n]);
				}		    
			}

			var unsafeComment = this.editor.get("value");

			this.registerAsyncOperationStarted(WorkflowReviewResultWidget.AsyncOperation.CLEAN_COMMENT);
			var utilService = this.applicationContext.getService("utilService");
			utilService.getSafeHtml(unsafeComment, false).then(
					lang.hitch(this, function(safeComment) {
						this.registerAsyncOperationFinished(WorkflowReviewResultWidget.AsyncOperation.CLEAN_COMMENT);

						this.doSign(safeComment, selectedResultOption, fileInfosToPass);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : WorkflowReviewResultWidget.AsyncOperation.CLEAN_COMMENT,
							opName : "getSafeHtml",
							message : i18n.workflowReviewResultGetSafeHtmlFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getSafeHtml]", err);
							}));            	    
		},

		doSign : function(comment, selectedResultOption, fileInfosToPass) {

			this.storeToNextInLocalStorage();
			var toNext = this.toNextCheckBox.get("checked");
			var nextTaskJoin = toNext ? this.taskJoins[this.taskNumber + 1] : null;

			var contentWidget = new ReviewSignWidget({
				applicationContext : this.applicationContext,
				backPage : this.backPage,
				backParams : this.backParams,
				batch : false,
				nextTaskJoin : nextTaskJoin,
				taskJoins : nextTaskJoin != null ? this.taskJoins : null                
			});

			var editDialog = new EditDialog({
				contentWidget : contentWidget,
				defaultWidth  : 1100,  // Should be in sync with corresponding rules in CSS
				defaultHeight : 400,
				title : i18n.reviewSignWidgetCaption,
				buttons : [ { type : ClazzesVoc.Button.SAVE, label : i18n.signButtonCaption, title : i18n.reviewSignSignButtonToolTip },
					{ type : ClazzesVoc.Button.ABORT, title : i18n.workflowReviewResultAbortButtonToolTip } ]
			});
			editDialog.setData({
				tokenInfos : [{
					organisationName : this.taskJoin.organisationName,
					personId : this.taskJoin.personId,
					personGivenName : this.taskJoin.personGivenName,
					personSurName : this.taskJoin.personSurName,
					comment : this.editor.get("value"),
					workflowTokenId : this.taskJoin.workflowTokenId,
					workflowNodePositionResultOptionId : selectedResultOption.id,
					workflowNodePositionResultOptionTitle : selectedResultOption.title,
					fileInfos : fileInfosToPass
				}]
			});                
			editDialog.show();            

			on(editDialog, "dialogClosed", function() {
				contentWidget.destroy();
			});				  
		},

		addToBatchSign : function() {
			this.storeToNextInLocalStorage();

			var selectedResultOption = this.getSelectedResultOption();

			if (selectedResultOption == null) {
				InfoDialog.showError({
					title : i18n.workflowReviewResultNoResultChosenCaption,
					message : i18n.workflowReviewResultNoResultChosenText
				});
				return;		
			}

			var tempFileToOriginalFileName = new Object();	    
			for (var n = 0; n < this.fileInfos.length; n++) {
				var fileInfo = this.fileInfos[n];
				if (fileInfo.fileName != null) {
					tempFileToOriginalFileName[this.fileInfos[n].fileName] = this.fileInfos[n].originalFileName;		
				}
			}

			var signInfo = {
					organisationPersonId : this.applicationContext.getPageContextOrganisationPersonId(),
					workflowTokenId : this.taskJoin.workflowTokenId,
					workflowNodePositionResultOptionId : selectedResultOption.id,
					comment : this.editor.get("value"),
					tempFileToOriginalFileName : tempFileToOriginalFileName
			};

			this.registerAsyncOperationStarted(WorkflowReviewResultWidget.AsyncOperation.REGISTER_FOR_LATER_SIGNATURE);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.registerWorkflowReviewForLaterSignature(signInfo).then(
					lang.hitch(this, function() {
						this.registerAsyncOperationFinished(WorkflowReviewResultWidget.AsyncOperation.REGISTER_FOR_LATER_SIGNATURE);

						var toNext = this.toNextCheckBox.get("checked");
						if (toNext) {
							this.skip();
						} else {
							this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
						}
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : WorkflowReviewResultWidget.AsyncOperation.REGISTER_FOR_LATER_SIGNATURE,
							opName : "registerWorkflowReviewForLaterSignature",
							message : i18n.workflowReviewResultAddForLaterSignatureFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [signWorkflowNodePositionResult]", err);
							}));                        
		},

		abort : function() {
			if (this.backPage != null) {
				this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
			}            
		},

		skip : function() {
			var nextTaskJoin = this.taskJoins[this.taskNumber + 1];

			this.applicationContext.setPage("workflowReview",
					{ id : nextTaskJoin.workflowTokenId },
					{
						backPage : this.backPage,
						backParams : this.backParams,
						taskJoins : this.taskJoins
					});
		},

		resize : function(newSize) {
			// Hack born out of a 30-minute-debug-session against BorderContainer layout algorithm.
			// For some obscure reason, the initial call of the Dojo layout/resize algorithms
			// emits a width value, that is 19px smaller than the subsequent ones.
			if (this.firstResize) {
				if (newSize.w != null) {
					newSize.w += 19;
				}
				this.firstResize = false;                
			}                

			if (newSize.w != null && !isNaN(newSize.w)) {
				domStyle.set(this.topDiv, "width", newSize.w + "px");
			}                
			if (newSize.h != null && !isNaN(newSize.h)) {
				var newHeight = Math.max(newSize.h, 295);
				domStyle.set(this.topDiv, "height", newHeight + "px");
				if (this.resultHeight != null) {
					this.editor.resize({ h : (newHeight - this.resultHeight - 180) });
				}                    
			}                
		},

		setData : function(params) {
			this.taskInfo = params.planningNotificationTaskInfos[0];
			this.taskJoin = this.taskInfo.taskJoin;
			this.baulose = this.taskInfo.workflowNodePositionBaulose != null ? this.taskInfo.workflowNodePositionBaulose : [];
			this.resultOptions = params.resultOptions;
			this.backPage = params.backPage;
			this.backParams = params.backParams;
			this.taskJoins = params.taskJoins;
			this.comment = params.comment;
			this.resultOptionId = params.resultOptionId;            

			var attachments = params.attachments != null ? json.parse(params.attachments, true) : null;
			this.fileInfos = [];
			for (var n = 0; attachments != null && n < attachments.length; n++) {
				this.fileInfos.push({
					originalFileName : attachments[n].original,
					label : attachments[n].original,
					fileName : attachments[n].file                    
				});                    
			}                

			this.reload();	    
		},

		reload : function() {
			this.taskNumber = null;
			for (var n = 0; this.taskJoins && n < this.taskJoins.length; n++) {
				var taskJoin = this.taskJoins[n];
				if (taskJoin.workflowTokenId == this.taskJoin.workflowTokenId) {
					this.taskNumber = n;
				}
			}                

			this.updateWidgetsFromData();
		},

		updateWidgetsFromData : function() {
			// Caption
			var baulosString = "";
			for (var n = 0; n < this.baulose.length; n++) {
				baulosString += this.baulose[n].value + (n < this.baulose.length - 1 ? ", " : "");
			}		
			if (baulosString.length > 0)
				baulosString = i18n.workflowNodePositionListBaulosColumn + " " + baulosString;

			var caption = string.substitute(i18n.workflowReviewResultCaption, {
				workflowNodeName : this.taskInfo.taskJoin.workflowNodeTemplateName,
				baulos : baulosString		    
			});		

			DOMHelper.setInnerText(this.captionDiv, caption);	    

			// Baulos / Initiator
			var initiatorString =
				string.substitute(i18n.projectParticipantNameOrganisationFirst, {
					organisationName : this.taskJoin.initiatorOrganisationName,
					personGivenName : this.taskJoin.initiatorPersonGivenName,
					personSurName : this.taskJoin.initiatorPersonSurName       
				});
			var baulose = this.taskJoin.workflowNodePositionBaulose;
			var baulosString = "";
			for (var n = 0; baulose && n < baulose.length; n++) {
				baulosString += baulose[n].value;
				if (n < baulose.length - 1) {
					baulosString += ", ";
				}		    
			}

			this.initiatorTextBox.set("value", /*baulosString + " \u2015 " +*/ initiatorString);		

			// ProjectParticipant	    
			var participationString =
				string.substitute(i18n.projectParticipantNameOrganisationFirst, {
					organisationName : this.taskJoin.organisationName,
					personGivenName : this.taskJoin.personGivenName,
					personSurName : this.taskJoin.personSurName       
				});

			this.mainParticipantTextBox.set("value", participationString);

			// ResultOptions	    
			domConstruct.empty(this.resultDiv);
			this.resultWidth = 0;
			this.resultInfos = [];
			var lineHeight = 25;	    
			var y = 0;
			for (var n = 0; n < this.resultOptions.length; n++) {
				var resultOption = this.resultOptions[n];

				var radioButton = new RadioButton({
					label : resultOption.title,
					title : resultOption.description,
					name : "result",
					dojoClick : false                     
				});
				domClass.add(radioButton.domNode, "fixedDialogWidget");
				domStyle.set(radioButton.domNode, "top", y + "px");
				domStyle.set(radioButton.domNode, "left", "5px");		
				domConstruct.place(radioButton.domNode, this.resultDiv);
				WidgetHelper.handleRadioButtonEvents(radioButton, lang.hitch(this, this.updateWidgetState));

				if (this.resultOptionId == resultOption.id) {
					radioButton.set("checked", true);
				}                    

				this.resultInfos.push({
					radioButton : radioButton,
					resultOption : resultOption		    
				});		    

				var estimatedWidth = resultOption.title.length * 10;
				this.resultWidth = Math.max(this.resultWidth, estimatedWidth);
				var label = DOMHelper.createTextNode("div", resultOption.title, this.resultDiv, "fixedDialogWidget");
				domStyle.set(label, "top", y + "px");
				domStyle.set(label, "left", "30px");
				domStyle.set(label, "width", estimatedWidth + "px");

				this.handleRadioButtonLabelClick(radioButton, label);

				y += lineHeight;
			}

			this.resultHeight = y;
			domStyle.set(this.resultDiv, "width", this.resultWidth + "px");
			domStyle.set(this.resultDiv, "height", this.resultHeight + "px");

			domStyle.set(this.fileUploadLabel, "bottom", (this.resultHeight + 65) + "px");
			domStyle.set(this.importForm.domNode, "bottom", (this.resultHeight + 60) + "px");	    

			domStyle.set(this.fileInfoDiv, "height", (this.resultHeight + 86) + "px"); 
			domStyle.set(this.fileInfoDiv, "left", Math.max(250, this.resultWidth) + "px"); // 230 = right end of the "Upload file" button

			// TaskNumber
			var taskNumberLabel = string.substitute(i18n.workflowReviewResultTaskNumberLabel, {
				taskNumber : this.taskNumber != null ? this.taskNumber + 1 : "---",
						count : this.taskJoins != null ? this.taskJoins.length : "---"
			});
			DOMHelper.setInnerText(this.taskNumberLabel, taskNumberLabel);            

			// Information entered by the user before            
			if (this.comment != null) {
				this.editor.set("value", this.comment);
			}

			this.updateFileInfos();
			this.updateWidgetState();
		},

		handleRadioButtonLabelClick : function(radioButton, label) {
			label.addEventListener("click", lang.hitch(this, function() {
				radioButton.set("checked", true);
				this.updateWidgetState();
			}));
		},

		updateWidgetState : function() {
			var anyOptionChecked = false;
			for (var n = 0; n < this.resultInfos.length; n++) {
				anyOptionChecked |= this.resultInfos[n].radioButton.get("checked");
			}

			var allFieldsValid = anyOptionChecked;
			this.signButton.set("disabled", !allFieldsValid);
			this.batchButton.set("disabled", !allFieldsValid);            
		},

		destroy : function() {
			log.info("Calling destroy");
			this.inherited(arguments);
			this.importForm.destroy();
			if (this.documentLoadRegistration != null) {
				this.documentLoadRegistration.remove();
			}	    
		}
	});

	WorkflowReviewResultWidget.AsyncOperation = {
			REGISTER_FOR_LATER_SIGNATURE : "RegisterForLaterSignature",
			CHECK_SIZE : "CheckSize",
			CLEAN_COMMENT : "CleanComment"        
	};

	return WorkflowReviewResultWidget;
});
