define([
        "cdes/certificate/CertificateCreateWidget",
        "cdes/certificate/CertificateInviteChooseDialog",
        "cdes/core/CdesVoc",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/topic",
        "clazzes/util/ErrorHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/InfoDialog",
        "dojo/on",
        "dojo/string",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
function(
         CertificateCreateWidget,
         CertificateInviteChooseDialog,
         CdesVoc,
    	 TinyLog,
    	 DateHelper,
         topic,
         ErrorHelper,
         ChooseDialog,
         InfoDialog,
         on,
         string,
         lang,
         i18n
    	 ) {

	var className = "at.cdes.web.certificate.CertificateHelper";

	var log = new TinyLog(className);

    var CertificateHelper = {

    	preprocessCertificateJoins : function(certificateJoins) {

    		/* Use this code, if certificateJoin instances for different networks can exist.

			// A certificate can have multiple corresponding networks.
			// (via Certificate --> OrganisationPerson --> Organisation <-- NetworkOrganisation --> Network)
			// Only add one certificateJoin instance per certificate to the grid, and construct a comma separated
			// list of all corresponding network names in that join.
    		var certificateIdToNetworkString = new Object();
    		var newCertificateJoins = [];
    		for (var n = 0; n < certificateJoins.length; n++) {
    			var certificateJoin = certificateJoins[n];
    			if (!(certificateJoin.certificateId in certificateIdToNetworkString)) {
    				certificateIdToNetworkString[certificateJoin.certificateId] = certificateJoin.networkName;
    				newCertificateJoins.push(certificateJoin);
    			} else {
    				certificateIdToNetworkString[certificateJoin.certificateId]
    						= certificateIdToNetworkString[certificateJoin.certificateId] + ", " + certificateJoin.networkName;
    			}
    		}
    		for(var n = 0; n < newCertificateJoins.length; n++) {
    			var certificateJoin = newCertificateJoins[n];
    			certificateJoin._networkString = certificateIdToNetworkString[certificateJoin.certificateId];
    		}

    		return newCertificateJoins;
    		*/

    		return certificateJoins;
    	},

    	updateCertificateStatus : function(joinDto) {
    		var fromGiven = joinDto.certificateCertValidFrom != null;
    		var toGiven = joinDto.certificateCertValidTo != null;

    		var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();

    		if (fromGiven && toGiven) {
    			if (joinDto.certificateCertValidFrom <= currentTimeSeconds && joinDto.certificateCertValidTo >= currentTimeSeconds
    					&& joinDto.certificateMayLogin && joinDto.certificateMaySign) {
    				if (joinDto.certificateCertValidTo - 30 * 24 * 3600 <= currentTimeSeconds) {
    					joinDto.status = CdesVoc.CertificateStatus.VALID_EXPIRES_SOON;
    				} else {
    					joinDto.status = CdesVoc.CertificateStatus.VALID;
    				}
    			} else {
    				joinDto.status = CdesVoc.CertificateStatus.EXPIRED;
    			}
    		} else {
    			joinDto.status = CdesVoc.CertificateStatus.INCONSISTENT;
    		}
    	},

        askInviteForCertificate : function(params) {
            var joinDto = params.certificateJoin;
            var applicationContext = params.applicationContext;
            var baseWidget = params.baseWidget;
            var successCallback = params.successCallback;

            var message = string.substitute(i18n.certificateListAskForInvitationDialogQuestion, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName
            });

            var chooseDialog = new CertificateInviteChooseDialog({
                applicationContext : applicationContext,
                             title : i18n.certificateListAskForInvitationDialogCaption,
                           buttons : [
                               { type : ChooseDialog.Button.CHOOSE,
                                    name : "allPerMailButton",
                                   label : i18n.certificateListAskForInvitationAllPerMailButtonCaption,
                                   title : i18n.certificateListAskForInvitationAllPerMailButtonToolTip
                               },
                               { type : InfoDialog.Button.ABORT}
                           ],
                      defaultWidth : 800,
                     defaultHeight : 400
            });
            on(chooseDialog, "valueChosen", function(chooseInfo) {
                var networkId = chooseInfo.networkId;
                var buttonName = chooseInfo.buttonName;

                if (buttonName == "allPerMailButton") {
                    CertificateHelper.inviteSendAllPerMail({
                           certificateJoin : joinDto,
                                 networkId : networkId,
                        applicationContext : applicationContext,
                                baseWidget : baseWidget,
                           successCallback : successCallback
                    });
                }
            });
            chooseDialog.show(null);
        },

        inviteSendAllPerMail : function(params) {
            var joinDto = params.certificateJoin;
            var networkId = params.networkId;
            var applicationContext = params.applicationContext;
            var baseWidget = params.baseWidget;
            var successCallback = params.successCallback; // on.emit(baseWidget, "doSearch");

            var pageContextOrganisationPersonId = applicationContext.getPageContextOrganisationPersonId();

            var certificateService = applicationContext.getService("certificateService");

            baseWidget.registerAsyncOperationStarted(CertificateHelper.AsyncOperation.INVITE_SEND_ALL_PER_MAIL);
            var deferred = certificateService.inviteAndSendAllPerMail(joinDto.organisationPersonId, networkId, pageContextOrganisationPersonId);
            deferred.then(function() {

                baseWidget.registerAsyncOperationFinished(CertificateHelper.AsyncOperation.INVITE_SEND_ALL_PER_MAIL);

                topic.publish("message/ok", CertificateHelper.getInvitationResultMessage(i18n.certificateListInvitationSendAllOk, joinDto));

                if (successCallback) {
                    successCallback();
                }

                delete deferred;
            }, function(err) {
                    delete deferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : baseWidget,
                        asyncOperation : CertificateHelper.AsyncOperation.INVITE_SEND_ALL_PER_MAIL,
                                opName : "inviteAndSendAllPerMail",
                               message : CertificateHelper.getInvitationResultMessage(i18n.certificateListInvitationSendAllFailed, joinDto)
                    });
                }
            ).otherwise(function(err) {
                log.error("Error while processing the results of calling inviteAndSendAllPerMail: ", err);
            });
        },

        getInvitationResultMessage : function(rawMessage, joinDto) {
            return string.substitute(rawMessage, {
                givenName : joinDto.personGivenName,
                  surName : joinDto.personSurName,
                     mail : joinDto.organisationPersonEmailAddress
            });
        },

        doIssueCertificate : function(params) {
            var applicationContext = params.applicationContext;
            var joinDto = params.joinDto;
            var personJoin = params.personJoin;
            var baseWidget = params.baseWidget;
            var successCallback = params.successCallback;
            var userPolicyPath = params.userPolicyPath;

            var certificateCreateWidget = new CertificateCreateWidget({
                applicationContext : applicationContext
            });

            var certificateCreateDialog = new InfoDialog({
                        title : i18n.certificateListCreateDialogCaption,
                      content : certificateCreateWidget.getContainer(),
                 defaultWidth : 900,
                defaultHeight : 230,
                      buttons : [ { type : InfoDialog.Button.CUSTOM,
                                 name : "createCertificateButton",
                                label : i18n.signButtonCaption,
                                title : i18n.certificateListCreateSignButtonToolTip,
                          manualClose : true,
                                  fct : function() {
                                      certificateCreateWidget.doCreateCertificate();
                                  }},
                          { type : InfoDialog.Button.CLOSE }
                      ]
            });

            certificateCreateWidget.dialog = certificateCreateDialog;

            on(certificateCreateDialog, "hide", function() {
                certificateCreateWidget.destroy();
            });

            certificateCreateDialog.show();

            certificateCreateWidget.setData({
                certificateJoin : joinDto,
                     personJoin : personJoin != null ? personJoin : joinDto,
                successCallback : successCallback,
                 userPolicyPath : userPolicyPath
            });

            on(certificateCreateWidget, "certificateCreated", function() {
                certificateCreateDialog.close();
                if (successCallback != null) {
                    successCallback();
                }
            });
        }
    };

    CertificateHelper.AsyncOperation = {
        INVITE_SEND_ALL_PER_MAIL : "InviteSendAllPerMail",
        INVITE_SEND_INVITATION_PER_MAIL : "InviteSendInvitationPerMail"
    };

    return CertificateHelper;
});
