define([
	"cdes/core/CdesVoc",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
	"clazzes/util/DOMHelper",
	"clazzes/widgets/layout/InfoDialog",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/io-query",
	"dojo/on",
	"dojo/string",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"    
	],
	function(
			CdesVoc,
			TinyLog,
			FancyButton,
			DOMHelper,
			InfoDialog,
			domClass,
			domConstruct,
			ioQuery,
			on,
			string,    
			lang,    
			i18n    
	) {

	var className = "at.cdes.document.DocumentHelper";

	var log = new TinyLog(className);	

	var DocumentHelper = {

			getLastDocumentVersion : function(givenVersionJoins) {
				var versionJoins = [];
				for (var n = 0; n < givenVersionJoins.length; n++) {
					versionJoins.push(givenVersionJoins[n]);
				}
				versionJoins.sort(function(versionJoinOne, versionJoinTwo) {
					var uploadedOne = versionJoinOne.documentVersionUploaded != null ? versionJoinOne.documentVersionUploaded : 0;
					var uploadedTwo = versionJoinTwo.documentVersionUploaded != null ? versionJoinTwo.documentVersionUploaded : 0;
					return uploadedOne - uploadedTwo;                
				});

				var lastVersionJoin = versionJoins.length > 0 ? versionJoins[versionJoins.length - 1] : null;
				if (lastVersionJoin.documentVersionReactivatedDocumentVersionId != null) {
					for (var z = 0; z < givenVersionJoins.length; z++) {
						if (givenVersionJoins[z].documentVersionId == lastVersionJoin.documentVersionReactivatedDocumentVersionId) {
							return givenVersionJoins[z];
						}
					}                    

					throw new Error("Did not find documentVersionJoin with id [" + lastVersionJoin.documentVersionReactivatedDocumentVersionId
						+ "] in givenVersionJoins.  However, it should be there.");                    
				} else {
					return lastVersionJoin;
				}            
			},

			isLastDocumentVersion : function(givenVersionJoins, documentVersionId) {
				var lastVersionJoin = DocumentHelper.getLastDocumentVersion(givenVersionJoins);
				return lastVersionJoin.documentVersionId == documentVersionId;            
			},

			getRevisedCount : function(versionJoins, documentVersionId) {
				var count = 0;
				for (var n = 0; n < versionJoins.length; n++) {
					if (versionJoins[n].revisedDocumentVersionId == documentVersionId) {
						count++;
					}                    
				}
				return count;            
			},


	    /* ======================== File related buttons (replacement for DocumentVersionFileLinkGroup) ====================== */

            constructPreviewPdfButtonByVersionId : function(documentVersionId) {
		var button = new FancyButton({
                        title : i18n.documentListPreviewPdfToolTip,
		    iconClass : "fancyButtonIcon17x18 fancyButton17x18 previewPdfButton"
		});

		domClass.add(button.domNode, "listButton");

		on(button, "click", lang.hitch(this, function() {
		    var url = "/cdes/app?service=CDESMimeService/6/documentVersionPdfMimeSource&sp=" + documentVersionId + "&rand=" + Math.random() + "&ts=" + dojoConfig.tabSessionId;
		    window.open(url);                
		}));

		return button;            
            },

	    constructPreviewPdfButton : function(documentListJoin) {
                var documentVersionId = documentListJoin.documentVersionId;
                return DocumentHelper.constructPreviewPdfButtonByVersionId(documentVersionId);
	    },

	    constructPreviewPngButton : function(documentListJoin) {
                var documentVersionId = documentListJoin.documentVersionId;
                var documentName = documentListJoin.documentName;
                return DocumentHelper.constructPreviewPngButtonByVersionId(documentVersionId, documentName);
	    },

	    constructPreviewPngButtonByVersionId : function(documentVersionId, documentName) {
		var button = new FancyButton({
		    title : i18n.documentListPreviewPngToolTip,
		    iconClass : "fancyButtonIcon17x18 fancyButton17x18 previewButton"
		});

		domClass.add(button.domNode, "listButton");

		on(button, "click", lang.hitch(this, function() {
		    var topDiv = domConstruct.create("div", null, null);
		    var imageTag = domConstruct.create("img", null, null);
		    domConstruct.place(imageTag, topDiv);                

		    imageTag.src = "/cdes/app?service=CDESMimeService/4/documentVersionPngMimeSource&sp=" + documentVersionId + "&sp=320&sp=T&rand=" + Math.random()
			+ "&ts=" + dojoConfig.tabSessionId;

		    var infoDialog = new InfoDialog({
			defaultWidth : 320,
			defaultHeight : 320, 
			title : string.substitute(i18n.plotOrderItemListPreviewTitle, { documentName : documentName}),
			content : topDiv,
			buttons : [ ]    	    			
		    });
		    infoDialog.show();

		    imageTag.onload = lang.hitch(this, function() {
                        //						log.info("Width: [" + imageTag.width + "], height: [" + imageTag.height + "]");
			infoDialog.dialog.resizeMe({ w : imageTag.width, h : imageTag.height });
		    });                                    
		    imageTag.onerror = function() {
			infoDialog.close();                        
			window.alert(i18n.documentHelperOpenPreviewFailed);
		    };                    
		    on(imageTag, "click", function() {
			var paramString = ioQuery.objectToQuery({
			    service : "external/PngPreview",                
			    sp : ["SdownloadDocumentVersion", documentVersionId ],
			    ts : dojoConfig.tabSessionId
			});
			var pngPreviewWidget = window.open("/cdes/app?" + paramString, "_blank", "toolbar=no, menubar=no,scrollbars=no,resizable=yes");
			infoDialog.close();                        
		    });
		}));

		return button;            
            },

	    constructDocumentComparisonButton : function(documentListJoin) {
                var documentVersionId = documentListJoin.documentVersionId;
                return DocumentHelper.constructDocumentComparisonButtonByVersionId(documentVersionId);
	    },

            constructDocumentComparisonButtonByVersionId : function(documentVersionId) {
		var button = new FancyButton({
		    title : i18n.documentListDocumentComparisonToolTip,
		    iconClass : "fancyButtonIcon17x18 fancyButton17x18 documentCompareButton"
		});

		domClass.add(button.domNode, "listButton");

		on(button, "click", lang.hitch(this, function() {
		    window.open("frame.html?ts=" + dojoConfig.tabSessionId + "#page=documentComparePage&documentVersionId="
                                + documentVersionId, "_blank", "toolbar=no, menubar=no,scrollbars=no,resizable=yes");
		}));

		return button;                
            },

	    constructDownloadButton : function(documentListJoin, organisationPersonId) {
                var documentVersionId = documentListJoin.documentVersionId;
                return DocumentHelper.constructDownloadButtonByVersionId(documentVersionId, organisationPersonId);
	    },

            constructDownloadButtonByVersionId : function(documentVersionId, organisationPersonId) {
		var button = new FancyButton({
		    title : i18n.documentListDownloadToolTip,
		    iconClass : "fancyButtonIcon17x18 fancyButton17x18 saveButton"
		});

		domClass.add(button.domNode, "listButton");

		on(button, "click", lang.hitch(this, function() {
		    var url = "/cdes/app?service=CDESMimeService/6/documentVersionMimeSource&sp="
                        + documentVersionId + "&rand=" + Math.random() + "&ts=" + dojoConfig.tabSessionId;
		    window.open(url);
                    //					window.open("/cdes-dojo-impl/repositoryDownload/final/" + organisationPersonId + "/" + documentVersionId);
		}));

		return button;
            },

	    renderFileButtons : function(params) {
                var documentListRow = params.documentListRow;
				var documentListJoin = params.documentListJoin;
				var applicationContext = params.applicationContext;
				var checkForInvalidDocumentVersionPreview = params.checkForInvalidDocumentVersionPreview;
				var checkForInvalidDocumentVersionDownload = params.checkForInvalidDocumentVersionDownload;            
		
				var buttonDiv = domConstruct.create("div", null, null);

                var documentVersionId;
                var documentVersionStatus;
                var documentName;
                var subProjectInvalidated;
                var objectPlannerId;
                var _objectPlannerIdToActions;
                var documentVersionFileType;
                var previewSupportDocumentVersionId;
                if (documentListRow != null) {
                    documentVersionId = documentListRow.documentVersion != null ? documentListRow.documentVersion.id : null;
                    documentVersionStatus = documentListRow.documentVersion != null ? documentListRow.documentVersion.status : null;
                    documentName = documentListRow.document != null ? documentListRow.document.name : null;
                    subProjectInvalidated = documentListRow.subProject.invalidated;
                    objectPlannerId = documentListRow.objectPlanner.id;
                    _objectPlannerIdToActions = documentListRow._objectPlannerIdToActions;
                    documentVersionFileType = documentListRow.documentVersion != null
                        ? documentListRow.documentVersion.filetype : null;
                    previewSupportDocumentVersionId = documentListRow.previewSupportDocumentVersion != null
                        ? documentListRow.previewSupportDocumentVersion.id : null;
                } else {
                    documentVersionId = documentListJoin.documentVersionId;
                    documentVersionStatus = documentListJoin.documentVersionStatus;
                    documentName = documentListJoin.documentName;
                    subProjectInvalidated = documentListJoin.subProjectInvalidated;
                    objectPlannerId = documentListJoin.documentObjectPlannerId;
                    _objectPlannerIdToActions = documentListJoin._objectPlannerIdToActions;
                    documentVersionFileType = documentListJoin.documentVersionFiletype;
                    previewSupportDocumentVersionId = documentListJoin.previewSupportDocumentVersionId;
                }

				var validVersion = 
				    documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
				    && documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDALL
				    && documentVersionStatus != CdesVoc.DocumentVersionStatus.DELETED
				    && documentVersionStatus != CdesVoc.DocumentVersionStatus.ABORTED
				    && subProjectInvalidated == 0;
		
				var actions = objectPlannerId in _objectPlannerIdToActions ? _objectPlannerIdToActions[objectPlannerId] : new Object();
				if (actions != null && ("downloadDocumentVersion" in actions || "downloadDocumentVersionOPContext" in actions)) {
				    if ((!checkForInvalidDocumentVersionPreview || validVersion)
		                        && DocumentHelper.isFileTypeSupportedForPreview(documentVersionFileType)) {
						var previewPdfButton = DocumentHelper.constructPreviewPdfButtonByVersionId(documentVersionId);
						domConstruct.place(previewPdfButton.domNode, buttonDiv);
				    }                    
		
				    if ("showPngPreview" in actions && (!checkForInvalidDocumentVersionPreview || validVersion)
		                        && DocumentHelper.isFileTypeSupportedForPreview(documentVersionFileType)) {
						var previewPngButton = DocumentHelper.constructPreviewPngButtonByVersionId(documentVersionId, documentName);
						domConstruct.place(previewPngButton.domNode, buttonDiv);
				    }                            
		
				    if (previewSupportDocumentVersionId != null) {
						var documentComparisonButton = DocumentHelper.constructDocumentComparisonButtonByVersionId(documentVersionId);
						domConstruct.place(documentComparisonButton.domNode, buttonDiv);
				    }
		
				    if (!checkForInvalidDocumentVersionDownload || validVersion) {                
						var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
						var downloadButton = DocumentHelper.constructDownloadButtonByVersionId(documentVersionId, organisationPersonId);
						domConstruct.place(downloadButton.domNode, buttonDiv);
				    }                    
				}                
		
				return buttonDiv;            
		    },

			renderAttachmentFileButton : function(params) {
				var documentListJoin = params.documentListJoin;
				var applicationContext = params.applicationContext;

				var originalFileName = documentListJoin.documentReferenceAttachmentOriginalFilename;            
				var fileType = documentListJoin.documentReferenceFiletype != null ? "." + documentListJoin.documentReferenceFiletype : "";
				var title = string.substitute(i18n.documentReferenceAttachmentToolTip, {
					originalFileName : originalFileName != null ? originalFileName : "",
							fileType : fileType
				});

				var button = new FancyButton({
					title : title,
					iconClass : "fancyButtonIcon17x18 fancyButton17x18 attachmentIcon"
				});
				domClass.add(button.domNode, "listButton");

				on(button, "click", lang.hitch(this, function() {
					var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
					var documentReferenceId = documentListJoin.documentReferenceId;
					window.open("/cdes-dojo-impl/repositoryDownload/documentRef/" + organisationPersonId + "/" + documentReferenceId);
				}));

				return button.domNode;
			},

			isFileTypeSupportedForPreview : function(fileType) {
				fileType = fileType.toLowerCase();

				return fileType == "hpgl" || fileType == "hpg" || fileType == "plt" || fileType == "pdf";            
			}
	};

	return DocumentHelper;
});
