define([ 
         "cdes/pdc/PlanDeliverHelper",
         "cdes/pdc/PlanDeliverNewWidget",
//         "cdes/widget/ContextBar",
         "clazzes/TinyLog",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/util/JoinHelper",
         "clazzes/util/StringHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/layout/ContentWidget",
         "dijit/form/Button",
         "dijit/form/Select",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/dom-style",
         "dojo/on",
         "dojo/string",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/promise/all",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 PlanDeliverHelper,
    		 PlanDeliverNewWidget,
//    		 ContextBar,
    		 TinyLog,
    		 DOMHelper,
    		 ErrorHelper,
    		 JoinHelper,
    		 StringHelper,	
    		 WidgetHelper,
    		 ContentWidget,
    		 Button,
    		 Select,
    		 domClass,
    		 domConstruct,
    		 domStyle,
    		 on,
    		 string,
    		 declare,
    		 lang,
    		 promiseAll,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plan.PlanDeliverNewPage";

	var log = new TinyLog(className);
	
    var PlanDeliverNewPage = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
			this.updateWidgetState();
    		
			if (this.documentListReleaseVersions) {
				this.setupVersionSelect(this.documentListReleaseVersions);
				this.reload();
			} else {
	    		var subProjectId = this.applicationContext.getPageContextSubProjectId();
	    		
	    		var planDeliverService = this.applicationContext.getService("planDeliverService");
	    		
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    		this.registerAsyncOperationStarted(PlanDeliverNewPage.AsyncOperation.GET_DOCUMENT_LISTS);
	    		planDeliverService.getDocumentListReleaseVersions(organisationPersonId, subProjectId).then(lang.hitch(this, function(documentListReleaseVersions) {

	    				this.setupVersionSelect(documentListReleaseVersions);
	    				this.reload();
	    				
	    				this.registerAsyncOperationFinished(PlanDeliverNewPage.AsyncOperation.GET_DOCUMENT_LISTS);
	    			}),
	    			lang.hitch(this, function(err) {  
	       				ErrorHelper.processAsyncError({
                                        err : err,
                                     widget : this,
                             asyncOperation : PlanDeliverNewPage.AsyncOperation.GET_DOCUMENT_LISTS,
                                     opName : "getDocumentListReleaseVersions",
                                    message : i18n.planDeliverCatalogueGetVersionsFailed
	       				});  	    				
					})
	    		).otherwise(lang.hitch(this, function(err) {
	    			log.error("Error while processing the results of a call to getDocumentListReleaseVersions: ", err);
	    		}));				
			}

    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlanDeliverNewPage";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {    		
    		var topDiv = domConstruct.create("div", null, null);
    		
    		// Caption Bar
    		this.captionBarDiv = this.constructCaptionBar();
    		domClass.add(this.captionBarDiv, "planDeliverNewPageCaptionBar");
    		domConstruct.place(this.captionBarDiv, topDiv);

    		// Status Bar
    		this.statusBarDiv = this.constructStatusBar();
    		domClass.add(this.statusBarDiv, "planDeliverNewPageStatusBar");
    		domConstruct.place(this.statusBarDiv, topDiv);
    		
    		// PlanDeliverNewWidget
			this.newWidget = new PlanDeliverNewWidget({
				applicationContext : this.applicationContext,
				oldPlanDeliverJoin : this.oldPlanDeliverJoin,
				presetObjectId : this.presetObjectId,
			    presetObjectPlannerId : this.presetObjectPlannerId,
                contentLocales : this.contentLocales
			});
			this.newWidgetDiv = this.newWidget.getContainer();
			domConstruct.place(this.newWidgetDiv, topDiv);
			
			on(this.newWidget, "warnMessage", lang.hitch(this, function(msg) {
				DOMHelper.setInnerText(this.statusBarDiv, msg);
			}));
			on(this.newWidget, "infoMessage", lang.hitch(this, function(msg) {
				DOMHelper.setInnerText(this.statusBarDiv, "");
			}));
			
            this.newWidget.restoreColumnWidths();

    		/*
    		// List Widget
    		this.listWidget = new PlanDeliverListWidget({
    			applicationContext : this.applicationContext
    		});
    		this.listWidgetDiv = this.listWidget.getContainer();
    		domConstruct.place(this.listWidgetDiv, topDiv);
    		*/
    		return topDiv;
    	},
    	
    	constructCaptionBar : function() {
    		// Caption Bar consisting of caption and context bar right of the caption
    		var captionBarDiv = domConstruct.create("div", null, null);
    		domClass.add(captionBarDiv, "planDeliverCatalogueCaptionBar");
    		
    		// Caption
    		this.captionDiv = DOMHelper.createTextNode("h1", i18n.planDeliverCatalogueNewEntriesCaption, captionBarDiv, "planDeliverCatalogueCaption");

     		// Version
     		var options = [];
     		
     		this.versionSelect = new Select({
     			   label : i18n.planDeliverCatalogueVersionLabel,
     			   title : i18n.planDeliverCatalogueVersionToolTip,
     			 options : options,
     			disabled : true
     		});
     		domClass.add(this.versionSelect.domNode, "planDeliverCatalogueVersionSelect");
     		domConstruct.place(this.versionSelect.domNode, captionBarDiv);
     		WidgetHelper.handleSelectEvents(this.versionSelect, lang.hitch(this, function() {
     			// Trigger new search, if and only if the value in the dropdown has actually changed
     			var selectedDocumentListId = this.versionSelect.get("value");
     			if (!this.lastSearchedDocumentListId || selectedDocumentListId != this.lastSearchedDocumentListId) {
     				this.reload();
     			}
     		}));

    		return captionBarDiv;
    	},
    	
    	constructStatusBar : function() {
    		var statusBarDiv = domConstruct.create("div", null, null);
    		domClass.add(statusBarDiv, "refNodeOfPositionAbsolute");
    		
    		this.statusDiv = DOMHelper.createTextNode("div", i18n.planDeliverCatalogueNotYetSearched, statusBarDiv, "fixedDialogWidget planDeliverNewPageStatusDiv");
    		
    		return statusBarDiv;
    	},
    	
    	resize : function(newSize) {
    		var totalHeight = newSize.h;      		
    		
    		var statusBarHeight = Math.max(this.statusDiv.offsetHeight, 50);
    		domStyle.set(this.statusBarDiv, "height", statusBarHeight);
//    		log.info("statusBarHeight = " + statusBarHeight);
    		
    		var tableWidth = this.captionBarDiv.offsetWidth - 15;
    		var tableHeight = totalHeight
    					//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
    					- this.captionBarDiv.offsetHeight
    					- statusBarHeight
    					- 16;
    		
    		this.newWidget.resize({ w : tableWidth, h : tableHeight });
    	},
    	
    	setData : function() {

    	},
    	
    	reload : function() {
    		//this.contextBar.reload();
    		
    		var planDeliverService = this.applicationContext.getService("planDeliverService");
    		var project = this.applicationContext.getPageContextProject();
    		
    		this.newWidget.reload();
    		/*
    		// If the previous search still runs, cancel it
    		if (this.joinDeferred != null) {
    			log.info("Previous joinDeferred still runs, will cancel it.");
    			this.joinDeferred.cancel();
    		}
    		
    		if (log.isDebugEnabled()) {
    			log.debug("Will execute plan deliver join, documentListId = " + searchModel.documentListId + ", unreleased: " + this.unreleasedDocumentId);	
    		}    		
    		
    		// Trigger async search request
    		this.joinDeferred = searchModel.documentListId == this.unreleasedDocumentId
    					? planDeliverService.getPlanDeliverUnreleasedJoin(searchModel) : planDeliverService.getPlanDeliverReleasedJoin(searchModel);
    		
    		// Print out that a search is running, discard the previous data immediately, to avoid disturbing the user
    		DOMHelper.setInnerText(this.statusDiv, i18n.planDeliverCatalogueSearchRuns);
    		this.listWidget.setData({ data : [] });
    		
    		// Update button state etc.
    		this.registerAsyncOperationStarted(PlanDeliverCatalogue.AsyncOperation.GET_DATA);
    		this.updateWidgetState();
    		promiseAll([this.joinDeferred]).then(lang.hitch(this, function(resultArray) {
    				this.planDeliverJoinDtos = resultArray[0].joinDtos;
    				var documentIdToHistoryItems = resultArray[0].documentIdToHistoryItems;
    				this.objectPlannerIdToActions = ActionHelper.transformObjectPlannerIdToActions(resultArray[0].objectPlannerIdToActions);
    				
    				log.info("Received objectPlannerIdToActions: ", this.objectPlannerIdToActions);
    				
    				var plannerMap = this.getPlannerMap(this.planDeliverJoinDtos);
    				var objectMap = this.getObjectMap(this.planDeliverJoinDtos);
    				var objectPlannerMap = this.getObjectPlannerMap(this.planDeliverJoinDtos);
    				
    				var searchInfoString = this.getSearchInfoString(this.planDeliverJoinDtos, plannerMap, objectMap, objectPlannerMap);
    				DOMHelper.setInnerText(this.statusDiv, searchInfoString);
    				
    				var columnSettings = this.getAutomaticColumnSettings(plannerMap, objectMap, objectPlannerMap);
    				this.listWidget.setData({             data : this.planDeliverJoinDtos,
    									               columns : columnSettings,
    								  documentIdToHistoryItems : documentIdToHistoryItems,
    								  objectPlannerIdToActions : this.objectPlannerIdToActions,
    								                unreleased : searchModel.documentListId == this.unreleasedDocumentId
    				});
    				
    				delete this.joinDeferred;
    				
    	    		this.registerAsyncOperationFinished(PlanDeliverCatalogue.AsyncOperation.GET_DATA);
    				this.updateWidgetState();
   			}),
   			lang.hitch(this, function(err) {    			
   				log.error("Error calling getPlanDeliverJoin or getting documentNumberSpec: ", err);
				delete this.joinDeferred;
				this.registerAsyncOperationFinished(PlanDeliverCatalogue.AsyncOperation.GET_DATA);
				this.updateWidgetState();
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling getPlanDeliverJoin or getting documentNumberSpec: ", err);
    		}));  
			*/
    	},
    	
    	updateWidgetState : function() {
    		/*
    		var operationRunning = this.isAsyncOperationRunning();
    		
    		domClass.add(this.captionButtonDiv, "hidden");
    		domClass.add(this.searchWidgetDiv, "hidden");
    		
    		domClass.add(this.quickSearchLabel, "hidden");
    		domClass.add(this.quickSearchTextBox.domNode, "hidden");
    		domClass.add(this.quickSearchClearButton.domNode, "hidden");
    		
			// The newWidgetDiv is initialized in a lazy manner, not before the PlanDeliverCatalogue enters mode NEW for the first time
			if (this.newWidgetDiv != null) {
				domClass.add(this.newWidgetDiv, "hidden");
			}    		
    		
    		domClass.add(this.saveButton.domNode, "hidden");
    		domClass.add(this.saveAndQuitEditButton.domNode, "hidden");
    		domClass.add(this.saveAndReleaseButton.domNode, "hidden");
    		
    		domClass.add(this.abortEditButton.domNode, "hidden");
    		domClass.add(this.abortReleaseButton.domNode, "hidden");
    		domClass.add(this.listWidgetDiv, "hidden");
    		
    		if (this.mode == PlanDeliverCatalogue.Mode.DEFAULT) {    			
        		var unreleased = this.versionSelect.get("value") == this.unreleasedDocumentId;
    			
        		domClass.remove(this.captionButtonDiv, "hidden");
    			domClass.remove(this.editButton.domNode, "hidden");
    			domClass.remove(this.searchWidgetDiv, "hidden");
        		domClass.remove(this.quickSearchLabel, "hidden");
        		domClass.remove(this.quickSearchTextBox.domNode, "hidden");
        		domClass.remove(this.quickSearchClearButton.domNode, "hidden");    			
    			if (unreleased) {
    				domClass.remove(this.releaseButton.domNode, "hidden");
        		}
    			
        		domClass.remove(this.listWidgetDiv, "hidden");
        		
        		var newDisabled = operationRunning
        						   || (   !ActionHelper.hasAnyObjectPlannerEditPermission(this.objectPlannerIdToActions)
    									   && !this.applicationContext.isActionAllowedForProject("editPlanDeliverCatalogueDatesProjCont"));
    			var editDisabled = operationRunning 
								   || !this.planDeliverJoinDtos
								   || this.planDeliverJoinDtos.length == 0
								   || (   !ActionHelper.hasAnyObjectPlannerEditPermission(this.objectPlannerIdToActions)
									   && !this.applicationContext.isActionAllowedForProject("editPlanDeliverCatalogueDatesProjCont"));
    			
    			this.newButton.set("disabled", newDisabled);
        		this.editButton.set("disabled", editDisabled);
    		} else if (this.mode == PlanDeliverCatalogue.Mode.NEW) {
    			this.oldSelectedVersion = this.versionSelect.get("value");
    			this.versionSelect.set("value", this.unreleasedDocumentId);    			
    			
    			if (this.newWidgetDiv == null) {
        			this.newWidget = new PlanDeliverNewWidget({
        				applicationContext : this.applicationContext
        			});
        			this.newWidgetDiv = this.newWidget.getContainer();
        			
        			DOMHelper.setInnerText(this.statusDiv, this.newWidget.getStatusMessage());
        			on(this.newWidget, "statusMessage", lang.hitch(this, function() {
        				DOMHelper.setInnerText(this.statusDiv, this.newWidget.getStatusMessage());
        			}));
    			}
    			
    			domClass.remove(this.newWidgetDiv, "hidden");
    			
    		} else if (this.mode == PlanDeliverCatalogue.Mode.EDITING) {
    			this.oldSelectedVersion = this.versionSelect.get("value");
    			this.versionSelect.set("value", this.unreleasedDocumentId);
    			
    			domClass.remove(this.abortEditButton.domNode, "hidden");
    			domClass.remove(this.saveButton.domNode, "hidden");
    			domClass.remove(this.saveAndQuitEditButton.domNode, "hidden");
    			domClass.remove(this.saveAndReleaseButton.domNode, "hidden");
    			
    			var unreleased = this.versionSelect.get("value") == this.unreleasedDocumentId;
    			domClass.remove(this.abortEditButton.domNode, "hidden");
    			if (unreleased) {
    				domClass.remove(this.releaseButton.domNode, "hidden");
    			}
    			
        		domClass.remove(this.listWidgetDiv, "hidden");
    			
    			this.editButton.set("disabled", true);
    			this.releaseButton.set("disabled", true);
    		} else if (this.mode == PlanDeliverCatalogue.Mode.RELEASING) {
    			domClass.remove(this.buttonBarDiv, "hidden");
    		} else {
    			throw new Error("UpdateWidgetState received invalid mode: [" + this.mode + "]");
    		}
    		
    		var captionLabel = null;
    		if (this.mode == PlanDeliverCatalogue.Mode.NEW) {
    			captionLabel = i18n.planDeliverCatalogueNewEntriesCaption;
    		} else {
    			captionLabel = i18n.planDeliverCatalogueCaption;
    		}
    		
    		DOMHelper.setInnerText(this.captionDiv, captionLabel);
    		this.versionSelect.set("disabled", this.mode == PlanDeliverCatalogue.Mode.NEW || this.mode == PlanDeliverCatalogue.Mode.EDITING);
    		


    		this.releaseButton.set("disabled", operationRunning);
    		*/
    	},
    	
     	setupVersionSelect : function(documentListReleaseVersions) {
     		var versionSelectInfo = PlanDeliverHelper.constructVersionOptions({
		                 applicationContext : this.applicationContext,
		        documentListReleaseVersions : documentListReleaseVersions
     		});
	
     		var options = versionSelectInfo.options;
     		this.unreleasedDocumentId = versionSelectInfo.unreleasedDocumentId;
	
     		this.versionSelect.set("options", options);
     		
     		// Select always the unreleased version
     		if (options.length > 0) {
     			this.versionSelect.set("value", options[0].value);
     		}
     	},
     	
     	save : function() {
     		/*	
     		this.listWidget.save();
     		
     		var newPlanDeliverJoinDtos = this.listWidget.getPlanDeliverJoinDtos();
     		log.info("New joinDtos: ", newPlanDeliverJoinDtos);
     		
     		var documents = JoinHelper.getJoinDtoComponent(newPlanDeliverJoinDtos, "document");
     		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
     		var projectId = this.applicationContext.getPageContextProjectId();
     		var subProjectId = this.applicationContext.getPageContextSubProjectId();

    		this.registerAsyncOperationStarted(PlanDeliverCatalogue.AsyncOperation.SAVE);
    		var planDeliverService = this.applicationContext.getService("planDeliverService");
    		planDeliverService.savePlanDeliverCatalogue(documents, [], organisationPersonId, projectId, subProjectId).then(lang.hitch(this, function() {
    			               
    				log.info("Saved");
    			
    				this.registerAsyncOperationFinished(PlanDeliverCatalogue.AsyncOperation.SAVE);
    			}),
    			lang.hitch(this, function(err) {    			
    				log.error("Error calling savePlanDeliverCatalogue: ", err);
    				this.registerAsyncOperationFinished(PlanDeliverCatalogue.AsyncOperation.SAVE);
				})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of a call to savePlanDeliverCatalogue: ", err);
    		}));
    		*/
     	},
     	
     	destroy : function() {
     		this.inherited(arguments);
     		this.newWidget.destroy();
     	}
    });
    
    PlanDeliverNewPage.AsyncOperation = {
    	GET_DOCUMENT_LISTS : "GetDocumentLists",
    	/*          GET_DATA : "GetData",
    	              SAVE : "Save"*/
    };
    
    return PlanDeliverNewPage;
});
