/*******************************************************************************
 * $Id$
 * 
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 * 
 ******************************************************************************/

// //css-prefix = planningNotificationReportstep
// //i18n-prefix = planningNotificationReportstep

define(
		[   "clazzes/TinyLog", "clazzes/dateTime/DateHelper",
				"clazzes/util/DOMHelper", "clazzes/util/DataHelper",
				"clazzes/widgets/layout/ContentWidget", "dojo/dom-class",
				"dojo/dom-construct", "dojo/dom-style", "dojo/on",
				"dojo/string", "dojo/_base/declare", "dojo/_base/lang",
				"dojo/i18n!/cdes/nls/cdes-web-i18n.js" ],
		function(TinyLog, DateHelper, DOMHelper, DataHelper, ContentWidget,
				domClass, domConstruct, domStyle, on, string, declare, lang,
				i18n) {

			var className = "at.cdes.web.planning.report.PlanningNotificationReportStepWidget";

			var log = new TinyLog(className);

			var PlanningNotificationReportStepWidget = declare(
					className,
					ContentWidget,
					{

						constructor : function(params) {
							lang.mixin(this, params);

							this.topDiv = this.constructTopDiv();
							this.initialize();
							this.updateWidgetState();

							this.allFieldsValid = true;
						},

						getWidgetId : function() {
							// To be implemented in subclass
						},

						getDataId : function() {
							return null;
						},

						getPageCaption : function() {
							// To be implemented in subclass
						},

						getData : function() {
							// summary:
							// Returns all data set within this widget, and
							// interesting for the
							// subsequent widgets, in an object.
						},

						// Event stepWidgetChanged
						// ... emitted on (a) changes of "may step forward"
						// property, or on (b) changes of the step forward
						// button caption

						stepBackwardHandler : function() {
							// Function called by the
							// PlanningNotificationReportPage after the user
							// hits "Back", and before that back step
							// is actually executed. Responsible for cleanup
							// tasks like cancelling running requests.
						},

						getStepForwardCaption : function() {
						},

						getStepForwardToolTip : function() {
						},

						getCustomButtons : function() {
							return [];
						},

						disableStepForward : function() {
							// Usually set by updateWidgetState
							return !this.mayStepForward;
						},

						performStepForward : function(stepWidgets) {
							// summary:
							// Given an array of step widgets (which contains
							// the this-pointer of this widget),
							// this function steps to the next widget.
							// description:
							// The next widget can either be constructed newly
							// (if it did not exist yet), or can
							// be the next widget from the array. The latter
							// case happens if the user first hit
							// "Back", and then "Next". In that case, it is up
							// to the subclass, wether the already
							// existing widget can be reused, or not. If yes,
							// member variables of the already
							// existing widget may be altered as needed, if no,
							// a new widget will be constructed,
							// and the given array will be altered accordingly.
							// returns:
							// The widget being active afterwards, i.e. either
							// the next from the array, or a newly
							// constructed one.
						},

						processNetworkChange : function() {
							// summary:
							// Function called by the
							// PlanningNotificationReportPage on changes of the
							// PnNetworkId
							// in the application context.
						},

						createOrReuseStepForwardWidget : function(stepWidgets, widgetId, creatorFct) {
							var thisWidgetIndex = this.getThisWidgetIndex(stepWidgets);

							if (thisWidgetIndex < stepWidgets.length - 1) {
								// Previous back happened, try to reuse widget
								var nextWidget = stepWidgets[thisWidgetIndex + 1];
								var nextWidgetId = nextWidget.getWidgetId();
								if (nextWidgetId == widgetId) {
									return nextWidget;
								} else {
									for (var n = thisWidgetIndex + 2; n < stepWidgets.length; n++) {
										stepWidgets[n].destroy();
									}
									stepWidgets.splice(thisWidgetIndex + 2,
											stepWidgets.length - (thisWidgetIndex + 2));
									stepWidgets[thisWidgetIndex + 1] = creatorFct();
									return stepWidgets[thisWidgetIndex + 1];
								}
							} else {
								stepWidgets.push(creatorFct());
								return stepWidgets[stepWidgets.length - 1];
							}
						},

						storeConfigToLocalStorage : function() {
							this.updateDataFromWidgets();

							// Clone config, to be able to do manual changes
							// only relevant for localStorage below.
							var config = DataHelper.clone(this.config);
							if (config.cover == null) {
								config.cover = {
										comment : ""
								};	   
							}

							// Deliberately don't save the comment in
							// localStorage; it is only saved as part of named
							// reports
							config.cover.comment = "";
							config.timestamp = DateHelper.getCurrentTimeSeconds();

							var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
							var networkId = this.applicationContext.getPageContextPnNetworkId();
							//log.info("Storing config to [" + organisationPersonId + "] and networkId [" + networkId + "]", config);
							this.applicationContext.storeInLocalStorage([ organisationPersonId, networkId ], "/planningNotificationReport/config", config);
						},

						getContainer : function() {
							return this.topDiv;
						},

						constructTopDiv : function() {
							var topDiv = domConstruct.create("div", null, null);
							domClass.add(topDiv, "fixedDialogWidget occupyWholeParent");

							return topDiv;
						},

						getThisWidgetIndex : function(stepWidgets) {
							for (var n = 0; n < stepWidgets.length; n++) {
								if (stepWidgets[n] == this) {
									return n;
								}
							}

							return null;
						},

						resize : function(size) {
							// summary:
							// Resize the step widget. Currently, only size.h is
							// supported, not size.w
						},

						destroy : function() {
							this.inherited(arguments);
						}
					});

			PlanningNotificationReportStepWidget.Step = {
				OPTIONS : "Options",
				COVER : "Cover",
				DATA : "Data"
			};

			return PlanningNotificationReportStepWidget;
		});
