/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

define([ "clazzes/TinyLog",
	 "dstore/Memory",
	 "dojo/_base/declare"],
       function(TinyLog,
		Memory,
		declare) {

    var className = "at.cdes.web.util.FancyMemory";

    var log = new TinyLog(className);

    var FancyMemory = declare(className, Memory, {

	/* ============================== CAUTION ====================================== */
	/* ============================================================================= */	
	/* Function copied from dstore/SimpleQuery, to allow for a custom sort function. */
	/* ============================================================================= */		
	
	_createSortQuerier: function (sorted) {
	    return function (data) {
		data = data.slice();
		data.sort(typeof sorted == 'function' ? sorted : function (a, b) {
		    for (var i = 0; i < sorted.length; i++) {
			var comparison;
			if (typeof sorted[i] == 'function') {
			    comparison = sorted[i](a, b);
			} else {
			    var property = sorted[i].property;
			    var descending = sorted[i].descending;
						  var aValue = a.get ? a.get(property) : a[property];
						  var bValue = b.get ? b.get(property) : b[property];

			    aValue != null && (aValue = aValue.valueOf());
			    bValue != null && (bValue = bValue.valueOf());

			    if (aValue == null || (typeof aValue == "string" && aValue.trim().length == 0)) {
				comparison = 1;
			    } else if (bValue == null || (typeof bValue == "string" && bValue.trim().length == 0)) {
				comparison = -1;
			    } else {
				if (typeof aValue == "string" && typeof bValue == "string") {
				    if (descending) {
					comparison = -aValue.localeCompare(bValue);
				    } else {
					comparison = aValue.localeCompare(bValue);
				    }
				} else {
				    if (descending) {
					comparison = aValue < bValue ? 1 : -1;
				    } else {
					comparison = aValue < bValue ? -1 : 1;
				    }
				}				

				/*
				comparison = aValue === bValue
				? 0
				   : (!!descending === (aValue === null || aValue > bValue) ? -1 : 1);*/
			    }
			}

			if (comparison !== 0) {
			    return comparison;
			}
		    }
			return 0;
		});
		return data;
	    };
	}
    });

    return FancyMemory;
});
