/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationOrderColumn
////i18n-prefix = planningNotificationOrderColumn


define([
    "cdes/util/ColumnHelper",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/IconTitlePane",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/CheckBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    ColumnHelper,
    TinyLog,
    DOMHelper,
    WidgetHelper,
    IconTitlePane,
    ContentWidget,
    CheckBox,
    domClass,
    domConstruct,
    on,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.planning.order.PlanningNotificationOrderColumnWidget";

    var log = new TinyLog(className);

    var PlanningNotificationOrderColumnWidget = declare(className, ContentWidget, {

	constructor : function(params) {
	    lang.mixin(this, params);

	    this.topDiv = this.constructTopDiv();
	    this.postTitleClick();

	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "PlanningNotificationOrderColumnWidget";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructTopDiv : function() {
	    var topDiv = domConstruct.create("div", null, null);
	    domClass.add(topDiv, "refNodeOfPositionAbsolute planningNotificationOrderColumnFull");

	    this.titlePane = this.constructTitlePane();
	    domConstruct.place(this.titlePane.domNode, topDiv);

	    return topDiv;
	},

	postTitleClick : function() {
	    var open = this.titlePane.get("open");

	    if (open) {
		this.titlePane.set("title", i18n.columnOpenCaption);
		domClass.replace(this.topDiv, "planningNotificationOrderColumnFull", "planningNotificationOrderColumnReduced");
	    } else {
		this.titlePane.set("title", i18n.columnClosedCaption);
		domClass.replace(this.topDiv, "planningNotificationOrderColumnReduced", "planningNotificationOrderColumnFull");
	    }

	    on.emit(this, "titlePaneToggled");
	},

	constructTitlePane : function() {
	    var contentDiv = this.constructContentDiv();

	    var titlePane = new IconTitlePane({
		       title   : i18n.columnOpenCaption,
		       content : contentDiv,
		    toggleable : true,
			  open : false,
		postTitleClick : lang.hitch(this, this.postTitleClick)
	    });
	    domClass.add(titlePane.domNode, "occupyWholeParent");

	    return titlePane;
	},

	constructContentDiv : function() {
	    var contentDiv = domConstruct.create("div", null, null);
	    domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationOrderColumnContentDiv");

	    // SerialNumberCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnSerialNumberLabel");
	    this.serialNumberCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderSerialNumberLabel,
		title : i18n.planningNotificationOrderSerialNumberToolTip
	    });
	    domClass.add(this.serialNumberCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnSerialNumberCheckBox");
	    domConstruct.place(this.serialNumberCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.serialNumberCheckBox, "serialNumber");

	    // TextCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderTextLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnTextLabel");
	    this.textCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderTextLabel,
		title : i18n.planningNotificationOrderTextToolTip
	    });
	    domClass.add(this.textCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnTextCheckBox");
	    domConstruct.place(this.textCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.textCheckBox, "text");

	    // PlanningNotificationCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderPlanningNotificationLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnPlanningNotificationLabel");
	    this.planningNotificationCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderPlanningNotificationLabel,
		title : i18n.planningNotificationOrderPlanningNotificationToolTip
	    });
	    domClass.add(this.planningNotificationCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnPlanningNotificationCheckBox");
	    domConstruct.place(this.planningNotificationCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.planningNotificationCheckBox, "planningNotification");

	    // ProjectCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderProjectLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnProjectLabel");
	    this.projectCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderProjectLabel,
		title : i18n.planningNotificationOrderProjectToolTip
	    });
	    domClass.add(this.projectCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnProjectCheckBox");
	    domConstruct.place(this.projectCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.projectCheckBox, "project");

	    // SubjectAreaCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubjectAreaLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnSubjectAreaLabel");
	    this.subjectAreaCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderSubjectAreaLabel,
		title : i18n.planningNotificationOrderSubjectAreaToolTip
	    });
	    domClass.add(this.subjectAreaCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnSubjectAreaCheckBox");
	    domConstruct.place(this.subjectAreaCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.subjectAreaCheckBox, "subjectArea");

	    // AuthorizedInspectorCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderAuthorizedInspectorLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnAuthorizedInspectorLabel");
	    this.authorizedInspectorCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderAuthorizedInspectorLabel,
		title : i18n.planningNotificationOrderAuthorizedInspectorToolTip
	    });
	    domClass.add(this.authorizedInspectorCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnAuthorizedInspectorCheckBox");
	    domConstruct.place(this.authorizedInspectorCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.authorizedInspectorCheckBox, "authorizedInspector");

	    // ReferenceCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderReferenceLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnReferenceLabel");
	    this.referenceCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderReferenceLabel,
		title : i18n.planningNotificationOrderReferenceToolTip
	    });
	    domClass.add(this.referenceCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnReferenceCheckBox");
	    domConstruct.place(this.referenceCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.referenceCheckBox, "reference");

	    // StatutoryDutyCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnStatutoryDutyLabel");
	    this.statutoryDutyCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderStatutoryDutyLabel,
		title : i18n.planningNotificationOrderStatutoryDutyToolTip
	    });
	    domClass.add(this.statutoryDutyCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnStatutoryDutyCheckBox");
	    domConstruct.place(this.statutoryDutyCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.statutoryDutyCheckBox, "statutoryDuty");

	    // InvalidatedCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderInvalidatedLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnInvalidatedLabel");
	    this.invalidatedCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderInvalidatedLabel,
		title : i18n.planningNotificationOrderInvalidatedToolTip
	    });
	    domClass.add(this.invalidatedCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnInvalidatedCheckBox");
	    domConstruct.place(this.invalidatedCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.invalidatedCheckBox, "invalidated");

	    // WorkflowNodeCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnWorkflowNodeLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnWorkflowNodeLabel");
	    this.workflowNodeCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderColumnWorkflowNodeLabel,
		title : i18n.planningNotificationOrderColumnWorkflowNodeToolTip
	    });
	    domClass.add(this.workflowNodeCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnWorkflowNodeCheckBox");
	    domConstruct.place(this.workflowNodeCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.workflowNodeCheckBox, "workflowNode");

	    // StateCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStateLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnStateLabel");
	    this.stateCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderStateLabel,
		title : i18n.planningNotificationOrderStateToolTip
	    });
	    domClass.add(this.stateCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnStateCheckBox");
	    domConstruct.place(this.stateCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.stateCheckBox, "state");

	    // DocumentPageCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPageLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnDocumentPageLabel");
	    this.documentPageCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderDocumentPageLabel,
		title : i18n.planningNotificationOrderDocumentPageToolTip
	    });
	    domClass.add(this.documentPageCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnDocumentPageCheckBox");
	    domConstruct.place(this.documentPageCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.documentPageCheckBox, "documentPage");

	    // DocumentPositionCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPositionLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnDocumentPositionLabel");
	    this.documentPositionCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderDocumentPositionLabel,
		title : i18n.planningNotificationOrderDocumentPositionToolTip
	    });
	    domClass.add(this.documentPositionCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnDocumentPositionCheckBox");
	    domConstruct.place(this.documentPositionCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.documentPositionCheckBox, "documentPosition");

	    // SourceCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSourceLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnSourceLabel");
	    this.sourceCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderSourceLabel,
		title : i18n.planningNotificationOrderSourceToolTip
	    });
	    domClass.add(this.sourceCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnSourceCheckBox");
	    domConstruct.place(this.sourceCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.sourceCheckBox, "source");

	    // PersonInChargeCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderPersonInChargeLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnPersonInChargeLabel");
	    this.personInChargeCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderPersonInChargeLabel,
		title : i18n.planningNotificationOrderPersonInChargeToolTip
	    });
	    domClass.add(this.personInChargeCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnPersonInChargeCheckBox");
	    domConstruct.place(this.personInChargeCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.personInChargeCheckBox, "personInCharge");            

	    // StatutoryDutyFromCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnStatutoryDutyFromLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnStatutoryDutyFromLabel");
	    this.statutoryDutyFromCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderColumnStatutoryDutyFromLabel,
		title : i18n.planningNotificationOrderColumnStatutoryDutyFromToolTip
	    });
	    domClass.add(this.statutoryDutyFromCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnStatutoryDutyFromCheckBox");
	    domConstruct.place(this.statutoryDutyFromCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.statutoryDutyFromCheckBox, "statutoryDutyFrom");

	    // StatutoryDutyToCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnStatutoryDutyToLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnStatutoryDutyToLabel");
	    this.statutoryDutyToCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderColumnStatutoryDutyToLabel,
		title : i18n.planningNotificationOrderColumnStatutoryDutyToToolTip
	    });
	    domClass.add(this.statutoryDutyToCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnStatutoryDutyToCheckBox");
	    domConstruct.place(this.statutoryDutyToCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.statutoryDutyToCheckBox, "statutoryDutyTo");

	    // StatutoryDutyIntervalCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnStatutoryDutyIntervalLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnStatutoryDutyIntervalLabel");
	    this.statutoryDutyIntervalCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderColumnStatutoryDutyIntervalLabel,
		title : i18n.planningNotificationOrderColumnStatutoryDutyIntervalToolTip
	    });
	    domClass.add(this.statutoryDutyIntervalCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnStatutoryDutyIntervalCheckBox");
	    domConstruct.place(this.statutoryDutyIntervalCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.statutoryDutyIntervalCheckBox, "statutoryDutyInterval");

	    // LeadTimeCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnLeadTimeLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnLeadTimeLabel");
	    this.leadTimeCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderColumnLeadTimeLabel,
		title : i18n.planningNotificationOrderColumnLeadTimeToolTip
	    });
	    domClass.add(this.leadTimeCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnLeadTimeCheckBox");
	    domConstruct.place(this.leadTimeCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.leadTimeCheckBox, "statutoryDutyLeadTime");

	    // SiteTypeCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnSiteTypeLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnSiteTypeLabel");
	    this.siteTypeCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderColumnSiteTypeLabel
	    });
	    domClass.add(this.siteTypeCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnSiteTypeCheckBox");
	    domConstruct.place(this.siteTypeCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.siteTypeCheckBox, "siteType");

	    // StatutoryDutyExpiredCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyExpiredLabel, contentDiv,
		"fixedDialogWidget planningNotificationOrderColumnStatutoryDutyExpiredLabel");
	    this.statutoryDutyExpiredCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderStatutoryDutyExpiredLabel,
		title : i18n.planningNotificationOrderStatutoryDutyExpiredToolTip
	    });
	    domClass.add(this.statutoryDutyExpiredCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnStatutoryDutyExpiredCheckBox");
	    domConstruct.place(this.statutoryDutyExpiredCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.statutoryDutyExpiredCheckBox, "statutoryDutyExpired");

	    // SubmitAuthorityCheckBox
	    var submitAuthorityLabel = i18n.planningNotificationOrderSubmitAuthorityLabel;
	    if (submitAuthorityLabel.length > 21)
	    submitAuthorityLabel = submitAuthorityLabel.substr(0, 19)+"..";
	    DOMHelper.createTextNode("div", submitAuthorityLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnSubmitAuthorityLabel");
	    this.submitAuthorityCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderSubmitAuthorityLabel,
		title : i18n.planningNotificationOrderSubmitAuthorityToolTip
	    });
	    domClass.add(this.submitAuthorityCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnSubmitAuthorityCheckBox");
	    domConstruct.place(this.submitAuthorityCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.submitAuthorityCheckBox, "submitAuthority");

	    // TagCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnTagLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnTagLabel");
	    this.tagCheckBox = new CheckBox({
		label : i18n.planningNotificationOrderColumnTagLabel,
		title : i18n.planningNotificationOrderColumnTagToolTip
	    });
	    domClass.add(this.tagCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnTagCheckBox");
	    domConstruct.place(this.tagCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.tagCheckBox, "tag");

	    // CommentCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderCommentLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnCommentLabel");
	    this.commentCheckBox = new CheckBox({
		label : i18n.planningNotificationColumnCommentLabel,
		title : i18n.planningNotificationColumnCommentToolTip
	    });
	    domClass.add(this.commentCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnCommentCheckBox");
	    domConstruct.place(this.commentCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.commentCheckBox, "orderComment");

	    // EnvironmentallyRelevantCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderEnvironmentallyRelevantLabel, contentDiv, "fixedDialogWidget planningNotificationOrderColumnEnvironmentallyRelevantLabel");
	    this.environmentallyRelevantCheckBox = new CheckBox({
		label : i18n.planningNotificationColumnEnvironmentallyRelevantLabel,
		title : i18n.planningNotificationColumnEnvironmentallyRelevantLabel
	    });
	    domClass.add(this.environmentallyRelevantCheckBox.domNode, "fixedDialogWidget planningNotificationOrderColumnEnvironmentallyRelevantCheckBox");
	    domConstruct.place(this.environmentallyRelevantCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.environmentallyRelevantCheckBox, "environmentallyRelevant");

	    return contentDiv;
	},

        handleCheckBoxEvents : function(checkBox, columnId) {
            WidgetHelper.handleCheckBoxEvents(checkBox, lang.hitch(this, function() {
                ColumnHelper.emitColumnsChangedPN(this.applicationContext, this, "planningNotificationOrder/columns", columnId);
            }));                        
        },

	setData : function(columnSettings) {
	    this.columnSettings = columnSettings;
	    this.reload();
	},

	reload : function() {
	    this.updateWidgetsFromData();
	},	    

	updateWidgetsFromData : function() {
	    this.serialNumberCheckBox.set("checked", this.columnSettings.showSerialNumber);
	    this.textCheckBox.set("checked", this.columnSettings.showText);
	    this.planningNotificationCheckBox.set("checked", this.columnSettings.showPlanningNotification);
	    this.projectCheckBox.set("checked", this.columnSettings.showProject);
	    this.subjectAreaCheckBox.set("checked", this.columnSettings.showSubjectArea);
	    this.authorizedInspectorCheckBox.set("checked", this.columnSettings.showAuthorizedInspector);
	    this.referenceCheckBox.set("checked", this.columnSettings.showReference);
	    this.statutoryDutyCheckBox.set("checked", this.columnSettings.showStatutoryDuty);
	    this.invalidatedCheckBox.set("checked", this.columnSettings.showInvalidated);
	    this.workflowNodeCheckBox.set("checked", this.columnSettings.showWorkflowNode);
	    this.stateCheckBox.set("checked", this.columnSettings.showState);
	    this.documentPageCheckBox.set("checked", this.columnSettings.showDocumentPage);
	    this.documentPositionCheckBox.set("checked", this.columnSettings.showDocumentPosition);
	    this.sourceCheckBox.set("checked", this.columnSettings.showSource);
	    this.personInChargeCheckBox.set("checked", this.columnSettings.showPersonInCharge);
	    this.statutoryDutyFromCheckBox.set("checked", this.columnSettings.showStatutoryDutyFrom);
	    this.statutoryDutyToCheckBox.set("checked", this.columnSettings.showStatutoryDutyTo);
	    this.statutoryDutyIntervalCheckBox.set("checked", this.columnSettings.showStatutoryDutyInterval);
	    this.leadTimeCheckBox.set("checked", this.columnSettings.showStatutoryDutyLeadTime);
	    this.siteTypeCheckBox.set("checked", this.columnSettings.showSiteType);	    
	    this.statutoryDutyExpiredCheckBox.set("checked", this.columnSettings.showStatutoryDutyExpired);
	    this.submitAuthorityCheckBox.set("checked", this.columnSettings.showSubmitAuthority);
	    this.tagCheckBox.set("checked", this.columnSettings.showTag);
	    this.commentCheckBox.set("checked", this.columnSettings.showOrderComment);
	    this.environmentallyRelevantCheckBox.set("checked", this.columnSettings.showEnvironmentallyRelevant);	    
	},

	updateDataFromWidgets : function() {
	    this.columnSettings.showSerialNumber = this.serialNumberCheckBox.get("checked");
	    this.columnSettings.showText = this.textCheckBox.get("checked");
	    this.columnSettings.showPlanningNotification = this.planningNotificationCheckBox.get("checked");
	    this.columnSettings.showProject = this.projectCheckBox.get("checked");
	    this.columnSettings.showSubjectArea = this.subjectAreaCheckBox.get("checked");
	    this.columnSettings.showAuthorizedInspector = this.authorizedInspectorCheckBox.get("checked");
	    this.columnSettings.showReference = this.referenceCheckBox.get("checked");
	    this.columnSettings.showStatutoryDuty = this.statutoryDutyCheckBox.get("checked");
	    this.columnSettings.showInvalidated = this.invalidatedCheckBox.get("checked");
	    this.columnSettings.showWorkflowNode = this.workflowNodeCheckBox.get("checked");
	    this.columnSettings.showState = this.stateCheckBox.get("checked");
	    this.columnSettings.showDocumentPage = this.documentPageCheckBox.get("checked");
	    this.columnSettings.showDocumentPosition = this.documentPositionCheckBox.get("checked");
	    this.columnSettings.showSource = this.sourceCheckBox.get("checked");
	    this.columnSettings.showPersonInCharge = this.personInChargeCheckBox.get("checked");
	    this.columnSettings.showStatutoryDutyFrom = this.statutoryDutyFromCheckBox.get("checked");
	    this.columnSettings.showStatutoryDutyTo = this.statutoryDutyToCheckBox.get("checked");
	    this.columnSettings.showStatutoryDutyInterval = this.statutoryDutyIntervalCheckBox.get("checked");
	    this.columnSettings.showStatutoryDutyLeadTime = this.leadTimeCheckBox.get("checked");
	    this.columnSettings.showSiteType = this.siteTypeCheckBox.get("checked");	    
	    this.columnSettings.showStatutoryDutyExpired = this.statutoryDutyExpiredCheckBox.get("checked");
	    this.columnSettings.showSubmitAuthority = this.submitAuthorityCheckBox.get("checked");
	    this.columnSettings.showTag = this.tagCheckBox.get("checked");
	    this.columnSettings.showOrderComment = this.commentCheckBox.get("checked");
	    this.columnSettings.showEnvironmentallyRelevant = this.environmentallyRelevantCheckBox.get("checked");	    
	},

	getColumnSettings : function() {
	    return this.columnSettings;
	},

	updateWidgetState : function() {

	}
    });

    PlanningNotificationOrderColumnWidget.AsyncOperation = {

    };

    return PlanningNotificationOrderColumnWidget;
});
