/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationOrderSearch
////i18n-prefix = planningNotificationOrderSearch



define([ "cdes/core/CdesVoc",
	"cdes/planning/util/PlanningNotificationHelper",
	"cdes/planning/util/PlanningNotificationTitleMultiSearchWidget",
	"cdes/util/SearchPageHelper",
    "cdes/widget/CalendarSpinner",
	"cdes/widget/util/WidgetFactory",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/form/NumberSpinner",
	"clazzes/util/DOMHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/IconTitlePane",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Button",
	"dijit/form/CheckBox",
	"dijit/form/ComboBox",
	"dijit/form/Select",
	"dijit/form/TextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/keys",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
	 PlanningNotificationHelper,
	 PlanningNotificationTitleMultiSearchWidget,
     SearchPageHelper,
	 CalendarSpinner,
	 WidgetFactory,
	 TinyLog,
	 DateTimeSpinBox,
	 NumberSpinner,
	 DOMHelper,
	 WidgetHelper,
	 IconTitlePane,
	 ContentWidget,
	 Button,
	 CheckBox,
	 ComboBox,
	 Select,
	 TextBox,
	 domClass,
	 domConstruct,
	 Keys,
	 on,
	 string,		
	 declare,
	 lang,
	 i18n) {

    var className = "at.cdes.web.planning.order.PlanningNotificationOrderSearchWidget";

    var log = new TinyLog(className);

    var PlanningNotificationOrderSearchWidget = declare(className, ContentWidget, {

	constructor : function(params) {
	    lang.mixin(this, params);

	    this.constructTopDiv();

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    var networkId = this.applicationContext.getPageContextPnNetworkId();
	    this.optionalFieldsVisible = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId],
					                                             "/planningNotificationOrder/optionalSearchFieldsVisible");
	    if (this.optionalFieldsVisible == null) {
		this.optionalFieldsVisible = false;
	    }		
	    this.updateOptionalFieldVisibility();

	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "PlanningNotificationOrderSearchWidget";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructTopDiv : function() {
	    this.topDiv = domConstruct.create("div", null, null);
	    domClass.add(this.topDiv, "refNodeOfPositionAbsolute planningNotificationOrderSearchFull");

	    this.titlePane = this.constructTitlePane();
	    domConstruct.place(this.titlePane.domNode, this.topDiv);
	},

	postTitleClick : function() {
	    var open = this.titlePane.get("open");

	    if (open) {
		var fullClass = this.optionalFieldsVisible ? "planningNotificationOrderSearchFullWithOptional" : "planningNotificationOrderSearchFull";

		this.titlePane.set("title", i18n.searchOpenCaption);
		domClass.replace(this.topDiv, fullClass, "planningNotificationOrderSearchReduced");
	    } else {
		this.titlePane.set("title", i18n.searchClosedCaption);
		domClass.replace(this.topDiv,
				 "planningNotificationOrderSearchReduced",
				 "planningNotificationOrderSearchFull planningNotificationOrderSearchFullWithOptional");
	    }

	    on.emit(this, "titlePaneToggled");
	},

	constructTitlePane : function() {
	    var contentDiv = this.constructContentDiv();

	    var titlePane = new IconTitlePane({
		       title   : i18n.searchOpenCaption,
		       content : contentDiv,
		    toggleable : true,
			  open : true,
		postTitleClick : lang.hitch(this, this.postTitleClick)
	    });
	    domClass.add(titlePane.domNode, "occupyWholeParent");

	    return titlePane;
	},

	constructContentDiv : function() {
	    var contentDiv = domConstruct.create("div", null, null);
	    domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationOrderSearchContentDiv");

	    // Widgets shown always
	    this.permanentDiv = domConstruct.create("div", null, null);
	    domClass.add(this.permanentDiv, "refNodeOfPositionAbsolute planningNotificationOrderSearchPermanentDiv");
	    domConstruct.place(this.permanentDiv, contentDiv);
	    this.constructPermanentWidgets();

	    // Widgets shown optionally
	    this.optionalDiv = domConstruct.create("div", null, null);
	    domClass.add(this.optionalDiv, "refNodeOfPositionAbsolute planningNotificationOrderSearchOptionalDiv");
	    domConstruct.place(this.optionalDiv, contentDiv);
	    this.constructOptionalWidgets();

	    // Buttons
	    this.buttonDiv = domConstruct.create("div", null, null);
	    domClass.add(this.buttonDiv, "refNodeOfPositionAbsolute planningNotificationOrderSearchButtonDiv");
	    domConstruct.place(this.buttonDiv, contentDiv);
	    this.constructButtons();	    

	    // Update visibility of the optional search field block
	    this.updateOptionalFieldVisibility();

	    return contentDiv;	    
	},

	constructPermanentWidgets : function() {

	    // SerialNumberNumberSpinner
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, this.permanentDiv,
			             "propertyLabel planningNotificationOrderSearchSerialNumberLabel");
	    this.serialNumberSpinner = new NumberSpinner({
								label : i18n.planningNotificationOrderSerialNumberLabel,
								title : i18n.planningNotificationOrderSerialNumberToolTip,
				omitThousandSeparator : true
	    });
	    domClass.add(this.serialNumberSpinner.domNode, "fixedDialogWidget planningNotificationOrderSearchSerialNumberSpinner");
	    domConstruct.place(this.serialNumberSpinner.domNode, this.permanentDiv);

	    on(this.serialNumberSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    //	    WidgetHelper.handleSpinnerEvents(this.serialNumberSpinner, lang.hitch(this, this.updateWidgetState));

	    // PlanningNotificationComboBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderEditPlanningNotificationLabel, this.permanentDiv,
			             "propertyLabel planningNotificationOrderSearchPlanningNotificationLabel");

	    this.planningNotificationMultiComboBox = new PlanningNotificationTitleMultiSearchWidget({
							label : i18n.planningNotificationOrderEditPlanningNotificationLabel,
					// Use the tooltip of the PlanningNotificationTitleMultiSearchWidget
					//			title : i18n.planningNotificationOrderPlanningNotificationToolTip,
					comboBoxClass : "fixedDialogWidget planningNotificationOrderSearchTitleSearchComboBox",
                	selectOnClick : true
	    });	    
	    domClass.add(this.planningNotificationMultiComboBox.domNode, "fixedDialogWidget planningNotificationOrderSearchPlanningNotificationComboBox");
	    domConstruct.place(this.planningNotificationMultiComboBox.domNode, this.permanentDiv);
	    on(this.planningNotificationMultiComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    
		//Erfüllungsprozess:
	    //Baulos Vorgabe
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowBaulosLabel, this.permanentDiv,
			             "fixedDialogWidget planningNotificationOrderSearchOrderBaulosShowLabel");
	    this.orderBaulosTextBox = new TextBox({
							label : i18n.planningNotificationReportSearchShowBaulosLabel,
							title : i18n.planningNotificationReportSearchShowBaulosToolTip,
	        		selectOnClick : true 
	    });
	    domClass.add(this.orderBaulosTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchOrderBaulosTextBox");
	    domConstruct.place(this.orderBaulosTextBox.domNode, this.permanentDiv);	    
	    on(this.orderBaulosTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    //WidgetHelper.handleTextBoxEvents(this.orderBaulosTextBox, lang.hitch(this, this.updateWidgetState));

	    // ProjectSelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderProjectLabel, this.permanentDiv, "propertyLabel planningNotificationOrderSearchProjectLabel");
	    this.projectSelect = new Select({
			label : i18n.planningNotificationOrderProjectLabel,
			title : i18n.planningNotificationOrderProjectToolTip
	    });
	    domClass.add(this.projectSelect.domNode, "fixedDialogWidget planningNotificationOrderSearchProjectSelect");
	    domConstruct.place(this.projectSelect.domNode, this.permanentDiv);
	    WidgetHelper.handleSelectEvents(this.projectSelect, lang.hitch(this, this.handleProjectSelectChange));

	    //	    WidgetHelper.(this.planningNotification, lang.hitch(this, this.updateWidgetState));

	    // TextTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderTextLabel, this.permanentDiv, "propertyLabel planningNotificationOrderSearchTextLabel");
	    this.textTextBox = new TextBox({
							label : i18n.planningNotificationOrderTextLabel,
							title : i18n.planningNotificationOrderTextToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.textTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchTextTextBox");
	    domConstruct.place(this.textTextBox.domNode, this.permanentDiv);
	    on(this.textTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    //	    WidgetHelper.handleTextBoxEvents(this.textTextBox, lang.hitch(this, this.updateWidgetState));

	    // SubjectAreaComboBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubjectAreaLabel, this.permanentDiv,
			             "propertyLabel planningNotificationOrderSearchSubjectAreaLabel");
	    this.subjectAreaComboBox = new ComboBox({
					label : i18n.planningNotificationOrderSubjectAreaLabel,
					title : i18n.planningNotificationOrderSubjectAreaToolTip,
            selectOnClick : true
	    });
	    domClass.add(this.subjectAreaComboBox.domNode, "fixedDialogWidget planningNotificationOrderSearchSubjectAreaComboBox");
	    domConstruct.place(this.subjectAreaComboBox.domNode, this.permanentDiv);
	    on(this.subjectAreaComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    //	    WidgetHelper.(this.subjectArea, lang.hitch(this, this.updateWidgetState));

	    // AuthorizedInspectorTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderAuthorizedInspectorLabel, this.permanentDiv,
			             "propertyLabel planningNotificationOrderSearchAuthorizedInspectorLabel");
	    this.authorizedInspectorTextBox = new TextBox({
							label : i18n.planningNotificationOrderAuthorizedInspectorLabel,
							title : i18n.planningNotificationOrderAuthorizedInspectorToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.authorizedInspectorTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchAuthorizedInspectorTextBox");
	    domConstruct.place(this.authorizedInspectorTextBox.domNode, this.permanentDiv);
	    on(this.authorizedInspectorTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    //	    WidgetHelper.handleTextBoxEvents(this.authorizedInspectorTextBox, lang.hitch(this, this.updateWidgetState));

	    // StatutoryDutySelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyLabel, this.permanentDiv,
			             "propertyLabel planningNotificationOrderSearchStatutoryDutyLabel");
	    this.statutoryDutySelect = new Select({
		label : i18n.planningNotificationOrderStatutoryDutyLabel,
		title : i18n.planningNotificationOrderStatutoryDutyToolTip
	    });
	    domClass.add(this.statutoryDutySelect.domNode, "fixedDialogWidget planningNotificationOrderSearchStatutoryDutySelect");
	    domConstruct.place(this.statutoryDutySelect.domNode, this.permanentDiv);
	    //	    WidgetHelper.handleSelectEvents(this.statutoryDutySelect, lang.hitch(this, this.updateWidgetState));

	    // InvalidatedCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderInvalidatedLabel, this.permanentDiv,
			             "propertyLabel planningNotificationOrderSearchInvalidatedLabel");
	    this.invalidatedSelect = WidgetFactory.constructBooleanSelect();
	    this.invalidatedSelect.set("label", i18n.planningNotificationOrderInvalidatedLabel);
	    this.invalidatedSelect.set("title", i18n.planningNotificationOrderInvalidatedToolTip);
	    domClass.add(this.invalidatedSelect.domNode, "fixedDialogWidget planningNotificationOrderSearchInvalidatedSelect");
	    domConstruct.place(this.invalidatedSelect.domNode, this.permanentDiv);
	    //	    WidgetHelper.handleCheckBoxEvents(this.invalidatedCheckBox, lang.hitch(this, this.updateWidgetState));

	    // StateSelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStateLabel, this.permanentDiv, "propertyLabel planningNotificationOrderSearchStateLabel");
	    this.stateSelect = new Select({
		label : i18n.planningNotificationOrderStateLabel,
		title : i18n.planningNotificationOrderStateToolTip
	    });
	    domClass.add(this.stateSelect.domNode, "fixedDialogWidget planningNotificationOrderSearchStateSelect");
	    domConstruct.place(this.stateSelect.domNode, this.permanentDiv);
	    //	    WidgetHelper.handleSelectEvents(this.stateSelect, lang.hitch(this, this.updateWidgetState));

	    // ReferenceTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderReferenceLabel, this.permanentDiv, "propertyLabel planningNotificationOrderSearchReferenceLabel");
	    this.referenceTextBox = new TextBox({
							label : i18n.planningNotificationOrderReferenceLabel,
							title : i18n.planningNotificationOrderSearchReferenceToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.referenceTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchReferenceTextBox");
	    domConstruct.place(this.referenceTextBox.domNode, this.permanentDiv);
	    on(this.referenceTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    //	    WidgetHelper.handleTextBoxEvents(this.referenceTextBox, lang.hitch(this, this.updateWidgetState));

	    // EnvironmentallyRelevantCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderEnvironmentallyRelevantLabel, this.permanentDiv,
			             "propertyLabel planningNotificationOrderSearchEnvironmentallyRelevantLabel");
	    this.environmentallyRelevantSelect = WidgetFactory.constructBooleanSelect();
	    this.environmentallyRelevantSelect.set("label", i18n.planningNotificationOrderEnvironmentallyRelevantLabel);
	    this.environmentallyRelevantSelect.set("title", i18n.planningNotificationOrderEnvironmentallyRelevantLabel);
	    domClass.add(this.environmentallyRelevantSelect.domNode, "fixedDialogWidget planningNotificationOrderSearchEnvironmentallyRelevantSelect");
	    domConstruct.place(this.environmentallyRelevantSelect.domNode, this.permanentDiv);
	    WidgetHelper.handleCheckBoxEvents(this.environmentallyRelevantSelect, lang.hitch(this, this.updateWidgetState));
	    
	},

	constructOptionalWidgets : function() {
	    // StatutoryDutyFromFromDateTimeSpinBox
	    var statutoryDutyFromLabel = string.substitute(i18n.searchFrom, { label : i18n.planningNotificationOrderSearchStatutoryDutyFromFromLabel });
	    DOMHelper.createTextNode("div", statutoryDutyFromLabel, this.optionalDiv, "propertyLabel planningNotificationOrderSearchStatutoryDutyFromFromLabel");
	    this.statutoryDutyFromFromSpinner = new CalendarSpinner({
			    label : i18n.statutoryDutyFromLabel,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyFromFromToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null                
	    });
	    domClass.add(this.statutoryDutyFromFromSpinner.domNode, "fixedDialogWidget planningNotificationOrderSearchStatutoryDutyFromFromSpinner");
	    domConstruct.place(this.statutoryDutyFromFromSpinner.domNode, this.optionalDiv);
	    on(this.statutoryDutyFromFromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyFromFromSpinner, lang.hitch(this, this.updateWidgetState));

	    // StatutoryDutyFromToDateTimeSpinBox
	    DOMHelper.createTextNode("div", i18n.searchTo, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchStatutoryDutyFromToLabel");
	    this.statutoryDutyFromToSpinner = new CalendarSpinner({
			    label : i18n.searchTo,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyFromToToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null                
	    });
	    domClass.add(this.statutoryDutyFromToSpinner.domNode, "fixedDialogWidget planningNotificationOrderSearchStatutoryDutyFromToSpinner");
	    domConstruct.place(this.statutoryDutyFromToSpinner.domNode, this.optionalDiv);
	    on(this.statutoryDutyFromToSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyFromToSpinner, lang.hitch(this, this.updateWidgetState));

	    // DocumentPageTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPageLabel, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchDocumentPageLabel");
	    this.documentPageTextBox = new TextBox({
							label : i18n.planningNotificationOrderDocumentPageLabel,
							title : i18n.planningNotificationOrderDocumentPageToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.documentPageTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchDocumentPageTextBox");
	    domConstruct.place(this.documentPageTextBox.domNode, this.optionalDiv);
	    on(this.documentPageTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleTextBoxEvents(this.documentPageTextBox, lang.hitch(this, this.updateWidgetState));

	    // DocumentPositionTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPositionLabel, this.optionalDiv, "propertyLabel planningNotificationOrderSearchDocumentPositionLabel");
	    this.documentPositionTextBox = new TextBox({
							label : i18n.planningNotificationOrderDocumentPositionLabel,
							title : i18n.planningNotificationOrderDocumentPositionToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.documentPositionTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchDocumentPositionTextBox");
	    domConstruct.place(this.documentPositionTextBox.domNode, this.optionalDiv);
	    on(this.documentPositionTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleTextBoxEvents(this.documentPositionTextBox, lang.hitch(this, this.updateWidgetState));

	    // SourceTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSourceLabel, this.optionalDiv, "propertyLabel planningNotificationOrderSearchSourceLabel");
	    this.sourceTextBox = new TextBox({
							label : i18n.planningNotificationOrderSourceLabel,
							title : i18n.planningNotificationOrderSourceToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.sourceTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchSourceTextBox");
	    domConstruct.place(this.sourceTextBox.domNode, this.optionalDiv);
	    on(this.sourceTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleTextBoxEvents(this.sourceTextBox, lang.hitch(this, this.updateWidgetState));

	    // StatutoryDutyToFromDateTimeSpinBox
	    var statutoryDutyToLabel = string.substitute(i18n.searchFrom, { label : i18n.planningNotificationOrderSearchStatutoryDutyToFromLabel });
	    DOMHelper.createTextNode("div", statutoryDutyToLabel, this.optionalDiv, "propertyLabel planningNotificationOrderSearchStatutoryDutyToFromLabel");
	    this.statutoryDutyToFromSpinner = new CalendarSpinner({
			    label : i18n.statutoryDutyToLabel,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyToFromToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null                
	    });
	    domClass.add(this.statutoryDutyToFromSpinner.domNode, "fixedDialogWidget planningNotificationOrderSearchStatutoryDutyToFromSpinner");
	    domConstruct.place(this.statutoryDutyToFromSpinner.domNode, this.optionalDiv);
	    on(this.statutoryDutyToFromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyToFromSpinner, lang.hitch(this, this.updateWidgetState));

	    // StatutoryDutyToToDateTimeSpinBox
	    DOMHelper.createTextNode("div", i18n.searchTo, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchStatutoryDutyToToLabel");
	    this.statutoryDutyToToSpinner = new CalendarSpinner({
			    label : i18n.searchTo,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyToToToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null		
	    });
	    domClass.add(this.statutoryDutyToToSpinner.domNode, "fixedDialogWidget planningNotificationOrderSearchStatutoryDutyToToSpinner");
	    domConstruct.place(this.statutoryDutyToToSpinner.domNode, this.optionalDiv);
	    on(this.statutoryDutyToToSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyToToSpinner, lang.hitch(this, this.updateWidgetState));

	    // PersonInChargeSelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderPersonInChargeLabel, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchPersonInChargeLabel");
	    this.personInChargeSelect = new Select({
		label : i18n.planningNotificationOrderPersonInChargeLabel,
		title : i18n.planningNotificationOrderPersonInChargeToolTip
	    });
	    domClass.add(this.personInChargeSelect.domNode, "fixedDialogWidget planningNotificationOrderSearchPersonInChargeSelect");
	    domConstruct.place(this.personInChargeSelect.domNode, this.optionalDiv);
	    WidgetHelper.handleSelectEvents(this.personInChargeSelect, lang.hitch(this, this.updateWidgetState));

	    // IntervalNumberSpinner
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSearchIntervalLabel, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchIntervalLabel");
	    this.intervalSpinner = new NumberSpinner({
				label : i18n.planningNotificationOrderSearchIntervalLabel,
				title : i18n.planningNotificationOrderSearchIntervalToolTip,
		omitThousandSeparator : true		        
	    });
	    domClass.add(this.intervalSpinner.domNode, "fixedDialogWidget planningNotificationOrderSearchIntervalSpinner");
	    domConstruct.place(this.intervalSpinner.domNode, this.optionalDiv);

	    on(this.intervalSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleSpinnerEvents(this.intervalSpinner, lang.hitch(this, this.updateWidgetState));

	    // LeadTimeNumberSpinner
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSearchLeadTimeLabel, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchLeadTimeLabel");
	    this.leadTimeSpinner = new NumberSpinner({
				label : i18n.planningNotificationOrderSearchLeadTimeLabel,
				title : i18n.planningNotificationOrderSearchLeadTimeToolTip,
		omitThousandSeparator : true		
	    });
	    domClass.add(this.leadTimeSpinner.domNode, "fixedDialogWidget planningNotificationOrderSearchLeadTimeSpinner");
	    domConstruct.place(this.leadTimeSpinner.domNode, this.optionalDiv);

	    on(this.leadTimeSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleSpinnerEvents(this.leadTimeSpinner, lang.hitch(this, this.updateWidgetState));

	    // TagTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSearchTagLabel, this.optionalDiv, "propertyLabel planningNotificationOrderSearchTagLabel");
	    this.tagTextBox = new TextBox({
							label : i18n.planningNotificationOrderSearchTagLabel,
							title : i18n.planningNotificationOrderSearchTagToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.tagTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchTagTextBox");
	    domConstruct.place(this.tagTextBox.domNode, this.optionalDiv);
	    on(this.tagTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleTextBoxEvents(this.tagTextBox, lang.hitch(this, this.updateWidgetState));

	    // StatutoryDutyExpiredCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyExpiredLabel, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchStatutoryDutyExpiredLabel");
	    this.statutoryDutyExpiredSelect = WidgetFactory.constructBooleanSelect();
	    this.statutoryDutyExpiredSelect.set("label", i18n.planningNotificationOrderStatutoryDutyExpiredLabel);
	    this.statutoryDutyExpiredSelect.set("title", i18n.planningNotificationOrderStatutoryDutyExpiredToolTip);
	    domClass.add(this.statutoryDutyExpiredSelect.domNode, "fixedDialogWidget planningNotificationOrderSearchStatutoryDutyExpiredSelect");
	    domConstruct.place(this.statutoryDutyExpiredSelect.domNode, this.optionalDiv);
	    WidgetHelper.handleCheckBoxEvents(this.statutoryDutyExpiredSelect, lang.hitch(this, this.updateWidgetState));

	    // SubmitAuthorityCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubmitAuthorityLabel, this.optionalDiv,
			             "propertyLabel planningNotificationOrderSearchSubmitAuthorityLabel");
	    this.submitAuthoritySelect = WidgetFactory.constructBooleanSelect();
	    this.submitAuthoritySelect.set("label", i18n.planningNotificationOrderSubmitAuthorityLabel);
	    this.submitAuthoritySelect.set("title", i18n.planningNotificationOrderSubmitAuthorityToolTip);
	    domClass.add(this.submitAuthoritySelect.domNode, "fixedDialogWidget planningNotificationOrderSearchSubmitAuthoritySelect");
	    domConstruct.place(this.submitAuthoritySelect.domNode, this.optionalDiv);
	    WidgetHelper.handleCheckBoxEvents(this.submitAuthoritySelect, lang.hitch(this, this.updateWidgetState));

	    // CommentTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderCommentLabel, this.optionalDiv, "propertyLabel planningNotificationOrderSearchCommentLabel");
	    this.orderCommentTextBox = new TextBox({
							label : i18n.planningNotificationOrderCommentLabel,
							title : i18n.planningNotificationOrderCommentToolTip,
            		selectOnClick : true 
	    });
	    domClass.add(this.orderCommentTextBox.domNode, "fixedDialogWidget planningNotificationOrderSearchCommentTextBox");
	    domConstruct.place(this.orderCommentTextBox.domNode, this.optionalDiv);
	    on(this.orderCommentTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
	    WidgetHelper.handleTextBoxEvents(this.orderCommentTextBox, lang.hitch(this, this.updateWidgetState));
	},

	/*
        Beginn der Rechtspflicht von ... bis        Seite     Vorschreibungspunkt
        Ende der Rechtspflicht von ... bis          Verweis
        Intervall der Rechtspflicht   Vorlaufzeit

        Vorschreibungspunkt
        Seite
        Verweis
        Durchführungsverantwortlicher
        Ist der Behörde vorzulegen
        Zusatzinformation
        Kommentar

        Vorschreibungspunkt
        Seite
        Verweis
        Durchführungsverantwortlicher
        Beginn der Rechtspflicht
        Intervall der Rechtspflicht
        Vorlaufzeit
        Ende der Rechtspflicht
        Ist der Behörde vorzulegen
        Zusatzinformation
        Kommentar
	*/

	setSearchInfo : function(searchInfo, firstCall) {  // PlanningNotificationOrderSearchInfo
	    this.projectIdToProject = searchInfo.projectIdToProject;
	    this.projectIdToPlanningNotifications = searchInfo.projectIdToPlanningNotifications;	    
	    this.processProjectChange();

	    var personInChargeOptions = PlanningNotificationHelper.getSelectOptionsForMap(searchInfo.idToPersonInCharge, "name",
					                                                  { label : i18n.whatever, value : CdesVoc.WHATEVER });
	    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.personInChargeSelect, personInChargeOptions);

	    var statutoryDutyOptions = PlanningNotificationHelper.getSelectOptionsForMap(searchInfo.idToStatutoryDuty, "name",
					                                                 { label : i18n.whatever, value : CdesVoc.WHATEVER }, "Keine");
	    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.statutoryDutySelect, statutoryDutyOptions);

	    var subjectAreaOptions = PlanningNotificationHelper.getSelectOptionsForMap(searchInfo.idToSubjectArea, "name");
            subjectAreaOptions.splice(0, 0, { label: i18n.allOption, value : CdesVoc.MagicSelectOption.ALL });            
	    WidgetHelper.setComboBoxOptions(this.subjectAreaComboBox, subjectAreaOptions);

	    var stateOptions = [
				{ label : i18n.whatever, value : CdesVoc.WHATEVER },
				{ label : i18n.workflowStatusNotInitialized, value : CdesVoc.WORKFLOW_ENTITIY_STATUS_NOT_INITIALIZED }
	    ];
	    var stateInstances = [];
	    for (var id in searchInfo.idToWorkflowEntityStatus) {
		stateInstances.push(searchInfo.idToWorkflowEntityStatus[id]);
	    }

	    stateInstances.sort(function(instanceOne, instanceTwo) {
		return instanceOne.id - instanceTwo.id;
	    });
	    for (var v = 0; v < stateInstances.length; v++) {
		stateOptions.push({ label : stateInstances[v].name, value : stateInstances[v].id });
	    }		

	    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.stateSelect, stateOptions);

	    if (firstCall) {
		this.personInChargeSelect.set("value", CdesVoc.WHATEVER);
		this.statutoryDutySelect.set("value", CdesVoc.WHATEVER);
		this.stateSelect.set("value", CdesVoc.WHATEVER);		
	    }		

	    this.populateSearchFields();

	    this.updateWidgetState();
	},	    	    

	constructButtons : function() {
	    // ToggleOptionalFieldsButton
	    this.toggleOptionalFieldsButton = new Button({
		label : i18n.hideAdditionalSearchFieldsButtonCaption,
		title : i18n.hideAdditionalSearchFieldsButtonCaption
	    });            
	    domClass.add(this.toggleOptionalFieldsButton.domNode, "planningNotificationOrderSearchToggleOptionalFieldsButton");
	    domConstruct.place(this.toggleOptionalFieldsButton.domNode, this.buttonDiv);
	    on(this.toggleOptionalFieldsButton, "click", lang.hitch(this, this.doToggleOptionalFields));

	    // ClearSearchFieldsButton
	    this.clearSearchFieldsButton = new Button({
		label : i18n.clearSearchFieldsButtonCaption,
		title : i18n.clearSearchFieldsButtonToolTip
	    });
	    domClass.add(this.clearSearchFieldsButton.domNode, "planningNotificationOrderSearchClearSearchFieldsButton");
	    domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);
	    on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));	    

	    // SearchButton
	    this.searchButton = new Button({
		label : i18n.searchButtonCaption,
		title : i18n.planningNotificationOrderSearchSearchButtonToolTip
	    });            
	    domClass.add(this.searchButton.domNode, "planningNotificationOrderSearchSearchButton");
	    domConstruct.place(this.searchButton.domNode, this.buttonDiv);
	    on(this.searchButton, "click", lang.hitch(this, this.doSearch));            
	},

	updateWidgetState : function() {
	    this.updateOptionalFieldVisibility();

	    var allFieldsValid = this.applicationContext.getPageContextPnNetworkId() != null;
	    this.searchButton.set("disabled", !allFieldsValid);	    
	},

	handleProjectSelectChange : function() {
	    var projectId = WidgetHelper.getSelectValue(this.projectSelect);
	    if (this.projectIdFromLocalStorage != null && projectId != this.projectIdFromLocalStorage) {
		this.projectIdFromLocalStorage = null;
	    }

	    this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChange(this.projectSelect, this.planningNotificationMultiComboBox,
					                                              this.projectIdToPlanningNotifications, this.lastProjectId,
					                                              this.projectIdFromLocalStorage != null);
	},

	processProjectChange : function() {
	    PlanningNotificationHelper.processProjectChange({
		     projectSelect : this.projectSelect, 
		projectIdToProject : this.projectIdToProject,
		 addWhateverOption : true,
		 noWhateverDefault : true		
	    });
	    this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChange(this.projectSelect, this.planningNotificationMultiComboBox,
					                                              this.projectIdToPlanningNotifications, this.lastProjectId);
	},	

	doToggleOptionalFields : function() {
	    this.optionalFieldsVisible = !this.optionalFieldsVisible;

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    var networkId = this.applicationContext.getPageContextPnNetworkId();
	    this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/optionalSearchFieldsVisible",
					                this.optionalFieldsVisible);

	    this.updateOptionalFieldVisibility();
	    on.emit(this, "titlePaneToggled");	    
	},

	updateOptionalFieldVisibility : function() {
	    if (this.optionalFieldsVisible) {
		domClass.replace(this.optionalDiv, "visible", "hidden");
		this.toggleOptionalFieldsButton.set("label", i18n.hideAdditionalSearchFieldsButtonCaption);
		this.toggleOptionalFieldsButton.set("title", i18n.hideAdditionalSearchFieldsButtonCaption);
		domClass.replace(this.topDiv,
				 "planningNotificationOrderSearchFullWithOptional",
				 "planningNotificationOrderSearchFull planningNotificationOrderSearchReduced");
	    } else {
		domClass.replace(this.optionalDiv, "hidden", "visible");                
		this.updateShowOptionalFieldsButtonCaption();
		domClass.replace(this.topDiv,
				 "planningNotificationOrderSearchFull",
				 "planningNotificationOrderSearchFullWithOptional planningNotificationOrderSearchReduced");
	    }
	},

	updateShowOptionalFieldsButtonCaption : function() {
	    var statutoryDutyFromFrom = this.statutoryDutyFromFromSpinner.getUtcSeconds();
	    var statutoryDutyFromTo = this.statutoryDutyFromToSpinner.getUtcSeconds();
	    var documentPage = this.documentPageTextBox.get("value");
	    var documentPosition = this.documentPositionTextBox.get("value");
	    var source = this.sourceTextBox.get("value");
	    var statutoryDutyToFrom = this.statutoryDutyToFromSpinner.getUtcSeconds();
	    var statutoryDutyToTo = this.statutoryDutyToToSpinner.getUtcSeconds();
	    var personInChargeId = WidgetHelper.getSelectValue(this.personInChargeSelect);
	    var interval = this.intervalSpinner.get("value");
	    var leadTime = this.leadTimeSpinner.get("value");
	    var tag = this.tagTextBox.get("value");
	    var statutoryDutyExpired = WidgetFactory.getBooleanSelectValue(this.statutoryDutyExpiredSelect);
	    var submitAuthority = WidgetFactory.getBooleanSelectValue(this.submitAuthoritySelect);
	    var comment = this.orderCommentTextBox.get("value");

	    var numberOfOptionalSearchFieldsSet =
	    (statutoryDutyFromFrom != null ? 1 : 0)
			     + (statutoryDutyFromTo != null ? 1 : 0)
	+ (documentPage != null && documentPage.trim().length > 0 ? 1 : 0)
 + (documentPosition != null && documentPosition.trim().length > 0 ? 1 : 0)
 + (source != null && source.trim().length > 0 ? 1 : 0)
 + (statutoryDutyToFrom != null ? 1 : 0)
 + (statutoryDutyToTo != null ? 1 : 0)
 + (personInChargeId != null && personInChargeId != CdesVoc.WHATEVER ? 1 : 0)
 + (interval != null ? 1 : 0)
 + (leadTime != null ? 1 : 0)
 + (tag != null && tag.trim().length > 0 ? 1 : 0)
 + (statutoryDutyExpired != null ? 1 : 0)
 + (submitAuthority != null ? 1 : 0)
 + (comment != null && comment.trim().length > 0 ? 1 : 0);

	    if (numberOfOptionalSearchFieldsSet == 0) {
		this.toggleOptionalFieldsButton.set("label", i18n.showAdditionalSearchFieldsButtonCaption);
		this.toggleOptionalFieldsButton.set("title", i18n.showAdditionalSearchFieldsButtonCaption);
	    } else {
		var showCaption = string.substitute(i18n.showNumberedAdditionalSearchFieldsButtonCaption, {
		    countActive : numberOfOptionalSearchFieldsSet
		});
		this.toggleOptionalFieldsButton.set("label", showCaption);
		this.toggleOptionalFieldsButton.set("title", showCaption);
	    }		    
	},

	clearSearchFields : function() {
	    this.serialNumberSpinner.set("value", null, false);
	    // Deliberately no reset
	    //	    this.projectSelect.set("value", CdesVoc.WHATEVER, false);
	    this.planningNotificationMultiComboBox.set("value", [], false);
	    this.textTextBox.set("value", "", false);
	    this.orderBaulosTextBox.set("value", "", false);

        SearchPageHelper.setComboBoxValue(this.subjectAreaComboBox, CdesVoc.MagicSelectOption.ALL);
	    this.authorizedInspectorTextBox.set("value", "", false);
	    this.statutoryDutySelect.set("value", CdesVoc.WHATEVER, false);
	    this.invalidatedSelect.set("value", CdesVoc.WHATEVER, false);
	    this.stateSelect.set("value", CdesVoc.WHATEVER, false);
	    this.referenceTextBox.set("value", "", false);
	    this.environmentallyRelevantSelect.set("value", CdesVoc.WHATEVER, false);

	    this.statutoryDutyFromFromSpinner.setUtcSeconds(null);
	    this.statutoryDutyFromToSpinner.setUtcSeconds(null);
	    this.documentPageTextBox.set("value", "", false);
	    this.documentPositionTextBox.set("value", "", false);
	    this.sourceTextBox.set("value", "", false);
	    this.statutoryDutyToFromSpinner.setUtcSeconds(null);
	    this.statutoryDutyToToSpinner.setUtcSeconds(null);
	    this.personInChargeSelect.set("value", CdesVoc.WHATEVER, false);
	    this.intervalSpinner.set("value", null, false);
	    this.leadTimeSpinner.set("value", null, false);
	    this.tagTextBox.set("value", "", false);
	    this.statutoryDutyExpiredSelect.set("value", CdesVoc.WHATEVER, false);
	    this.submitAuthoritySelect.set("value", CdesVoc.WHATEVER, false);
	    this.orderCommentTextBox.set("value", "", false);

	    this.handleProjectSelectChange();
	    this.updateOptionalFieldVisibility();
	},

	getSearchModel : function() {
	    return PlanningNotificationHelper.getPlanningNotificationOrderSearchModel(this);
	},	    

	populateSearchFields : function() {
	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    var networkId = this.applicationContext.getPageContextPnNetworkId();
	    var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/search");

	    if (oldSearchModel != null) {
			this.serialNumberSpinner.set("value", oldSearchModel.serialNumber);
	
			var projectId = oldSearchModel.projectId == null ? CdesVoc.WHATEVER : oldSearchModel.projectId;
			// Not null until it is changed for the first time; as long as it is not null, the document titles will be kept
			// regardless of calls to handleProjectSelectChange		
			this.projectIdFromLocalStorage = projectId;
	                this.projectSelect.set("value", projectId, false);
	                this.handleProjectSelectChange();
	
			this.planningNotificationMultiComboBox.set("value", oldSearchModel.planningNotificationEntries);
	
			WidgetFactory.setBooleanSelectValue(this.invalidatedSelect, oldSearchModel.invalidated);
			WidgetHelper.setSelectValue(this.stateSelect, oldSearchModel.state);
			this.planningNotificationMultiComboBox.set("value", oldSearchModel.planningNotificationEntries);
			//		this.planningNotificationComboBox.set("value", oldSearchModel.planningNotificationTitle); // TODO
			this.referenceTextBox.set("value", oldSearchModel.reference);
			WidgetFactory.setBooleanSelectValue(this.environmentallyRelevantSelect, oldSearchModel.environmentallyRelevant);
			WidgetHelper.setSelectValue(this.statutoryDutySelect, oldSearchModel.statutoryDutyId);
			this.textTextBox.set("value", oldSearchModel.text);
			this.orderBaulosTextBox.set("value", oldSearchModel.baulos);
			this.authorizedInspectorTextBox.set("value", oldSearchModel.authorizedInspector);
			this.statutoryDutyFromFromSpinner.setUtcSeconds(oldSearchModel.statutoryDutyFromFrom);
			this.statutoryDutyFromToSpinner.setUtcSeconds(oldSearchModel.statutoryDutyFromTo);
			this.statutoryDutyToFromSpinner.setUtcSeconds(oldSearchModel.statutoryDutyToFrom);
			this.statutoryDutyToToSpinner.setUtcSeconds(oldSearchModel.statutoryDutyToTo);
			this.intervalSpinner.set("value", oldSearchModel.statutoryDutyInterval);
			this.leadTimeSpinner.set("value", oldSearchModel.statutoryDutyLeadTime);
			WidgetFactory.setBooleanSelectValue(this.statutoryDutyExpiredSelect, oldSearchModel.statutoryDutyExpired);
			this.documentPageTextBox.set("value", oldSearchModel.documentPage);
			this.documentPositionTextBox.set("value", oldSearchModel.documentPosition);
			this.sourceTextBox.set("value", oldSearchModel.source);
			WidgetHelper.setSelectValue(this.personInChargeSelect, oldSearchModel.personInChargeId);
			this.tagTextBox.set("value", oldSearchModel.tags);
			WidgetFactory.setBooleanSelectValue(this.submitAuthoritySelect, oldSearchModel.submitAuthority);
			this.orderCommentTextBox.set("value", oldSearchModel.comment);
	    }
	},	    

	// TODO call.	
	searchIfEnter : function(e) {
	    if (e.keyCode == Keys.ENTER) {
		this.doSearch();
	    }
	},

	getSelectedProjectId : function() {
	    var projectId = WidgetHelper.getSelectValue(this.projectSelect);
	    if (projectId == CdesVoc.WHATEVER) {
		return null;
	    } else {
		return projectId;
	    }                            
	},

	getSelectedPlanningNotificationTitle : function() {
	    var titles = this.planningNotificationMultiComboBox.get("value");
	    return titles != null && titles.length >= 1 ? titles[0] : "";	    
	},

	doSearch : function() {
	    on.emit(this, "doSearch");            
	}
    });

    PlanningNotificationOrderSearchWidget.AsyncOperation = {

    };

    return PlanningNotificationOrderSearchWidget;
});
